/**
 * ZEITGEIST_NCAL_ALARM:
 * 
 * ALARM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Alarm"></ulink></para><para>Provide a grouping of component properties that define an alarm.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_ATTACHMENT:
 * 
 * ATTACHMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Attachment"></ulink></para><para>An object attached to a calendar entity. This class has been introduced to serve as a structured value of the ncal:attach property. See the documentation of ncal:attach for details.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-ATTACHMENT:CAPS"><literal>ZEITGEIST_NFO_ATTACHMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_CALENDAR:
 * 
 * CALENDAR:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Calendar"></ulink></para><para>A calendar. Inspirations for this class can be traced to the VCALENDAR component defined in RFC 2445 sec. 4.4, but it may just as well be used to represent any kind of Calendar.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_CALENDAR_DATA_OBJECT:
 * 
 * CALENDAR_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#CalendarDataObject"></ulink></para><para>A DataObject found in a calendar. It is usually interpreted as one of the calendar entity types (e.g. Event, Journal, Todo etc.)</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_EVENT:
 * 
 * EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Event"></ulink></para><para>Provide a grouping of component properties that describe an event.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_FREEBUSY:
 * 
 * FREEBUSY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Freebusy"></ulink></para><para>Provide a grouping of component properties that describe either a request for free/busy time, describe a response to a request for free/busy time or describe a published set of busy time.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_JOURNAL:
 * 
 * JOURNAL:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Journal"></ulink></para><para>Provide a grouping of component properties that describe a journal entry.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_TIMEZONE:
 * 
 * TIMEZONE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Timezone"></ulink></para><para>Provide a grouping of component properties that defines a time zone.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCAL_TODO:
 * 
 * TODO:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/04/02/ncal#Todo"></ulink></para><para>Provide a grouping of calendar properties that describe a to-do.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_CONTACT:
 * 
 * CONTACT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact"></ulink></para><para>A Contact. A piece of data that can provide means to identify or communicate with an entity.</para><para>Children: <link linkend="ZEITGEIST-NCO-PERSON-CONTACT:CAPS"><literal>ZEITGEIST_NCO_PERSON_CONTACT</literal></link>, <link linkend="ZEITGEIST-NCO-ORGANIZATION-CONTACT:CAPS"><literal>ZEITGEIST_NCO_ORGANIZATION_CONTACT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_CONTACT_GROUP:
 * 
 * CONTACT_GROUP:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactGroup"></ulink></para><para>A group of Contacts. Could be used to express a group in an addressbook or on a contact list of an IM application. One contact can belong to many groups.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_CONTACT_LIST:
 * 
 * CONTACT_LIST:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactList"></ulink></para><para>A contact list, this class represents an addressbook or a contact list of an IM application. Contacts inside a contact list can belong to contact groups.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT:
 * 
 * CONTACT_LIST_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#ContactListDataObject"></ulink></para><para>An entity occuring on a contact list (usually interpreted as an nco:Contact)</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_ORGANIZATION_CONTACT:
 * 
 * ORGANIZATION_CONTACT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#OrganizationContact"></ulink></para><para>A Contact that denotes on Organization.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NCO-CONTACT:CAPS"><literal>ZEITGEIST_NCO_CONTACT</literal></link></para>
 */
/**
 * ZEITGEIST_NCO_PERSON_CONTACT:
 * 
 * PERSON_CONTACT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nco#PersonContact"></ulink></para><para>A Contact that denotes a Person. A person can have multiple Affiliations.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NCO-CONTACT:CAPS"><literal>ZEITGEIST_NCO_CONTACT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_APPLICATION:
 * 
 * APPLICATION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Application"></ulink></para><para>An application</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-SOFTWARE:CAPS"><literal>ZEITGEIST_NFO_SOFTWARE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_ARCHIVE:
 * 
 * ARCHIVE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive"></ulink></para><para>A compressed file. May contain other files or folder inside.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DATA-CONTAINER:CAPS"><literal>ZEITGEIST_NFO_DATA_CONTAINER</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_ARCHIVE_ITEM:
 * 
 * ARCHIVE_ITEM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#ArchiveItem"></ulink></para><para>A file entity inside an archive.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-EMBEDDED-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_ATTACHMENT:
 * 
 * ATTACHMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Attachment"></ulink></para><para>A file attached to another data object. Many data formats allow for attachments: emails, vcards, ical events, id3 and exif...</para><para>Children: <link linkend="ZEITGEIST-NCAL-ATTACHMENT:CAPS"><literal>ZEITGEIST_NCAL_ATTACHMENT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-EMBEDDED-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_AUDIO:
 * 
 * AUDIO:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio"></ulink></para><para>A file containing audio content</para><para>Children: <link linkend="ZEITGEIST-NMM-MUSIC-PIECE:CAPS"><literal>ZEITGEIST_NMM_MUSIC_PIECE</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-MEDIA:CAPS"><literal>ZEITGEIST_NFO_MEDIA</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_BOOKMARK:
 * 
 * BOOKMARK:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Bookmark"></ulink></para><para>A bookmark of a webbrowser. Use nie:title for the name/label, nie:contentCreated to represent the date when the user added the bookmark, and nie:contentLastModified for modifications. nfo:bookmarks to store the link.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_BOOKMARK_FOLDER:
 * 
 * BOOKMARK_FOLDER:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#BookmarkFolder"></ulink></para><para>A folder with bookmarks of a webbrowser. Use nfo:containsBookmark to relate Bookmarks. Folders can contain subfolders, use containsBookmarkFolder to relate them.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_CURSOR:
 * 
 * CURSOR:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Cursor"></ulink></para><para>A Cursor.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-RASTER-IMAGE:CAPS"><literal>ZEITGEIST_NFO_RASTER_IMAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_DATA_CONTAINER:
 * 
 * DATA_CONTAINER:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DataContainer"></ulink></para><para>A superclass for all entities, whose primary purpose is to serve as containers for other data object. They usually don&apos;t have any &quot;meaning&quot; by themselves. Examples include folders, archives and optical disc images.</para><para>Children: <link linkend="ZEITGEIST-NFO-FILESYSTEM:CAPS"><literal>ZEITGEIST_NFO_FILESYSTEM</literal></link>, <link linkend="ZEITGEIST-NFO-ARCHIVE:CAPS"><literal>ZEITGEIST_NFO_ARCHIVE</literal></link>, <link linkend="ZEITGEIST-NFO-FOLDER:CAPS"><literal>ZEITGEIST_NFO_FOLDER</literal></link>, <link linkend="ZEITGEIST-NFO-TRASH:CAPS"><literal>ZEITGEIST_NFO_TRASH</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_DELETED_RESOURCE:
 * 
 * DELETED_RESOURCE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#DeletedResource"></ulink></para><para>A file entity that has been deleted from the original source. Usually such entities are stored within various kinds of &apos;Trash&apos; or &apos;Recycle Bin&apos; folders.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_FILE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_DOCUMENT:
 * 
 * DOCUMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document"></ulink></para><para>A generic document. A common superclass for all documents on the desktop.</para><para>Children: <link linkend="ZEITGEIST-NFO-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_TEXT_DOCUMENT</literal></link>, <link linkend="ZEITGEIST-NFO-PRESENTATION:CAPS"><literal>ZEITGEIST_NFO_PRESENTATION</literal></link>, <link linkend="ZEITGEIST-NFO-MIND-MAP:CAPS"><literal>ZEITGEIST_NFO_MIND_MAP</literal></link>, <link linkend="ZEITGEIST-NFO-SPREADSHEET:CAPS"><literal>ZEITGEIST_NFO_SPREADSHEET</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT:
 * 
 * EMBEDDED_FILE_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#EmbeddedFileDataObject"></ulink></para><para>A file embedded in another data object. There are many ways in which a file may be embedded in another one. Use this class directly only in cases if none of the subclasses gives a better description of your case.</para><para>Children: <link linkend="ZEITGEIST-NFO-ARCHIVE-ITEM:CAPS"><literal>ZEITGEIST_NFO_ARCHIVE_ITEM</literal></link>, <link linkend="ZEITGEIST-NFO-ATTACHMENT:CAPS"><literal>ZEITGEIST_NFO_ATTACHMENT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_FILE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_EXECUTABLE:
 * 
 * EXECUTABLE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable"></ulink></para><para>An executable file.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_FILESYSTEM:
 * 
 * FILESYSTEM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Filesystem"></ulink></para><para>A filesystem. Examples of filesystems include hard disk partitions, removable media, but also images thereof stored in files such as ISO.</para><para>Children: <link linkend="ZEITGEIST-NFO-FILESYSTEM-IMAGE:CAPS"><literal>ZEITGEIST_NFO_FILESYSTEM_IMAGE</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-DATA-CONTAINER:CAPS"><literal>ZEITGEIST_NFO_DATA_CONTAINER</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_FILESYSTEM_IMAGE:
 * 
 * FILESYSTEM_IMAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemImage"></ulink></para><para>An image of a filesystem. Instances of this class may include CD images, DVD images or hard disk partition images created by various pieces of software (e.g. Norton Ghost). Deprecated in favor of nfo:Filesystem.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-FILESYSTEM:CAPS"><literal>ZEITGEIST_NFO_FILESYSTEM</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_FILE_DATA_OBJECT:
 * 
 * FILE_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject"></ulink></para><para>A resource containing a finite sequence of bytes with arbitrary information, that is available to a computer program and is usually based on some kind of durable storage. A file is durable in the sense that it remains available for programs to use after the current program has finished.</para><para>Children: <link linkend="ZEITGEIST-NFO-EMBEDDED-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_EMBEDDED_FILE_DATA_OBJECT</literal></link>, <link linkend="ZEITGEIST-NFO-DELETED-RESOURCE:CAPS"><literal>ZEITGEIST_NFO_DELETED_RESOURCE</literal></link>, <link linkend="ZEITGEIST-NFO-REMOTE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_REMOTE_DATA_OBJECT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_FOLDER:
 * 
 * FOLDER:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder"></ulink></para><para>A folder/directory. Examples of folders include folders on a filesystem and message folders in a mailbox.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DATA-CONTAINER:CAPS"><literal>ZEITGEIST_NFO_DATA_CONTAINER</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_FONT:
 * 
 * FONT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Font"></ulink></para><para>A font.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_HARD_DISK_PARTITION:
 * 
 * HARD_DISK_PARTITION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HardDiskPartition"></ulink></para><para>A partition on a hard disk</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_HTML_DOCUMENT:
 * 
 * HTML_DOCUMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument"></ulink></para><para>A HTML document, may contain links to other files.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-PLAIN-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_ICON:
 * 
 * ICON:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon"></ulink></para><para>An Icon (regardless of whether it&apos;s a raster or a vector icon. A resource representing an icon could have two types (Icon and Raster, or Icon and Vector) if required.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-IMAGE:CAPS"><literal>ZEITGEIST_NFO_IMAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_IMAGE:
 * 
 * IMAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image"></ulink></para><para>A file containing an image.</para><para>Children: <link linkend="ZEITGEIST-NFO-ICON:CAPS"><literal>ZEITGEIST_NFO_ICON</literal></link>, <link linkend="ZEITGEIST-NFO-VECTOR-IMAGE:CAPS"><literal>ZEITGEIST_NFO_VECTOR_IMAGE</literal></link>, <link linkend="ZEITGEIST-NFO-RASTER-IMAGE:CAPS"><literal>ZEITGEIST_NFO_RASTER_IMAGE</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-VISUAL:CAPS"><literal>ZEITGEIST_NFO_VISUAL</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_MEDIA:
 * 
 * MEDIA:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Media"></ulink></para><para>A piece of media content. This class may be used to express complex media containers with many streams of various media content (both aural and visual).</para><para>Children: <link linkend="ZEITGEIST-NFO-VISUAL:CAPS"><literal>ZEITGEIST_NFO_VISUAL</literal></link>, <link linkend="ZEITGEIST-NFO-AUDIO:CAPS"><literal>ZEITGEIST_NFO_AUDIO</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_MEDIA_LIST:
 * 
 * MEDIA_LIST:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList"></ulink></para><para>A file containing a list of media files.e.g. a playlist</para><para>Children: <link linkend="ZEITGEIST-NMM-MUSIC-ALBUM:CAPS"><literal>ZEITGEIST_NMM_MUSIC_ALBUM</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_MEDIA_STREAM:
 * 
 * MEDIA_STREAM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaStream"></ulink></para><para>A stream of multimedia content, usually contained within a media container such as a movie (containing both audio and video) or a DVD (possibly containing many streams of audio and video). Most common interpretations for such a DataObject include Audio and Video.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_MIND_MAP:
 * 
 * MIND_MAP:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MindMap"></ulink></para><para>A MindMap, created by a mind-mapping utility. Examples might include FreeMind or mind mapper.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_OPERATING_SYSTEM:
 * 
 * OPERATING_SYSTEM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#OperatingSystem"></ulink></para><para>An OperatingSystem</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-SOFTWARE:CAPS"><literal>ZEITGEIST_NFO_SOFTWARE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT:
 * 
 * PAGINATED_TEXT_DOCUMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedTextDocument"></ulink></para><para>A file containing a text document, that is unambiguously divided into pages. Examples might include PDF, DOC, PS, DVI etc.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_TEXT_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT:
 * 
 * PLAIN_TEXT_DOCUMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PlainTextDocument"></ulink></para><para>A file containing plain text (ASCII, Unicode or other encodings). Examples may include TXT, HTML, XML, program source code etc.</para><para>Children: <link linkend="ZEITGEIST-NFO-SOURCE-CODE:CAPS"><literal>ZEITGEIST_NFO_SOURCE_CODE</literal></link>, <link linkend="ZEITGEIST-NFO-HTML-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_HTML_DOCUMENT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_TEXT_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_PRESENTATION:
 * 
 * PRESENTATION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation"></ulink></para><para>A Presentation made by some presentation software (Corel Presentations, OpenOffice Impress, MS Powerpoint etc.)</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_RASTER_IMAGE:
 * 
 * RASTER_IMAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage"></ulink></para><para>A raster image.</para><para>Children: <link linkend="ZEITGEIST-NFO-CURSOR:CAPS"><literal>ZEITGEIST_NFO_CURSOR</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-IMAGE:CAPS"><literal>ZEITGEIST_NFO_IMAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_REMOTE_DATA_OBJECT:
 * 
 * REMOTE_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObject"></ulink></para><para>A file data object stored at a remote location. Don&apos;t confuse this class with a RemotePortAddress. This one applies to a particular resource, RemotePortAddress applies to an address, that can have various interpretations.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_FILE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_REMOTE_PORT_ADDRESS:
 * 
 * REMOTE_PORT_ADDRESS:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemotePortAddress"></ulink></para><para>An address specifying a remote host and port. Such an address can be interpreted in many ways (examples of such interpretations include mailboxes, websites, remote calendars or filesystems), depending on an interpretation, various kinds of data may be extracted from such an address.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_SOFTWARE:
 * 
 * SOFTWARE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software"></ulink></para><para>A piece of software. Examples may include applications and the operating system. This interpretation most commonly applies to SoftwareItems.</para><para>Children: <link linkend="ZEITGEIST-NFO-OPERATING-SYSTEM:CAPS"><literal>ZEITGEIST_NFO_OPERATING_SYSTEM</literal></link>, <link linkend="ZEITGEIST-NFO-APPLICATION:CAPS"><literal>ZEITGEIST_NFO_APPLICATION</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_SOFTWARE_ITEM:
 * 
 * SOFTWARE_ITEM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareItem"></ulink></para><para>A DataObject representing a piece of software. Examples of interpretations of a SoftwareItem include an Application and an OperatingSystem.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_SOFTWARE_SERVICE:
 * 
 * SOFTWARE_SERVICE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SoftwareService"></ulink></para><para>A service published by a piece of software, either by an operating system or an application. Examples of such services may include calendar, addressbook and mailbox managed by a PIM application. This category is introduced to distinguish between data available directly from the applications (Via some Interprocess Communication Mechanisms) and data available from files on a disk. In either case both DataObjects would receive a similar interpretation (e.g. a Mailbox) and wouldn&apos;t differ on the content level.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_SOURCE_CODE:
 * 
 * SOURCE_CODE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode"></ulink></para><para>Code in a compilable or interpreted programming language.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-PLAIN-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_SPREADSHEET:
 * 
 * SPREADSHEET:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet"></ulink></para><para>A spreadsheet, created by a spreadsheet application. Examples might include Gnumeric, OpenOffice Calc or MS Excel.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_TEXT_DOCUMENT:
 * 
 * TEXT_DOCUMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument"></ulink></para><para>A text document</para><para>Children: <link linkend="ZEITGEIST-NFO-PAGINATED-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT</literal></link>, <link linkend="ZEITGEIST-NFO-PLAIN-TEXT-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_PLAIN_TEXT_DOCUMENT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_DOCUMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_TRASH:
 * 
 * TRASH:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Trash"></ulink></para><para>Represents a container for deleted files, a feature common in modern operating systems.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-DATA-CONTAINER:CAPS"><literal>ZEITGEIST_NFO_DATA_CONTAINER</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_VECTOR_IMAGE:
 * 
 * VECTOR_IMAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage"></ulink></para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-IMAGE:CAPS"><literal>ZEITGEIST_NFO_IMAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_VIDEO:
 * 
 * VIDEO:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video"></ulink></para><para>A video file.</para><para>Children: <link linkend="ZEITGEIST-NMM-TVSHOW:CAPS"><literal>ZEITGEIST_NMM_TVSHOW</literal></link>, <link linkend="ZEITGEIST-NMM-MOVIE:CAPS"><literal>ZEITGEIST_NMM_MOVIE</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-VISUAL:CAPS"><literal>ZEITGEIST_NFO_VISUAL</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_VISUAL:
 * 
 * VISUAL:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Visual"></ulink></para><para>File containing visual content.</para><para>Children: <link linkend="ZEITGEIST-NFO-IMAGE:CAPS"><literal>ZEITGEIST_NFO_IMAGE</literal></link>, <link linkend="ZEITGEIST-NFO-VIDEO:CAPS"><literal>ZEITGEIST_NFO_VIDEO</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NFO-MEDIA:CAPS"><literal>ZEITGEIST_NFO_MEDIA</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_WEBSITE:
 * 
 * WEBSITE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Website"></ulink></para><para>A website, usually a container for remote resources, that may be interpreted as HTMLDocuments, images or other types of content.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NFO_WEB_DATA_OBJECT:
 * 
 * WEB_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject"></ulink></para><para>An information resources of which representations (files, streams) can be retrieved through a web server. They may be generated at retrieval time. Typical examples are pages served by PHP or AJAX or mp3 streams.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NIE_DATA_OBJECT:
 * 
 * DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/01/19/nie#DataObject"></ulink></para><para>A unit of data that is created, annotated and processed on the user desktop. It represents a native structure the user works with. The usage of the term &apos;native&apos; is important. It means that a DataObject can be directly mapped to a data structure maintained by a native application. This may be a file, a set of files or a part of a file. The granularity depends on the user. This class is not intended to be instantiated by itself. Use more specific subclasses.</para><para>Children: <link linkend="ZEITGEIST-NFO-MEDIA-STREAM:CAPS"><literal>ZEITGEIST_NFO_MEDIA_STREAM</literal></link>, <link linkend="ZEITGEIST-NFO-FILE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_FILE_DATA_OBJECT</literal></link>, <link linkend="ZEITGEIST-NFO-SOFTWARE-SERVICE:CAPS"><literal>ZEITGEIST_NFO_SOFTWARE_SERVICE</literal></link>, <link linkend="ZEITGEIST-NFO-HARD-DISK-PARTITION:CAPS"><literal>ZEITGEIST_NFO_HARD_DISK_PARTITION</literal></link>, <link linkend="ZEITGEIST-NCO-CONTACT-LIST-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NCO_CONTACT_LIST_DATA_OBJECT</literal></link>, <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link>, <link linkend="ZEITGEIST-NMO-MAILBOX-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NMO_MAILBOX_DATA_OBJECT</literal></link>, <link linkend="ZEITGEIST-NFO-WEB-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NFO_WEB_DATA_OBJECT</literal></link>, <link linkend="ZEITGEIST-NFO-REMOTE-PORT-ADDRESS:CAPS"><literal>ZEITGEIST_NFO_REMOTE_PORT_ADDRESS</literal></link>, <link linkend="ZEITGEIST-NFO-SOFTWARE-ITEM:CAPS"><literal>ZEITGEIST_NFO_SOFTWARE_ITEM</literal></link>, <link linkend="ZEITGEIST-NCAL-CALENDAR-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NCAL_CALENDAR_DATA_OBJECT</literal></link></para><para>Parents: None</para>
 */
/**
 * ZEITGEIST_NIE_INFORMATION_ELEMENT:
 * 
 * INFORMATION_ELEMENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/01/19/nie#InformationElement"></ulink></para><para>A unit of content the user works with. This is a superclass for all interpretations of a DataObject.</para><para>Children: <link linkend="ZEITGEIST-NFO-EXECUTABLE:CAPS"><literal>ZEITGEIST_NFO_EXECUTABLE</literal></link>, <link linkend="ZEITGEIST-NCAL-JOURNAL:CAPS"><literal>ZEITGEIST_NCAL_JOURNAL</literal></link>, <link linkend="ZEITGEIST-NMO-MESSAGE:CAPS"><literal>ZEITGEIST_NMO_MESSAGE</literal></link>, <link linkend="ZEITGEIST-NFO-WEBSITE:CAPS"><literal>ZEITGEIST_NFO_WEBSITE</literal></link>, <link linkend="ZEITGEIST-NCAL-TODO:CAPS"><literal>ZEITGEIST_NCAL_TODO</literal></link>, <link linkend="ZEITGEIST-NFO-MEDIA-LIST:CAPS"><literal>ZEITGEIST_NFO_MEDIA_LIST</literal></link>, <link linkend="ZEITGEIST-NCAL-ALARM:CAPS"><literal>ZEITGEIST_NCAL_ALARM</literal></link>, <link linkend="ZEITGEIST-NCAL-CALENDAR:CAPS"><literal>ZEITGEIST_NCAL_CALENDAR</literal></link>, <link linkend="ZEITGEIST-NCO-CONTACT:CAPS"><literal>ZEITGEIST_NCO_CONTACT</literal></link>, <link linkend="ZEITGEIST-NCAL-EVENT:CAPS"><literal>ZEITGEIST_NCAL_EVENT</literal></link>, <link linkend="ZEITGEIST-NFO-BOOKMARK-FOLDER:CAPS"><literal>ZEITGEIST_NFO_BOOKMARK_FOLDER</literal></link>, <link linkend="ZEITGEIST-ZG-APPLICATION-ACTION:CAPS"><literal>ZEITGEIST_ZG_APPLICATION_ACTION</literal></link>, <link linkend="ZEITGEIST-NFO-BOOKMARK:CAPS"><literal>ZEITGEIST_NFO_BOOKMARK</literal></link>, <link linkend="ZEITGEIST-NFO-FONT:CAPS"><literal>ZEITGEIST_NFO_FONT</literal></link>, <link linkend="ZEITGEIST-NFO-DATA-CONTAINER:CAPS"><literal>ZEITGEIST_NFO_DATA_CONTAINER</literal></link>, <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link>, <link linkend="ZEITGEIST-NFO-DOCUMENT:CAPS"><literal>ZEITGEIST_NFO_DOCUMENT</literal></link>, <link linkend="ZEITGEIST-NMO-MAILBOX:CAPS"><literal>ZEITGEIST_NMO_MAILBOX</literal></link>, <link linkend="ZEITGEIST-NCAL-FREEBUSY:CAPS"><literal>ZEITGEIST_NCAL_FREEBUSY</literal></link>, <link linkend="ZEITGEIST-NCO-CONTACT-LIST:CAPS"><literal>ZEITGEIST_NCO_CONTACT_LIST</literal></link>, <link linkend="ZEITGEIST-NMM-TVSERIES:CAPS"><literal>ZEITGEIST_NMM_TVSERIES</literal></link>, <link linkend="ZEITGEIST-NCO-CONTACT-GROUP:CAPS"><literal>ZEITGEIST_NCO_CONTACT_GROUP</literal></link>, <link linkend="ZEITGEIST-NFO-SOFTWARE:CAPS"><literal>ZEITGEIST_NFO_SOFTWARE</literal></link>, <link linkend="ZEITGEIST-NCAL-TIMEZONE:CAPS"><literal>ZEITGEIST_NCAL_TIMEZONE</literal></link>, <link linkend="ZEITGEIST-NMO-MIME-ENTITY:CAPS"><literal>ZEITGEIST_NMO_MIME_ENTITY</literal></link>, <link linkend="ZEITGEIST-NFO-MEDIA:CAPS"><literal>ZEITGEIST_NFO_MEDIA</literal></link></para><para>Parents: None</para>
 */
/**
 * ZEITGEIST_NMM_MOVIE:
 * 
 * MOVIE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#Movie"></ulink></para><para>A Movie</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-VIDEO:CAPS"><literal>ZEITGEIST_NFO_VIDEO</literal></link></para>
 */
/**
 * ZEITGEIST_NMM_MUSIC_ALBUM:
 * 
 * MUSIC_ALBUM:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicAlbum"></ulink></para><para>The music album as provided by the publisher. Not to be confused with media lists or collections.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-MEDIA-LIST:CAPS"><literal>ZEITGEIST_NFO_MEDIA_LIST</literal></link></para>
 */
/**
 * ZEITGEIST_NMM_MUSIC_PIECE:
 * 
 * MUSIC_PIECE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#MusicPiece"></ulink></para><para>Used to assign music-specific properties such a BPM to video and audio</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-AUDIO:CAPS"><literal>ZEITGEIST_NFO_AUDIO</literal></link></para>
 */
/**
 * ZEITGEIST_NMM_TVSERIES:
 * 
 * TVSERIES:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVSeries"></ulink></para><para>A TV Series has multiple seasons and episodes</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NMM_TVSHOW:
 * 
 * TVSHOW:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2009/02/19/nmm#TVShow"></ulink></para><para>A TV Show</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NFO-VIDEO:CAPS"><literal>ZEITGEIST_NFO_VIDEO</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_EMAIL:
 * 
 * EMAIL:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email"></ulink></para><para>An email.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NMO-MESSAGE:CAPS"><literal>ZEITGEIST_NMO_MESSAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_IMMESSAGE:
 * 
 * IMMESSAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#IMMessage"></ulink></para><para>A message sent with Instant Messaging software.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NMO-MESSAGE:CAPS"><literal>ZEITGEIST_NMO_MESSAGE</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_MAILBOX:
 * 
 * MAILBOX:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Mailbox"></ulink></para><para>A mailbox - container for MailboxDataObjects.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_MAILBOX_DATA_OBJECT:
 * 
 * MAILBOX_DATA_OBJECT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MailboxDataObject"></ulink></para><para>An entity encountered in a mailbox. Most common interpretations for such an entity include Message or Folder</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_MESSAGE:
 * 
 * MESSAGE:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Message"></ulink></para><para>A message. Could be an email, instant messanging message, SMS message etc.</para><para>Children: <link linkend="ZEITGEIST-NMO-EMAIL:CAPS"><literal>ZEITGEIST_NMO_EMAIL</literal></link>, <link linkend="ZEITGEIST-NMO-IMMESSAGE:CAPS"><literal>ZEITGEIST_NMO_IMMESSAGE</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_NMO_MIME_ENTITY:
 * 
 * MIME_ENTITY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#MimeEntity"></ulink></para><para>A MIME entity, as defined in RFC2045, Section 2.4.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_ACCEPT_EVENT:
 * 
 * ACCEPT_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AcceptEvent"></ulink></para><para>Event triggered when the user accepts a request of some sort. Examples could be answering a phone call, accepting a file transfer, or accepting a friendship request over an IM protocol. See also DenyEvent for when the user denies a similar request</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_ACCESS_EVENT:
 * 
 * ACCESS_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#AccessEvent"></ulink></para><para>Event triggered by opening, accessing, or starting a resource. Most zg:AccessEvents will have an accompanying zg:LeaveEvent, but this need not always be the case</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_APPLICATION_ACTION:
 * 
 * APPLICATION_ACTION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ApplicationAction"></ulink></para><para>Representation of a specific Action on an Application</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_CREATE_EVENT:
 * 
 * CREATE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#CreateEvent"></ulink></para><para>Event type triggered when an item is created</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_DELETE_EVENT:
 * 
 * DELETE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DeleteEvent"></ulink></para><para>Event triggered because a resource has been deleted or otherwise made permanently unavailable. Fx. when deleting a file. FIXME: How about when moving to trash?</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_DENY_EVENT:
 * 
 * DENY_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#DenyEvent"></ulink></para><para>Event triggered when the user denies a request of some sort. Examples could be rejecting a phone call, rejecting a file transfer, or denying a friendship request over an IM protocol. See also AcceptEvent for the converse event type</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_EVENT_INTERPRETATION:
 * 
 * EVENT_INTERPRETATION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventInterpretation"></ulink></para><para>Base class for event interpretations. Please do no instantiate directly, but use one of the sub classes. The interpretation of an event describes &apos;what happened&apos; - fx. &apos;something was created&apos; or &apos;something was accessed&apos;</para><para>Children: <link linkend="ZEITGEIST-ZG-DENY-EVENT:CAPS"><literal>ZEITGEIST_ZG_DENY_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-ACCESS-EVENT:CAPS"><literal>ZEITGEIST_ZG_ACCESS_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-EXPIRE-EVENT:CAPS"><literal>ZEITGEIST_ZG_EXPIRE_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-LEAVE-EVENT:CAPS"><literal>ZEITGEIST_ZG_LEAVE_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-CREATE-EVENT:CAPS"><literal>ZEITGEIST_ZG_CREATE_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-MOVE-EVENT:CAPS"><literal>ZEITGEIST_ZG_MOVE_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-ACCEPT-EVENT:CAPS"><literal>ZEITGEIST_ZG_ACCEPT_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-SEND-EVENT:CAPS"><literal>ZEITGEIST_ZG_SEND_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-MODIFY-EVENT:CAPS"><literal>ZEITGEIST_ZG_MODIFY_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-DELETE-EVENT:CAPS"><literal>ZEITGEIST_ZG_DELETE_EVENT</literal></link>, <link linkend="ZEITGEIST-ZG-RECEIVE-EVENT:CAPS"><literal>ZEITGEIST_ZG_RECEIVE_EVENT</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-INFORMATION-ELEMENT:CAPS"><literal>ZEITGEIST_NIE_INFORMATION_ELEMENT</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_EVENT_MANIFESTATION:
 * 
 * EVENT_MANIFESTATION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#EventManifestation"></ulink></para><para>Base class for event manifestation types. Please do no instantiate directly, but use one of the sub classes. The manifestation of an event describes &apos;how it happened&apos;. Fx. &apos;the user did this&apos; or &apos;the system notified the user&apos;</para><para>Children: <link linkend="ZEITGEIST-ZG-USER-ACTIVITY:CAPS"><literal>ZEITGEIST_ZG_USER_ACTIVITY</literal></link>, <link linkend="ZEITGEIST-ZG-WORLD-ACTIVITY:CAPS"><literal>ZEITGEIST_ZG_WORLD_ACTIVITY</literal></link>, <link linkend="ZEITGEIST-ZG-HEURISTIC-ACTIVITY:CAPS"><literal>ZEITGEIST_ZG_HEURISTIC_ACTIVITY</literal></link>, <link linkend="ZEITGEIST-ZG-SCHEDULED-ACTIVITY:CAPS"><literal>ZEITGEIST_ZG_SCHEDULED_ACTIVITY</literal></link>, <link linkend="ZEITGEIST-ZG-SYSTEM-NOTIFICATION:CAPS"><literal>ZEITGEIST_ZG_SYSTEM_NOTIFICATION</literal></link></para><para>Parents: <link linkend="ZEITGEIST-NIE-DATA-OBJECT:CAPS"><literal>ZEITGEIST_NIE_DATA_OBJECT</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_EXPIRE_EVENT:
 * 
 * EXPIRE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ExpireEvent"></ulink></para><para>Event triggered when something expires or times out. These types of events are normally not triggered by the user, but by the operating system or some external party. Examples are a recurring calendar item or task deadline that expires or a when the user fails to respond to an external request such as a phone call</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_HEURISTIC_ACTIVITY:
 * 
 * HEURISTIC_ACTIVITY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#HeuristicActivity"></ulink></para><para>An event that is caused indirectly from user activity or deducted via analysis of other events. Fx. if an algorithm divides a user workflow into disjoint &apos;projects&apos; based on temporal analysis it could insert heuristic events when the user changed project</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_LEAVE_EVENT:
 * 
 * LEAVE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#LeaveEvent"></ulink></para><para>Event triggered by closing, leaving, or stopping a resource. Most zg:LeaveEvents will be following a zg:Access event, but this need not always be the case</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_MODIFY_EVENT:
 * 
 * MODIFY_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ModifyEvent"></ulink></para><para>Event triggered by modifying an existing resources. Fx. when editing and saving a file on disk or correcting a typo in the name of a contact</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_MOVE_EVENT:
 * 
 * MOVE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#MoveEvent"></ulink></para><para>Event triggered when a resource has been moved from a location to another. Fx. moving a file from a folder to another.</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_RECEIVE_EVENT:
 * 
 * RECEIVE_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ReceiveEvent"></ulink></para><para>Event triggered when something is received from an external party. The event manifestation must be set according to the world view of the receiving party. Most often the item that is being received will be some sort of message - an email, instant message, or broadcasted media such as micro blogging</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_SCHEDULED_ACTIVITY:
 * 
 * SCHEDULED_ACTIVITY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#ScheduledActivity"></ulink></para><para>An event that was directly triggered by some user initiated sequence of actions. For example a music player automatically changing to the next song in a playlist</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_SEND_EVENT:
 * 
 * SEND_EVENT:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SendEvent"></ulink></para><para>Event triggered when something is send to an external party. The event manifestation must be set according to the world view of the sending party. Most often the item that is being send will be some sort of message - an email, instant message, or broadcasted media such as micro blogging</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-INTERPRETATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_INTERPRETATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_SYSTEM_NOTIFICATION:
 * 
 * SYSTEM_NOTIFICATION:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#SystemNotification"></ulink></para><para>An event send to the user by the operating system. Examples could include when the user inserts a USB stick or when the system warns that the hard disk is full</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_USER_ACTIVITY:
 * 
 * USER_ACTIVITY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#UserActivity"></ulink></para><para>An event that was actively performed by the user. For example saving or opening a file by clicking on it in the file manager</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link></para>
 */
/**
 * ZEITGEIST_ZG_WORLD_ACTIVITY:
 * 
 * WORLD_ACTIVITY:
 * 
 * <para>Macro defining the interpretation type <ulink url="http://www.zeitgeist-project.com/ontologies/2010/01/27/zg#WorldActivity"></ulink></para><para>An event that was performed by an entity, usually human or organization, other than the user. An example could be logging the activities of other people in a team</para><para>Children: None</para><para>Parents: <link linkend="ZEITGEIST-ZG-EVENT-MANIFESTATION:CAPS"><literal>ZEITGEIST_ZG_EVENT_MANIFESTATION</literal></link></para>
 */
