/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* If you want the full range of tests, compile with
 * -DNSS_SOFTOKEN_DH_INCLUDE_SLOW. These tests could take minuts on a fast
 *  PC and longer on a slow mac */

namespace nss_test {
/* first list the primes we want to test */

/* known primes */
/* IKE 1536 prime is: 2^1536 - 2^1472 - 1 + 2^64 * { [2^1406 pi] + 741804 } */
static const unsigned char prime_ike_1536[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x23, 0x73, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* IKE 2048 prime is: 2^2048 - 2^1984 - 1 + 2^64 * { [2^1918 pi] + 124476 } */
static const unsigned char prime_ike_2048[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x18, 0x21, 0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
    0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03, 0x9B, 0x27, 0x83, 0xA2,
    0xEC, 0x07, 0xA2, 0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
    0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7C,
    0xEA, 0x95, 0x6A, 0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
    0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAC, 0xAA, 0x68, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF};

/* TLS 2048 prime is: 2^2048 - 2^1984 + {[2^1918 * e] + 560316 } * 2^64 - 1 */
static const unsigned char prime_tls_2048[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x28, 0x5C, 0x97, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF};

/* IKE 3072 prime is: 2^3072 - 2^3008 - 1 + 2^64 * { [2^2942 pi] + 1690314 } */
static const unsigned char prime_ike_3072[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x18, 0x21, 0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
    0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03, 0x9B, 0x27, 0x83, 0xA2,
    0xEC, 0x07, 0xA2, 0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
    0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7C,
    0xEA, 0x95, 0x6A, 0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
    0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAA, 0xC4, 0x2D, 0xAD, 0x33, 0x17, 0x0D,
    0x04, 0x50, 0x7A, 0x33, 0xA8, 0x55, 0x21, 0xAB, 0xDF, 0x1C, 0xBA, 0x64,
    0xEC, 0xFB, 0x85, 0x04, 0x58, 0xDB, 0xEF, 0x0A, 0x8A, 0xEA, 0x71, 0x57,
    0x5D, 0x06, 0x0C, 0x7D, 0xB3, 0x97, 0x0F, 0x85, 0xA6, 0xE1, 0xE4, 0xC7,
    0xAB, 0xF5, 0xAE, 0x8C, 0xDB, 0x09, 0x33, 0xD7, 0x1E, 0x8C, 0x94, 0xE0,
    0x4A, 0x25, 0x61, 0x9D, 0xCE, 0xE3, 0xD2, 0x26, 0x1A, 0xD2, 0xEE, 0x6B,
    0xF1, 0x2F, 0xFA, 0x06, 0xD9, 0x8A, 0x08, 0x64, 0xD8, 0x76, 0x02, 0x73,
    0x3E, 0xC8, 0x6A, 0x64, 0x52, 0x1F, 0x2B, 0x18, 0x17, 0x7B, 0x20, 0x0C,
    0xBB, 0xE1, 0x17, 0x57, 0x7A, 0x61, 0x5D, 0x6C, 0x77, 0x09, 0x88, 0xC0,
    0xBA, 0xD9, 0x46, 0xE2, 0x08, 0xE2, 0x4F, 0xA0, 0x74, 0xE5, 0xAB, 0x31,
    0x43, 0xDB, 0x5B, 0xFC, 0xE0, 0xFD, 0x10, 0x8E, 0x4B, 0x82, 0xD1, 0x20,
    0xA9, 0x3A, 0xD2, 0xCA, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* TLS 3072 prime is: 2^3072 - 2^3008 + {[2^2942 * e] + 2625351} * 2^64 - 1 */
static const unsigned char prime_tls_3072[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x1F, 0xCF, 0xDC, 0xDE, 0x35, 0x5B, 0x3B,
    0x65, 0x19, 0x03, 0x5B, 0xBC, 0x34, 0xF4, 0xDE, 0xF9, 0x9C, 0x02, 0x38,
    0x61, 0xB4, 0x6F, 0xC9, 0xD6, 0xE6, 0xC9, 0x07, 0x7A, 0xD9, 0x1D, 0x26,
    0x91, 0xF7, 0xF7, 0xEE, 0x59, 0x8C, 0xB0, 0xFA, 0xC1, 0x86, 0xD9, 0x1C,
    0xAE, 0xFE, 0x13, 0x09, 0x85, 0x13, 0x92, 0x70, 0xB4, 0x13, 0x0C, 0x93,
    0xBC, 0x43, 0x79, 0x44, 0xF4, 0xFD, 0x44, 0x52, 0xE2, 0xD7, 0x4D, 0xD3,
    0x64, 0xF2, 0xE2, 0x1E, 0x71, 0xF5, 0x4B, 0xFF, 0x5C, 0xAE, 0x82, 0xAB,
    0x9C, 0x9D, 0xF6, 0x9E, 0xE8, 0x6D, 0x2B, 0xC5, 0x22, 0x36, 0x3A, 0x0D,
    0xAB, 0xC5, 0x21, 0x97, 0x9B, 0x0D, 0xEA, 0xDA, 0x1D, 0xBF, 0x9A, 0x42,
    0xD5, 0xC4, 0x48, 0x4E, 0x0A, 0xBC, 0xD0, 0x6B, 0xFA, 0x53, 0xDD, 0xEF,
    0x3C, 0x1B, 0x20, 0xEE, 0x3F, 0xD5, 0x9D, 0x7C, 0x25, 0xE4, 0x1D, 0x2B,
    0x66, 0xC6, 0x2E, 0x37, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* IKE 4096 prime is: 2^4096 - 2^4032 - 1 + 2^64 * { [2^3966 pi] + 240904 } */
static const unsigned char prime_ike_4096[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x18, 0x21, 0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
    0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03, 0x9B, 0x27, 0x83, 0xA2,
    0xEC, 0x07, 0xA2, 0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
    0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7C,
    0xEA, 0x95, 0x6A, 0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
    0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAA, 0xC4, 0x2D, 0xAD, 0x33, 0x17, 0x0D,
    0x04, 0x50, 0x7A, 0x33, 0xA8, 0x55, 0x21, 0xAB, 0xDF, 0x1C, 0xBA, 0x64,
    0xEC, 0xFB, 0x85, 0x04, 0x58, 0xDB, 0xEF, 0x0A, 0x8A, 0xEA, 0x71, 0x57,
    0x5D, 0x06, 0x0C, 0x7D, 0xB3, 0x97, 0x0F, 0x85, 0xA6, 0xE1, 0xE4, 0xC7,
    0xAB, 0xF5, 0xAE, 0x8C, 0xDB, 0x09, 0x33, 0xD7, 0x1E, 0x8C, 0x94, 0xE0,
    0x4A, 0x25, 0x61, 0x9D, 0xCE, 0xE3, 0xD2, 0x26, 0x1A, 0xD2, 0xEE, 0x6B,
    0xF1, 0x2F, 0xFA, 0x06, 0xD9, 0x8A, 0x08, 0x64, 0xD8, 0x76, 0x02, 0x73,
    0x3E, 0xC8, 0x6A, 0x64, 0x52, 0x1F, 0x2B, 0x18, 0x17, 0x7B, 0x20, 0x0C,
    0xBB, 0xE1, 0x17, 0x57, 0x7A, 0x61, 0x5D, 0x6C, 0x77, 0x09, 0x88, 0xC0,
    0xBA, 0xD9, 0x46, 0xE2, 0x08, 0xE2, 0x4F, 0xA0, 0x74, 0xE5, 0xAB, 0x31,
    0x43, 0xDB, 0x5B, 0xFC, 0xE0, 0xFD, 0x10, 0x8E, 0x4B, 0x82, 0xD1, 0x20,
    0xA9, 0x21, 0x08, 0x01, 0x1A, 0x72, 0x3C, 0x12, 0xA7, 0x87, 0xE6, 0xD7,
    0x88, 0x71, 0x9A, 0x10, 0xBD, 0xBA, 0x5B, 0x26, 0x99, 0xC3, 0x27, 0x18,
    0x6A, 0xF4, 0xE2, 0x3C, 0x1A, 0x94, 0x68, 0x34, 0xB6, 0x15, 0x0B, 0xDA,
    0x25, 0x83, 0xE9, 0xCA, 0x2A, 0xD4, 0x4C, 0xE8, 0xDB, 0xBB, 0xC2, 0xDB,
    0x04, 0xDE, 0x8E, 0xF9, 0x2E, 0x8E, 0xFC, 0x14, 0x1F, 0xBE, 0xCA, 0xA6,
    0x28, 0x7C, 0x59, 0x47, 0x4E, 0x6B, 0xC0, 0x5D, 0x99, 0xB2, 0x96, 0x4F,
    0xA0, 0x90, 0xC3, 0xA2, 0x23, 0x3B, 0xA1, 0x86, 0x51, 0x5B, 0xE7, 0xED,
    0x1F, 0x61, 0x29, 0x70, 0xCE, 0xE2, 0xD7, 0xAF, 0xB8, 0x1B, 0xDD, 0x76,
    0x21, 0x70, 0x48, 0x1C, 0xD0, 0x06, 0x91, 0x27, 0xD5, 0xB0, 0x5A, 0xA9,
    0x93, 0xB4, 0xEA, 0x98, 0x8D, 0x8F, 0xDD, 0xC1, 0x86, 0xFF, 0xB7, 0xDC,
    0x90, 0xA6, 0xC0, 0x8F, 0x4D, 0xF4, 0x35, 0xC9, 0x34, 0x06, 0x31, 0x99,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* TLS 4096 prime is: 2^4096 - 2^4032 + {[2^3966 * e] + 5736041} * 2^64 - 1 */
static const unsigned char prime_tls_4096[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x1F, 0xCF, 0xDC, 0xDE, 0x35, 0x5B, 0x3B,
    0x65, 0x19, 0x03, 0x5B, 0xBC, 0x34, 0xF4, 0xDE, 0xF9, 0x9C, 0x02, 0x38,
    0x61, 0xB4, 0x6F, 0xC9, 0xD6, 0xE6, 0xC9, 0x07, 0x7A, 0xD9, 0x1D, 0x26,
    0x91, 0xF7, 0xF7, 0xEE, 0x59, 0x8C, 0xB0, 0xFA, 0xC1, 0x86, 0xD9, 0x1C,
    0xAE, 0xFE, 0x13, 0x09, 0x85, 0x13, 0x92, 0x70, 0xB4, 0x13, 0x0C, 0x93,
    0xBC, 0x43, 0x79, 0x44, 0xF4, 0xFD, 0x44, 0x52, 0xE2, 0xD7, 0x4D, 0xD3,
    0x64, 0xF2, 0xE2, 0x1E, 0x71, 0xF5, 0x4B, 0xFF, 0x5C, 0xAE, 0x82, 0xAB,
    0x9C, 0x9D, 0xF6, 0x9E, 0xE8, 0x6D, 0x2B, 0xC5, 0x22, 0x36, 0x3A, 0x0D,
    0xAB, 0xC5, 0x21, 0x97, 0x9B, 0x0D, 0xEA, 0xDA, 0x1D, 0xBF, 0x9A, 0x42,
    0xD5, 0xC4, 0x48, 0x4E, 0x0A, 0xBC, 0xD0, 0x6B, 0xFA, 0x53, 0xDD, 0xEF,
    0x3C, 0x1B, 0x20, 0xEE, 0x3F, 0xD5, 0x9D, 0x7C, 0x25, 0xE4, 0x1D, 0x2B,
    0x66, 0x9E, 0x1E, 0xF1, 0x6E, 0x6F, 0x52, 0xC3, 0x16, 0x4D, 0xF4, 0xFB,
    0x79, 0x30, 0xE9, 0xE4, 0xE5, 0x88, 0x57, 0xB6, 0xAC, 0x7D, 0x5F, 0x42,
    0xD6, 0x9F, 0x6D, 0x18, 0x77, 0x63, 0xCF, 0x1D, 0x55, 0x03, 0x40, 0x04,
    0x87, 0xF5, 0x5B, 0xA5, 0x7E, 0x31, 0xCC, 0x7A, 0x71, 0x35, 0xC8, 0x86,
    0xEF, 0xB4, 0x31, 0x8A, 0xED, 0x6A, 0x1E, 0x01, 0x2D, 0x9E, 0x68, 0x32,
    0xA9, 0x07, 0x60, 0x0A, 0x91, 0x81, 0x30, 0xC4, 0x6D, 0xC7, 0x78, 0xF9,
    0x71, 0xAD, 0x00, 0x38, 0x09, 0x29, 0x99, 0xA3, 0x33, 0xCB, 0x8B, 0x7A,
    0x1A, 0x1D, 0xB9, 0x3D, 0x71, 0x40, 0x00, 0x3C, 0x2A, 0x4E, 0xCE, 0xA9,
    0xF9, 0x8D, 0x0A, 0xCC, 0x0A, 0x82, 0x91, 0xCD, 0xCE, 0xC9, 0x7D, 0xCF,
    0x8E, 0xC9, 0xB5, 0x5A, 0x7F, 0x88, 0xA4, 0x6B, 0x4D, 0xB5, 0xA8, 0x51,
    0xF4, 0x41, 0x82, 0xE1, 0xC6, 0x8A, 0x00, 0x7E, 0x5E, 0x65, 0x5F, 0x6A,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* IKE 6144 prime is: 2^6144 - 2^6080 - 1 + 2^64 * { [2^6014 pi] + 929484 } */
static const unsigned char prime_ike_6144[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x18, 0x21, 0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
    0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03, 0x9B, 0x27, 0x83, 0xA2,
    0xEC, 0x07, 0xA2, 0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
    0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7C,
    0xEA, 0x95, 0x6A, 0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
    0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAA, 0xC4, 0x2D, 0xAD, 0x33, 0x17, 0x0D,
    0x04, 0x50, 0x7A, 0x33, 0xA8, 0x55, 0x21, 0xAB, 0xDF, 0x1C, 0xBA, 0x64,
    0xEC, 0xFB, 0x85, 0x04, 0x58, 0xDB, 0xEF, 0x0A, 0x8A, 0xEA, 0x71, 0x57,
    0x5D, 0x06, 0x0C, 0x7D, 0xB3, 0x97, 0x0F, 0x85, 0xA6, 0xE1, 0xE4, 0xC7,
    0xAB, 0xF5, 0xAE, 0x8C, 0xDB, 0x09, 0x33, 0xD7, 0x1E, 0x8C, 0x94, 0xE0,
    0x4A, 0x25, 0x61, 0x9D, 0xCE, 0xE3, 0xD2, 0x26, 0x1A, 0xD2, 0xEE, 0x6B,
    0xF1, 0x2F, 0xFA, 0x06, 0xD9, 0x8A, 0x08, 0x64, 0xD8, 0x76, 0x02, 0x73,
    0x3E, 0xC8, 0x6A, 0x64, 0x52, 0x1F, 0x2B, 0x18, 0x17, 0x7B, 0x20, 0x0C,
    0xBB, 0xE1, 0x17, 0x57, 0x7A, 0x61, 0x5D, 0x6C, 0x77, 0x09, 0x88, 0xC0,
    0xBA, 0xD9, 0x46, 0xE2, 0x08, 0xE2, 0x4F, 0xA0, 0x74, 0xE5, 0xAB, 0x31,
    0x43, 0xDB, 0x5B, 0xFC, 0xE0, 0xFD, 0x10, 0x8E, 0x4B, 0x82, 0xD1, 0x20,
    0xA9, 0x21, 0x08, 0x01, 0x1A, 0x72, 0x3C, 0x12, 0xA7, 0x87, 0xE6, 0xD7,
    0x88, 0x71, 0x9A, 0x10, 0xBD, 0xBA, 0x5B, 0x26, 0x99, 0xC3, 0x27, 0x18,
    0x6A, 0xF4, 0xE2, 0x3C, 0x1A, 0x94, 0x68, 0x34, 0xB6, 0x15, 0x0B, 0xDA,
    0x25, 0x83, 0xE9, 0xCA, 0x2A, 0xD4, 0x4C, 0xE8, 0xDB, 0xBB, 0xC2, 0xDB,
    0x04, 0xDE, 0x8E, 0xF9, 0x2E, 0x8E, 0xFC, 0x14, 0x1F, 0xBE, 0xCA, 0xA6,
    0x28, 0x7C, 0x59, 0x47, 0x4E, 0x6B, 0xC0, 0x5D, 0x99, 0xB2, 0x96, 0x4F,
    0xA0, 0x90, 0xC3, 0xA2, 0x23, 0x3B, 0xA1, 0x86, 0x51, 0x5B, 0xE7, 0xED,
    0x1F, 0x61, 0x29, 0x70, 0xCE, 0xE2, 0xD7, 0xAF, 0xB8, 0x1B, 0xDD, 0x76,
    0x21, 0x70, 0x48, 0x1C, 0xD0, 0x06, 0x91, 0x27, 0xD5, 0xB0, 0x5A, 0xA9,
    0x93, 0xB4, 0xEA, 0x98, 0x8D, 0x8F, 0xDD, 0xC1, 0x86, 0xFF, 0xB7, 0xDC,
    0x90, 0xA6, 0xC0, 0x8F, 0x4D, 0xF4, 0x35, 0xC9, 0x34, 0x02, 0x84, 0x92,
    0x36, 0xC3, 0xFA, 0xB4, 0xD2, 0x7C, 0x70, 0x26, 0xC1, 0xD4, 0xDC, 0xB2,
    0x60, 0x26, 0x46, 0xDE, 0xC9, 0x75, 0x1E, 0x76, 0x3D, 0xBA, 0x37, 0xBD,
    0xF8, 0xFF, 0x94, 0x06, 0xAD, 0x9E, 0x53, 0x0E, 0xE5, 0xDB, 0x38, 0x2F,
    0x41, 0x30, 0x01, 0xAE, 0xB0, 0x6A, 0x53, 0xED, 0x90, 0x27, 0xD8, 0x31,
    0x17, 0x97, 0x27, 0xB0, 0x86, 0x5A, 0x89, 0x18, 0xDA, 0x3E, 0xDB, 0xEB,
    0xCF, 0x9B, 0x14, 0xED, 0x44, 0xCE, 0x6C, 0xBA, 0xCE, 0xD4, 0xBB, 0x1B,
    0xDB, 0x7F, 0x14, 0x47, 0xE6, 0xCC, 0x25, 0x4B, 0x33, 0x20, 0x51, 0x51,
    0x2B, 0xD7, 0xAF, 0x42, 0x6F, 0xB8, 0xF4, 0x01, 0x37, 0x8C, 0xD2, 0xBF,
    0x59, 0x83, 0xCA, 0x01, 0xC6, 0x4B, 0x92, 0xEC, 0xF0, 0x32, 0xEA, 0x15,
    0xD1, 0x72, 0x1D, 0x03, 0xF4, 0x82, 0xD7, 0xCE, 0x6E, 0x74, 0xFE, 0xF6,
    0xD5, 0x5E, 0x70, 0x2F, 0x46, 0x98, 0x0C, 0x82, 0xB5, 0xA8, 0x40, 0x31,
    0x90, 0x0B, 0x1C, 0x9E, 0x59, 0xE7, 0xC9, 0x7F, 0xBE, 0xC7, 0xE8, 0xF3,
    0x23, 0xA9, 0x7A, 0x7E, 0x36, 0xCC, 0x88, 0xBE, 0x0F, 0x1D, 0x45, 0xB7,
    0xFF, 0x58, 0x5A, 0xC5, 0x4B, 0xD4, 0x07, 0xB2, 0x2B, 0x41, 0x54, 0xAA,
    0xCC, 0x8F, 0x6D, 0x7E, 0xBF, 0x48, 0xE1, 0xD8, 0x14, 0xCC, 0x5E, 0xD2,
    0x0F, 0x80, 0x37, 0xE0, 0xA7, 0x97, 0x15, 0xEE, 0xF2, 0x9B, 0xE3, 0x28,
    0x06, 0xA1, 0xD5, 0x8B, 0xB7, 0xC5, 0xDA, 0x76, 0xF5, 0x50, 0xAA, 0x3D,
    0x8A, 0x1F, 0xBF, 0xF0, 0xEB, 0x19, 0xCC, 0xB1, 0xA3, 0x13, 0xD5, 0x5C,
    0xDA, 0x56, 0xC9, 0xEC, 0x2E, 0xF2, 0x96, 0x32, 0x38, 0x7F, 0xE8, 0xD7,
    0x6E, 0x3C, 0x04, 0x68, 0x04, 0x3E, 0x8F, 0x66, 0x3F, 0x48, 0x60, 0xEE,
    0x12, 0xBF, 0x2D, 0x5B, 0x0B, 0x74, 0x74, 0xD6, 0xE6, 0x94, 0xF9, 0x1E,
    0x6D, 0xCC, 0x40, 0x24, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* TLS 6144 prime is: 2^6144 - 2^6080 + {[2^6014 * e] + 15705020} * 2^64 - 1 */
static const unsigned char prime_tls_6144[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x1F, 0xCF, 0xDC, 0xDE, 0x35, 0x5B, 0x3B,
    0x65, 0x19, 0x03, 0x5B, 0xBC, 0x34, 0xF4, 0xDE, 0xF9, 0x9C, 0x02, 0x38,
    0x61, 0xB4, 0x6F, 0xC9, 0xD6, 0xE6, 0xC9, 0x07, 0x7A, 0xD9, 0x1D, 0x26,
    0x91, 0xF7, 0xF7, 0xEE, 0x59, 0x8C, 0xB0, 0xFA, 0xC1, 0x86, 0xD9, 0x1C,
    0xAE, 0xFE, 0x13, 0x09, 0x85, 0x13, 0x92, 0x70, 0xB4, 0x13, 0x0C, 0x93,
    0xBC, 0x43, 0x79, 0x44, 0xF4, 0xFD, 0x44, 0x52, 0xE2, 0xD7, 0x4D, 0xD3,
    0x64, 0xF2, 0xE2, 0x1E, 0x71, 0xF5, 0x4B, 0xFF, 0x5C, 0xAE, 0x82, 0xAB,
    0x9C, 0x9D, 0xF6, 0x9E, 0xE8, 0x6D, 0x2B, 0xC5, 0x22, 0x36, 0x3A, 0x0D,
    0xAB, 0xC5, 0x21, 0x97, 0x9B, 0x0D, 0xEA, 0xDA, 0x1D, 0xBF, 0x9A, 0x42,
    0xD5, 0xC4, 0x48, 0x4E, 0x0A, 0xBC, 0xD0, 0x6B, 0xFA, 0x53, 0xDD, 0xEF,
    0x3C, 0x1B, 0x20, 0xEE, 0x3F, 0xD5, 0x9D, 0x7C, 0x25, 0xE4, 0x1D, 0x2B,
    0x66, 0x9E, 0x1E, 0xF1, 0x6E, 0x6F, 0x52, 0xC3, 0x16, 0x4D, 0xF4, 0xFB,
    0x79, 0x30, 0xE9, 0xE4, 0xE5, 0x88, 0x57, 0xB6, 0xAC, 0x7D, 0x5F, 0x42,
    0xD6, 0x9F, 0x6D, 0x18, 0x77, 0x63, 0xCF, 0x1D, 0x55, 0x03, 0x40, 0x04,
    0x87, 0xF5, 0x5B, 0xA5, 0x7E, 0x31, 0xCC, 0x7A, 0x71, 0x35, 0xC8, 0x86,
    0xEF, 0xB4, 0x31, 0x8A, 0xED, 0x6A, 0x1E, 0x01, 0x2D, 0x9E, 0x68, 0x32,
    0xA9, 0x07, 0x60, 0x0A, 0x91, 0x81, 0x30, 0xC4, 0x6D, 0xC7, 0x78, 0xF9,
    0x71, 0xAD, 0x00, 0x38, 0x09, 0x29, 0x99, 0xA3, 0x33, 0xCB, 0x8B, 0x7A,
    0x1A, 0x1D, 0xB9, 0x3D, 0x71, 0x40, 0x00, 0x3C, 0x2A, 0x4E, 0xCE, 0xA9,
    0xF9, 0x8D, 0x0A, 0xCC, 0x0A, 0x82, 0x91, 0xCD, 0xCE, 0xC9, 0x7D, 0xCF,
    0x8E, 0xC9, 0xB5, 0x5A, 0x7F, 0x88, 0xA4, 0x6B, 0x4D, 0xB5, 0xA8, 0x51,
    0xF4, 0x41, 0x82, 0xE1, 0xC6, 0x8A, 0x00, 0x7E, 0x5E, 0x0D, 0xD9, 0x02,
    0x0B, 0xFD, 0x64, 0xB6, 0x45, 0x03, 0x6C, 0x7A, 0x4E, 0x67, 0x7D, 0x2C,
    0x38, 0x53, 0x2A, 0x3A, 0x23, 0xBA, 0x44, 0x42, 0xCA, 0xF5, 0x3E, 0xA6,
    0x3B, 0xB4, 0x54, 0x32, 0x9B, 0x76, 0x24, 0xC8, 0x91, 0x7B, 0xDD, 0x64,
    0xB1, 0xC0, 0xFD, 0x4C, 0xB3, 0x8E, 0x8C, 0x33, 0x4C, 0x70, 0x1C, 0x3A,
    0xCD, 0xAD, 0x06, 0x57, 0xFC, 0xCF, 0xEC, 0x71, 0x9B, 0x1F, 0x5C, 0x3E,
    0x4E, 0x46, 0x04, 0x1F, 0x38, 0x81, 0x47, 0xFB, 0x4C, 0xFD, 0xB4, 0x77,
    0xA5, 0x24, 0x71, 0xF7, 0xA9, 0xA9, 0x69, 0x10, 0xB8, 0x55, 0x32, 0x2E,
    0xDB, 0x63, 0x40, 0xD8, 0xA0, 0x0E, 0xF0, 0x92, 0x35, 0x05, 0x11, 0xE3,
    0x0A, 0xBE, 0xC1, 0xFF, 0xF9, 0xE3, 0xA2, 0x6E, 0x7F, 0xB2, 0x9F, 0x8C,
    0x18, 0x30, 0x23, 0xC3, 0x58, 0x7E, 0x38, 0xDA, 0x00, 0x77, 0xD9, 0xB4,
    0x76, 0x3E, 0x4E, 0x4B, 0x94, 0xB2, 0xBB, 0xC1, 0x94, 0xC6, 0x65, 0x1E,
    0x77, 0xCA, 0xF9, 0x92, 0xEE, 0xAA, 0xC0, 0x23, 0x2A, 0x28, 0x1B, 0xF6,
    0xB3, 0xA7, 0x39, 0xC1, 0x22, 0x61, 0x16, 0x82, 0x0A, 0xE8, 0xDB, 0x58,
    0x47, 0xA6, 0x7C, 0xBE, 0xF9, 0xC9, 0x09, 0x1B, 0x46, 0x2D, 0x53, 0x8C,
    0xD7, 0x2B, 0x03, 0x74, 0x6A, 0xE7, 0x7F, 0x5E, 0x62, 0x29, 0x2C, 0x31,
    0x15, 0x62, 0xA8, 0x46, 0x50, 0x5D, 0xC8, 0x2D, 0xB8, 0x54, 0x33, 0x8A,
    0xE4, 0x9F, 0x52, 0x35, 0xC9, 0x5B, 0x91, 0x17, 0x8C, 0xCF, 0x2D, 0xD5,
    0xCA, 0xCE, 0xF4, 0x03, 0xEC, 0x9D, 0x18, 0x10, 0xC6, 0x27, 0x2B, 0x04,
    0x5B, 0x3B, 0x71, 0xF9, 0xDC, 0x6B, 0x80, 0xD6, 0x3F, 0xDD, 0x4A, 0x8E,
    0x9A, 0xDB, 0x1E, 0x69, 0x62, 0xA6, 0x95, 0x26, 0xD4, 0x31, 0x61, 0xC1,
    0xA4, 0x1D, 0x57, 0x0D, 0x79, 0x38, 0xDA, 0xD4, 0xA4, 0x0E, 0x32, 0x9C,
    0xD0, 0xE4, 0x0E, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* IKE 8192 prime is: 2^8192 - 2^8128 - 1 + 2^64 * { [2^8062 pi] + 4743158 } */
static const unsigned char prime_ike_8192[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x18, 0x21, 0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE, 0x3B,
    0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86, 0x03, 0x9B, 0x27, 0x83, 0xA2,
    0xEC, 0x07, 0xA2, 0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52, 0xC9,
    0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7C,
    0xEA, 0x95, 0x6A, 0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05, 0x10,
    0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAA, 0xC4, 0x2D, 0xAD, 0x33, 0x17, 0x0D,
    0x04, 0x50, 0x7A, 0x33, 0xA8, 0x55, 0x21, 0xAB, 0xDF, 0x1C, 0xBA, 0x64,
    0xEC, 0xFB, 0x85, 0x04, 0x58, 0xDB, 0xEF, 0x0A, 0x8A, 0xEA, 0x71, 0x57,
    0x5D, 0x06, 0x0C, 0x7D, 0xB3, 0x97, 0x0F, 0x85, 0xA6, 0xE1, 0xE4, 0xC7,
    0xAB, 0xF5, 0xAE, 0x8C, 0xDB, 0x09, 0x33, 0xD7, 0x1E, 0x8C, 0x94, 0xE0,
    0x4A, 0x25, 0x61, 0x9D, 0xCE, 0xE3, 0xD2, 0x26, 0x1A, 0xD2, 0xEE, 0x6B,
    0xF1, 0x2F, 0xFA, 0x06, 0xD9, 0x8A, 0x08, 0x64, 0xD8, 0x76, 0x02, 0x73,
    0x3E, 0xC8, 0x6A, 0x64, 0x52, 0x1F, 0x2B, 0x18, 0x17, 0x7B, 0x20, 0x0C,
    0xBB, 0xE1, 0x17, 0x57, 0x7A, 0x61, 0x5D, 0x6C, 0x77, 0x09, 0x88, 0xC0,
    0xBA, 0xD9, 0x46, 0xE2, 0x08, 0xE2, 0x4F, 0xA0, 0x74, 0xE5, 0xAB, 0x31,
    0x43, 0xDB, 0x5B, 0xFC, 0xE0, 0xFD, 0x10, 0x8E, 0x4B, 0x82, 0xD1, 0x20,
    0xA9, 0x21, 0x08, 0x01, 0x1A, 0x72, 0x3C, 0x12, 0xA7, 0x87, 0xE6, 0xD7,
    0x88, 0x71, 0x9A, 0x10, 0xBD, 0xBA, 0x5B, 0x26, 0x99, 0xC3, 0x27, 0x18,
    0x6A, 0xF4, 0xE2, 0x3C, 0x1A, 0x94, 0x68, 0x34, 0xB6, 0x15, 0x0B, 0xDA,
    0x25, 0x83, 0xE9, 0xCA, 0x2A, 0xD4, 0x4C, 0xE8, 0xDB, 0xBB, 0xC2, 0xDB,
    0x04, 0xDE, 0x8E, 0xF9, 0x2E, 0x8E, 0xFC, 0x14, 0x1F, 0xBE, 0xCA, 0xA6,
    0x28, 0x7C, 0x59, 0x47, 0x4E, 0x6B, 0xC0, 0x5D, 0x99, 0xB2, 0x96, 0x4F,
    0xA0, 0x90, 0xC3, 0xA2, 0x23, 0x3B, 0xA1, 0x86, 0x51, 0x5B, 0xE7, 0xED,
    0x1F, 0x61, 0x29, 0x70, 0xCE, 0xE2, 0xD7, 0xAF, 0xB8, 0x1B, 0xDD, 0x76,
    0x21, 0x70, 0x48, 0x1C, 0xD0, 0x06, 0x91, 0x27, 0xD5, 0xB0, 0x5A, 0xA9,
    0x93, 0xB4, 0xEA, 0x98, 0x8D, 0x8F, 0xDD, 0xC1, 0x86, 0xFF, 0xB7, 0xDC,
    0x90, 0xA6, 0xC0, 0x8F, 0x4D, 0xF4, 0x35, 0xC9, 0x34, 0x02, 0x84, 0x92,
    0x36, 0xC3, 0xFA, 0xB4, 0xD2, 0x7C, 0x70, 0x26, 0xC1, 0xD4, 0xDC, 0xB2,
    0x60, 0x26, 0x46, 0xDE, 0xC9, 0x75, 0x1E, 0x76, 0x3D, 0xBA, 0x37, 0xBD,
    0xF8, 0xFF, 0x94, 0x06, 0xAD, 0x9E, 0x53, 0x0E, 0xE5, 0xDB, 0x38, 0x2F,
    0x41, 0x30, 0x01, 0xAE, 0xB0, 0x6A, 0x53, 0xED, 0x90, 0x27, 0xD8, 0x31,
    0x17, 0x97, 0x27, 0xB0, 0x86, 0x5A, 0x89, 0x18, 0xDA, 0x3E, 0xDB, 0xEB,
    0xCF, 0x9B, 0x14, 0xED, 0x44, 0xCE, 0x6C, 0xBA, 0xCE, 0xD4, 0xBB, 0x1B,
    0xDB, 0x7F, 0x14, 0x47, 0xE6, 0xCC, 0x25, 0x4B, 0x33, 0x20, 0x51, 0x51,
    0x2B, 0xD7, 0xAF, 0x42, 0x6F, 0xB8, 0xF4, 0x01, 0x37, 0x8C, 0xD2, 0xBF,
    0x59, 0x83, 0xCA, 0x01, 0xC6, 0x4B, 0x92, 0xEC, 0xF0, 0x32, 0xEA, 0x15,
    0xD1, 0x72, 0x1D, 0x03, 0xF4, 0x82, 0xD7, 0xCE, 0x6E, 0x74, 0xFE, 0xF6,
    0xD5, 0x5E, 0x70, 0x2F, 0x46, 0x98, 0x0C, 0x82, 0xB5, 0xA8, 0x40, 0x31,
    0x90, 0x0B, 0x1C, 0x9E, 0x59, 0xE7, 0xC9, 0x7F, 0xBE, 0xC7, 0xE8, 0xF3,
    0x23, 0xA9, 0x7A, 0x7E, 0x36, 0xCC, 0x88, 0xBE, 0x0F, 0x1D, 0x45, 0xB7,
    0xFF, 0x58, 0x5A, 0xC5, 0x4B, 0xD4, 0x07, 0xB2, 0x2B, 0x41, 0x54, 0xAA,
    0xCC, 0x8F, 0x6D, 0x7E, 0xBF, 0x48, 0xE1, 0xD8, 0x14, 0xCC, 0x5E, 0xD2,
    0x0F, 0x80, 0x37, 0xE0, 0xA7, 0x97, 0x15, 0xEE, 0xF2, 0x9B, 0xE3, 0x28,
    0x06, 0xA1, 0xD5, 0x8B, 0xB7, 0xC5, 0xDA, 0x76, 0xF5, 0x50, 0xAA, 0x3D,
    0x8A, 0x1F, 0xBF, 0xF0, 0xEB, 0x19, 0xCC, 0xB1, 0xA3, 0x13, 0xD5, 0x5C,
    0xDA, 0x56, 0xC9, 0xEC, 0x2E, 0xF2, 0x96, 0x32, 0x38, 0x7F, 0xE8, 0xD7,
    0x6E, 0x3C, 0x04, 0x68, 0x04, 0x3E, 0x8F, 0x66, 0x3F, 0x48, 0x60, 0xEE,
    0x12, 0xBF, 0x2D, 0x5B, 0x0B, 0x74, 0x74, 0xD6, 0xE6, 0x94, 0xF9, 0x1E,
    0x6D, 0xBE, 0x11, 0x59, 0x74, 0xA3, 0x92, 0x6F, 0x12, 0xFE, 0xE5, 0xE4,
    0x38, 0x77, 0x7C, 0xB6, 0xA9, 0x32, 0xDF, 0x8C, 0xD8, 0xBE, 0xC4, 0xD0,
    0x73, 0xB9, 0x31, 0xBA, 0x3B, 0xC8, 0x32, 0xB6, 0x8D, 0x9D, 0xD3, 0x00,
    0x74, 0x1F, 0xA7, 0xBF, 0x8A, 0xFC, 0x47, 0xED, 0x25, 0x76, 0xF6, 0x93,
    0x6B, 0xA4, 0x24, 0x66, 0x3A, 0xAB, 0x63, 0x9C, 0x5A, 0xE4, 0xF5, 0x68,
    0x34, 0x23, 0xB4, 0x74, 0x2B, 0xF1, 0xC9, 0x78, 0x23, 0x8F, 0x16, 0xCB,
    0xE3, 0x9D, 0x65, 0x2D, 0xE3, 0xFD, 0xB8, 0xBE, 0xFC, 0x84, 0x8A, 0xD9,
    0x22, 0x22, 0x2E, 0x04, 0xA4, 0x03, 0x7C, 0x07, 0x13, 0xEB, 0x57, 0xA8,
    0x1A, 0x23, 0xF0, 0xC7, 0x34, 0x73, 0xFC, 0x64, 0x6C, 0xEA, 0x30, 0x6B,
    0x4B, 0xCB, 0xC8, 0x86, 0x2F, 0x83, 0x85, 0xDD, 0xFA, 0x9D, 0x4B, 0x7F,
    0xA2, 0xC0, 0x87, 0xE8, 0x79, 0x68, 0x33, 0x03, 0xED, 0x5B, 0xDD, 0x3A,
    0x06, 0x2B, 0x3C, 0xF5, 0xB3, 0xA2, 0x78, 0xA6, 0x6D, 0x2A, 0x13, 0xF8,
    0x3F, 0x44, 0xF8, 0x2D, 0xDF, 0x31, 0x0E, 0xE0, 0x74, 0xAB, 0x6A, 0x36,
    0x45, 0x97, 0xE8, 0x99, 0xA0, 0x25, 0x5D, 0xC1, 0x64, 0xF3, 0x1C, 0xC5,
    0x08, 0x46, 0x85, 0x1D, 0xF9, 0xAB, 0x48, 0x19, 0x5D, 0xED, 0x7E, 0xA1,
    0xB1, 0xD5, 0x10, 0xBD, 0x7E, 0xE7, 0x4D, 0x73, 0xFA, 0xF3, 0x6B, 0xC3,
    0x1E, 0xCF, 0xA2, 0x68, 0x35, 0x90, 0x46, 0xF4, 0xEB, 0x87, 0x9F, 0x92,
    0x40, 0x09, 0x43, 0x8B, 0x48, 0x1C, 0x6C, 0xD7, 0x88, 0x9A, 0x00, 0x2E,
    0xD5, 0xEE, 0x38, 0x2B, 0xC9, 0x19, 0x0D, 0xA6, 0xFC, 0x02, 0x6E, 0x47,
    0x95, 0x58, 0xE4, 0x47, 0x56, 0x77, 0xE9, 0xAA, 0x9E, 0x30, 0x50, 0xE2,
    0x76, 0x56, 0x94, 0xDF, 0xC8, 0x1F, 0x56, 0xE8, 0x80, 0xB9, 0x6E, 0x71,
    0x60, 0xC9, 0x80, 0xDD, 0x98, 0xED, 0xD3, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF};

/* TLS 8192 prime is: 2^8192 - 2^8128 + {[2^8062 * e] + 10965728} * 2^64 - 1 */
static const unsigned char prime_tls_8192[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x1F, 0xCF, 0xDC, 0xDE, 0x35, 0x5B, 0x3B,
    0x65, 0x19, 0x03, 0x5B, 0xBC, 0x34, 0xF4, 0xDE, 0xF9, 0x9C, 0x02, 0x38,
    0x61, 0xB4, 0x6F, 0xC9, 0xD6, 0xE6, 0xC9, 0x07, 0x7A, 0xD9, 0x1D, 0x26,
    0x91, 0xF7, 0xF7, 0xEE, 0x59, 0x8C, 0xB0, 0xFA, 0xC1, 0x86, 0xD9, 0x1C,
    0xAE, 0xFE, 0x13, 0x09, 0x85, 0x13, 0x92, 0x70, 0xB4, 0x13, 0x0C, 0x93,
    0xBC, 0x43, 0x79, 0x44, 0xF4, 0xFD, 0x44, 0x52, 0xE2, 0xD7, 0x4D, 0xD3,
    0x64, 0xF2, 0xE2, 0x1E, 0x71, 0xF5, 0x4B, 0xFF, 0x5C, 0xAE, 0x82, 0xAB,
    0x9C, 0x9D, 0xF6, 0x9E, 0xE8, 0x6D, 0x2B, 0xC5, 0x22, 0x36, 0x3A, 0x0D,
    0xAB, 0xC5, 0x21, 0x97, 0x9B, 0x0D, 0xEA, 0xDA, 0x1D, 0xBF, 0x9A, 0x42,
    0xD5, 0xC4, 0x48, 0x4E, 0x0A, 0xBC, 0xD0, 0x6B, 0xFA, 0x53, 0xDD, 0xEF,
    0x3C, 0x1B, 0x20, 0xEE, 0x3F, 0xD5, 0x9D, 0x7C, 0x25, 0xE4, 0x1D, 0x2B,
    0x66, 0x9E, 0x1E, 0xF1, 0x6E, 0x6F, 0x52, 0xC3, 0x16, 0x4D, 0xF4, 0xFB,
    0x79, 0x30, 0xE9, 0xE4, 0xE5, 0x88, 0x57, 0xB6, 0xAC, 0x7D, 0x5F, 0x42,
    0xD6, 0x9F, 0x6D, 0x18, 0x77, 0x63, 0xCF, 0x1D, 0x55, 0x03, 0x40, 0x04,
    0x87, 0xF5, 0x5B, 0xA5, 0x7E, 0x31, 0xCC, 0x7A, 0x71, 0x35, 0xC8, 0x86,
    0xEF, 0xB4, 0x31, 0x8A, 0xED, 0x6A, 0x1E, 0x01, 0x2D, 0x9E, 0x68, 0x32,
    0xA9, 0x07, 0x60, 0x0A, 0x91, 0x81, 0x30, 0xC4, 0x6D, 0xC7, 0x78, 0xF9,
    0x71, 0xAD, 0x00, 0x38, 0x09, 0x29, 0x99, 0xA3, 0x33, 0xCB, 0x8B, 0x7A,
    0x1A, 0x1D, 0xB9, 0x3D, 0x71, 0x40, 0x00, 0x3C, 0x2A, 0x4E, 0xCE, 0xA9,
    0xF9, 0x8D, 0x0A, 0xCC, 0x0A, 0x82, 0x91, 0xCD, 0xCE, 0xC9, 0x7D, 0xCF,
    0x8E, 0xC9, 0xB5, 0x5A, 0x7F, 0x88, 0xA4, 0x6B, 0x4D, 0xB5, 0xA8, 0x51,
    0xF4, 0x41, 0x82, 0xE1, 0xC6, 0x8A, 0x00, 0x7E, 0x5E, 0x0D, 0xD9, 0x02,
    0x0B, 0xFD, 0x64, 0xB6, 0x45, 0x03, 0x6C, 0x7A, 0x4E, 0x67, 0x7D, 0x2C,
    0x38, 0x53, 0x2A, 0x3A, 0x23, 0xBA, 0x44, 0x42, 0xCA, 0xF5, 0x3E, 0xA6,
    0x3B, 0xB4, 0x54, 0x32, 0x9B, 0x76, 0x24, 0xC8, 0x91, 0x7B, 0xDD, 0x64,
    0xB1, 0xC0, 0xFD, 0x4C, 0xB3, 0x8E, 0x8C, 0x33, 0x4C, 0x70, 0x1C, 0x3A,
    0xCD, 0xAD, 0x06, 0x57, 0xFC, 0xCF, 0xEC, 0x71, 0x9B, 0x1F, 0x5C, 0x3E,
    0x4E, 0x46, 0x04, 0x1F, 0x38, 0x81, 0x47, 0xFB, 0x4C, 0xFD, 0xB4, 0x77,
    0xA5, 0x24, 0x71, 0xF7, 0xA9, 0xA9, 0x69, 0x10, 0xB8, 0x55, 0x32, 0x2E,
    0xDB, 0x63, 0x40, 0xD8, 0xA0, 0x0E, 0xF0, 0x92, 0x35, 0x05, 0x11, 0xE3,
    0x0A, 0xBE, 0xC1, 0xFF, 0xF9, 0xE3, 0xA2, 0x6E, 0x7F, 0xB2, 0x9F, 0x8C,
    0x18, 0x30, 0x23, 0xC3, 0x58, 0x7E, 0x38, 0xDA, 0x00, 0x77, 0xD9, 0xB4,
    0x76, 0x3E, 0x4E, 0x4B, 0x94, 0xB2, 0xBB, 0xC1, 0x94, 0xC6, 0x65, 0x1E,
    0x77, 0xCA, 0xF9, 0x92, 0xEE, 0xAA, 0xC0, 0x23, 0x2A, 0x28, 0x1B, 0xF6,
    0xB3, 0xA7, 0x39, 0xC1, 0x22, 0x61, 0x16, 0x82, 0x0A, 0xE8, 0xDB, 0x58,
    0x47, 0xA6, 0x7C, 0xBE, 0xF9, 0xC9, 0x09, 0x1B, 0x46, 0x2D, 0x53, 0x8C,
    0xD7, 0x2B, 0x03, 0x74, 0x6A, 0xE7, 0x7F, 0x5E, 0x62, 0x29, 0x2C, 0x31,
    0x15, 0x62, 0xA8, 0x46, 0x50, 0x5D, 0xC8, 0x2D, 0xB8, 0x54, 0x33, 0x8A,
    0xE4, 0x9F, 0x52, 0x35, 0xC9, 0x5B, 0x91, 0x17, 0x8C, 0xCF, 0x2D, 0xD5,
    0xCA, 0xCE, 0xF4, 0x03, 0xEC, 0x9D, 0x18, 0x10, 0xC6, 0x27, 0x2B, 0x04,
    0x5B, 0x3B, 0x71, 0xF9, 0xDC, 0x6B, 0x80, 0xD6, 0x3F, 0xDD, 0x4A, 0x8E,
    0x9A, 0xDB, 0x1E, 0x69, 0x62, 0xA6, 0x95, 0x26, 0xD4, 0x31, 0x61, 0xC1,
    0xA4, 0x1D, 0x57, 0x0D, 0x79, 0x38, 0xDA, 0xD4, 0xA4, 0x0E, 0x32, 0x9C,
    0xCF, 0xF4, 0x6A, 0xAA, 0x36, 0xAD, 0x00, 0x4C, 0xF6, 0x00, 0xC8, 0x38,
    0x1E, 0x42, 0x5A, 0x31, 0xD9, 0x51, 0xAE, 0x64, 0xFD, 0xB2, 0x3F, 0xCE,
    0xC9, 0x50, 0x9D, 0x43, 0x68, 0x7F, 0xEB, 0x69, 0xED, 0xD1, 0xCC, 0x5E,
    0x0B, 0x8C, 0xC3, 0xBD, 0xF6, 0x4B, 0x10, 0xEF, 0x86, 0xB6, 0x31, 0x42,
    0xA3, 0xAB, 0x88, 0x29, 0x55, 0x5B, 0x2F, 0x74, 0x7C, 0x93, 0x26, 0x65,
    0xCB, 0x2C, 0x0F, 0x1C, 0xC0, 0x1B, 0xD7, 0x02, 0x29, 0x38, 0x88, 0x39,
    0xD2, 0xAF, 0x05, 0xE4, 0x54, 0x50, 0x4A, 0xC7, 0x8B, 0x75, 0x82, 0x82,
    0x28, 0x46, 0xC0, 0xBA, 0x35, 0xC3, 0x5F, 0x5C, 0x59, 0x16, 0x0C, 0xC0,
    0x46, 0xFD, 0x82, 0x51, 0x54, 0x1F, 0xC6, 0x8C, 0x9C, 0x86, 0xB0, 0x22,
    0xBB, 0x70, 0x99, 0x87, 0x6A, 0x46, 0x0E, 0x74, 0x51, 0xA8, 0xA9, 0x31,
    0x09, 0x70, 0x3F, 0xEE, 0x1C, 0x21, 0x7E, 0x6C, 0x38, 0x26, 0xE5, 0x2C,
    0x51, 0xAA, 0x69, 0x1E, 0x0E, 0x42, 0x3C, 0xFC, 0x99, 0xE9, 0xE3, 0x16,
    0x50, 0xC1, 0x21, 0x7B, 0x62, 0x48, 0x16, 0xCD, 0xAD, 0x9A, 0x95, 0xF9,
    0xD5, 0xB8, 0x01, 0x94, 0x88, 0xD9, 0xC0, 0xA0, 0xA1, 0xFE, 0x30, 0x75,
    0xA5, 0x77, 0xE2, 0x31, 0x83, 0xF8, 0x1D, 0x4A, 0x3F, 0x2F, 0xA4, 0x57,
    0x1E, 0xFC, 0x8C, 0xE0, 0xBA, 0x8A, 0x4F, 0xE8, 0xB6, 0x85, 0x5D, 0xFE,
    0x72, 0xB0, 0xA6, 0x6E, 0xDE, 0xD2, 0xFB, 0xAB, 0xFB, 0xE5, 0x8A, 0x30,
    0xFA, 0xFA, 0xBE, 0x1C, 0x5D, 0x71, 0xA8, 0x7E, 0x2F, 0x74, 0x1E, 0xF8,
    0xC1, 0xFE, 0x86, 0xFE, 0xA6, 0xBB, 0xFD, 0xE5, 0x30, 0x67, 0x7F, 0x0D,
    0x97, 0xD1, 0x1D, 0x49, 0xF7, 0xA8, 0x44, 0x3D, 0x08, 0x22, 0xE5, 0x06,
    0xA9, 0xF4, 0x61, 0x4E, 0x01, 0x1E, 0x2A, 0x94, 0x83, 0x8F, 0xF8, 0x8C,
    0xD6, 0x8C, 0x8B, 0xB7, 0xC5, 0xC6, 0x42, 0x4C, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF};

/* safe primes that aren't already known. These primes should pass, but
 * take more processing in FIPS mode */
static const unsigned char prime_safe_1536[] = {
    0xf7, 0x67, 0x31, 0xc8, 0x45, 0x6a, 0xd9, 0xea, 0x53, 0x0b, 0x21, 0xc7,
    0x4a, 0xfa, 0x81, 0x66, 0x76, 0x5c, 0xea, 0xb7, 0xf5, 0x11, 0x32, 0x6d,
    0xd3, 0x4c, 0x7a, 0xac, 0x39, 0x17, 0x1a, 0x87, 0xb8, 0x00, 0xd7, 0x11,
    0xc5, 0xfd, 0xe1, 0xe3, 0x65, 0x4c, 0x1f, 0x42, 0x24, 0x41, 0x1e, 0x92,
    0x42, 0xbf, 0xb6, 0x65, 0x0e, 0x72, 0x83, 0x8a, 0xb8, 0x82, 0xa6, 0x4f,
    0x9e, 0xca, 0x4f, 0xd1, 0xb1, 0x13, 0xc2, 0xfa, 0x67, 0xa1, 0x6a, 0x06,
    0x4f, 0xaf, 0x6e, 0x16, 0xd9, 0x94, 0xd8, 0xda, 0xe3, 0x66, 0x62, 0x01,
    0x1f, 0x82, 0x8f, 0x10, 0xe0, 0x2f, 0x3c, 0xa3, 0x42, 0xa8, 0xbb, 0x94,
    0x32, 0x79, 0x79, 0x7f, 0x97, 0xf8, 0x3a, 0x31, 0xaa, 0x14, 0xc7, 0xfe,
    0x13, 0x96, 0x77, 0x15, 0xbf, 0x47, 0x20, 0x57, 0x11, 0xe0, 0x4f, 0xda,
    0x7e, 0xa9, 0x19, 0x49, 0xa1, 0x8d, 0x29, 0x76, 0x8a, 0xd3, 0x9b, 0xb0,
    0xbe, 0x50, 0xc3, 0x25, 0x82, 0xf9, 0xe3, 0x21, 0x8c, 0xfd, 0xa6, 0x51,
    0xe5, 0x36, 0x7e, 0x82, 0xb6, 0x90, 0x45, 0xe1, 0xd5, 0x72, 0x56, 0xbe,
    0xc5, 0x67, 0x3d, 0x13, 0x1a, 0x39, 0x7f, 0x98, 0x33, 0xfc, 0xb4, 0x7b,
    0xa4, 0x38, 0x71, 0x87, 0x96, 0x6e, 0xe6, 0x7b, 0x77, 0xb2, 0x65, 0xfd,
    0xdf, 0x27, 0x93, 0x0c, 0x3c, 0x60, 0xdf, 0xe5, 0x33, 0xfe, 0xd7, 0x4b};

static const unsigned char prime_safe_2048[] = {
    0xe1, 0xa3, 0x6e, 0x49, 0x69, 0x07, 0x1c, 0x5f, 0xb4, 0x15, 0x35, 0x46,
    0x99, 0x52, 0xd0, 0x4e, 0xff, 0x4e, 0x4c, 0xb1, 0xe1, 0x59, 0xed, 0x2e,
    0x71, 0xf3, 0x80, 0x14, 0x54, 0xd0, 0xfc, 0x83, 0x20, 0x29, 0x15, 0x21,
    0xa6, 0x5f, 0x10, 0x81, 0x57, 0xf4, 0x2e, 0x49, 0xb2, 0xd1, 0x37, 0xe8,
    0x6a, 0xbf, 0x72, 0xf9, 0x55, 0x4e, 0x9e, 0xae, 0x20, 0xc5, 0xb6, 0xc5,
    0x91, 0x79, 0x0d, 0xa2, 0xdd, 0xb4, 0xbb, 0x50, 0x4e, 0x20, 0xca, 0x8a,
    0x8f, 0x82, 0x34, 0xb9, 0x6a, 0x3e, 0x9a, 0x67, 0xc2, 0x7e, 0x83, 0xf6,
    0xc0, 0xad, 0xe3, 0xca, 0x00, 0xd6, 0x11, 0x88, 0x9c, 0xc7, 0x9f, 0xb4,
    0x3d, 0x53, 0xa5, 0x5a, 0x97, 0x44, 0x4d, 0xe7, 0x5c, 0xd5, 0x76, 0x80,
    0xf8, 0x0c, 0xcd, 0xa6, 0x55, 0xe2, 0x5f, 0xcf, 0xf4, 0x46, 0xa4, 0xc7,
    0x0f, 0xc1, 0x80, 0x84, 0x65, 0x46, 0x8c, 0x87, 0xd2, 0x99, 0x82, 0xdf,
    0x8e, 0x00, 0x89, 0xf3, 0x0d, 0xd5, 0xc0, 0x54, 0x94, 0xc6, 0xa3, 0x92,
    0x0f, 0x91, 0x10, 0xee, 0xa3, 0x65, 0x44, 0xb7, 0x6d, 0xe8, 0x23, 0xf9,
    0x7f, 0x91, 0x62, 0x65, 0x09, 0x8e, 0xa1, 0x33, 0xd4, 0xd6, 0x55, 0x0a,
    0xc0, 0xe8, 0x66, 0x70, 0x05, 0xd0, 0x12, 0x34, 0xc1, 0xfd, 0xce, 0x75,
    0xa4, 0x75, 0xe1, 0x46, 0xa1, 0x08, 0xb4, 0x52, 0xfe, 0x25, 0xa4, 0xc5,
    0x4f, 0x23, 0x04, 0x7e, 0xa1, 0x2c, 0xf3, 0x56, 0xcb, 0xfa, 0x7a, 0xbc,
    0x45, 0xcc, 0x78, 0xb3, 0x28, 0xf3, 0xe5, 0xd5, 0x26, 0x56, 0x27, 0x86,
    0x6a, 0x56, 0x6b, 0x87, 0x56, 0x0e, 0xc4, 0x3c, 0xed, 0xff, 0xcb, 0x96,
    0xb4, 0x13, 0x1d, 0x4d, 0x38, 0x4e, 0x69, 0x34, 0x51, 0x7a, 0x85, 0x31,
    0xb4, 0x80, 0xda, 0x41, 0xe3, 0xdc, 0x2e, 0x53, 0xd8, 0x71, 0x3e, 0xcc,
    0x37, 0x8a, 0x80, 0x33};

static const unsigned char prime_safe_3072[] = {
    0x87, 0x66, 0xdf, 0xf7, 0xec, 0x49, 0x6a, 0x9a, 0x7c, 0x96, 0x28, 0xae,
    0x67, 0x38, 0xab, 0xfa, 0xfe, 0x5c, 0x46, 0x7b, 0xef, 0xe9, 0x18, 0xa6,
    0x76, 0xb2, 0xe5, 0x0e, 0xbe, 0xb8, 0xf2, 0x80, 0x36, 0x09, 0x82, 0x44,
    0x7b, 0xe8, 0xe8, 0xcc, 0x89, 0x27, 0x68, 0x05, 0xe0, 0xe1, 0x37, 0xd7,
    0xbf, 0xdb, 0x0c, 0xf6, 0x48, 0x52, 0x17, 0x3f, 0x75, 0xc5, 0x4e, 0xb4,
    0x3d, 0xf8, 0x4c, 0xea, 0xb4, 0x0b, 0x06, 0x04, 0x15, 0x89, 0x7c, 0xba,
    0xf3, 0xf5, 0xde, 0x66, 0x6e, 0x7d, 0x30, 0xc4, 0x20, 0x05, 0xda, 0x32,
    0x0f, 0xff, 0x79, 0x71, 0x44, 0x9b, 0x10, 0x0f, 0xf1, 0xbb, 0x31, 0xde,
    0x67, 0x90, 0xea, 0x77, 0xad, 0x65, 0xd7, 0x05, 0x75, 0xab, 0x66, 0xf2,
    0xe6, 0x52, 0xac, 0xf2, 0xaa, 0xa7, 0xd2, 0x45, 0xd9, 0xc6, 0x42, 0x39,
    0x27, 0x1f, 0x46, 0x84, 0xad, 0x78, 0xb4, 0xfa, 0x84, 0xf8, 0x9b, 0x3e,
    0xcb, 0xc1, 0x99, 0xe5, 0x35, 0x42, 0x26, 0x05, 0xea, 0xac, 0x51, 0x04,
    0x4f, 0x8a, 0x98, 0x25, 0xa7, 0x46, 0xab, 0x7b, 0xed, 0xb8, 0xa9, 0x0b,
    0x24, 0x23, 0x83, 0x23, 0x16, 0x87, 0x64, 0x91, 0x0c, 0xbf, 0x1f, 0xbc,
    0xec, 0x4a, 0xdd, 0x12, 0x2b, 0x0c, 0xa9, 0x39, 0x96, 0xc4, 0xc3, 0xcf,
    0xa5, 0x38, 0x40, 0x0d, 0x6e, 0xd0, 0xfa, 0x0a, 0x0c, 0x3e, 0xe9, 0x75,
    0x0b, 0x70, 0x28, 0x68, 0xbc, 0xfd, 0xf6, 0xc2, 0x9a, 0x59, 0x91, 0x20,
    0x5c, 0x70, 0xfe, 0x31, 0xa6, 0x50, 0x87, 0x9a, 0x6a, 0x61, 0x20, 0x2c,
    0x77, 0x84, 0x81, 0xa8, 0x3e, 0xc9, 0xa8, 0x72, 0xb0, 0x53, 0x43, 0x85,
    0x1c, 0x9b, 0x3a, 0xdd, 0xef, 0x09, 0x7d, 0xc7, 0x68, 0xc6, 0xef, 0x08,
    0xce, 0x47, 0xa0, 0xdc, 0x5b, 0xdb, 0x2f, 0x2d, 0x34, 0xe3, 0xde, 0x95,
    0xf6, 0x6b, 0x6d, 0x5d, 0x91, 0xbe, 0x45, 0xee, 0x2d, 0x04, 0x93, 0x78,
    0xc7, 0xa4, 0x49, 0xcc, 0x71, 0xa8, 0x5d, 0xd8, 0x8a, 0x7e, 0x9e, 0x4f,
    0x10, 0xc9, 0x41, 0xd1, 0x62, 0xc1, 0x70, 0x48, 0xb5, 0x12, 0x11, 0x23,
    0xa6, 0xe4, 0xdf, 0x64, 0xac, 0xd9, 0xe4, 0x37, 0xc2, 0xb9, 0x23, 0xa7,
    0x40, 0xea, 0x7f, 0x54, 0xe3, 0xef, 0x71, 0x81, 0xb4, 0xe7, 0x05, 0x10,
    0xd6, 0x2b, 0xd5, 0x11, 0x84, 0x5a, 0x69, 0xa5, 0xac, 0x52, 0x6d, 0xa8,
    0x79, 0x27, 0xff, 0x1c, 0x02, 0xd1, 0x62, 0x36, 0x03, 0xa2, 0xa9, 0x46,
    0x6c, 0x4f, 0xca, 0x58, 0xf2, 0xb2, 0xed, 0x91, 0xb4, 0x9e, 0x5b, 0xdd,
    0xf9, 0x99, 0xb6, 0x8d, 0x70, 0x34, 0x0a, 0xc5, 0x4d, 0xd7, 0xce, 0x8b,
    0xf1, 0x50, 0x25, 0x89, 0xff, 0xe7, 0xf2, 0x1e, 0xb9, 0x21, 0xb3, 0x8b,
    0xc8, 0x42, 0x7c, 0x26, 0xef, 0x4c, 0x30, 0x8d, 0x60, 0xb7, 0x25, 0xfb};

static const unsigned char prime_safe_4096[] = {
    0x8b, 0xdf, 0xc1, 0xa3, 0xe4, 0xbd, 0x1c, 0xb1, 0xf4, 0xb1, 0x51, 0xd3,
    0x8a, 0xce, 0x3d, 0x33, 0x58, 0x80, 0xa3, 0x1c, 0x7c, 0x0d, 0xbd, 0x8e,
    0xbd, 0xb3, 0xe7, 0x9e, 0xd4, 0xde, 0x06, 0xfc, 0x98, 0xaf, 0x01, 0x43,
    0x93, 0x2c, 0xfc, 0xfb, 0x92, 0x80, 0xe0, 0x6e, 0xf9, 0xf6, 0xab, 0x73,
    0x96, 0x8d, 0x7e, 0xc0, 0xeb, 0x26, 0x6c, 0x0c, 0x53, 0x06, 0x9f, 0x32,
    0x4b, 0xad, 0x53, 0xd5, 0xbf, 0x91, 0x35, 0x16, 0xfd, 0x7f, 0xba, 0x30,
    0xb6, 0xb4, 0x88, 0x10, 0x1f, 0x5a, 0xc0, 0x62, 0xf9, 0x7f, 0x71, 0x9b,
    0xb5, 0x10, 0x4b, 0x99, 0xd0, 0xf0, 0xe9, 0xc2, 0xee, 0x35, 0x24, 0xeb,
    0xcc, 0xee, 0x06, 0xbf, 0xa0, 0x05, 0xe4, 0x61, 0xa4, 0xa6, 0x98, 0x23,
    0xd0, 0xe4, 0x8a, 0x61, 0xca, 0x05, 0x8a, 0x6c, 0x98, 0xfa, 0x83, 0xc3,
    0x50, 0x7d, 0x55, 0x3b, 0x2e, 0xd5, 0xac, 0x14, 0x61, 0x86, 0xd1, 0xb5,
    0xcf, 0xc0, 0xdc, 0x69, 0x4b, 0x6c, 0x4a, 0xc5, 0xd7, 0xfe, 0xe0, 0xe8,
    0x1a, 0x64, 0x11, 0xdb, 0x56, 0xf0, 0x1c, 0x95, 0x5c, 0xd1, 0x6a, 0xb9,
    0xf6, 0xe2, 0x00, 0xf4, 0x22, 0x03, 0x03, 0x2a, 0xbc, 0x9c, 0x82, 0xeb,
    0x89, 0x1a, 0xdd, 0x94, 0x65, 0x02, 0x44, 0x61, 0x76, 0xc1, 0xae, 0xd8,
    0xca, 0xfd, 0x66, 0xf4, 0x96, 0xe7, 0x79, 0xfe, 0x3a, 0x98, 0xf1, 0x80,
    0x02, 0xfa, 0x42, 0xb7, 0xae, 0xeb, 0x39, 0x28, 0xc3, 0xb9, 0xce, 0x8c,
    0x71, 0xea, 0x14, 0x74, 0x86, 0x6c, 0x26, 0xd5, 0x15, 0x21, 0x97, 0x0c,
    0x82, 0x8d, 0x81, 0x84, 0xc5, 0x47, 0x10, 0x06, 0x67, 0xa8, 0x5f, 0xb1,
    0xc5, 0x32, 0xdc, 0x7f, 0xe6, 0x61, 0xe5, 0xeb, 0x9e, 0xa9, 0x61, 0x99,
    0x43, 0xa9, 0x8b, 0xed, 0xaf, 0xe4, 0x21, 0xef, 0x8e, 0x78, 0x5a, 0x61,
    0x55, 0x9d, 0x43, 0xdb, 0x77, 0xaa, 0xbb, 0x19, 0xea, 0x4f, 0x49, 0x53,
    0x80, 0xce, 0x7c, 0x9a, 0xea, 0xa6, 0x93, 0x58, 0xd4, 0xab, 0xf4, 0xe9,
    0x60, 0x7d, 0xca, 0xb2, 0x97, 0xa5, 0xe0, 0x92, 0xce, 0xec, 0x57, 0xbc,
    0xc5, 0x05, 0x76, 0x11, 0x79, 0x03, 0xe1, 0xb2, 0x99, 0xc1, 0x21, 0xd4,
    0x85, 0xe7, 0x6f, 0xc9, 0x58, 0xe8, 0x1c, 0x0d, 0xc8, 0x90, 0x44, 0x4c,
    0x58, 0x55, 0x9a, 0xee, 0xde, 0x62, 0x0e, 0xb2, 0xe3, 0xbc, 0xeb, 0x51,
    0x40, 0x05, 0x71, 0xfe, 0xb4, 0xe9, 0xe6, 0xf6, 0x0e, 0xd7, 0xbb, 0x1b,
    0xb8, 0x99, 0xe8, 0xc9, 0xda, 0x9f, 0xde, 0x3c, 0x13, 0xd9, 0x16, 0x45,
    0x3d, 0xac, 0xe2, 0x09, 0xc3, 0x87, 0xbb, 0x39, 0x8c, 0x6f, 0x11, 0x60,
    0x87, 0x1f, 0xaf, 0xa7, 0xdc, 0x12, 0x8f, 0x7d, 0x4c, 0x5e, 0x56, 0xc3,
    0x62, 0xdd, 0xdd, 0x03, 0x55, 0x9e, 0x24, 0x6c, 0xc5, 0x6c, 0xb8, 0x0e,
    0xaf, 0x11, 0xd5, 0x1e, 0x6a, 0x36, 0x9c, 0xca, 0x46, 0x34, 0x13, 0x2b,
    0xd1, 0xa3, 0x34, 0x2c, 0x83, 0x1b, 0x25, 0xcc, 0x17, 0x01, 0x9c, 0x68,
    0x53, 0xb7, 0x87, 0xed, 0x0e, 0x48, 0xd7, 0x69, 0xf9, 0xc8, 0x1d, 0x8b,
    0x71, 0xf4, 0x6f, 0xd1, 0xb1, 0xd5, 0x70, 0xa0, 0xd7, 0x71, 0x3d, 0x9f,
    0xfc, 0xfa, 0x35, 0x69, 0x25, 0xf3, 0x39, 0x79, 0xad, 0x7b, 0x01, 0xc5,
    0x66, 0xa5, 0xf0, 0xc7, 0x1c, 0xb6, 0x51, 0xe5, 0x02, 0x2b, 0xcf, 0xc1,
    0x2a, 0x91, 0x9d, 0xa5, 0xbf, 0x37, 0x37, 0xdd, 0x2e, 0x30, 0x40, 0xdb,
    0xbf, 0xec, 0xfe, 0x6c, 0x2c, 0xe9, 0x20, 0xee, 0x89, 0xac, 0x55, 0xaf,
    0x03, 0x5a, 0xba, 0x5a, 0x52, 0xfb, 0xbf, 0xb5, 0xae, 0x38, 0x20, 0xa5,
    0x68, 0x92, 0x5f, 0xec, 0x17, 0xa9, 0x80, 0x53, 0xf2, 0x3b, 0x0c, 0x09,
    0xf3, 0xeb, 0x15, 0x62, 0x8e, 0x39, 0x7b, 0x6b};

static const unsigned char prime_safe_6144[] = {
    0xb9, 0x0f, 0xc1, 0x41, 0x4a, 0xde, 0x1a, 0x1c, 0x80, 0xa0, 0xd6, 0x39,
    0x81, 0x10, 0xf3, 0x09, 0xca, 0xc0, 0x60, 0x8c, 0x5e, 0x8c, 0x17, 0x21,
    0xa0, 0x18, 0x50, 0xd6, 0x60, 0x13, 0xfc, 0x38, 0x00, 0x26, 0xd9, 0x71,
    0xd2, 0x73, 0xfc, 0x5d, 0x0c, 0xf1, 0x20, 0xce, 0x76, 0x44, 0xbb, 0x8b,
    0x5c, 0xc8, 0x5a, 0x59, 0x0c, 0xcd, 0x48, 0xba, 0xbf, 0x86, 0x72, 0xda,
    0xf5, 0xbd, 0x7c, 0x1d, 0x41, 0xba, 0xe8, 0x9f, 0x8c, 0xc2, 0x18, 0x27,
    0xfa, 0xbc, 0xc6, 0xcf, 0xd8, 0x47, 0xf5, 0xe9, 0x71, 0xcc, 0x37, 0x34,
    0xc3, 0x9b, 0x5a, 0xff, 0xc3, 0x0c, 0xab, 0x1d, 0x97, 0x8c, 0x26, 0x95,
    0x8c, 0xf1, 0x0a, 0x5d, 0x22, 0x84, 0x5a, 0x7c, 0xf2, 0xd1, 0x8b, 0x7c,
    0x6f, 0x17, 0x09, 0x13, 0x00, 0xc9, 0xdf, 0x79, 0xe1, 0x6e, 0xc8, 0xf8,
    0xd3, 0xc1, 0xdd, 0xb2, 0xf4, 0x24, 0x2a, 0xfa, 0x5c, 0x66, 0x25, 0x2b,
    0x39, 0xd1, 0x39, 0x48, 0xfa, 0x76, 0x4f, 0x57, 0xa3, 0x20, 0xc3, 0x38,
    0x2e, 0x85, 0x67, 0x31, 0x92, 0x85, 0x3c, 0x70, 0x23, 0x14, 0xec, 0x6c,
    0x85, 0x28, 0xe0, 0x4f, 0xcc, 0xc6, 0x3b, 0xcf, 0x19, 0x30, 0x3b, 0x01,
    0xfe, 0x9e, 0x16, 0x65, 0x1c, 0xf4, 0x31, 0x0c, 0x9d, 0x23, 0x40, 0x85,
    0x6c, 0xdd, 0xe5, 0xf7, 0x90, 0x25, 0x69, 0x7a, 0x3c, 0xd6, 0xe4, 0x42,
    0x6c, 0x87, 0x04, 0x06, 0xa7, 0x82, 0x1d, 0xfc, 0x5e, 0xd9, 0x03, 0x60,
    0x20, 0x9a, 0x5c, 0x6a, 0xfe, 0x53, 0x0d, 0x05, 0x92, 0x1b, 0xa1, 0xdb,
    0xfa, 0x01, 0x2f, 0x84, 0x89, 0xe0, 0x56, 0x66, 0x7e, 0xe3, 0xe6, 0x99,
    0x4d, 0xb3, 0xd2, 0xf0, 0xce, 0xf3, 0xdf, 0x05, 0x0d, 0x57, 0x42, 0xcd,
    0xfc, 0x06, 0x3c, 0xe7, 0x11, 0x34, 0x7f, 0x51, 0x8e, 0xb7, 0x24, 0x01,
    0xe3, 0x26, 0x47, 0xe7, 0xd1, 0x57, 0x0e, 0x0e, 0xf1, 0x12, 0xc5, 0x79,
    0x2d, 0x87, 0x0f, 0xb1, 0x19, 0x6a, 0xd7, 0x44, 0x33, 0x46, 0x4c, 0xbc,
    0xc5, 0xc6, 0x24, 0xf8, 0x7c, 0x7a, 0x61, 0xfe, 0x72, 0x95, 0x21, 0xcd,
    0xd1, 0x3a, 0xd3, 0x5d, 0x77, 0x76, 0xbd, 0x86, 0xd8, 0xbd, 0x8e, 0x5e,
    0xf2, 0xe5, 0x20, 0x01, 0xd9, 0xb4, 0x47, 0xf7, 0x1c, 0x51, 0x70, 0x39,
    0x6a, 0xc7, 0xea, 0xed, 0x90, 0xd7, 0xc4, 0xd3, 0xcd, 0x8e, 0x4b, 0xd8,
    0x11, 0xf0, 0xd3, 0x66, 0x36, 0x77, 0xe2, 0x16, 0x13, 0xbd, 0xd2, 0x54,
    0x4a, 0x1c, 0x61, 0x54, 0x88, 0x1a, 0x69, 0x85, 0x9f, 0x5d, 0xc5, 0xb7,
    0x62, 0x7e, 0x72, 0x0a, 0x89, 0x90, 0x24, 0x8f, 0x39, 0xb2, 0xf2, 0xb6,
    0x12, 0x8e, 0x50, 0xb4, 0xd3, 0xea, 0xc3, 0xac, 0xea, 0x8d, 0x27, 0x17,
    0xbd, 0x07, 0xd2, 0x15, 0x80, 0x49, 0xe0, 0x97, 0x41, 0x16, 0xd6, 0x3b,
    0x24, 0xe8, 0x8b, 0xfd, 0xa3, 0x18, 0xbd, 0x52, 0x5d, 0xe2, 0x21, 0xce,
    0x7c, 0x6f, 0x10, 0x38, 0x70, 0x64, 0xc4, 0x15, 0xf3, 0x28, 0xc6, 0x66,
    0xfc, 0xd1, 0x22, 0x04, 0x80, 0x80, 0xc6, 0xc5, 0x75, 0xf5, 0xdc, 0xb0,
    0x40, 0x4b, 0x12, 0xfa, 0xdb, 0xd5, 0x36, 0xcd, 0x31, 0xab, 0xd7, 0x1d,
    0x18, 0x07, 0x9d, 0x09, 0x9b, 0x16, 0xa0, 0xfe, 0x1e, 0x6f, 0x3f, 0x34,
    0x5a, 0xe6, 0x70, 0x85, 0x98, 0x30, 0xd4, 0x94, 0xc5, 0xf0, 0x36, 0x35,
    0xa1, 0xed, 0x46, 0x63, 0x3c, 0x0f, 0xcf, 0xc5, 0x9e, 0x7c, 0x68, 0x25,
    0x64, 0x93, 0x30, 0x36, 0x38, 0xb1, 0x99, 0x6c, 0x37, 0xf5, 0xcf, 0x64,
    0x4b, 0xef, 0xa6, 0xff, 0x6a, 0xaa, 0xaa, 0xb6, 0x29, 0xed, 0x38, 0x80,
    0x1f, 0x58, 0x35, 0x88, 0x3f, 0x01, 0x1c, 0xc8, 0x23, 0x48, 0x37, 0xa7,
    0xd2, 0xb1, 0xb1, 0xee, 0x44, 0x59, 0x0a, 0xfb, 0x05, 0xd9, 0xe1, 0x5b,
    0x53, 0x34, 0x9d, 0x99, 0x30, 0x28, 0xa9, 0x3b, 0x8e, 0x1b, 0xac, 0x8a,
    0x90, 0x91, 0xc9, 0x71, 0x8a, 0xea, 0xb9, 0x11, 0xd5, 0x67, 0x87, 0x4f,
    0xdb, 0x27, 0x4f, 0x7f, 0xb8, 0x54, 0x7f, 0x5e, 0x18, 0x08, 0xf7, 0xf3,
    0x1c, 0x02, 0x3a, 0x04, 0xde, 0xcc, 0x10, 0x06, 0x7e, 0x15, 0xc3, 0x24,
    0x0c, 0xdf, 0x0d, 0xf8, 0x86, 0xc0, 0x4c, 0xab, 0x0f, 0x75, 0x04, 0xbe,
    0xf3, 0x90, 0x28, 0xd1, 0x22, 0x17, 0x96, 0xcc, 0x29, 0x11, 0x09, 0xa7,
    0x53, 0x42, 0xea, 0x91, 0x51, 0xaf, 0x55, 0xa1, 0x03, 0x67, 0x78, 0x63,
    0xb3, 0xb0, 0x0f, 0x59, 0x5d, 0x37, 0xe7, 0x30, 0x8b, 0xca, 0xa0, 0x45,
    0x12, 0x7a, 0xa5, 0x09, 0xfb, 0xa6, 0x99, 0xdd, 0xf7, 0xe9, 0x30, 0x5a,
    0xc2, 0x9d, 0x0d, 0xdf, 0x39, 0x99, 0x25, 0x0d, 0xb2, 0x57, 0xb6, 0x78,
    0x02, 0x30, 0xf8, 0x86, 0xde, 0x79, 0xb4, 0xbe, 0x3e, 0x53, 0xff, 0x74,
    0x0f, 0x4d, 0x30, 0x2d, 0xe6, 0x57, 0x4a, 0x57, 0x53, 0x3a, 0x0b, 0x19,
    0x86, 0xab, 0x90, 0xe5, 0x33, 0x84, 0x53, 0x7a, 0x17, 0xc5, 0xf1, 0x8c,
    0xc3, 0xe4, 0x11, 0x53, 0x2b, 0xb5, 0xb4, 0x8e, 0xe6, 0xd2, 0x04, 0x43,
    0x5b, 0x6a, 0x30, 0xc7, 0xca, 0xaf, 0x91, 0xc0, 0x76, 0x43, 0x86, 0x65,
    0xee, 0xcd, 0x82, 0xbe, 0xa2, 0xd8, 0x2d, 0xad, 0xeb, 0xb5, 0x1a, 0xb5,
    0xbf, 0xa1, 0xe7, 0x93, 0x50, 0x15, 0x08, 0x27, 0x27, 0x3c, 0xcc, 0x53,
    0x82, 0x67, 0xd4, 0xf2, 0x0d, 0x26, 0x60, 0x87, 0x05, 0x2e, 0xaa, 0x62,
    0x55, 0xcc, 0x9a, 0xee, 0x2c, 0x20, 0x23, 0x14, 0xfa, 0x5c, 0x29, 0x41,
    0xe1, 0x89, 0x83, 0x19, 0xc1, 0x36, 0x8c, 0xa4, 0x91, 0xf6, 0x40, 0x37,
    0x70, 0x2a, 0x0d, 0x82, 0xbb, 0x56, 0x6e, 0x23, 0x34, 0xb9, 0x6e, 0x33};

static const unsigned char prime_safe_8192[] = {
    0x9b, 0xa7, 0x9b, 0xa2, 0x86, 0x54, 0xe7, 0x99, 0x11, 0x5b, 0x35, 0x81,
    0xd5, 0x7a, 0x8a, 0x6e, 0x4d, 0x4d, 0x61, 0x5d, 0xd3, 0xcf, 0x0c, 0x65,
    0x7e, 0xda, 0xd8, 0xce, 0x28, 0xac, 0xa0, 0x38, 0x81, 0xee, 0xa1, 0x14,
    0x25, 0x21, 0x67, 0x66, 0x3a, 0x6c, 0x0f, 0x80, 0x3d, 0x89, 0x79, 0xfe,
    0x71, 0x43, 0x57, 0xc3, 0xa9, 0x54, 0x1e, 0x20, 0x8a, 0xee, 0x0f, 0xa6,
    0x8b, 0x88, 0x81, 0x3d, 0xe8, 0x5c, 0x40, 0x47, 0x05, 0xdf, 0xd8, 0x6d,
    0x98, 0x65, 0x16, 0xa9, 0xf9, 0xc4, 0x8c, 0x02, 0xba, 0xae, 0x6b, 0x36,
    0x76, 0xc9, 0xfa, 0x8e, 0xd0, 0xd7, 0x9a, 0x3c, 0xcb, 0xd1, 0x44, 0x09,
    0xd7, 0x4f, 0x28, 0x51, 0x94, 0x92, 0x5b, 0x02, 0xb2, 0xbd, 0x78, 0xd3,
    0xc2, 0x76, 0x03, 0x15, 0x17, 0x0b, 0x55, 0x08, 0x02, 0x42, 0x9e, 0x26,
    0x56, 0x33, 0x72, 0xe6, 0xbd, 0x0e, 0xf9, 0x3d, 0x2c, 0xb3, 0x8a, 0x4c,
    0x67, 0x17, 0xfd, 0xe9, 0x03, 0xad, 0x8c, 0x34, 0x84, 0xe5, 0x83, 0xdf,
    0x9c, 0x04, 0x93, 0x03, 0x26, 0x19, 0xc1, 0xf1, 0x24, 0x68, 0xf6, 0x54,
    0x96, 0xce, 0x38, 0x51, 0xbd, 0x6c, 0x3d, 0x9c, 0x0c, 0xd8, 0x6e, 0x13,
    0x4c, 0x8b, 0xf6, 0x34, 0xae, 0xd8, 0x85, 0x1d, 0x1d, 0x8e, 0xc2, 0xad,
    0xab, 0xa2, 0xc5, 0x40, 0x76, 0x7f, 0x2f, 0x2e, 0x38, 0xf4, 0x6a, 0x39,
    0x33, 0x3d, 0x17, 0xce, 0x1f, 0xe9, 0xc3, 0x8d, 0x9e, 0xe5, 0xbe, 0xd6,
    0xad, 0x9a, 0x23, 0xd8, 0x06, 0xf3, 0x7c, 0x39, 0xd5, 0xae, 0x57, 0xb6,
    0xe5, 0xc3, 0x9a, 0x8a, 0x8c, 0x6e, 0xd3, 0xc1, 0x1a, 0x64, 0x12, 0x00,
    0x18, 0x53, 0xca, 0x32, 0x88, 0x8e, 0xc0, 0x5f, 0x2d, 0xb2, 0x3d, 0x14,
    0x1b, 0x58, 0x5c, 0x20, 0xe8, 0x52, 0xe5, 0x28, 0x41, 0xbc, 0x9e, 0x08,
    0x29, 0xab, 0xa5, 0x43, 0x99, 0x0e, 0xd7, 0x2a, 0xb9, 0xb8, 0x64, 0x9d,
    0x83, 0xe3, 0x1a, 0x26, 0x59, 0x65, 0xf2, 0x0c, 0xc9, 0xc5, 0x8f, 0x0d,
    0xcf, 0xa1, 0x18, 0xfc, 0x8b, 0x77, 0xe9, 0xe1, 0x19, 0x7b, 0x03, 0xd4,
    0x37, 0x8d, 0x5d, 0x37, 0x2b, 0xad, 0x58, 0x5e, 0x73, 0x72, 0xce, 0x84,
    0xe5, 0xc9, 0x75, 0x1d, 0xf3, 0x58, 0x42, 0x77, 0xfe, 0x53, 0xa0, 0xc2,
    0x66, 0x21, 0xaf, 0xe2, 0x61, 0xd2, 0x84, 0xb3, 0x03, 0x4d, 0xd8, 0x7d,
    0x85, 0xe1, 0xa8, 0xa0, 0x48, 0x5d, 0x1a, 0xa9, 0xac, 0xc1, 0x69, 0x24,
    0xc6, 0xfa, 0xb5, 0x22, 0x3e, 0xa3, 0x8d, 0x35, 0x29, 0xcf, 0x9a, 0xe5,
    0x84, 0x3b, 0x0b, 0x27, 0x36, 0x7e, 0x9d, 0xa6, 0xb0, 0x45, 0x60, 0x42,
    0x1e, 0x4b, 0x24, 0xd1, 0x36, 0x8b, 0x70, 0xd1, 0x95, 0x54, 0x14, 0xb9,
    0x47, 0x3d, 0x8d, 0xe4, 0x5f, 0x81, 0x1a, 0x21, 0x17, 0x17, 0xbf, 0x92,
    0x22, 0x4c, 0x77, 0x30, 0xdc, 0x9c, 0x84, 0xe6, 0x68, 0xcc, 0xd6, 0x11,
    0x04, 0xff, 0x71, 0x86, 0xb3, 0xa9, 0x9b, 0x13, 0x95, 0x35, 0xfd, 0x68,
    0x28, 0x9b, 0x6f, 0x5c, 0xf7, 0x66, 0xa8, 0x6f, 0x89, 0x0f, 0x92, 0xdf,
    0x52, 0x24, 0x3f, 0xdb, 0x2f, 0x40, 0x12, 0x32, 0xa4, 0xff, 0x2e, 0x4b,
    0xb8, 0xa0, 0xe7, 0xc9, 0xcb, 0x98, 0x13, 0xf9, 0xd2, 0xfa, 0x82, 0x68,
    0xb2, 0x8f, 0xd3, 0x17, 0x8c, 0x93, 0xf5, 0x80, 0xe4, 0x5a, 0x33, 0x1b,
    0x6a, 0xd8, 0xbf, 0x37, 0xa7, 0xe1, 0x63, 0x1d, 0x6a, 0xc3, 0xfa, 0xa1,
    0x2f, 0xc1, 0x72, 0x55, 0xd5, 0xe2, 0x67, 0x3b, 0x6b, 0x3a, 0xa8, 0xb0,
    0x54, 0x04, 0x1d, 0xbb, 0xc1, 0xe5, 0x3a, 0x52, 0xb1, 0x67, 0x0b, 0x12,
    0x3e, 0xcd, 0xa9, 0x9a, 0x0e, 0xbb, 0xa3, 0x75, 0x6d, 0x6f, 0x77, 0x74,
    0x64, 0xe3, 0x16, 0x8c, 0xa5, 0xba, 0xec, 0x51, 0x73, 0xce, 0x4b, 0xe6,
    0x6f, 0x3d, 0x15, 0x56, 0x43, 0xe1, 0x17, 0x77, 0x66, 0xab, 0xdc, 0x9d,
    0x9b, 0x10, 0x5d, 0xc4, 0xe9, 0x1e, 0xaa, 0x2d, 0x15, 0xbb, 0xc4, 0x09,
    0x46, 0x30, 0xe1, 0xb8, 0x92, 0x94, 0x5f, 0xb7, 0xe7, 0x7e, 0x97, 0x43,
    0xc0, 0x48, 0x5b, 0xaf, 0xea, 0x74, 0xae, 0x8c, 0x79, 0x6b, 0x66, 0x83,
    0x62, 0x88, 0x17, 0xa4, 0x56, 0x5d, 0x58, 0xfb, 0x6c, 0x38, 0x57, 0x4d,
    0xef, 0xd7, 0x36, 0x44, 0x39, 0x5b, 0xab, 0x94, 0xe4, 0x08, 0x30, 0xd3,
    0x2c, 0x59, 0xa0, 0x32, 0xe2, 0x71, 0x99, 0xec, 0x66, 0x5e, 0xf7, 0xe2,
    0x9c, 0x19, 0x69, 0x72, 0x6f, 0xdb, 0x3e, 0xcc, 0x19, 0x5a, 0xfd, 0xad,
    0xd6, 0x6e, 0x9d, 0x07, 0xc0, 0x65, 0x01, 0x75, 0xdd, 0x37, 0x1b, 0x9c,
    0x5e, 0x93, 0x32, 0xf8, 0x7e, 0x65, 0xd5, 0xb5, 0x15, 0x35, 0xad, 0x05,
    0xb5, 0xd2, 0x25, 0xc7, 0x71, 0x5a, 0xe4, 0xb7, 0x58, 0x6a, 0xc3, 0x5a,
    0xd9, 0xd4, 0xee, 0x32, 0xb5, 0x0b, 0x5b, 0x2a, 0xcd, 0x80, 0xce, 0xd4,
    0x2d, 0xc9, 0x09, 0x94, 0xf5, 0xf2, 0x7c, 0xaf, 0xba, 0x5a, 0xd3, 0xdc,
    0xcd, 0xd7, 0xf7, 0xea, 0x42, 0xe2, 0xc2, 0x34, 0x21, 0xb9, 0x15, 0x24,
    0xe8, 0x32, 0x6b, 0x6f, 0xb0, 0xed, 0x76, 0x5e, 0x45, 0xbf, 0x02, 0xa2,
    0xb8, 0x3c, 0xa5, 0xf5, 0x74, 0xe3, 0x18, 0x89, 0x21, 0x4e, 0xa6, 0x08,
    0xa3, 0xa5, 0x93, 0x69, 0x48, 0x96, 0xbd, 0x47, 0xd3, 0xeb, 0x67, 0x29,
    0xa8, 0xbb, 0xbe, 0x78, 0x05, 0xfa, 0x46, 0x89, 0x4e, 0x0c, 0xe2, 0x6c,
    0xbb, 0xe5, 0xf8, 0xba, 0xe5, 0x5d, 0x29, 0xe7, 0xdd, 0x71, 0x7e, 0x94,
    0xd7, 0x56, 0x0c, 0x3c, 0xde, 0x5f, 0xbc, 0xdc, 0x0f, 0x8e, 0xd6, 0x6f,
    0x0a, 0x07, 0xb8, 0x07, 0x24, 0x62, 0x4c, 0xed, 0x45, 0x4f, 0x0d, 0x9f,
    0x2e, 0x83, 0x6a, 0xeb, 0xbc, 0xff, 0xa9, 0xf2, 0x73, 0xb3, 0x5b, 0xaa,
    0xac, 0xed, 0xac, 0x88, 0xa2, 0x0d, 0x8d, 0x8f, 0xb4, 0xf7, 0x73, 0x1e,
    0xc0, 0x2e, 0xd3, 0x45, 0x15, 0x4b, 0x4a, 0xe7, 0xd4, 0xef, 0xb1, 0xc6,
    0xd3, 0x8f, 0xf8, 0x24, 0x12, 0x33, 0x3e, 0x8e, 0x95, 0xbc, 0x81, 0xb4,
    0xd4, 0xd1, 0x13, 0xbc, 0x7e, 0x25, 0xb4, 0x5b, 0xff, 0x15, 0xba, 0xf8,
    0x9a, 0xec, 0x78, 0xe4, 0x63, 0xc7, 0x26, 0xd5, 0x89, 0x3d, 0x63, 0x5b,
    0x7c, 0x86, 0x63, 0x34, 0x06, 0x28, 0x23, 0x08, 0xff, 0x6d, 0xbd, 0xe0,
    0x75, 0xb3, 0x71, 0x12, 0x26, 0x63, 0xca, 0x93, 0x36, 0x86, 0xeb, 0xf7,
    0x48, 0xd1, 0x96, 0xf4, 0x02, 0x3e, 0x5d, 0x69, 0x75, 0x5e, 0x95, 0xee,
    0x32, 0xb9, 0xba, 0x55, 0xc5, 0x42, 0x74, 0x00, 0xe1, 0x0f, 0x16, 0x05,
    0x62, 0x3c, 0x58, 0xcb, 0xe0, 0xd4, 0xa9, 0xe5, 0x1a, 0x3b, 0x84, 0x7e,
    0x19, 0x87, 0xad, 0x67, 0xcd, 0x9b, 0x97, 0xb0, 0x32, 0xd7, 0xb8, 0x1e,
    0x96, 0x69, 0x75, 0x0f, 0x61, 0x69, 0xb3, 0xc9, 0xce, 0x73, 0x7c, 0x5f,
    0xd5, 0x08, 0xdf, 0xd4, 0x07, 0x75, 0x60, 0xd7, 0x50, 0x52, 0xe7, 0x5c,
    0x6f, 0x04, 0x59, 0x65, 0xbd, 0x70, 0x99, 0x15, 0xf9, 0xbc, 0x34, 0x78,
    0x6a, 0x64, 0xac, 0x5f, 0x07, 0xc2, 0x89, 0x88, 0xfe, 0x11, 0x7a, 0xf7,
    0x3d, 0xbe, 0x83, 0xff, 0xeb, 0x1d, 0x52, 0xbe, 0xd4, 0x09, 0x71, 0x0f,
    0x7c, 0x95, 0x19, 0xf2, 0x4b, 0xf5, 0x44, 0x63, 0xf2, 0xec, 0x3f, 0xf9,
    0xe4, 0xfb, 0xbe, 0x24, 0xb2, 0x18, 0x53, 0xce, 0x16, 0x40, 0x1e, 0x27,
    0x62, 0x99, 0x93, 0xc9, 0x49, 0x8f, 0x98, 0x0d, 0xd8, 0x73, 0x65, 0x99,
    0xac, 0xff, 0xfe, 0x22, 0x6a, 0xd1, 0xfb, 0xa1, 0xe4, 0xe7, 0xab, 0x3c,
    0x72, 0x10, 0xac, 0x73};

/* Weak primes with value subprimes. Accepted, but takes more processing
 * in both modes. */
static const unsigned char prime_weak_1024[] = {
    0xe4, 0x82, 0x09, 0x4a, 0x6b, 0xbe, 0x9b, 0x51, 0x11, 0xa0, 0x74, 0x25,
    0xff, 0x50, 0x1c, 0x0a, 0xd6, 0xd0, 0xbc, 0xd3, 0x24, 0x89, 0x75, 0x74,
    0xb3, 0xd6, 0x6b, 0xf4, 0xc7, 0x5f, 0x6a, 0xec, 0x1e, 0x3a, 0x20, 0x02,
    0x16, 0x75, 0xcc, 0x44, 0x4a, 0xbf, 0x5b, 0x58, 0xad, 0xfe, 0xb0, 0x18,
    0x6a, 0x38, 0x8b, 0xcb, 0xdb, 0xd1, 0x77, 0x42, 0xe3, 0xa3, 0x87, 0x8a,
    0x99, 0x2e, 0x11, 0xd8, 0xc9, 0x02, 0x84, 0x1d, 0xd2, 0x67, 0x28, 0xbd,
    0x8f, 0xfb, 0x56, 0xf2, 0x63, 0x8a, 0x2c, 0x7c, 0x38, 0xef, 0xa2, 0x0c,
    0x6a, 0x36, 0xd0, 0x99, 0x13, 0x47, 0x48, 0x40, 0xe5, 0xcd, 0xdb, 0x04,
    0x4c, 0xa2, 0x12, 0x3f, 0x1a, 0x9b, 0x9a, 0x0e, 0xb8, 0x68, 0x7d, 0x01,
    0xbc, 0x16, 0x6f, 0x51, 0x64, 0x1d, 0xab, 0x21, 0x75, 0x49, 0x12, 0x36,
    0xac, 0x65, 0x8b, 0xf8, 0x87, 0xd9, 0xaf, 0xd1};

static const unsigned char subprime_weak_1024[] = {
    0xef, 0x0c, 0x17, 0x60, 0xd1, 0x91, 0x8f, 0xea, 0x4d, 0xbe,
    0x0a, 0xb2, 0x37, 0xcc, 0x6b, 0xba, 0x97, 0x98, 0x2d, 0x4b};

static const unsigned char base_weak_1024[] = {
    0x5a, 0x70, 0x8b, 0xe1, 0x1d, 0xed, 0x69, 0x04, 0xd0, 0xdc, 0xda, 0x84,
    0x9e, 0x79, 0x56, 0x11, 0x44, 0xdc, 0xf7, 0xb8, 0x84, 0x88, 0x75, 0x67,
    0xba, 0x80, 0x5b, 0x7e, 0x50, 0xc1, 0x5c, 0x80, 0x59, 0xaa, 0x55, 0x24,
    0x44, 0x6a, 0x8a, 0x31, 0x20, 0x1a, 0xd4, 0xba, 0x5f, 0x32, 0xc6, 0x5d,
    0x9d, 0x0e, 0x58, 0xfc, 0xd0, 0x6c, 0x74, 0xea, 0xd9, 0xc6, 0x86, 0x9f,
    0x3f, 0x83, 0x0e, 0x73, 0xae, 0x28, 0x40, 0x19, 0x9f, 0x5d, 0x64, 0xc4,
    0xae, 0xda, 0x11, 0x3e, 0x3f, 0x44, 0x87, 0xac, 0x41, 0x1e, 0xfa, 0xdb,
    0x1f, 0xde, 0x09, 0x7c, 0x54, 0x7c, 0x8a, 0xe0, 0x82, 0xd7, 0x8c, 0xb9,
    0x61, 0xa0, 0x10, 0xab, 0xff, 0xe1, 0x1f, 0x8b, 0x9d, 0x51, 0x71, 0xc7,
    0xfb, 0xd9, 0xe0, 0x10, 0xc3, 0x7d, 0x88, 0xe9, 0xd2, 0x42, 0xaf, 0xda,
    0x77, 0x55, 0x28, 0x07, 0x03, 0x26, 0xb3, 0x77};

static const unsigned char prime_weak_2048[] = {
    0xb5, 0x08, 0x83, 0x6a, 0x22, 0x39, 0xdf, 0x02, 0xfe, 0x73, 0x6b, 0xfb,
    0x0d, 0x4e, 0xad, 0x4b, 0x0f, 0xfd, 0xb2, 0x27, 0xe7, 0xd2, 0x35, 0xd4,
    0x83, 0xf2, 0xbc, 0x29, 0xff, 0x50, 0xf7, 0x6b, 0xb7, 0x94, 0x38, 0xff,
    0xdc, 0x79, 0x67, 0x9a, 0x80, 0x8b, 0xc2, 0x20, 0x4e, 0x53, 0x02, 0x2a,
    0x07, 0xec, 0xa9, 0xbd, 0x22, 0xd1, 0xba, 0x35, 0x31, 0x10, 0x21, 0xb6,
    0x4f, 0xe1, 0x94, 0x0b, 0xb0, 0xb3, 0x37, 0x20, 0x0d, 0x6a, 0xd4, 0x91,
    0x5c, 0x85, 0xe9, 0xae, 0x8a, 0xf2, 0x94, 0xe7, 0x44, 0xf5, 0xcc, 0x04,
    0x82, 0x57, 0x81, 0x21, 0x83, 0x18, 0x48, 0x2d, 0xe3, 0x1c, 0xa1, 0x7f,
    0xee, 0x10, 0xb9, 0xe8, 0x40, 0xfc, 0xda, 0x43, 0x7d, 0x18, 0xe4, 0x68,
    0x9f, 0xed, 0x5e, 0xc3, 0x1f, 0x80, 0xef, 0x5c, 0x24, 0x5e, 0x68, 0xac,
    0x99, 0x9c, 0x74, 0x96, 0x5b, 0xb3, 0xe7, 0xb2, 0x65, 0x78, 0xfb, 0x3c,
    0x11, 0x00, 0x04, 0x4b, 0x98, 0x0e, 0x8a, 0x7b, 0x38, 0x08, 0x34, 0xb9,
    0x6d, 0x08, 0x65, 0x17, 0x91, 0x49, 0x62, 0x47, 0x64, 0xab, 0xc6, 0xd0,
    0xf2, 0xcf, 0x89, 0x07, 0xeb, 0xa3, 0x5d, 0xf3, 0xa2, 0xfb, 0xdd, 0x7b,
    0x3e, 0x7e, 0xa2, 0xd7, 0x1a, 0x42, 0xad, 0x74, 0xbd, 0xbb, 0xcf, 0x21,
    0x91, 0xd2, 0x6b, 0x1d, 0x9d, 0xa8, 0x05, 0x88, 0x4f, 0xb1, 0x45, 0xa2,
    0x86, 0x90, 0x12, 0xfd, 0xcb, 0x25, 0xe1, 0x12, 0x08, 0x47, 0x1d, 0x83,
    0x2d, 0x14, 0x42, 0x20, 0x08, 0x31, 0x54, 0x2c, 0x9b, 0x49, 0xf6, 0xb6,
    0x2d, 0x25, 0xea, 0x28, 0xbf, 0x13, 0x2b, 0xd3, 0x45, 0x8d, 0x02, 0x9f,
    0xa5, 0xaa, 0xeb, 0xc0, 0x48, 0xd1, 0x06, 0xe6, 0x1e, 0xa0, 0x3e, 0x04,
    0x20, 0x79, 0x7c, 0xd1, 0xd0, 0xac, 0x61, 0x89, 0x6c, 0x3b, 0x88, 0xa3,
    0x54, 0x6c, 0x80, 0x59};

static const unsigned char subprime_weak_2048[] = {
    0xcd, 0x9d, 0xbf, 0x88, 0xe5, 0xc0, 0x03, 0x16, 0xec, 0x9c, 0xb4,
    0x6e, 0x54, 0xd2, 0xbf, 0xdc, 0x05, 0x92, 0xcd, 0x05, 0x87, 0xc9,
    0x9c, 0x91, 0x19, 0x54, 0xb6, 0xd7, 0x1e, 0xe1, 0x0a, 0x93};

static const unsigned char base_weak_2048[] = {
    0x36, 0xc6, 0x6e, 0x3e, 0xe8, 0x44, 0xa0, 0x57, 0x1d, 0x8e, 0x71, 0xb6,
    0x6c, 0x24, 0xf6, 0x1d, 0xb6, 0xa5, 0xfd, 0xe3, 0xd6, 0xc5, 0x6b, 0xe8,
    0x94, 0x5a, 0x8c, 0x5a, 0xdf, 0x41, 0x51, 0xe6, 0xfb, 0x76, 0x4b, 0x06,
    0x4b, 0x03, 0x33, 0x98, 0x15, 0xb5, 0x60, 0x43, 0xc7, 0xc5, 0xb3, 0x4d,
    0x58, 0x90, 0xe8, 0x63, 0xc5, 0xad, 0x5f, 0x57, 0xcf, 0x42, 0x26, 0x99,
    0xa0, 0x71, 0xc6, 0x73, 0x03, 0xa0, 0x45, 0xd0, 0x87, 0xf0, 0xd8, 0x9a,
    0xb2, 0x7d, 0xd7, 0x2d, 0x10, 0x52, 0x04, 0x36, 0x37, 0x4f, 0x9d, 0xb7,
    0x66, 0xdc, 0xf5, 0x76, 0xac, 0x87, 0xfe, 0x5a, 0x9d, 0xca, 0x1e, 0xfb,
    0x6f, 0x7f, 0xfd, 0x9a, 0xaa, 0x12, 0xcf, 0x7a, 0xdb, 0x15, 0xf3, 0xb2,
    0x7b, 0x17, 0xb9, 0xaf, 0x5f, 0xdf, 0x9c, 0x66, 0x29, 0x83, 0x89, 0xf9,
    0xf9, 0xf7, 0x4a, 0x04, 0x1d, 0x00, 0xf7, 0x11, 0x98, 0x18, 0x0a, 0xab,
    0x47, 0xcc, 0x3e, 0x11, 0xf4, 0xe0, 0x7e, 0xad, 0xa5, 0x67, 0xf8, 0x4b,
    0x1b, 0x81, 0x72, 0x8e, 0x5b, 0x49, 0x90, 0x0e, 0x01, 0xc1, 0x7e, 0x8d,
    0xfb, 0xa2, 0xe7, 0x92, 0xd0, 0x23, 0xf5, 0x4a, 0xe8, 0xd4, 0x51, 0xc4,
    0x89, 0xe8, 0x4a, 0x9f, 0xf6, 0xa2, 0xdc, 0xe2, 0x32, 0x88, 0x56, 0x2c,
    0x97, 0x38, 0xdf, 0xd6, 0x4f, 0xfb, 0xf8, 0xbb, 0xee, 0x7a, 0x3a, 0x05,
    0xa2, 0x7f, 0xbb, 0x6d, 0xf6, 0xd6, 0x48, 0xf4, 0x6d, 0x23, 0xb3, 0x93,
    0x7c, 0xfb, 0xd4, 0x8c, 0xa0, 0x58, 0xbc, 0xdf, 0x1b, 0x35, 0x2a, 0x56,
    0x80, 0x7c, 0xc6, 0x28, 0x35, 0xb6, 0x17, 0x5d, 0xa5, 0x15, 0x79, 0x7d,
    0x2c, 0x6a, 0xcf, 0xb1, 0xb1, 0x6e, 0xea, 0xd0, 0x4b, 0xfb, 0xa5, 0xbb,
    0xb7, 0x9f, 0x74, 0x42, 0xd5, 0xf3, 0x4b, 0x54, 0x40, 0xf0, 0x4c, 0x6b,
    0x0f, 0xaf, 0x89, 0x10};

static const unsigned char prime_weak_3072[] = {
    0x94, 0x32, 0xc7, 0x47, 0x51, 0xa3, 0x03, 0x9b, 0xf2, 0x51, 0x5c, 0x69,
    0xaf, 0x05, 0x3c, 0x76, 0x62, 0xa2, 0xec, 0x5a, 0xcc, 0xdf, 0x80, 0xf3,
    0x2d, 0xce, 0xa5, 0xa5, 0x9e, 0x2d, 0xab, 0x5f, 0x91, 0xbd, 0x93, 0x61,
    0xd7, 0x7b, 0x71, 0x6f, 0xf3, 0x92, 0xbf, 0xa8, 0xfc, 0xcd, 0x00, 0xf5,
    0x49, 0x08, 0x00, 0x8c, 0xd2, 0xfe, 0x4a, 0xd8, 0x2b, 0x6e, 0x42, 0xc0,
    0xd8, 0xa2, 0x8b, 0x2b, 0x18, 0x02, 0xad, 0xe8, 0x4e, 0x44, 0x09, 0x26,
    0xa1, 0xa1, 0xca, 0x99, 0xe3, 0xd9, 0x9a, 0x87, 0x3c, 0x83, 0x6a, 0x1a,
    0x7b, 0x60, 0xba, 0x78, 0x0c, 0x79, 0x50, 0x1f, 0xde, 0x40, 0x14, 0x58,
    0x18, 0xa9, 0x2b, 0x74, 0x11, 0xb4, 0x65, 0xfe, 0x9d, 0x03, 0xa4, 0xef,
    0xdf, 0x74, 0x8e, 0xcd, 0x7b, 0xd4, 0xf3, 0x28, 0x75, 0xb2, 0x31, 0xef,
    0x99, 0x65, 0xcb, 0x5a, 0x77, 0xca, 0xa2, 0x25, 0x28, 0xae, 0xfa, 0x9f,
    0xeb, 0xda, 0xcc, 0x34, 0x7b, 0x21, 0xd7, 0xdb, 0x54, 0x40, 0xe6, 0x2f,
    0xdb, 0xc0, 0xce, 0xdc, 0xe5, 0xc9, 0x27, 0x97, 0x99, 0x9c, 0x02, 0x4f,
    0x24, 0x88, 0x93, 0xdf, 0xa9, 0xc7, 0x3e, 0x10, 0xc8, 0xaa, 0x6a, 0xce,
    0xda, 0x46, 0x94, 0x8c, 0xad, 0x1e, 0xf1, 0xcb, 0xd3, 0xcd, 0x43, 0x44,
    0xb4, 0x20, 0x91, 0x9e, 0xf6, 0xd1, 0x03, 0xef, 0xc2, 0x04, 0xf7, 0x07,
    0xdb, 0xac, 0xa2, 0x28, 0x8c, 0x7d, 0x1d, 0x5d, 0x2c, 0x5a, 0xfc, 0x26,
    0x5b, 0x0b, 0x58, 0xb9, 0x9a, 0x47, 0xe9, 0xa0, 0xdf, 0xa5, 0x5a, 0xf3,
    0xe5, 0xd6, 0xeb, 0x69, 0xb5, 0x4e, 0xbc, 0x71, 0xc0, 0xd6, 0x9b, 0xb8,
    0x40, 0x3b, 0xc5, 0x72, 0x5d, 0x4d, 0x1b, 0x17, 0x3d, 0x36, 0xa4, 0xb1,
    0x15, 0xa7, 0x9a, 0x72, 0xeb, 0xf2, 0x9e, 0x40, 0xd1, 0xbc, 0x35, 0xc7,
    0xd1, 0x1a, 0x8f, 0x1c, 0x2b, 0x5e, 0xd8, 0xb3, 0x3b, 0x44, 0xae, 0xf5,
    0x81, 0xd0, 0x8a, 0x37, 0xab, 0xba, 0x22, 0xbc, 0x2d, 0x88, 0x2f, 0x24,
    0xbb, 0xb0, 0x1a, 0xa9, 0x5f, 0x07, 0x10, 0x6d, 0xc6, 0xbb, 0x3c, 0xa2,
    0x66, 0xf9, 0xb9, 0x95, 0xd6, 0x5e, 0x8c, 0xce, 0x04, 0xdc, 0xb3, 0x4c,
    0xbc, 0xe9, 0xc5, 0xcb, 0x19, 0x97, 0xe2, 0xa1, 0x09, 0x38, 0xd7, 0x82,
    0xa6, 0xbf, 0xc9, 0x15, 0x25, 0xf1, 0x2c, 0x77, 0xfc, 0xbd, 0xfa, 0x7f,
    0x92, 0xfe, 0xd6, 0x31, 0x03, 0x23, 0x2d, 0x17, 0x2f, 0x51, 0x9e, 0x5c,
    0xb1, 0x68, 0xc0, 0x3f, 0x42, 0x99, 0x00, 0x55, 0x33, 0x68, 0xd7, 0xee,
    0x51, 0x7d, 0x3e, 0x03, 0x4f, 0x02, 0x5f, 0x27, 0xdd, 0x17, 0x18, 0x6c,
    0x1e, 0x9d, 0x91, 0x65, 0xf8, 0xd7, 0xa6, 0x9f, 0xa1, 0xba, 0xa8, 0x76,
    0xe4, 0xd8, 0xf4, 0x59, 0x90, 0x16, 0x67, 0x88, 0xc2, 0xa9, 0xe4, 0x2d};

static const unsigned char subprime_weak_3072[] = {
    0xd6, 0xf6, 0xeb, 0x1e, 0x65, 0x44, 0xe1, 0x1a, 0x37, 0x69, 0x8c,
    0x60, 0x45, 0xcb, 0xcb, 0x52, 0xe4, 0x88, 0xcb, 0xad, 0xb2, 0x27,
    0x18, 0xfa, 0x3a, 0xcf, 0xc6, 0xf9, 0xc3, 0x03, 0xa8, 0xb9};

static const unsigned char base_weak_3072[] = {
    0x6e, 0x65, 0xcd, 0xd8, 0xbf, 0x8a, 0x5a, 0xa1, 0x05, 0x62, 0xa2, 0x64,
    0x88, 0x4a, 0x49, 0x1b, 0x57, 0xa8, 0x0e, 0x2e, 0x28, 0x4a, 0xe3, 0xaa,
    0xa7, 0x4e, 0xc7, 0x06, 0xe2, 0xf8, 0x9c, 0xd7, 0x05, 0x05, 0x6e, 0x5b,
    0x89, 0xd5, 0xa1, 0x16, 0xda, 0x2a, 0x2f, 0xe6, 0x86, 0xf0, 0x6e, 0xdc,
    0xd0, 0xbc, 0x0b, 0x39, 0x90, 0xe3, 0x74, 0x2c, 0x02, 0x6f, 0x7e, 0x32,
    0x2d, 0xf6, 0xd7, 0xa2, 0xfb, 0xe9, 0xaf, 0x8b, 0xb3, 0x1c, 0xd0, 0x78,
    0x4a, 0x76, 0xf8, 0xbd, 0x03, 0x5b, 0x0c, 0x68, 0x65, 0x23, 0x8a, 0x45,
    0xf3, 0x51, 0xe0, 0xe1, 0x96, 0x57, 0x7e, 0x05, 0x6c, 0xae, 0xaf, 0xa6,
    0x45, 0xdc, 0xa8, 0x36, 0x69, 0xa5, 0x13, 0x37, 0x4a, 0x16, 0x43, 0x11,
    0xab, 0x5b, 0xb6, 0xcf, 0x86, 0xb6, 0xf8, 0x44, 0xb9, 0x76, 0xe7, 0x1e,
    0x88, 0x99, 0x6f, 0xfe, 0xfb, 0x5c, 0xdb, 0x59, 0x4c, 0x26, 0xdb, 0x20,
    0x20, 0x97, 0x47, 0xda, 0x7b, 0x1d, 0xe9, 0x18, 0x1a, 0x89, 0x07, 0x3b,
    0xd1, 0xc8, 0x4c, 0xfd, 0xae, 0x35, 0x4c, 0xa0, 0x42, 0x94, 0x89, 0xc0,
    0xae, 0x2f, 0x94, 0x49, 0xd9, 0x7d, 0xb2, 0x4c, 0x50, 0x29, 0x46, 0x14,
    0x9a, 0x56, 0x49, 0x7a, 0x09, 0xa8, 0x95, 0x3a, 0x94, 0x06, 0x7c, 0xf0,
    0xea, 0x39, 0xcb, 0x33, 0xad, 0x28, 0xd1, 0x55, 0x02, 0xf5, 0x46, 0x0c,
    0x92, 0x12, 0x17, 0x05, 0x60, 0x97, 0xcd, 0x2f, 0x18, 0x5e, 0xe3, 0x41,
    0xe6, 0x46, 0x69, 0x27, 0x7d, 0x61, 0x00, 0x1e, 0x8d, 0x74, 0xa5, 0xc5,
    0xcb, 0xb9, 0xbc, 0x3f, 0x7a, 0x21, 0x23, 0x22, 0x1b, 0x15, 0x50, 0xb9,
    0x4b, 0x3b, 0x9f, 0xd5, 0xc0, 0x8c, 0xb9, 0x9d, 0x7e, 0xf4, 0x13, 0xc9,
    0x64, 0xe3, 0x7b, 0x44, 0xa7, 0x10, 0xad, 0x3c, 0xaf, 0xf0, 0x07, 0x8d,
    0x04, 0xc9, 0xa9, 0x36, 0x10, 0xb9, 0x8d, 0x7d, 0x43, 0x24, 0x7d, 0x8d,
    0x3c, 0x74, 0x58, 0x02, 0xb9, 0x4b, 0xe6, 0x6c, 0xa9, 0x9f, 0xdc, 0x50,
    0x5f, 0x62, 0x68, 0xc7, 0x14, 0xe7, 0x88, 0x33, 0x3e, 0x41, 0xad, 0x92,
    0x9d, 0x15, 0xd4, 0x77, 0xb9, 0xfb, 0x18, 0xd2, 0x8b, 0xb3, 0xc4, 0x0f,
    0x26, 0x04, 0xa4, 0xb1, 0xc1, 0x83, 0x96, 0x17, 0x67, 0x52, 0xa5, 0xfb,
    0x1b, 0x70, 0x20, 0x1c, 0x8c, 0x24, 0xc4, 0x5c, 0xd7, 0xe2, 0x12, 0xe3,
    0x31, 0x10, 0x4e, 0x85, 0xc2, 0xd2, 0x63, 0x3a, 0x75, 0xe0, 0x9e, 0x6f,
    0x78, 0x19, 0xb0, 0x40, 0x03, 0x32, 0x75, 0x6f, 0xea, 0x2f, 0x90, 0xb2,
    0x48, 0x79, 0xa1, 0xa0, 0x61, 0xf6, 0x13, 0xf3, 0x50, 0xa9, 0xec, 0x90,
    0x5d, 0xae, 0x45, 0x4f, 0x1b, 0x80, 0xd3, 0x96, 0x62, 0x05, 0x5b, 0x53,
    0x63, 0x99, 0xe5, 0xf2, 0x1b, 0xeb, 0x3e, 0x25, 0x2e, 0x72, 0xdb, 0x1f};

static const unsigned char prime_weak_4096[] = {
    0xff, 0x50, 0xd3, 0xcc, 0x89, 0x17, 0x5e, 0xb6, 0xf8, 0xa3, 0xb0, 0xe2,
    0xf9, 0x9f, 0x17, 0xa1, 0x92, 0x56, 0x15, 0x13, 0x12, 0x9f, 0x18, 0xdc,
    0x07, 0x00, 0xc2, 0x49, 0xc9, 0xd9, 0xd4, 0x0a, 0xe3, 0xd7, 0xf6, 0x60,
    0x21, 0xa9, 0x7b, 0xc0, 0x0f, 0x0e, 0xae, 0x3e, 0x77, 0x77, 0x48, 0xd8,
    0xfd, 0x42, 0xec, 0xb5, 0xae, 0x00, 0xab, 0xce, 0xd1, 0x11, 0xca, 0xd2,
    0x64, 0x5a, 0xa3, 0x6b, 0xba, 0xd1, 0x93, 0xea, 0xda, 0xd2, 0xa0, 0x60,
    0x39, 0x0b, 0x34, 0x4f, 0x0c, 0xf1, 0xb0, 0x52, 0x75, 0x51, 0x3d, 0x28,
    0x02, 0xb5, 0xbd, 0x42, 0x98, 0x20, 0xa7, 0x42, 0xb9, 0x21, 0x9a, 0xae,
    0xb6, 0x41, 0x7b, 0x70, 0xe3, 0xd9, 0xaf, 0x81, 0x1a, 0xc1, 0x39, 0x9c,
    0x52, 0x56, 0xcb, 0x0d, 0x6a, 0x67, 0x6f, 0x3d, 0x12, 0x76, 0x73, 0x53,
    0x95, 0x2d, 0xc1, 0x04, 0xdb, 0x83, 0xe4, 0xd0, 0xbe, 0x2d, 0xa6, 0x7a,
    0x0f, 0x80, 0x1b, 0xd0, 0x16, 0x14, 0x3a, 0xe0, 0x48, 0xfa, 0xf5, 0x44,
    0xa8, 0xe0, 0xbf, 0x98, 0xe1, 0x56, 0xea, 0x76, 0xb6, 0xe2, 0xa3, 0x5b,
    0x15, 0x79, 0x10, 0xb0, 0x41, 0xdc, 0x29, 0x0f, 0x1e, 0x37, 0x69, 0xcd,
    0x13, 0xbe, 0x2d, 0xe0, 0x73, 0x38, 0x68, 0xed, 0x50, 0x6a, 0xd0, 0xfb,
    0xcb, 0x17, 0x3a, 0x59, 0xfb, 0xec, 0xba, 0x75, 0xb6, 0x4e, 0x2f, 0x6e,
    0x97, 0x98, 0x0e, 0x79, 0x25, 0xdd, 0xd8, 0xf5, 0x34, 0xb4, 0xa0, 0x7e,
    0xba, 0x68, 0x7c, 0x4f, 0xfb, 0xe0, 0x97, 0x46, 0x50, 0x1e, 0x4a, 0x59,
    0x9c, 0xdc, 0x34, 0xe2, 0x2a, 0xb5, 0xc8, 0x58, 0x94, 0x48, 0x9f, 0xb8,
    0x36, 0xcb, 0xce, 0x36, 0xb1, 0x7c, 0xe5, 0x8d, 0x5b, 0x43, 0xd7, 0x88,
    0xdf, 0xae, 0xd0, 0xc9, 0x42, 0x5f, 0x0a, 0xe3, 0x63, 0x11, 0xc5, 0x0c,
    0x80, 0x55, 0x58, 0xd7, 0xf2, 0x51, 0x6e, 0xb3, 0x7e, 0x9d, 0x1c, 0xc3,
    0x61, 0x59, 0x5c, 0x47, 0xd4, 0x99, 0xc0, 0x67, 0xfb, 0xb2, 0xd6, 0x11,
    0xda, 0x92, 0x5b, 0x6b, 0xd2, 0x70, 0xb7, 0x69, 0x72, 0xe7, 0x06, 0xdd,
    0x40, 0xac, 0x81, 0x51, 0x1d, 0x52, 0x7a, 0x45, 0x38, 0x89, 0x27, 0x2c,
    0xc4, 0x4b, 0x7e, 0x5e, 0x79, 0xef, 0x84, 0x6a, 0x24, 0x4d, 0x9c, 0x9e,
    0xca, 0x75, 0x5c, 0x06, 0x6d, 0xd0, 0x52, 0xe9, 0xda, 0x9f, 0x46, 0xb6,
    0x62, 0x1d, 0xb3, 0xd9, 0xf2, 0x7d, 0xd6, 0xc2, 0x7a, 0x49, 0x7c, 0xdd,
    0x9b, 0xaa, 0xc3, 0x84, 0x0b, 0x08, 0x33, 0xb8, 0x80, 0xc3, 0x12, 0x8f,
    0xad, 0xac, 0x0f, 0x7f, 0xaf, 0x59, 0x61, 0x0d, 0x98, 0xc1, 0xf9, 0x68,
    0xc3, 0x1b, 0x10, 0x08, 0xc4, 0x33, 0x3c, 0xa4, 0xe2, 0xd5, 0xeb, 0x71,
    0x5d, 0x19, 0x7e, 0x05, 0xca, 0x9a, 0xf5, 0xbb, 0x71, 0x55, 0x83, 0x9c,
    0x25, 0x50, 0x35, 0x7f, 0x2d, 0xeb, 0xf2, 0x0d, 0xed, 0x3c, 0xb8, 0x71,
    0xbd, 0x08, 0xf5, 0x89, 0x7e, 0x5e, 0x38, 0x40, 0xd7, 0xed, 0x77, 0x8d,
    0x7a, 0xed, 0x2a, 0x9f, 0xfc, 0x01, 0xf4, 0xe2, 0xcf, 0xda, 0x8c, 0xa3,
    0x57, 0xdc, 0x14, 0xd6, 0xa1, 0xd9, 0x97, 0xb9, 0xe6, 0xfc, 0x48, 0x75,
    0x43, 0xbd, 0x3b, 0x91, 0x17, 0x3c, 0x33, 0xca, 0xce, 0x29, 0x09, 0x1b,
    0xe8, 0x9d, 0xb6, 0x74, 0x05, 0x5e, 0x2e, 0xa5, 0x1d, 0x7f, 0x3a, 0xa9,
    0x2c, 0xf6, 0x4d, 0x41, 0x90, 0xbc, 0x56, 0x18, 0x52, 0x02, 0x90, 0xef,
    0x71, 0xff, 0x3e, 0x0c, 0xf8, 0x00, 0x04, 0x07, 0xd5, 0x20, 0x26, 0xdd,
    0x5c, 0xb1, 0x37, 0x03, 0x20, 0x0c, 0xb4, 0xb6, 0x39, 0x49, 0x49, 0xaa,
    0xe7, 0x98, 0x01, 0xa2, 0x2e, 0x0a, 0x33, 0x82, 0x9e, 0xb9, 0x24, 0xb7,
    0x80, 0xdf, 0xd3, 0xdf, 0x04, 0xe4, 0x50, 0x9d};

#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
static const unsigned char subprime_weak_4096[] = {
    0xcf, 0xd9, 0x38, 0x6d, 0x5b, 0x8d, 0x82, 0x9d, 0xa8, 0xe7, 0x9f,
    0x21, 0x46, 0xcc, 0x15, 0xea, 0x61, 0x31, 0x13, 0x5d, 0x50, 0xcd,
    0x99, 0x26, 0xf9, 0x44, 0x28, 0x44, 0xc8, 0xae, 0xb7, 0x8f};
#endif

static const unsigned char base_weak_4096[] = {
    0x55, 0xa1, 0x9d, 0x92, 0x16, 0x3d, 0x9c, 0xfa, 0xd7, 0x7c, 0x71, 0xea,
    0x29, 0x53, 0x9b, 0xdc, 0x8e, 0xa6, 0xbb, 0x06, 0xd5, 0x00, 0x5d, 0x6c,
    0x8e, 0x5d, 0x44, 0xb9, 0x13, 0x4b, 0x20, 0x92, 0x6d, 0x39, 0x9d, 0x34,
    0xaf, 0x9b, 0x12, 0x1d, 0xc5, 0xea, 0xb2, 0x89, 0x05, 0xa6, 0x49, 0x9f,
    0xd8, 0xf4, 0xba, 0x33, 0xab, 0x28, 0xf2, 0x2f, 0xf6, 0x49, 0x37, 0x0e,
    0xb2, 0xc6, 0x41, 0x8c, 0x91, 0x97, 0x07, 0xf8, 0xa3, 0x88, 0x12, 0x6b,
    0xe8, 0x85, 0x0e, 0x26, 0x0a, 0x79, 0xe2, 0x48, 0x1c, 0x5c, 0xee, 0x99,
    0x4b, 0xd1, 0xf7, 0xe8, 0xff, 0xae, 0x5b, 0xd1, 0xf4, 0x5e, 0x6a, 0x09,
    0xc2, 0xa0, 0xc3, 0x14, 0xe3, 0xc6, 0x25, 0x3e, 0xe4, 0xff, 0xd7, 0x38,
    0xb4, 0xf4, 0xda, 0xab, 0xde, 0x84, 0x08, 0xd3, 0x53, 0xce, 0xb9, 0x5f,
    0x41, 0x4a, 0x02, 0x9f, 0xe1, 0x90, 0x3a, 0x80, 0x2f, 0xc5, 0xbb, 0xcc,
    0x92, 0xa8, 0x76, 0xa4, 0x78, 0x32, 0x70, 0x50, 0x21, 0x54, 0x4a, 0x97,
    0x4b, 0x8f, 0x2f, 0x61, 0x66, 0x65, 0x57, 0x2e, 0xf3, 0x64, 0x0e, 0x7e,
    0xa0, 0xf7, 0xf7, 0x5a, 0x32, 0xd9, 0x88, 0xf7, 0x4c, 0x4b, 0xd6, 0x5a,
    0xe1, 0x82, 0xd7, 0x6e, 0x4d, 0xee, 0xa2, 0xf0, 0x4e, 0x3f, 0x26, 0xba,
    0xfa, 0xfb, 0xe2, 0x1d, 0x64, 0x19, 0x10, 0x77, 0x99, 0xf4, 0x02, 0x46,
    0x30, 0xb0, 0xb1, 0x4b, 0xb2, 0xbd, 0x2c, 0xd4, 0xf8, 0xf2, 0x7f, 0xaf,
    0xd6, 0x80, 0xa4, 0x16, 0x72, 0x39, 0x0b, 0x83, 0x7d, 0x1a, 0x03, 0xcf,
    0x0c, 0xdc, 0xaa, 0x9c, 0x21, 0x61, 0xef, 0x12, 0x92, 0xc5, 0x71, 0x50,
    0x7f, 0x66, 0xda, 0x28, 0x50, 0xfa, 0x18, 0x33, 0xb8, 0x86, 0x50, 0x1a,
    0x8e, 0x6b, 0x6f, 0xd3, 0xe2, 0x7d, 0x6e, 0x3f, 0x6d, 0x9b, 0x26, 0x33,
    0x98, 0x82, 0x95, 0x2a, 0xdf, 0x11, 0xf8, 0xb6, 0x05, 0x10, 0x3d, 0x39,
    0x23, 0x28, 0x4a, 0x35, 0x72, 0xc4, 0x7f, 0x47, 0x5a, 0x0b, 0xcb, 0xed,
    0x54, 0xd3, 0x81, 0xdf, 0xd7, 0x0c, 0xf6, 0xbe, 0xca, 0x8e, 0xac, 0x22,
    0x67, 0xd4, 0xf9, 0xcb, 0xaf, 0xe6, 0x42, 0x58, 0x97, 0x0f, 0x24, 0xdf,
    0xb8, 0x85, 0xbe, 0x34, 0xd7, 0x68, 0xfa, 0xbf, 0xc5, 0xcb, 0x61, 0x8b,
    0xbf, 0xa8, 0xf7, 0x64, 0xee, 0xf3, 0x8d, 0xf7, 0x5b, 0x6e, 0xe8, 0x07,
    0xa0, 0x6d, 0xb5, 0x75, 0xa2, 0x33, 0x1f, 0xe0, 0x3e, 0x82, 0xc0, 0xef,
    0xeb, 0x6a, 0x8a, 0xba, 0x87, 0xb4, 0x44, 0x66, 0xb2, 0xe7, 0x06, 0xa5,
    0x5a, 0x02, 0x26, 0xa7, 0x8d, 0x57, 0xa7, 0x28, 0x62, 0x20, 0x0e, 0x3b,
    0xff, 0x90, 0xca, 0x9e, 0x95, 0xdf, 0xf3, 0x63, 0x8c, 0xc0, 0xd6, 0x1b,
    0xaa, 0x5e, 0x66, 0x54, 0xb2, 0x77, 0x4d, 0xd4, 0xd3, 0x99, 0xeb, 0xba,
    0xc1, 0x3c, 0xe3, 0xf7, 0x48, 0x65, 0x9f, 0xb3, 0x0c, 0x96, 0x3f, 0x3b,
    0x2f, 0x10, 0x80, 0x8f, 0x59, 0x49, 0xa0, 0x26, 0x68, 0xf9, 0x8e, 0x0b,
    0x66, 0x6e, 0xc1, 0x57, 0x77, 0x5d, 0xc7, 0x4b, 0x3b, 0x73, 0xa7, 0x75,
    0x80, 0x0d, 0x93, 0x36, 0x62, 0xf5, 0x5f, 0xa0, 0x71, 0x72, 0x54, 0x33,
    0x3b, 0xc8, 0xee, 0x68, 0x70, 0xdc, 0x1e, 0x39, 0x04, 0x1e, 0x98, 0xd4,
    0x7f, 0x57, 0x0e, 0x5d, 0x6e, 0x3f, 0x27, 0xc1, 0x7d, 0x50, 0x13, 0x5b,
    0x31, 0xfe, 0x7b, 0x12, 0xd5, 0x42, 0xda, 0x8d, 0x0e, 0x69, 0xcc, 0xa1,
    0xc4, 0x90, 0xf5, 0x37, 0x13, 0x20, 0x42, 0x74, 0xea, 0x79, 0xde, 0x84,
    0x6d, 0x8e, 0xcf, 0x57, 0x0b, 0x9f, 0xa6, 0x1d, 0xbe, 0x42, 0xb2, 0x47,
    0xf8, 0x7e, 0x51, 0x2e, 0x8b, 0x5e, 0x7d, 0x3d, 0x98, 0x1e, 0x43, 0x2b,
    0x32, 0x2f, 0xcb, 0x64, 0xd9, 0x43, 0x2b, 0xae};

static const unsigned char prime_weak_6144[] = {
    0xa2, 0x24, 0x96, 0xb6, 0x21, 0x68, 0xd5, 0x7e, 0x2c, 0x60, 0x4d, 0xc8,
    0x81, 0x59, 0x9c, 0x1c, 0x70, 0xec, 0x24, 0x28, 0xb6, 0x52, 0x36, 0x09,
    0x87, 0xaa, 0xc1, 0x5b, 0xe5, 0xa6, 0x3e, 0x88, 0x54, 0x05, 0xe3, 0x09,
    0x09, 0xca, 0x6d, 0x9b, 0xc4, 0x8d, 0x26, 0xaf, 0xd7, 0xee, 0x9f, 0x0d,
    0xbd, 0x44, 0x8e, 0xfe, 0xcd, 0xf2, 0xe6, 0xde, 0xac, 0xf2, 0x02, 0x37,
    0xdc, 0x35, 0xc2, 0xce, 0xcd, 0x5f, 0xc5, 0x87, 0x0f, 0x99, 0xa7, 0xdb,
    0x0f, 0x1a, 0xcd, 0x76, 0xaa, 0x4a, 0xa5, 0x09, 0x60, 0x60, 0xe3, 0x58,
    0xe4, 0x52, 0x07, 0x1b, 0x42, 0x17, 0x11, 0x50, 0x2b, 0x40, 0x95, 0x8d,
    0x48, 0xa0, 0x34, 0x95, 0x25, 0x38, 0xcf, 0x09, 0x94, 0xe6, 0x55, 0x06,
    0x8a, 0xde, 0xdc, 0x41, 0x4a, 0xd9, 0x1f, 0x80, 0x82, 0x1d, 0xb8, 0x1e,
    0x84, 0x60, 0xde, 0xed, 0x4f, 0xc0, 0xd8, 0x1d, 0x54, 0xda, 0xb3, 0xf3,
    0x0e, 0x54, 0x3f, 0x18, 0x88, 0xff, 0x25, 0x31, 0xc6, 0x16, 0xe6, 0x70,
    0xfa, 0xc4, 0x08, 0xfc, 0x00, 0x8b, 0xf6, 0x9d, 0x29, 0x8a, 0x59, 0x49,
    0xed, 0x5c, 0x34, 0x7a, 0x84, 0x79, 0x40, 0xc1, 0x7e, 0x82, 0x17, 0x36,
    0xc8, 0x96, 0xb5, 0xd2, 0xf9, 0xdb, 0xc0, 0x10, 0x9f, 0xf8, 0x95, 0x35,
    0x6f, 0xb0, 0xb9, 0x48, 0x88, 0xdc, 0xf0, 0x4d, 0x30, 0xcd, 0x15, 0xfd,
    0x2f, 0xba, 0x18, 0xcc, 0x94, 0x50, 0x3f, 0xfe, 0x60, 0x3d, 0x7a, 0x46,
    0xef, 0xc4, 0xcd, 0x14, 0xe0, 0xef, 0x97, 0x81, 0xa1, 0x95, 0xe3, 0xa5,
    0x91, 0x9a, 0xf7, 0x9f, 0x7c, 0xfa, 0x0c, 0x69, 0xb6, 0xdf, 0xdb, 0xaf,
    0x31, 0xd8, 0xa8, 0x77, 0x6a, 0xba, 0xba, 0x80, 0xff, 0x3f, 0x5f, 0x86,
    0x9f, 0x80, 0x03, 0x1e, 0xd0, 0x5f, 0x37, 0x50, 0x61, 0xfc, 0x03, 0xd8,
    0x93, 0xa1, 0x79, 0x62, 0xfa, 0x92, 0xb8, 0x4a, 0x66, 0x99, 0xd7, 0x85,
    0x8d, 0x0f, 0x07, 0x02, 0x03, 0x83, 0x8c, 0x20, 0xa5, 0x9c, 0x2f, 0xfd,
    0x22, 0x5a, 0xf0, 0x95, 0x1e, 0xbf, 0x17, 0xf1, 0x3a, 0x40, 0x7f, 0xce,
    0x94, 0x62, 0x5f, 0x58, 0xe5, 0xf3, 0x99, 0x8c, 0x38, 0x8f, 0x05, 0x10,
    0x68, 0xea, 0x41, 0xb5, 0xc0, 0x6f, 0x4f, 0x63, 0x87, 0x1d, 0x98, 0xc3,
    0x31, 0x66, 0x1e, 0x9f, 0x2d, 0x3c, 0x6e, 0x9f, 0xb3, 0xcf, 0x8e, 0x77,
    0xf5, 0x3c, 0x51, 0x5a, 0xee, 0x82, 0xa1, 0xc5, 0x53, 0x20, 0x75, 0xd1,
    0xa8, 0x02, 0x37, 0x43, 0x08, 0x16, 0x05, 0x01, 0xed, 0xea, 0xf1, 0x52,
    0x58, 0x20, 0x94, 0x85, 0x05, 0x2e, 0x48, 0x3f, 0x47, 0x49, 0x4f, 0x01,
    0x44, 0xbd, 0x1e, 0x42, 0xea, 0x90, 0x90, 0x23, 0x99, 0x05, 0xfd, 0x37,
    0x41, 0x0c, 0x2f, 0xc4, 0x20, 0x04, 0x99, 0xee, 0x0f, 0xbb, 0xc2, 0x6d,
    0x0a, 0x7f, 0x24, 0x5a, 0x17, 0xa4, 0xeb, 0x9c, 0x67, 0xfe, 0x64, 0x0d,
    0xea, 0xb7, 0x20, 0x48, 0x40, 0x3b, 0x25, 0xed, 0x51, 0x5c, 0xfc, 0x20,
    0x18, 0xb6, 0xfc, 0x3e, 0xdb, 0xd9, 0xa1, 0xbd, 0x9e, 0xee, 0xcb, 0x5d,
    0x02, 0xfe, 0x7f, 0x42, 0x9d, 0xc9, 0xce, 0xfa, 0xe1, 0xd8, 0xf2, 0x05,
    0x67, 0x35, 0x88, 0x4e, 0xd7, 0x70, 0x97, 0x63, 0xb5, 0x0c, 0x60, 0x89,
    0xc0, 0xfe, 0x32, 0xd7, 0xae, 0x4b, 0xf1, 0x0a, 0xae, 0x3c, 0xde, 0x18,
    0x9c, 0x1d, 0xd2, 0xda, 0xf2, 0x02, 0x8d, 0xf1, 0x07, 0xd6, 0x5e, 0xb7,
    0xba, 0xaf, 0x81, 0x97, 0xee, 0xe0, 0x9d, 0x51, 0xf3, 0x1d, 0xc1, 0x5d,
    0x43, 0xe2, 0x0b, 0x0c, 0x9c, 0x0d, 0x74, 0x91, 0x20, 0x6f, 0x65, 0xf1,
    0xf2, 0x84, 0x02, 0x38, 0xb5, 0xe5, 0x10, 0x21, 0xfc, 0xe6, 0xc3, 0x4b,
    0x60, 0x49, 0x6a, 0xf1, 0xd5, 0x50, 0x0f, 0x6f, 0x8b, 0x1e, 0x80, 0xf3,
    0x5d, 0x29, 0xee, 0x60, 0xab, 0x26, 0xa5, 0x8c, 0xc4, 0x4c, 0xcb, 0xa6,
    0xaa, 0xe3, 0xfe, 0xd1, 0x67, 0x48, 0xb4, 0xfa, 0xbf, 0x57, 0xfe, 0x62,
    0x85, 0xa0, 0xac, 0xdc, 0x4e, 0x71, 0x01, 0xcc, 0x12, 0xec, 0x80, 0x95,
    0x54, 0xdc, 0x14, 0x9e, 0x20, 0xda, 0x5a, 0xbd, 0xee, 0x76, 0xbe, 0x39,
    0xcf, 0xbd, 0x8a, 0xe3, 0x0e, 0x71, 0x85, 0xe4, 0x3c, 0x62, 0x3b, 0xf8,
    0x6e, 0x70, 0xd4, 0xd6, 0x2e, 0xe0, 0x5e, 0x11, 0x9d, 0x33, 0xd9, 0x30,
    0xff, 0x3b, 0xcc, 0x2a, 0x39, 0xc4, 0x6f, 0xfd, 0xca, 0x88, 0xad, 0x28,
    0xa2, 0xe8, 0xa8, 0xd7, 0xe6, 0x08, 0x0d, 0xaf, 0x9d, 0xd8, 0xc8, 0x41,
    0x66, 0x84, 0x66, 0x86, 0x2b, 0x81, 0x3b, 0x6c, 0xc6, 0x76, 0x27, 0x6a,
    0x0d, 0x96, 0x0e, 0x65, 0x3e, 0xdf, 0xf5, 0x68, 0x04, 0x9d, 0x2d, 0x26,
    0x8b, 0xca, 0x0a, 0x79, 0x2a, 0xb4, 0xa0, 0xb3, 0x18, 0x4a, 0xea, 0x6a,
    0xd2, 0x14, 0xcd, 0x47, 0x85, 0x9f, 0x86, 0xd7, 0xde, 0xaa, 0x1e, 0x0e,
    0x71, 0x13, 0xec, 0xfe, 0x7c, 0x69, 0xbf, 0x22, 0xf0, 0x61, 0x50, 0x97,
    0x77, 0xc2, 0x2b, 0x31, 0x89, 0x11, 0xd6, 0x08, 0xb1, 0xd4, 0xce, 0xba,
    0xa0, 0x16, 0x9c, 0x2b, 0x8b, 0x3e, 0x17, 0xd8, 0xea, 0xe1, 0xf1, 0x20,
    0x7f, 0x3e, 0x76, 0x9f, 0x2f, 0x46, 0xc3, 0xaf, 0xc4, 0xba, 0xc9, 0x63,
    0xf7, 0xbb, 0x98, 0x6d, 0x60, 0x16, 0x04, 0x14, 0xc2, 0xed, 0x2e, 0xc3,
    0x00, 0x4f, 0x8f, 0x9d, 0xc6, 0xd9, 0xcd, 0xc1, 0xab, 0x4e, 0x67, 0xed,
    0xf8, 0xd2, 0x62, 0x13, 0xfa, 0x11, 0x31, 0xbb, 0x08, 0xdd, 0x4e, 0x89,
    0x4a, 0xff, 0x07, 0x89, 0xb5, 0x6c, 0xc3, 0xfe, 0x76, 0x6d, 0x10, 0x4c,
    0x1e, 0x10, 0x55, 0x22, 0x95, 0xfe, 0x09, 0xa5, 0x6e, 0x73, 0x0c, 0x2b};

#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
static const unsigned char subprime_weak_6144[] = {
    0xa8, 0x61, 0x65, 0x91, 0xb2, 0x43, 0xe3, 0x04, 0x25, 0x77, 0xb0,
    0x5a, 0xc5, 0xb1, 0x50, 0x19, 0x31, 0x2a, 0xd4, 0x79, 0x93, 0xc4,
    0x90, 0x9b, 0x27, 0xf1, 0x1e, 0xbb, 0x6e, 0x08, 0x98, 0xb1};
#endif

static const unsigned char base_weak_6144[] = {
    0x34, 0xc2, 0xb2, 0x1f, 0xd9, 0x4e, 0xb6, 0xfd, 0x6c, 0x01, 0x47, 0xb9,
    0x50, 0xf1, 0xbe, 0x07, 0x1c, 0xdd, 0x67, 0xa2, 0xf1, 0x7c, 0x0d, 0xe5,
    0x9b, 0x7c, 0x9e, 0x0e, 0xd9, 0xf8, 0x81, 0xa1, 0xcf, 0x12, 0x28, 0x69,
    0xcd, 0xdf, 0x8a, 0x91, 0xad, 0x53, 0x0e, 0x31, 0x0c, 0xff, 0x4f, 0xaa,
    0x4f, 0x24, 0xa3, 0xd8, 0xc5, 0x56, 0xef, 0x21, 0xd6, 0x03, 0xcc, 0x87,
    0xab, 0xde, 0x7b, 0xbb, 0xbc, 0x1c, 0x91, 0xd4, 0x1d, 0x08, 0xe8, 0x26,
    0xba, 0x6e, 0x0c, 0x17, 0x1f, 0xb1, 0x29, 0x17, 0x04, 0x6c, 0x84, 0xd5,
    0x43, 0xc1, 0x35, 0xfd, 0x5a, 0x03, 0xd2, 0x9f, 0x30, 0xf7, 0xa5, 0xd5,
    0xb3, 0xc7, 0x5e, 0x00, 0x51, 0x31, 0x49, 0xec, 0x9b, 0xdd, 0x51, 0xee,
    0x84, 0xf4, 0x5f, 0xbe, 0x81, 0x23, 0x1e, 0xae, 0x99, 0x08, 0xdb, 0x26,
    0x41, 0xea, 0xcb, 0x7f, 0x40, 0xf6, 0x7b, 0x7f, 0xf7, 0x45, 0xcc, 0x7c,
    0x05, 0x35, 0xa8, 0x9f, 0x5a, 0x61, 0xf2, 0x71, 0xd4, 0x9b, 0x36, 0x19,
    0x69, 0xcd, 0x15, 0x06, 0x7a, 0xd7, 0x65, 0x04, 0x23, 0xa1, 0xf0, 0x18,
    0x16, 0xb1, 0x33, 0x45, 0x22, 0x14, 0xce, 0xc2, 0xfa, 0x6f, 0x5e, 0x4e,
    0x80, 0xc0, 0x99, 0x82, 0x6c, 0x2e, 0x6e, 0xaa, 0x0f, 0x5d, 0x60, 0xdc,
    0xc0, 0x91, 0x8f, 0x8b, 0xdd, 0x6c, 0xd2, 0xc2, 0x2e, 0x7a, 0xb6, 0x97,
    0x0a, 0x9c, 0x3c, 0x98, 0xe2, 0xd1, 0x5f, 0x6e, 0x1c, 0xbd, 0xb5, 0xdc,
    0x59, 0x3e, 0xb8, 0x94, 0x22, 0x89, 0x80, 0x0f, 0x75, 0x87, 0x18, 0x58,
    0x14, 0xb8, 0xa0, 0x80, 0x04, 0x33, 0x31, 0x34, 0x96, 0xd8, 0x0c, 0xc6,
    0xfd, 0xd0, 0x2b, 0xee, 0x52, 0xbf, 0x1f, 0x77, 0xfd, 0x18, 0xba, 0x77,
    0xb4, 0xf7, 0xcc, 0xc6, 0x5d, 0x50, 0x10, 0x94, 0xd8, 0x99, 0xce, 0x8d,
    0x2c, 0xc0, 0xa1, 0xd1, 0x44, 0xde, 0x90, 0x77, 0x45, 0x6a, 0x52, 0xbe,
    0x02, 0x8d, 0x21, 0x98, 0x76, 0xc9, 0x78, 0x31, 0x84, 0x21, 0xc6, 0x7d,
    0xb5, 0xcd, 0x65, 0x1e, 0x33, 0xea, 0x26, 0xe1, 0x5c, 0x1b, 0x4d, 0x66,
    0xc7, 0x08, 0xc9, 0xd5, 0x83, 0x8a, 0x2e, 0x80, 0x1c, 0xb8, 0x4d, 0x5f,
    0xf0, 0x28, 0x10, 0x02, 0x08, 0xd4, 0xe9, 0x87, 0xff, 0x5e, 0xe6, 0x39,
    0x4a, 0x40, 0xe6, 0x96, 0x64, 0xe5, 0x99, 0xbd, 0x69, 0xd3, 0x9a, 0xc6,
    0x0f, 0xea, 0x99, 0x34, 0x16, 0x06, 0x8d, 0xc4, 0xe9, 0x1e, 0x30, 0x31,
    0xa3, 0x23, 0xf2, 0xf6, 0x34, 0x65, 0x28, 0xe4, 0x6e, 0xfc, 0x85, 0x27,
    0xa2, 0x59, 0xb0, 0x19, 0x32, 0x7b, 0x07, 0x7b, 0x71, 0xa8, 0xb2, 0x9d,
    0x49, 0x14, 0xcd, 0xe5, 0x4e, 0x58, 0x34, 0xa8, 0x33, 0x7d, 0x99, 0xb8,
    0x48, 0x54, 0x1a, 0xc0, 0xd4, 0xb1, 0xaa, 0x15, 0x00, 0xe8, 0x7e, 0x9e,
    0x02, 0xcc, 0xde, 0x93, 0xe8, 0x73, 0x92, 0xf3, 0x3d, 0x99, 0x04, 0x21,
    0xc2, 0xa9, 0xb8, 0x1c, 0xfd, 0x9a, 0xfd, 0x30, 0xb4, 0x85, 0x5b, 0xbb,
    0x48, 0x0a, 0x7d, 0xfe, 0xc9, 0x49, 0x72, 0xdd, 0xbe, 0x6c, 0x3a, 0x2b,
    0x64, 0xc5, 0x85, 0xa8, 0xb4, 0x7c, 0x3a, 0xcb, 0x5f, 0x59, 0x62, 0xd6,
    0x2b, 0x62, 0x2d, 0xdb, 0x77, 0x96, 0x29, 0x9b, 0x75, 0x21, 0x4a, 0xaa,
    0xff, 0x19, 0xe4, 0x95, 0x2b, 0x7f, 0xec, 0xcb, 0x49, 0xd9, 0xa0, 0x70,
    0xc8, 0x5f, 0x0a, 0x5f, 0x27, 0x05, 0xf2, 0xff, 0xaa, 0x94, 0x47, 0x75,
    0x22, 0xf0, 0xe9, 0x29, 0x05, 0x45, 0x08, 0xb8, 0x24, 0xa5, 0x89, 0x0a,
    0xd4, 0x94, 0xfc, 0xe8, 0x55, 0x67, 0x1f, 0x16, 0x0e, 0x0f, 0xdb, 0xdf,
    0xcf, 0x4a, 0xba, 0x8f, 0x57, 0x4a, 0xf2, 0xe7, 0x8c, 0xe1, 0xe9, 0x5c,
    0x4a, 0xae, 0x2e, 0x85, 0x47, 0x93, 0x57, 0x6f, 0xb1, 0xea, 0xad, 0xaa,
    0x38, 0x52, 0x81, 0xe0, 0x14, 0xed, 0x16, 0xc5, 0xd3, 0xef, 0x70, 0x28,
    0x7e, 0x64, 0x52, 0xe2, 0x4a, 0x84, 0xdb, 0x44, 0x77, 0x87, 0x4e, 0x39,
    0x89, 0x73, 0x96, 0x3f, 0x5a, 0xfa, 0xb3, 0xa2, 0x88, 0x3d, 0x66, 0x41,
    0xbf, 0xdb, 0xa9, 0xb0, 0xbf, 0xec, 0x6f, 0x86, 0x25, 0x7f, 0x58, 0xce,
    0xc9, 0xa0, 0x1c, 0x3d, 0xf0, 0x0e, 0x08, 0xa7, 0x6e, 0x85, 0x15, 0x7f,
    0x0f, 0x5c, 0x1d, 0xfd, 0xfa, 0x86, 0x02, 0x73, 0x75, 0x21, 0xe4, 0xb4,
    0x98, 0x57, 0x87, 0x16, 0xbf, 0xd4, 0xdf, 0xd3, 0x5e, 0x62, 0x3b, 0x52,
    0xc4, 0xd6, 0xee, 0xed, 0x07, 0x51, 0x3f, 0x31, 0x50, 0x04, 0xc6, 0x8b,
    0xea, 0xfa, 0x04, 0x10, 0x54, 0xa9, 0x1a, 0xf1, 0x5c, 0x5e, 0xb0, 0x3a,
    0xf3, 0xcc, 0x65, 0xb1, 0x01, 0x98, 0x8e, 0x96, 0x6d, 0x55, 0x5f, 0x5b,
    0xfb, 0x09, 0xfa, 0x1f, 0x4c, 0x03, 0x11, 0x6f, 0xb9, 0x69, 0xfd, 0x8c,
    0x7a, 0xf6, 0x16, 0x51, 0x9f, 0xc0, 0xdf, 0x42, 0x91, 0xc8, 0xd5, 0x7c,
    0x58, 0xd3, 0xac, 0xdc, 0x53, 0xb4, 0x38, 0xe9, 0xbc, 0x76, 0x1e, 0x9b,
    0xf8, 0x53, 0x5c, 0xd2, 0xea, 0x11, 0xa0, 0x7e, 0x24, 0x36, 0x12, 0xff,
    0xac, 0x4f, 0x9d, 0x2d, 0xdc, 0x2a, 0x2b, 0xf7, 0xb6, 0x79, 0x1a, 0xa3,
    0x59, 0x09, 0x34, 0x56, 0x04, 0x8f, 0xfe, 0x1b, 0x3d, 0xf9, 0x73, 0xd1,
    0xc7, 0x30, 0x3d, 0x97, 0xc5, 0x2f, 0x4b, 0x0b, 0x66, 0xad, 0x4b, 0x4a,
    0xcd, 0xc9, 0x2d, 0xaa, 0xdd, 0x3a, 0x9a, 0x22, 0x89, 0x4c, 0x8c, 0xc6,
    0x1e, 0xbd, 0xa4, 0xbd, 0x43, 0x0b, 0x52, 0xfb, 0xcd, 0x07, 0x04, 0x43,
    0x77, 0xf7, 0x11, 0x7a, 0x70, 0x4f, 0x4a, 0xae, 0xb3, 0x7b, 0x99, 0x7e,
    0x90, 0x17, 0x8b, 0xca, 0x77, 0xfc, 0x15, 0x4b, 0xda, 0xc1, 0x7c, 0x56};

static const unsigned char prime_weak_8192[] = {
    0x93, 0xdf, 0x6d, 0x37, 0xdc, 0x2a, 0xa4, 0xab, 0x5d, 0xdc, 0x73, 0x42,
    0x12, 0x18, 0x8f, 0x39, 0x47, 0x73, 0xf5, 0x3e, 0xbc, 0x6e, 0x0d, 0x2a,
    0x68, 0x5d, 0x53, 0x4f, 0x22, 0x8c, 0xa8, 0xa8, 0x4a, 0xac, 0x6a, 0x60,
    0x54, 0xca, 0x1a, 0x75, 0xda, 0x85, 0x02, 0x5e, 0x80, 0xbb, 0x9b, 0x5a,
    0x74, 0x96, 0x69, 0xc2, 0x7c, 0x84, 0x1f, 0x76, 0x0d, 0x53, 0xe4, 0x0b,
    0x32, 0xf3, 0x4b, 0xf6, 0x92, 0x5b, 0x2c, 0x98, 0x5d, 0xa9, 0x60, 0xdc,
    0x17, 0x5b, 0xfb, 0xb5, 0x0e, 0x38, 0xae, 0x63, 0x16, 0x79, 0xa4, 0xc5,
    0x76, 0x74, 0x20, 0x97, 0x5b, 0xdc, 0xa9, 0x88, 0xd1, 0x14, 0x46, 0x3e,
    0x1d, 0xe6, 0xca, 0xb5, 0x38, 0x57, 0xfd, 0xeb, 0x66, 0x2a, 0xfa, 0x8c,
    0x30, 0x07, 0xea, 0xb4, 0xbc, 0x79, 0x33, 0x14, 0xdf, 0x8f, 0x1d, 0x60,
    0x47, 0xc7, 0x23, 0xd9, 0x7f, 0xe3, 0x1c, 0x94, 0xa9, 0xbb, 0x2d, 0x1b,
    0x37, 0x64, 0x20, 0xcf, 0x68, 0x52, 0x39, 0xd9, 0x6f, 0x23, 0x50, 0xb2,
    0x67, 0xc8, 0x47, 0xaa, 0x39, 0x96, 0xd2, 0xfd, 0x9b, 0x9c, 0x86, 0x71,
    0xd8, 0x7c, 0x67, 0xb5, 0x7a, 0x9d, 0x4f, 0xf8, 0x8f, 0x34, 0x64, 0xcb,
    0xdb, 0x85, 0x11, 0x97, 0x86, 0xf7, 0xa1, 0x19, 0x2a, 0x10, 0x7a, 0xf2,
    0x15, 0x1b, 0x0c, 0x6e, 0x64, 0xf1, 0x18, 0x53, 0xf9, 0x9a, 0xdd, 0x7c,
    0x0d, 0x7c, 0x3d, 0x39, 0x9c, 0xa3, 0xc5, 0xf8, 0x68, 0x6f, 0xb4, 0x35,
    0xf8, 0x1d, 0xb8, 0xc8, 0xab, 0xea, 0x58, 0xf3, 0xbb, 0x78, 0xf3, 0xe2,
    0xa6, 0x16, 0xb3, 0x4a, 0x0a, 0x56, 0x5b, 0x44, 0xac, 0xcb, 0x66, 0x5d,
    0xa3, 0x62, 0x71, 0x91, 0x05, 0xd4, 0x97, 0x72, 0x33, 0x77, 0x43, 0x31,
    0x35, 0x9c, 0x43, 0xb8, 0xd5, 0x85, 0xdb, 0x8e, 0x28, 0xcb, 0x29, 0x98,
    0xb7, 0xfe, 0x6a, 0xf6, 0x08, 0x89, 0x82, 0xfc, 0xe6, 0x5d, 0x62, 0x68,
    0x55, 0xac, 0x3b, 0x9d, 0x82, 0xcd, 0x06, 0x10, 0x53, 0x93, 0x1d, 0x66,
    0x6a, 0xce, 0x63, 0x2c, 0x49, 0x36, 0xf3, 0x0d, 0x1c, 0x3f, 0x24, 0xd0,
    0x7f, 0xb2, 0xa0, 0xcf, 0x76, 0x2a, 0x16, 0xa2, 0x6f, 0x6b, 0xf4, 0xfe,
    0xb5, 0xca, 0x99, 0x44, 0x7c, 0xfc, 0x3b, 0xc1, 0xe4, 0x09, 0xf5, 0x7b,
    0x6d, 0x6c, 0xa1, 0x15, 0x10, 0x00, 0x4c, 0x75, 0x4d, 0x2a, 0x80, 0x95,
    0x90, 0x9a, 0x15, 0x5e, 0x77, 0x28, 0x8e, 0x83, 0x40, 0x85, 0x1f, 0x2d,
    0x70, 0x17, 0xa0, 0xb0, 0x7d, 0xe5, 0xfa, 0x81, 0x51, 0xbe, 0xb4, 0x16,
    0xf6, 0x54, 0x9f, 0x0e, 0xa3, 0xe2, 0x1e, 0x5e, 0x9b, 0x1c, 0xda, 0x0e,
    0x9f, 0x93, 0x5c, 0xf4, 0x43, 0xbd, 0x9c, 0x1e, 0x16, 0x67, 0xb5, 0x42,
    0x94, 0x70, 0xf8, 0x79, 0x0c, 0x2d, 0x48, 0xc1, 0x24, 0xc5, 0xc6, 0xa9,
    0x64, 0x0c, 0x44, 0xec, 0x99, 0xae, 0xb5, 0xe7, 0xc1, 0x24, 0x8a, 0x6c,
    0xd1, 0xa2, 0xbf, 0x4c, 0x6b, 0x0b, 0xe9, 0xf0, 0x98, 0x3d, 0xc7, 0x9c,
    0xe1, 0x8d, 0x1a, 0xde, 0xc4, 0x44, 0x43, 0xc6, 0xbf, 0x38, 0x62, 0x25,
    0x91, 0x42, 0x84, 0x01, 0x28, 0xcb, 0x80, 0xbc, 0x39, 0x4c, 0xc3, 0x3f,
    0xf6, 0xdf, 0xe1, 0xe6, 0xc9, 0x77, 0x35, 0x57, 0x2f, 0x89, 0x9d, 0xfa,
    0xaf, 0x37, 0xd6, 0x33, 0x71, 0x34, 0xff, 0x52, 0x28, 0xb3, 0x3c, 0x96,
    0x68, 0x10, 0x12, 0xc9, 0xbe, 0x18, 0x03, 0xcd, 0xef, 0x27, 0x0a, 0xd1,
    0xc9, 0x0e, 0x49, 0x01, 0x22, 0x73, 0xdb, 0x5f, 0x11, 0x75, 0x6d, 0xea,
    0x16, 0xda, 0x26, 0x7f, 0x3e, 0x7c, 0xcb, 0x62, 0xcf, 0xcc, 0x8d, 0xd6,
    0xea, 0xce, 0x26, 0x44, 0xa4, 0x74, 0x54, 0x4e, 0x2b, 0x15, 0xba, 0x9d,
    0xa1, 0x39, 0xe8, 0xfd, 0xe0, 0x29, 0xf0, 0xd7, 0xaa, 0x30, 0x6b, 0xd7,
    0x14, 0x3c, 0xa0, 0x04, 0xbc, 0xed, 0x82, 0xcb, 0xc9, 0xdb, 0x4f, 0x20,
    0x05, 0x6e, 0x45, 0x79, 0xdd, 0x5b, 0x3d, 0x5e, 0xee, 0xf1, 0xc3, 0xaa,
    0xb3, 0xd3, 0x3a, 0x47, 0xac, 0xe3, 0x12, 0xa1, 0xd5, 0xf4, 0x24, 0xe5,
    0x6c, 0xe4, 0x9f, 0xb4, 0xca, 0x96, 0x49, 0x51, 0x36, 0x3b, 0xa4, 0xa2,
    0xd6, 0x2e, 0x42, 0x23, 0x32, 0x8c, 0xc8, 0x83, 0xea, 0x14, 0xd1, 0x08,
    0x09, 0x8f, 0xdb, 0x4c, 0xc2, 0x00, 0x44, 0x06, 0x81, 0xd4, 0x11, 0x5d,
    0x2b, 0x1e, 0x37, 0x80, 0xaa, 0xb9, 0x88, 0xfa, 0xab, 0xd2, 0x76, 0x2e,
    0x03, 0xb8, 0x3b, 0x0b, 0xfc, 0x01, 0x96, 0xe3, 0x62, 0x00, 0x71, 0x13,
    0xe8, 0xfb, 0x78, 0xce, 0x39, 0x06, 0xa1, 0x44, 0xdd, 0x61, 0x6a, 0x56,
    0xb2, 0xcd, 0xcb, 0xec, 0x67, 0x24, 0x28, 0x7d, 0x39, 0x80, 0x37, 0xcb,
    0x95, 0x49, 0x96, 0xe9, 0x3f, 0xb7, 0x89, 0xeb, 0x11, 0x7c, 0x34, 0x49,
    0x36, 0x2c, 0xec, 0x82, 0xb6, 0x3c, 0xa9, 0x9a, 0xd3, 0xb8, 0xab, 0xb9,
    0x28, 0x2f, 0x97, 0x71, 0x04, 0xa8, 0x86, 0x2b, 0x43, 0xb6, 0x27, 0x51,
    0x8a, 0xe0, 0xa3, 0x98, 0xe7, 0x33, 0x32, 0xfe, 0x18, 0xb9, 0x38, 0x95,
    0x78, 0x17, 0xbe, 0x43, 0xa0, 0x08, 0x8b, 0x05, 0x8d, 0x56, 0xd7, 0x4e,
    0x61, 0x01, 0x00, 0x05, 0x12, 0x6d, 0x13, 0x95, 0xea, 0xce, 0xdc, 0xbf,
    0xc4, 0x74, 0x20, 0x89, 0x28, 0x05, 0xd2, 0x97, 0xc3, 0x35, 0x24, 0x6d,
    0x43, 0xdd, 0xe2, 0x9f, 0x15, 0x80, 0xee, 0xdd, 0xcd, 0x8a, 0x88, 0xc5,
    0x92, 0xda, 0x1d, 0xd9, 0xd0, 0xb8, 0xfd, 0x18, 0xcc, 0x58, 0x1b, 0xca,
    0x3b, 0xcc, 0x9e, 0xcd, 0x53, 0x61, 0x68, 0xf5, 0xbb, 0x2d, 0x02, 0x55,
    0x2b, 0x93, 0x9f, 0x18, 0x17, 0x20, 0xb1, 0x54, 0xe0, 0xfe, 0x3e, 0x6a,
    0x10, 0x7f, 0xee, 0x60, 0x7c, 0xcb, 0x14, 0x82, 0x68, 0xed, 0x08, 0x07,
    0xe7, 0x34, 0xad, 0x27, 0x6f, 0xda, 0x57, 0xe2, 0xa7, 0x4b, 0x7e, 0x7a,
    0x2e, 0x95, 0x88, 0x58, 0x3d, 0xe7, 0xdc, 0xa3, 0xf2, 0xe9, 0xf5, 0x95,
    0xfd, 0x1c, 0x5f, 0x9e, 0x5c, 0x0c, 0xe8, 0x36, 0xd5, 0x09, 0x35, 0x66,
    0x27, 0xb9, 0x13, 0x8a, 0x0e, 0xfa, 0xeb, 0xa6, 0x5b, 0xd6, 0x07, 0x4d,
    0xcf, 0x0d, 0x90, 0x71, 0xa1, 0xe5, 0x58, 0x1e, 0x27, 0x69, 0x64, 0x18,
    0x22, 0x07, 0x8a, 0x2a, 0xe9, 0x08, 0x00, 0x02, 0x8a, 0x58, 0x38, 0x81,
    0x05, 0xd8, 0xe7, 0x5d, 0x3d, 0xe8, 0x2b, 0x17, 0xfa, 0x29, 0x5c, 0xeb,
    0x93, 0x0c, 0x0f, 0x29, 0x68, 0x21, 0x93, 0x62, 0xf2, 0xe1, 0x44, 0x38,
    0x69, 0x21, 0x57, 0x86, 0x71, 0x6b, 0x3d, 0x12, 0x4e, 0x28, 0xdb, 0x0b,
    0xd4, 0x2c, 0xc5, 0xe8, 0x5f, 0x9b, 0xd2, 0x26, 0x08, 0x45, 0xa4, 0xb2,
    0xb1, 0x5e, 0xd1, 0x18, 0x3e, 0x62, 0x8d, 0x77, 0xa0, 0x62, 0x07, 0x75,
    0x0c, 0x68, 0x7f, 0xab, 0xd2, 0x2c, 0xec, 0x8e, 0xa9, 0x6e, 0x37, 0x3d,
    0xdb, 0x33, 0x7a, 0x4a, 0xba, 0x86, 0x25, 0x50, 0x6a, 0x37, 0x1b, 0x9b,
    0x91, 0x1a, 0x5f, 0x93, 0x21, 0xea, 0x91, 0xdc, 0x64, 0xb6, 0x07, 0x44,
    0x34, 0x79, 0x6a, 0x6a, 0x42, 0x4e, 0xf3, 0xe2, 0xa2, 0x6b, 0xff, 0xcd,
    0xd7, 0xc5, 0x69, 0xb9, 0x81, 0x7d, 0x34, 0xb4, 0x5b, 0xb6, 0x83, 0xc3,
    0x6b, 0x9a, 0xe1, 0x2e, 0x5e, 0x34, 0x01, 0x21, 0xeb, 0x37, 0xcc, 0xc5,
    0x5f, 0x7f, 0xa0, 0xde, 0x0f, 0x79, 0xb7, 0xc3, 0x3b, 0x84, 0x7d, 0xe8,
    0x96, 0xfd, 0x32, 0x47, 0x78, 0x3e, 0x22, 0xc8, 0x98, 0xce, 0x7a, 0xef,
    0x1d, 0xa6, 0x09, 0x3a, 0xff, 0xf7, 0x68, 0xd9, 0xb8, 0xe9, 0x7e, 0x8a,
    0xec, 0x23, 0x01, 0x97};

#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
static const unsigned char subprime_weak_8192[] = {
    0xe2, 0x48, 0x2e, 0xe9, 0x45, 0x85, 0xe1, 0x01, 0x91, 0x3b, 0xd1,
    0x15, 0x16, 0xb4, 0xf5, 0x5b, 0x2c, 0xb4, 0xae, 0x42, 0x61, 0x7a,
    0xd9, 0x26, 0x39, 0x12, 0xd2, 0x46, 0xb3, 0x46, 0x9b, 0x5f};
#endif

static const unsigned char base_weak_8192[] = {
    0x78, 0x4d, 0x5d, 0xa1, 0xce, 0x9d, 0x68, 0xae, 0x47, 0x31, 0x81, 0x08,
    0x8c, 0x24, 0x38, 0x6a, 0xc8, 0xc7, 0xf4, 0x1c, 0xa1, 0xcb, 0x5d, 0x65,
    0x04, 0x6e, 0x0d, 0xbe, 0x55, 0x1d, 0x25, 0xc2, 0xca, 0x74, 0x99, 0x66,
    0x67, 0x75, 0x00, 0xd6, 0x12, 0x90, 0x7f, 0x44, 0x56, 0x40, 0x98, 0x23,
    0x30, 0x87, 0x7b, 0x02, 0x86, 0xc1, 0xb3, 0x1b, 0x83, 0x82, 0xdb, 0x5b,
    0xa6, 0x72, 0x90, 0x77, 0xf9, 0x63, 0x9d, 0xb4, 0xe0, 0x83, 0x5e, 0x04,
    0x1d, 0x7b, 0x25, 0x68, 0x67, 0xa4, 0xb2, 0x4e, 0x5a, 0xde, 0x1f, 0x48,
    0x01, 0x10, 0xde, 0xde, 0xa9, 0xc3, 0x14, 0xc5, 0x9c, 0xda, 0xbe, 0xd9,
    0x19, 0x91, 0x43, 0x4a, 0xaa, 0x77, 0xcc, 0xbb, 0xe0, 0xe7, 0x71, 0xa9,
    0xa2, 0x73, 0x4f, 0xf6, 0x88, 0xe0, 0xc6, 0x5d, 0x1a, 0xc9, 0x80, 0x6b,
    0x47, 0x98, 0x76, 0xb4, 0x6c, 0xfe, 0xc8, 0xdf, 0x65, 0x42, 0x3d, 0x11,
    0x60, 0x09, 0x32, 0xb3, 0x35, 0xc4, 0x97, 0x4c, 0xae, 0xd3, 0x3a, 0x0c,
    0x2b, 0x44, 0xe6, 0x21, 0x01, 0xf3, 0xbf, 0x3d, 0xb7, 0x18, 0x31, 0x28,
    0x88, 0x9e, 0xad, 0x06, 0xc4, 0xb8, 0x0a, 0x26, 0x09, 0xff, 0xe7, 0xf4,
    0xab, 0xd9, 0x28, 0x94, 0x02, 0xe6, 0x58, 0x65, 0xf4, 0x47, 0x3f, 0x4c,
    0x9e, 0xd8, 0x68, 0xed, 0x65, 0x39, 0x5b, 0x04, 0x6a, 0x1d, 0x21, 0xba,
    0xef, 0xbd, 0xdc, 0x15, 0x69, 0xb2, 0x24, 0x6c, 0x23, 0x98, 0xdd, 0x22,
    0xa0, 0x90, 0x48, 0xc1, 0xcc, 0xc6, 0xb4, 0xc9, 0x19, 0x8c, 0x23, 0x89,
    0x0b, 0x3b, 0x66, 0x0f, 0xfb, 0x45, 0xe6, 0x05, 0x7d, 0x57, 0xd3, 0x58,
    0x6c, 0xe5, 0x36, 0xaa, 0x05, 0xcf, 0xa6, 0x2d, 0x5a, 0x40, 0x96, 0x12,
    0x1e, 0xea, 0x34, 0x11, 0x94, 0x76, 0x47, 0xc8, 0x87, 0x3d, 0xb9, 0xe8,
    0x83, 0x6b, 0xfe, 0x83, 0xc6, 0xa3, 0x38, 0xe1, 0x06, 0xc3, 0xb0, 0xeb,
    0x53, 0x07, 0x75, 0x20, 0x60, 0xc2, 0xee, 0x1e, 0x95, 0xb4, 0xc1, 0xc5,
    0xe0, 0x1b, 0x47, 0xbb, 0xf9, 0x48, 0x6a, 0x68, 0x09, 0xab, 0xd2, 0x6e,
    0x29, 0x74, 0xed, 0x61, 0x0e, 0x12, 0xe2, 0x89, 0x15, 0x4f, 0xe2, 0xa1,
    0x50, 0xbd, 0x81, 0x49, 0xf0, 0xc4, 0x17, 0xe5, 0xb3, 0x35, 0x0b, 0xfa,
    0x59, 0x9f, 0x18, 0x84, 0xba, 0x74, 0xf2, 0xb8, 0x8f, 0xdf, 0x7c, 0x3e,
    0x36, 0x67, 0x84, 0xb7, 0x85, 0x50, 0x51, 0x64, 0x2a, 0xca, 0x8f, 0x6b,
    0xc8, 0xd1, 0x88, 0x0f, 0x64, 0x9a, 0x4a, 0xbd, 0x9b, 0x5f, 0x11, 0xd0,
    0x80, 0xba, 0x5d, 0x2e, 0x63, 0xc1, 0xe3, 0x58, 0xc1, 0xf3, 0xe3, 0x88,
    0xa7, 0xe6, 0xb2, 0x3c, 0xdf, 0x9d, 0xfa, 0xed, 0x5c, 0x6f, 0x86, 0x3b,
    0x25, 0x0f, 0x0e, 0xff, 0x0b, 0x88, 0x1c, 0xe9, 0xeb, 0xe5, 0x75, 0xee,
    0x50, 0xdf, 0x7c, 0xb0, 0xf2, 0x09, 0x78, 0x47, 0x60, 0x76, 0x3b, 0x44,
    0x5a, 0x9d, 0xf2, 0x5c, 0x68, 0xf9, 0x03, 0x88, 0x6a, 0x9f, 0x6a, 0x73,
    0x85, 0xc9, 0xe7, 0x5e, 0xbf, 0xac, 0x9e, 0x7a, 0x13, 0x53, 0x40, 0x65,
    0x65, 0x41, 0x02, 0x38, 0x5e, 0x05, 0xac, 0xbc, 0xc5, 0xff, 0xc5, 0x35,
    0x6c, 0x2b, 0x76, 0xac, 0xc5, 0xcc, 0x1e, 0x28, 0x53, 0x88, 0xab, 0x58,
    0x36, 0x7a, 0x99, 0xeb, 0x68, 0x7a, 0xdc, 0xd5, 0xc5, 0xaf, 0x84, 0xad,
    0x43, 0x0b, 0x3f, 0x3c, 0xbf, 0x87, 0x33, 0x45, 0xc6, 0x62, 0xf3, 0xac,
    0xff, 0x58, 0x82, 0x86, 0x9a, 0x3d, 0x05, 0xa0, 0xd2, 0xbb, 0x6d, 0x19,
    0x09, 0x09, 0x01, 0xeb, 0x8f, 0xd6, 0xf8, 0x13, 0xf6, 0x2f, 0xce, 0x0c,
    0x01, 0xe1, 0xcd, 0x56, 0xad, 0xf7, 0xd6, 0xe3, 0xf3, 0xfe, 0x5b, 0x61,
    0x40, 0x3d, 0x6b, 0x9b, 0xca, 0x44, 0xda, 0xac, 0xf5, 0xc0, 0x9f, 0xb5,
    0x23, 0x77, 0x70, 0x72, 0x83, 0xf4, 0xb8, 0x15, 0x66, 0x59, 0xc6, 0x72,
    0xea, 0xba, 0xa7, 0x1f, 0xd8, 0x27, 0xd3, 0x52, 0xdf, 0xec, 0x7c, 0x1d,
    0x3e, 0x60, 0x98, 0xb1, 0x30, 0xb8, 0x00, 0x37, 0x1a, 0x2d, 0xe9, 0xdb,
    0x62, 0x7f, 0xa9, 0x37, 0x9d, 0xf9, 0x82, 0x10, 0x98, 0xed, 0xc5, 0xc7,
    0xc7, 0xe6, 0x6e, 0xe8, 0x0f, 0xa8, 0x7e, 0xac, 0x30, 0xf8, 0x75, 0x95,
    0xc8, 0x56, 0x3b, 0xbb, 0x6f, 0x69, 0x48, 0x84, 0xb5, 0x4e, 0x8d, 0x68,
    0xdf, 0x2a, 0x1d, 0xf5, 0xd6, 0xd8, 0x00, 0x6f, 0x29, 0xea, 0x66, 0xb1,
    0xcb, 0xf3, 0xdb, 0x5e, 0x55, 0x9f, 0x13, 0x67, 0x22, 0xc3, 0x02, 0x74,
    0xc8, 0x69, 0x6b, 0xe5, 0x23, 0x83, 0x27, 0x20, 0x91, 0xda, 0xb3, 0x4a,
    0xe4, 0x92, 0xc9, 0x25, 0x76, 0x16, 0xf9, 0xfc, 0x74, 0xec, 0x95, 0xd9,
    0x61, 0x5f, 0x03, 0xac, 0x94, 0x2f, 0x4d, 0x00, 0xce, 0x97, 0xb7, 0x18,
    0x60, 0x10, 0x44, 0x1a, 0x48, 0xb2, 0x86, 0x02, 0x18, 0xac, 0x68, 0x61,
    0x73, 0x5e, 0x13, 0xd1, 0xd4, 0x66, 0x71, 0x8b, 0x1d, 0xbc, 0x08, 0xa2,
    0x45, 0xac, 0xe2, 0x06, 0xea, 0xe7, 0xb2, 0x8a, 0x27, 0x25, 0xb8, 0xa2,
    0xaf, 0x03, 0xc0, 0x0d, 0x90, 0x34, 0x90, 0x60, 0x55, 0x5f, 0x71, 0x94,
    0x8d, 0xfa, 0x5d, 0x91, 0x96, 0x3e, 0x7a, 0x2a, 0x4f, 0x50, 0x3f, 0x48,
    0xc2, 0x31, 0xd2, 0xa9, 0x29, 0x8a, 0x0a, 0x41, 0x50, 0xf2, 0x7d, 0x9b,
    0x52, 0xc9, 0xdf, 0x69, 0xfb, 0x6a, 0x1e, 0xee, 0xf2, 0x44, 0x3e, 0xe5,
    0x48, 0xad, 0x24, 0x3b, 0xac, 0xad, 0x62, 0x4f, 0xc8, 0x30, 0x1d, 0x7e,
    0x42, 0x4b, 0x52, 0x53, 0xca, 0x16, 0x27, 0x37, 0x76, 0x8f, 0x95, 0x7c,
    0xd1, 0xcd, 0x39, 0xac, 0x30, 0xc0, 0x1d, 0x15, 0xe4, 0x80, 0xc2, 0x43,
    0x6d, 0x77, 0x5d, 0x27, 0x4a, 0xad, 0xf4, 0x64, 0x56, 0xfd, 0x0b, 0x3a,
    0xaf, 0xb7, 0x63, 0x03, 0x44, 0x86, 0x4d, 0x72, 0x03, 0xd9, 0x91, 0xb9,
    0x06, 0xc0, 0x3f, 0x7a, 0xd7, 0xb6, 0x17, 0xd5, 0xb3, 0x2a, 0x13, 0x93,
    0x9d, 0x45, 0xfa, 0x70, 0xe7, 0x3a, 0xcd, 0x5e, 0xad, 0x7c, 0x70, 0x96,
    0x84, 0x91, 0xfd, 0x1c, 0x2b, 0xa2, 0x68, 0x7c, 0xc4, 0x8f, 0xa0, 0x2f,
    0x02, 0x6e, 0x4f, 0xd5, 0xe9, 0xb8, 0xbf, 0x52, 0x85, 0xd3, 0xdd, 0xbb,
    0x43, 0x73, 0x58, 0xd9, 0xa4, 0xb0, 0x08, 0x25, 0x16, 0xe3, 0x13, 0xc9,
    0x98, 0x26, 0x79, 0x91, 0xf8, 0x67, 0x2f, 0x05, 0x10, 0x8f, 0x03, 0xe5,
    0x26, 0x5c, 0xcb, 0x99, 0x97, 0xb7, 0xc9, 0x19, 0x4d, 0x4c, 0x9f, 0xc6,
    0xcc, 0x24, 0xfb, 0xe2, 0x83, 0x59, 0xbb, 0x9f, 0x25, 0x14, 0xf0, 0x92,
    0x3a, 0xcc, 0xc7, 0xcf, 0x66, 0xea, 0x43, 0x48, 0x8a, 0x23, 0xcb, 0xec,
    0xf5, 0x60, 0x7e, 0x81, 0x72, 0x94, 0x44, 0xfd, 0x33, 0x38, 0xfc, 0xbd,
    0xcf, 0x91, 0xe7, 0x22, 0x19, 0x8f, 0x1e, 0x0a, 0x8c, 0x08, 0x8c, 0xf1,
    0x39, 0x7d, 0xd4, 0xf1, 0xb3, 0xa0, 0x9d, 0xae, 0x9e, 0x8e, 0x24, 0xd7,
    0x37, 0x39, 0x9b, 0x93, 0xd7, 0x89, 0x1c, 0x04, 0x1b, 0x3e, 0x84, 0x5d,
    0xc6, 0x75, 0x36, 0x64, 0x08, 0x06, 0x0d, 0xdd, 0x83, 0x8c, 0xf4, 0xc4,
    0xe1, 0x11, 0xe1, 0x14, 0x49, 0xb1, 0x32, 0xce, 0x6a, 0x6c, 0x39, 0x0d,
    0xf9, 0x35, 0x1b, 0x95, 0x4b, 0xe1, 0x65, 0x0c, 0xa6, 0xac, 0x69, 0x27,
    0x98, 0xfa, 0x34, 0xf1, 0x30, 0x35, 0xb6, 0xe4, 0xc4, 0x55, 0x2d, 0xa8,
    0x5c, 0xcb, 0x6c, 0xcd, 0x66, 0x65, 0xe2, 0x94, 0xb2, 0xb1, 0xf4, 0x52,
    0x75, 0xed, 0x32, 0x8c, 0x08, 0xa1, 0x86, 0x53, 0x01, 0x6f, 0x52, 0x78,
    0xda, 0x20, 0x6e, 0x6a};
/* Calculated subprimes to verify primes are safe primes */

/* q=(p-1)/2 for prime prime_ike_1536 */
static const unsigned char sub2_prime_ike_1536[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x11, 0xb9, 0x93, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_ike_2048 */
static const unsigned char sub2_prime_ike_2048[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x0c, 0x10, 0xbe, 0x19, 0x48, 0x2f, 0x23, 0x17, 0x1b, 0x67, 0x1d,
    0xf1, 0xcf, 0x3b, 0x96, 0x0c, 0x07, 0x43, 0x01, 0xcd, 0x93, 0xc1, 0xd1,
    0x76, 0x03, 0xd1, 0x47, 0xda, 0xe2, 0xae, 0xf8, 0x37, 0xa6, 0x29, 0x64,
    0xef, 0x15, 0xe5, 0xfb, 0x4a, 0xac, 0x0b, 0x8c, 0x1c, 0xca, 0xa4, 0xbe,
    0x75, 0x4a, 0xb5, 0x72, 0x8a, 0xe9, 0x13, 0x0c, 0x4c, 0x7d, 0x02, 0x88,
    0x0a, 0xb9, 0x47, 0x2d, 0x45, 0x56, 0x55, 0x34, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_tls_2048 */
static const unsigned char sub2_prime_tls_2048[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xfc, 0x2a, 0x2c,
    0x51, 0x5d, 0xa5, 0x4d, 0x57, 0xee, 0x2b, 0x10, 0x13, 0x9e, 0x9e, 0x78,
    0xec, 0x5c, 0xe2, 0xc1, 0xe7, 0x16, 0x9b, 0x4a, 0xd4, 0xf0, 0x9b, 0x20,
    0x8a, 0x32, 0x19, 0xfd, 0xe6, 0x49, 0xce, 0xe7, 0x12, 0x4d, 0x9f, 0x7c,
    0xbe, 0x97, 0xf1, 0xb1, 0xb1, 0x86, 0x3a, 0xec, 0x7b, 0x40, 0xd9, 0x01,
    0x57, 0x62, 0x30, 0xbd, 0x69, 0xef, 0x8f, 0x6a, 0xea, 0xfe, 0xb2, 0xb0,
    0x92, 0x19, 0xfa, 0x8f, 0xaf, 0x83, 0x37, 0x68, 0x42, 0xb1, 0xb2, 0xaa,
    0x9e, 0xf6, 0x8d, 0x79, 0xda, 0xab, 0x89, 0xaf, 0x3f, 0xab, 0xe4, 0x9a,
    0xcc, 0x27, 0x86, 0x38, 0x70, 0x73, 0x45, 0xbb, 0xf1, 0x53, 0x44, 0xed,
    0x79, 0xf7, 0xf4, 0x39, 0x0e, 0xf8, 0xac, 0x50, 0x9b, 0x56, 0xf3, 0x9a,
    0x98, 0x56, 0x65, 0x27, 0xa4, 0x1d, 0x3c, 0xbd, 0x5e, 0x05, 0x58, 0xc1,
    0x59, 0x92, 0x7d, 0xb0, 0xe8, 0x84, 0x54, 0xa5, 0xd9, 0x64, 0x71, 0xfd,
    0xdc, 0xb5, 0x6d, 0x5b, 0xb0, 0x6b, 0xfa, 0x34, 0x0e, 0xa7, 0xa1, 0x51,
    0xef, 0x1c, 0xa6, 0xfa, 0x57, 0x2b, 0x76, 0xf3, 0xb1, 0xb9, 0x5d, 0x8c,
    0x85, 0x83, 0xd3, 0xe4, 0x77, 0x05, 0x36, 0xb8, 0x4f, 0x01, 0x7e, 0x70,
    0xe6, 0xfb, 0xf1, 0x76, 0x60, 0x1a, 0x02, 0x66, 0x94, 0x1a, 0x17, 0xb0,
    0xc8, 0xb9, 0x7f, 0x4e, 0x74, 0xc2, 0xc1, 0xff, 0xc7, 0x27, 0x89, 0x19,
    0x77, 0x79, 0x40, 0xc1, 0xe1, 0xff, 0x1d, 0x8d, 0xa6, 0x37, 0xd6, 0xb9,
    0x9d, 0xda, 0xfe, 0x5e, 0x17, 0x61, 0x10, 0x02, 0xe2, 0xc7, 0x78, 0xc1,
    0xbe, 0x8b, 0x41, 0xd9, 0x63, 0x79, 0xa5, 0x13, 0x60, 0xd9, 0x77, 0xfd,
    0x44, 0x35, 0xa1, 0x1c, 0x30, 0x94, 0x2e, 0x4b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_ike_3072 */
static const unsigned char sub2_prime_ike_3072[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x0c, 0x10, 0xbe, 0x19, 0x48, 0x2f, 0x23, 0x17, 0x1b, 0x67, 0x1d,
    0xf1, 0xcf, 0x3b, 0x96, 0x0c, 0x07, 0x43, 0x01, 0xcd, 0x93, 0xc1, 0xd1,
    0x76, 0x03, 0xd1, 0x47, 0xda, 0xe2, 0xae, 0xf8, 0x37, 0xa6, 0x29, 0x64,
    0xef, 0x15, 0xe5, 0xfb, 0x4a, 0xac, 0x0b, 0x8c, 0x1c, 0xca, 0xa4, 0xbe,
    0x75, 0x4a, 0xb5, 0x72, 0x8a, 0xe9, 0x13, 0x0c, 0x4c, 0x7d, 0x02, 0x88,
    0x0a, 0xb9, 0x47, 0x2d, 0x45, 0x55, 0x62, 0x16, 0xd6, 0x99, 0x8b, 0x86,
    0x82, 0x28, 0x3d, 0x19, 0xd4, 0x2a, 0x90, 0xd5, 0xef, 0x8e, 0x5d, 0x32,
    0x76, 0x7d, 0xc2, 0x82, 0x2c, 0x6d, 0xf7, 0x85, 0x45, 0x75, 0x38, 0xab,
    0xae, 0x83, 0x06, 0x3e, 0xd9, 0xcb, 0x87, 0xc2, 0xd3, 0x70, 0xf2, 0x63,
    0xd5, 0xfa, 0xd7, 0x46, 0x6d, 0x84, 0x99, 0xeb, 0x8f, 0x46, 0x4a, 0x70,
    0x25, 0x12, 0xb0, 0xce, 0xe7, 0x71, 0xe9, 0x13, 0x0d, 0x69, 0x77, 0x35,
    0xf8, 0x97, 0xfd, 0x03, 0x6c, 0xc5, 0x04, 0x32, 0x6c, 0x3b, 0x01, 0x39,
    0x9f, 0x64, 0x35, 0x32, 0x29, 0x0f, 0x95, 0x8c, 0x0b, 0xbd, 0x90, 0x06,
    0x5d, 0xf0, 0x8b, 0xab, 0xbd, 0x30, 0xae, 0xb6, 0x3b, 0x84, 0xc4, 0x60,
    0x5d, 0x6c, 0xa3, 0x71, 0x04, 0x71, 0x27, 0xd0, 0x3a, 0x72, 0xd5, 0x98,
    0xa1, 0xed, 0xad, 0xfe, 0x70, 0x7e, 0x88, 0x47, 0x25, 0xc1, 0x68, 0x90,
    0x54, 0x9d, 0x69, 0x65, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_tls_3072 */
static const unsigned char sub2_prime_tls_3072[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xfc, 0x2a, 0x2c,
    0x51, 0x5d, 0xa5, 0x4d, 0x57, 0xee, 0x2b, 0x10, 0x13, 0x9e, 0x9e, 0x78,
    0xec, 0x5c, 0xe2, 0xc1, 0xe7, 0x16, 0x9b, 0x4a, 0xd4, 0xf0, 0x9b, 0x20,
    0x8a, 0x32, 0x19, 0xfd, 0xe6, 0x49, 0xce, 0xe7, 0x12, 0x4d, 0x9f, 0x7c,
    0xbe, 0x97, 0xf1, 0xb1, 0xb1, 0x86, 0x3a, 0xec, 0x7b, 0x40, 0xd9, 0x01,
    0x57, 0x62, 0x30, 0xbd, 0x69, 0xef, 0x8f, 0x6a, 0xea, 0xfe, 0xb2, 0xb0,
    0x92, 0x19, 0xfa, 0x8f, 0xaf, 0x83, 0x37, 0x68, 0x42, 0xb1, 0xb2, 0xaa,
    0x9e, 0xf6, 0x8d, 0x79, 0xda, 0xab, 0x89, 0xaf, 0x3f, 0xab, 0xe4, 0x9a,
    0xcc, 0x27, 0x86, 0x38, 0x70, 0x73, 0x45, 0xbb, 0xf1, 0x53, 0x44, 0xed,
    0x79, 0xf7, 0xf4, 0x39, 0x0e, 0xf8, 0xac, 0x50, 0x9b, 0x56, 0xf3, 0x9a,
    0x98, 0x56, 0x65, 0x27, 0xa4, 0x1d, 0x3c, 0xbd, 0x5e, 0x05, 0x58, 0xc1,
    0x59, 0x92, 0x7d, 0xb0, 0xe8, 0x84, 0x54, 0xa5, 0xd9, 0x64, 0x71, 0xfd,
    0xdc, 0xb5, 0x6d, 0x5b, 0xb0, 0x6b, 0xfa, 0x34, 0x0e, 0xa7, 0xa1, 0x51,
    0xef, 0x1c, 0xa6, 0xfa, 0x57, 0x2b, 0x76, 0xf3, 0xb1, 0xb9, 0x5d, 0x8c,
    0x85, 0x83, 0xd3, 0xe4, 0x77, 0x05, 0x36, 0xb8, 0x4f, 0x01, 0x7e, 0x70,
    0xe6, 0xfb, 0xf1, 0x76, 0x60, 0x1a, 0x02, 0x66, 0x94, 0x1a, 0x17, 0xb0,
    0xc8, 0xb9, 0x7f, 0x4e, 0x74, 0xc2, 0xc1, 0xff, 0xc7, 0x27, 0x89, 0x19,
    0x77, 0x79, 0x40, 0xc1, 0xe1, 0xff, 0x1d, 0x8d, 0xa6, 0x37, 0xd6, 0xb9,
    0x9d, 0xda, 0xfe, 0x5e, 0x17, 0x61, 0x10, 0x02, 0xe2, 0xc7, 0x78, 0xc1,
    0xbe, 0x8b, 0x41, 0xd9, 0x63, 0x79, 0xa5, 0x13, 0x60, 0xd9, 0x77, 0xfd,
    0x44, 0x35, 0xa1, 0x1c, 0x30, 0x8f, 0xe7, 0xee, 0x6f, 0x1a, 0xad, 0x9d,
    0xb2, 0x8c, 0x81, 0xad, 0xde, 0x1a, 0x7a, 0x6f, 0x7c, 0xce, 0x01, 0x1c,
    0x30, 0xda, 0x37, 0xe4, 0xeb, 0x73, 0x64, 0x83, 0xbd, 0x6c, 0x8e, 0x93,
    0x48, 0xfb, 0xfb, 0xf7, 0x2c, 0xc6, 0x58, 0x7d, 0x60, 0xc3, 0x6c, 0x8e,
    0x57, 0x7f, 0x09, 0x84, 0xc2, 0x89, 0xc9, 0x38, 0x5a, 0x09, 0x86, 0x49,
    0xde, 0x21, 0xbc, 0xa2, 0x7a, 0x7e, 0xa2, 0x29, 0x71, 0x6b, 0xa6, 0xe9,
    0xb2, 0x79, 0x71, 0x0f, 0x38, 0xfa, 0xa5, 0xff, 0xae, 0x57, 0x41, 0x55,
    0xce, 0x4e, 0xfb, 0x4f, 0x74, 0x36, 0x95, 0xe2, 0x91, 0x1b, 0x1d, 0x06,
    0xd5, 0xe2, 0x90, 0xcb, 0xcd, 0x86, 0xf5, 0x6d, 0x0e, 0xdf, 0xcd, 0x21,
    0x6a, 0xe2, 0x24, 0x27, 0x05, 0x5e, 0x68, 0x35, 0xfd, 0x29, 0xee, 0xf7,
    0x9e, 0x0d, 0x90, 0x77, 0x1f, 0xea, 0xce, 0xbe, 0x12, 0xf2, 0x0e, 0x95,
    0xb3, 0x63, 0x17, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_ike_4096 */
static const unsigned char sub2_prime_ike_4096[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x0c, 0x10, 0xbe, 0x19, 0x48, 0x2f, 0x23, 0x17, 0x1b, 0x67, 0x1d,
    0xf1, 0xcf, 0x3b, 0x96, 0x0c, 0x07, 0x43, 0x01, 0xcd, 0x93, 0xc1, 0xd1,
    0x76, 0x03, 0xd1, 0x47, 0xda, 0xe2, 0xae, 0xf8, 0x37, 0xa6, 0x29, 0x64,
    0xef, 0x15, 0xe5, 0xfb, 0x4a, 0xac, 0x0b, 0x8c, 0x1c, 0xca, 0xa4, 0xbe,
    0x75, 0x4a, 0xb5, 0x72, 0x8a, 0xe9, 0x13, 0x0c, 0x4c, 0x7d, 0x02, 0x88,
    0x0a, 0xb9, 0x47, 0x2d, 0x45, 0x55, 0x62, 0x16, 0xd6, 0x99, 0x8b, 0x86,
    0x82, 0x28, 0x3d, 0x19, 0xd4, 0x2a, 0x90, 0xd5, 0xef, 0x8e, 0x5d, 0x32,
    0x76, 0x7d, 0xc2, 0x82, 0x2c, 0x6d, 0xf7, 0x85, 0x45, 0x75, 0x38, 0xab,
    0xae, 0x83, 0x06, 0x3e, 0xd9, 0xcb, 0x87, 0xc2, 0xd3, 0x70, 0xf2, 0x63,
    0xd5, 0xfa, 0xd7, 0x46, 0x6d, 0x84, 0x99, 0xeb, 0x8f, 0x46, 0x4a, 0x70,
    0x25, 0x12, 0xb0, 0xce, 0xe7, 0x71, 0xe9, 0x13, 0x0d, 0x69, 0x77, 0x35,
    0xf8, 0x97, 0xfd, 0x03, 0x6c, 0xc5, 0x04, 0x32, 0x6c, 0x3b, 0x01, 0x39,
    0x9f, 0x64, 0x35, 0x32, 0x29, 0x0f, 0x95, 0x8c, 0x0b, 0xbd, 0x90, 0x06,
    0x5d, 0xf0, 0x8b, 0xab, 0xbd, 0x30, 0xae, 0xb6, 0x3b, 0x84, 0xc4, 0x60,
    0x5d, 0x6c, 0xa3, 0x71, 0x04, 0x71, 0x27, 0xd0, 0x3a, 0x72, 0xd5, 0x98,
    0xa1, 0xed, 0xad, 0xfe, 0x70, 0x7e, 0x88, 0x47, 0x25, 0xc1, 0x68, 0x90,
    0x54, 0x90, 0x84, 0x00, 0x8d, 0x39, 0x1e, 0x09, 0x53, 0xc3, 0xf3, 0x6b,
    0xc4, 0x38, 0xcd, 0x08, 0x5e, 0xdd, 0x2d, 0x93, 0x4c, 0xe1, 0x93, 0x8c,
    0x35, 0x7a, 0x71, 0x1e, 0x0d, 0x4a, 0x34, 0x1a, 0x5b, 0x0a, 0x85, 0xed,
    0x12, 0xc1, 0xf4, 0xe5, 0x15, 0x6a, 0x26, 0x74, 0x6d, 0xdd, 0xe1, 0x6d,
    0x82, 0x6f, 0x47, 0x7c, 0x97, 0x47, 0x7e, 0x0a, 0x0f, 0xdf, 0x65, 0x53,
    0x14, 0x3e, 0x2c, 0xa3, 0xa7, 0x35, 0xe0, 0x2e, 0xcc, 0xd9, 0x4b, 0x27,
    0xd0, 0x48, 0x61, 0xd1, 0x11, 0x9d, 0xd0, 0xc3, 0x28, 0xad, 0xf3, 0xf6,
    0x8f, 0xb0, 0x94, 0xb8, 0x67, 0x71, 0x6b, 0xd7, 0xdc, 0x0d, 0xee, 0xbb,
    0x10, 0xb8, 0x24, 0x0e, 0x68, 0x03, 0x48, 0x93, 0xea, 0xd8, 0x2d, 0x54,
    0xc9, 0xda, 0x75, 0x4c, 0x46, 0xc7, 0xee, 0xe0, 0xc3, 0x7f, 0xdb, 0xee,
    0x48, 0x53, 0x60, 0x47, 0xa6, 0xfa, 0x1a, 0xe4, 0x9a, 0x03, 0x18, 0xcc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_tls_4096 */
static const unsigned char sub2_prime_tls_4096[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xfc, 0x2a, 0x2c,
    0x51, 0x5d, 0xa5, 0x4d, 0x57, 0xee, 0x2b, 0x10, 0x13, 0x9e, 0x9e, 0x78,
    0xec, 0x5c, 0xe2, 0xc1, 0xe7, 0x16, 0x9b, 0x4a, 0xd4, 0xf0, 0x9b, 0x20,
    0x8a, 0x32, 0x19, 0xfd, 0xe6, 0x49, 0xce, 0xe7, 0x12, 0x4d, 0x9f, 0x7c,
    0xbe, 0x97, 0xf1, 0xb1, 0xb1, 0x86, 0x3a, 0xec, 0x7b, 0x40, 0xd9, 0x01,
    0x57, 0x62, 0x30, 0xbd, 0x69, 0xef, 0x8f, 0x6a, 0xea, 0xfe, 0xb2, 0xb0,
    0x92, 0x19, 0xfa, 0x8f, 0xaf, 0x83, 0x37, 0x68, 0x42, 0xb1, 0xb2, 0xaa,
    0x9e, 0xf6, 0x8d, 0x79, 0xda, 0xab, 0x89, 0xaf, 0x3f, 0xab, 0xe4, 0x9a,
    0xcc, 0x27, 0x86, 0x38, 0x70, 0x73, 0x45, 0xbb, 0xf1, 0x53, 0x44, 0xed,
    0x79, 0xf7, 0xf4, 0x39, 0x0e, 0xf8, 0xac, 0x50, 0x9b, 0x56, 0xf3, 0x9a,
    0x98, 0x56, 0x65, 0x27, 0xa4, 0x1d, 0x3c, 0xbd, 0x5e, 0x05, 0x58, 0xc1,
    0x59, 0x92, 0x7d, 0xb0, 0xe8, 0x84, 0x54, 0xa5, 0xd9, 0x64, 0x71, 0xfd,
    0xdc, 0xb5, 0x6d, 0x5b, 0xb0, 0x6b, 0xfa, 0x34, 0x0e, 0xa7, 0xa1, 0x51,
    0xef, 0x1c, 0xa6, 0xfa, 0x57, 0x2b, 0x76, 0xf3, 0xb1, 0xb9, 0x5d, 0x8c,
    0x85, 0x83, 0xd3, 0xe4, 0x77, 0x05, 0x36, 0xb8, 0x4f, 0x01, 0x7e, 0x70,
    0xe6, 0xfb, 0xf1, 0x76, 0x60, 0x1a, 0x02, 0x66, 0x94, 0x1a, 0x17, 0xb0,
    0xc8, 0xb9, 0x7f, 0x4e, 0x74, 0xc2, 0xc1, 0xff, 0xc7, 0x27, 0x89, 0x19,
    0x77, 0x79, 0x40, 0xc1, 0xe1, 0xff, 0x1d, 0x8d, 0xa6, 0x37, 0xd6, 0xb9,
    0x9d, 0xda, 0xfe, 0x5e, 0x17, 0x61, 0x10, 0x02, 0xe2, 0xc7, 0x78, 0xc1,
    0xbe, 0x8b, 0x41, 0xd9, 0x63, 0x79, 0xa5, 0x13, 0x60, 0xd9, 0x77, 0xfd,
    0x44, 0x35, 0xa1, 0x1c, 0x30, 0x8f, 0xe7, 0xee, 0x6f, 0x1a, 0xad, 0x9d,
    0xb2, 0x8c, 0x81, 0xad, 0xde, 0x1a, 0x7a, 0x6f, 0x7c, 0xce, 0x01, 0x1c,
    0x30, 0xda, 0x37, 0xe4, 0xeb, 0x73, 0x64, 0x83, 0xbd, 0x6c, 0x8e, 0x93,
    0x48, 0xfb, 0xfb, 0xf7, 0x2c, 0xc6, 0x58, 0x7d, 0x60, 0xc3, 0x6c, 0x8e,
    0x57, 0x7f, 0x09, 0x84, 0xc2, 0x89, 0xc9, 0x38, 0x5a, 0x09, 0x86, 0x49,
    0xde, 0x21, 0xbc, 0xa2, 0x7a, 0x7e, 0xa2, 0x29, 0x71, 0x6b, 0xa6, 0xe9,
    0xb2, 0x79, 0x71, 0x0f, 0x38, 0xfa, 0xa5, 0xff, 0xae, 0x57, 0x41, 0x55,
    0xce, 0x4e, 0xfb, 0x4f, 0x74, 0x36, 0x95, 0xe2, 0x91, 0x1b, 0x1d, 0x06,
    0xd5, 0xe2, 0x90, 0xcb, 0xcd, 0x86, 0xf5, 0x6d, 0x0e, 0xdf, 0xcd, 0x21,
    0x6a, 0xe2, 0x24, 0x27, 0x05, 0x5e, 0x68, 0x35, 0xfd, 0x29, 0xee, 0xf7,
    0x9e, 0x0d, 0x90, 0x77, 0x1f, 0xea, 0xce, 0xbe, 0x12, 0xf2, 0x0e, 0x95,
    0xb3, 0x4f, 0x0f, 0x78, 0xb7, 0x37, 0xa9, 0x61, 0x8b, 0x26, 0xfa, 0x7d,
    0xbc, 0x98, 0x74, 0xf2, 0x72, 0xc4, 0x2b, 0xdb, 0x56, 0x3e, 0xaf, 0xa1,
    0x6b, 0x4f, 0xb6, 0x8c, 0x3b, 0xb1, 0xe7, 0x8e, 0xaa, 0x81, 0xa0, 0x02,
    0x43, 0xfa, 0xad, 0xd2, 0xbf, 0x18, 0xe6, 0x3d, 0x38, 0x9a, 0xe4, 0x43,
    0x77, 0xda, 0x18, 0xc5, 0x76, 0xb5, 0x0f, 0x00, 0x96, 0xcf, 0x34, 0x19,
    0x54, 0x83, 0xb0, 0x05, 0x48, 0xc0, 0x98, 0x62, 0x36, 0xe3, 0xbc, 0x7c,
    0xb8, 0xd6, 0x80, 0x1c, 0x04, 0x94, 0xcc, 0xd1, 0x99, 0xe5, 0xc5, 0xbd,
    0x0d, 0x0e, 0xdc, 0x9e, 0xb8, 0xa0, 0x00, 0x1e, 0x15, 0x27, 0x67, 0x54,
    0xfc, 0xc6, 0x85, 0x66, 0x05, 0x41, 0x48, 0xe6, 0xe7, 0x64, 0xbe, 0xe7,
    0xc7, 0x64, 0xda, 0xad, 0x3f, 0xc4, 0x52, 0x35, 0xa6, 0xda, 0xd4, 0x28,
    0xfa, 0x20, 0xc1, 0x70, 0xe3, 0x45, 0x00, 0x3f, 0x2f, 0x32, 0xaf, 0xb5,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_ike_6144 */
static const unsigned char sub2_prime_ike_6144[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x0c, 0x10, 0xbe, 0x19, 0x48, 0x2f, 0x23, 0x17, 0x1b, 0x67, 0x1d,
    0xf1, 0xcf, 0x3b, 0x96, 0x0c, 0x07, 0x43, 0x01, 0xcd, 0x93, 0xc1, 0xd1,
    0x76, 0x03, 0xd1, 0x47, 0xda, 0xe2, 0xae, 0xf8, 0x37, 0xa6, 0x29, 0x64,
    0xef, 0x15, 0xe5, 0xfb, 0x4a, 0xac, 0x0b, 0x8c, 0x1c, 0xca, 0xa4, 0xbe,
    0x75, 0x4a, 0xb5, 0x72, 0x8a, 0xe9, 0x13, 0x0c, 0x4c, 0x7d, 0x02, 0x88,
    0x0a, 0xb9, 0x47, 0x2d, 0x45, 0x55, 0x62, 0x16, 0xd6, 0x99, 0x8b, 0x86,
    0x82, 0x28, 0x3d, 0x19, 0xd4, 0x2a, 0x90, 0xd5, 0xef, 0x8e, 0x5d, 0x32,
    0x76, 0x7d, 0xc2, 0x82, 0x2c, 0x6d, 0xf7, 0x85, 0x45, 0x75, 0x38, 0xab,
    0xae, 0x83, 0x06, 0x3e, 0xd9, 0xcb, 0x87, 0xc2, 0xd3, 0x70, 0xf2, 0x63,
    0xd5, 0xfa, 0xd7, 0x46, 0x6d, 0x84, 0x99, 0xeb, 0x8f, 0x46, 0x4a, 0x70,
    0x25, 0x12, 0xb0, 0xce, 0xe7, 0x71, 0xe9, 0x13, 0x0d, 0x69, 0x77, 0x35,
    0xf8, 0x97, 0xfd, 0x03, 0x6c, 0xc5, 0x04, 0x32, 0x6c, 0x3b, 0x01, 0x39,
    0x9f, 0x64, 0x35, 0x32, 0x29, 0x0f, 0x95, 0x8c, 0x0b, 0xbd, 0x90, 0x06,
    0x5d, 0xf0, 0x8b, 0xab, 0xbd, 0x30, 0xae, 0xb6, 0x3b, 0x84, 0xc4, 0x60,
    0x5d, 0x6c, 0xa3, 0x71, 0x04, 0x71, 0x27, 0xd0, 0x3a, 0x72, 0xd5, 0x98,
    0xa1, 0xed, 0xad, 0xfe, 0x70, 0x7e, 0x88, 0x47, 0x25, 0xc1, 0x68, 0x90,
    0x54, 0x90, 0x84, 0x00, 0x8d, 0x39, 0x1e, 0x09, 0x53, 0xc3, 0xf3, 0x6b,
    0xc4, 0x38, 0xcd, 0x08, 0x5e, 0xdd, 0x2d, 0x93, 0x4c, 0xe1, 0x93, 0x8c,
    0x35, 0x7a, 0x71, 0x1e, 0x0d, 0x4a, 0x34, 0x1a, 0x5b, 0x0a, 0x85, 0xed,
    0x12, 0xc1, 0xf4, 0xe5, 0x15, 0x6a, 0x26, 0x74, 0x6d, 0xdd, 0xe1, 0x6d,
    0x82, 0x6f, 0x47, 0x7c, 0x97, 0x47, 0x7e, 0x0a, 0x0f, 0xdf, 0x65, 0x53,
    0x14, 0x3e, 0x2c, 0xa3, 0xa7, 0x35, 0xe0, 0x2e, 0xcc, 0xd9, 0x4b, 0x27,
    0xd0, 0x48, 0x61, 0xd1, 0x11, 0x9d, 0xd0, 0xc3, 0x28, 0xad, 0xf3, 0xf6,
    0x8f, 0xb0, 0x94, 0xb8, 0x67, 0x71, 0x6b, 0xd7, 0xdc, 0x0d, 0xee, 0xbb,
    0x10, 0xb8, 0x24, 0x0e, 0x68, 0x03, 0x48, 0x93, 0xea, 0xd8, 0x2d, 0x54,
    0xc9, 0xda, 0x75, 0x4c, 0x46, 0xc7, 0xee, 0xe0, 0xc3, 0x7f, 0xdb, 0xee,
    0x48, 0x53, 0x60, 0x47, 0xa6, 0xfa, 0x1a, 0xe4, 0x9a, 0x01, 0x42, 0x49,
    0x1b, 0x61, 0xfd, 0x5a, 0x69, 0x3e, 0x38, 0x13, 0x60, 0xea, 0x6e, 0x59,
    0x30, 0x13, 0x23, 0x6f, 0x64, 0xba, 0x8f, 0x3b, 0x1e, 0xdd, 0x1b, 0xde,
    0xfc, 0x7f, 0xca, 0x03, 0x56, 0xcf, 0x29, 0x87, 0x72, 0xed, 0x9c, 0x17,
    0xa0, 0x98, 0x00, 0xd7, 0x58, 0x35, 0x29, 0xf6, 0xc8, 0x13, 0xec, 0x18,
    0x8b, 0xcb, 0x93, 0xd8, 0x43, 0x2d, 0x44, 0x8c, 0x6d, 0x1f, 0x6d, 0xf5,
    0xe7, 0xcd, 0x8a, 0x76, 0xa2, 0x67, 0x36, 0x5d, 0x67, 0x6a, 0x5d, 0x8d,
    0xed, 0xbf, 0x8a, 0x23, 0xf3, 0x66, 0x12, 0xa5, 0x99, 0x90, 0x28, 0xa8,
    0x95, 0xeb, 0xd7, 0xa1, 0x37, 0xdc, 0x7a, 0x00, 0x9b, 0xc6, 0x69, 0x5f,
    0xac, 0xc1, 0xe5, 0x00, 0xe3, 0x25, 0xc9, 0x76, 0x78, 0x19, 0x75, 0x0a,
    0xe8, 0xb9, 0x0e, 0x81, 0xfa, 0x41, 0x6b, 0xe7, 0x37, 0x3a, 0x7f, 0x7b,
    0x6a, 0xaf, 0x38, 0x17, 0xa3, 0x4c, 0x06, 0x41, 0x5a, 0xd4, 0x20, 0x18,
    0xc8, 0x05, 0x8e, 0x4f, 0x2c, 0xf3, 0xe4, 0xbf, 0xdf, 0x63, 0xf4, 0x79,
    0x91, 0xd4, 0xbd, 0x3f, 0x1b, 0x66, 0x44, 0x5f, 0x07, 0x8e, 0xa2, 0xdb,
    0xff, 0xac, 0x2d, 0x62, 0xa5, 0xea, 0x03, 0xd9, 0x15, 0xa0, 0xaa, 0x55,
    0x66, 0x47, 0xb6, 0xbf, 0x5f, 0xa4, 0x70, 0xec, 0x0a, 0x66, 0x2f, 0x69,
    0x07, 0xc0, 0x1b, 0xf0, 0x53, 0xcb, 0x8a, 0xf7, 0x79, 0x4d, 0xf1, 0x94,
    0x03, 0x50, 0xea, 0xc5, 0xdb, 0xe2, 0xed, 0x3b, 0x7a, 0xa8, 0x55, 0x1e,
    0xc5, 0x0f, 0xdf, 0xf8, 0x75, 0x8c, 0xe6, 0x58, 0xd1, 0x89, 0xea, 0xae,
    0x6d, 0x2b, 0x64, 0xf6, 0x17, 0x79, 0x4b, 0x19, 0x1c, 0x3f, 0xf4, 0x6b,
    0xb7, 0x1e, 0x02, 0x34, 0x02, 0x1f, 0x47, 0xb3, 0x1f, 0xa4, 0x30, 0x77,
    0x09, 0x5f, 0x96, 0xad, 0x85, 0xba, 0x3a, 0x6b, 0x73, 0x4a, 0x7c, 0x8f,
    0x36, 0xe6, 0x20, 0x12, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_tls_6144 */
static const unsigned char sub2_prime_tls_6144[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xfc, 0x2a, 0x2c,
    0x51, 0x5d, 0xa5, 0x4d, 0x57, 0xee, 0x2b, 0x10, 0x13, 0x9e, 0x9e, 0x78,
    0xec, 0x5c, 0xe2, 0xc1, 0xe7, 0x16, 0x9b, 0x4a, 0xd4, 0xf0, 0x9b, 0x20,
    0x8a, 0x32, 0x19, 0xfd, 0xe6, 0x49, 0xce, 0xe7, 0x12, 0x4d, 0x9f, 0x7c,
    0xbe, 0x97, 0xf1, 0xb1, 0xb1, 0x86, 0x3a, 0xec, 0x7b, 0x40, 0xd9, 0x01,
    0x57, 0x62, 0x30, 0xbd, 0x69, 0xef, 0x8f, 0x6a, 0xea, 0xfe, 0xb2, 0xb0,
    0x92, 0x19, 0xfa, 0x8f, 0xaf, 0x83, 0x37, 0x68, 0x42, 0xb1, 0xb2, 0xaa,
    0x9e, 0xf6, 0x8d, 0x79, 0xda, 0xab, 0x89, 0xaf, 0x3f, 0xab, 0xe4, 0x9a,
    0xcc, 0x27, 0x86, 0x38, 0x70, 0x73, 0x45, 0xbb, 0xf1, 0x53, 0x44, 0xed,
    0x79, 0xf7, 0xf4, 0x39, 0x0e, 0xf8, 0xac, 0x50, 0x9b, 0x56, 0xf3, 0x9a,
    0x98, 0x56, 0x65, 0x27, 0xa4, 0x1d, 0x3c, 0xbd, 0x5e, 0x05, 0x58, 0xc1,
    0x59, 0x92, 0x7d, 0xb0, 0xe8, 0x84, 0x54, 0xa5, 0xd9, 0x64, 0x71, 0xfd,
    0xdc, 0xb5, 0x6d, 0x5b, 0xb0, 0x6b, 0xfa, 0x34, 0x0e, 0xa7, 0xa1, 0x51,
    0xef, 0x1c, 0xa6, 0xfa, 0x57, 0x2b, 0x76, 0xf3, 0xb1, 0xb9, 0x5d, 0x8c,
    0x85, 0x83, 0xd3, 0xe4, 0x77, 0x05, 0x36, 0xb8, 0x4f, 0x01, 0x7e, 0x70,
    0xe6, 0xfb, 0xf1, 0x76, 0x60, 0x1a, 0x02, 0x66, 0x94, 0x1a, 0x17, 0xb0,
    0xc8, 0xb9, 0x7f, 0x4e, 0x74, 0xc2, 0xc1, 0xff, 0xc7, 0x27, 0x89, 0x19,
    0x77, 0x79, 0x40, 0xc1, 0xe1, 0xff, 0x1d, 0x8d, 0xa6, 0x37, 0xd6, 0xb9,
    0x9d, 0xda, 0xfe, 0x5e, 0x17, 0x61, 0x10, 0x02, 0xe2, 0xc7, 0x78, 0xc1,
    0xbe, 0x8b, 0x41, 0xd9, 0x63, 0x79, 0xa5, 0x13, 0x60, 0xd9, 0x77, 0xfd,
    0x44, 0x35, 0xa1, 0x1c, 0x30, 0x8f, 0xe7, 0xee, 0x6f, 0x1a, 0xad, 0x9d,
    0xb2, 0x8c, 0x81, 0xad, 0xde, 0x1a, 0x7a, 0x6f, 0x7c, 0xce, 0x01, 0x1c,
    0x30, 0xda, 0x37, 0xe4, 0xeb, 0x73, 0x64, 0x83, 0xbd, 0x6c, 0x8e, 0x93,
    0x48, 0xfb, 0xfb, 0xf7, 0x2c, 0xc6, 0x58, 0x7d, 0x60, 0xc3, 0x6c, 0x8e,
    0x57, 0x7f, 0x09, 0x84, 0xc2, 0x89, 0xc9, 0x38, 0x5a, 0x09, 0x86, 0x49,
    0xde, 0x21, 0xbc, 0xa2, 0x7a, 0x7e, 0xa2, 0x29, 0x71, 0x6b, 0xa6, 0xe9,
    0xb2, 0x79, 0x71, 0x0f, 0x38, 0xfa, 0xa5, 0xff, 0xae, 0x57, 0x41, 0x55,
    0xce, 0x4e, 0xfb, 0x4f, 0x74, 0x36, 0x95, 0xe2, 0x91, 0x1b, 0x1d, 0x06,
    0xd5, 0xe2, 0x90, 0xcb, 0xcd, 0x86, 0xf5, 0x6d, 0x0e, 0xdf, 0xcd, 0x21,
    0x6a, 0xe2, 0x24, 0x27, 0x05, 0x5e, 0x68, 0x35, 0xfd, 0x29, 0xee, 0xf7,
    0x9e, 0x0d, 0x90, 0x77, 0x1f, 0xea, 0xce, 0xbe, 0x12, 0xf2, 0x0e, 0x95,
    0xb3, 0x4f, 0x0f, 0x78, 0xb7, 0x37, 0xa9, 0x61, 0x8b, 0x26, 0xfa, 0x7d,
    0xbc, 0x98, 0x74, 0xf2, 0x72, 0xc4, 0x2b, 0xdb, 0x56, 0x3e, 0xaf, 0xa1,
    0x6b, 0x4f, 0xb6, 0x8c, 0x3b, 0xb1, 0xe7, 0x8e, 0xaa, 0x81, 0xa0, 0x02,
    0x43, 0xfa, 0xad, 0xd2, 0xbf, 0x18, 0xe6, 0x3d, 0x38, 0x9a, 0xe4, 0x43,
    0x77, 0xda, 0x18, 0xc5, 0x76, 0xb5, 0x0f, 0x00, 0x96, 0xcf, 0x34, 0x19,
    0x54, 0x83, 0xb0, 0x05, 0x48, 0xc0, 0x98, 0x62, 0x36, 0xe3, 0xbc, 0x7c,
    0xb8, 0xd6, 0x80, 0x1c, 0x04, 0x94, 0xcc, 0xd1, 0x99, 0xe5, 0xc5, 0xbd,
    0x0d, 0x0e, 0xdc, 0x9e, 0xb8, 0xa0, 0x00, 0x1e, 0x15, 0x27, 0x67, 0x54,
    0xfc, 0xc6, 0x85, 0x66, 0x05, 0x41, 0x48, 0xe6, 0xe7, 0x64, 0xbe, 0xe7,
    0xc7, 0x64, 0xda, 0xad, 0x3f, 0xc4, 0x52, 0x35, 0xa6, 0xda, 0xd4, 0x28,
    0xfa, 0x20, 0xc1, 0x70, 0xe3, 0x45, 0x00, 0x3f, 0x2f, 0x06, 0xec, 0x81,
    0x05, 0xfe, 0xb2, 0x5b, 0x22, 0x81, 0xb6, 0x3d, 0x27, 0x33, 0xbe, 0x96,
    0x1c, 0x29, 0x95, 0x1d, 0x11, 0xdd, 0x22, 0x21, 0x65, 0x7a, 0x9f, 0x53,
    0x1d, 0xda, 0x2a, 0x19, 0x4d, 0xbb, 0x12, 0x64, 0x48, 0xbd, 0xee, 0xb2,
    0x58, 0xe0, 0x7e, 0xa6, 0x59, 0xc7, 0x46, 0x19, 0xa6, 0x38, 0x0e, 0x1d,
    0x66, 0xd6, 0x83, 0x2b, 0xfe, 0x67, 0xf6, 0x38, 0xcd, 0x8f, 0xae, 0x1f,
    0x27, 0x23, 0x02, 0x0f, 0x9c, 0x40, 0xa3, 0xfd, 0xa6, 0x7e, 0xda, 0x3b,
    0xd2, 0x92, 0x38, 0xfb, 0xd4, 0xd4, 0xb4, 0x88, 0x5c, 0x2a, 0x99, 0x17,
    0x6d, 0xb1, 0xa0, 0x6c, 0x50, 0x07, 0x78, 0x49, 0x1a, 0x82, 0x88, 0xf1,
    0x85, 0x5f, 0x60, 0xff, 0xfc, 0xf1, 0xd1, 0x37, 0x3f, 0xd9, 0x4f, 0xc6,
    0x0c, 0x18, 0x11, 0xe1, 0xac, 0x3f, 0x1c, 0x6d, 0x00, 0x3b, 0xec, 0xda,
    0x3b, 0x1f, 0x27, 0x25, 0xca, 0x59, 0x5d, 0xe0, 0xca, 0x63, 0x32, 0x8f,
    0x3b, 0xe5, 0x7c, 0xc9, 0x77, 0x55, 0x60, 0x11, 0x95, 0x14, 0x0d, 0xfb,
    0x59, 0xd3, 0x9c, 0xe0, 0x91, 0x30, 0x8b, 0x41, 0x05, 0x74, 0x6d, 0xac,
    0x23, 0xd3, 0x3e, 0x5f, 0x7c, 0xe4, 0x84, 0x8d, 0xa3, 0x16, 0xa9, 0xc6,
    0x6b, 0x95, 0x81, 0xba, 0x35, 0x73, 0xbf, 0xaf, 0x31, 0x14, 0x96, 0x18,
    0x8a, 0xb1, 0x54, 0x23, 0x28, 0x2e, 0xe4, 0x16, 0xdc, 0x2a, 0x19, 0xc5,
    0x72, 0x4f, 0xa9, 0x1a, 0xe4, 0xad, 0xc8, 0x8b, 0xc6, 0x67, 0x96, 0xea,
    0xe5, 0x67, 0x7a, 0x01, 0xf6, 0x4e, 0x8c, 0x08, 0x63, 0x13, 0x95, 0x82,
    0x2d, 0x9d, 0xb8, 0xfc, 0xee, 0x35, 0xc0, 0x6b, 0x1f, 0xee, 0xa5, 0x47,
    0x4d, 0x6d, 0x8f, 0x34, 0xb1, 0x53, 0x4a, 0x93, 0x6a, 0x18, 0xb0, 0xe0,
    0xd2, 0x0e, 0xab, 0x86, 0xbc, 0x9c, 0x6d, 0x6a, 0x52, 0x07, 0x19, 0x4e,
    0x68, 0x72, 0x07, 0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_ike_8192 */
static const unsigned char sub2_prime_ike_8192[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x87, 0xed, 0x51,
    0x10, 0xb4, 0x61, 0x1a, 0x62, 0x63, 0x31, 0x45, 0xc0, 0x6e, 0x0e, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xe6, 0x3a, 0x01, 0x05, 0xdf, 0x53,
    0x1d, 0x89, 0xcd, 0x91, 0x28, 0xa5, 0x04, 0x3c, 0xc7, 0x1a, 0x02, 0x6e,
    0xf7, 0xca, 0x8c, 0xd9, 0xe6, 0x9d, 0x21, 0x8d, 0x98, 0x15, 0x85, 0x36,
    0xf9, 0x2f, 0x8a, 0x1b, 0xa7, 0xf0, 0x9a, 0xb6, 0xb6, 0xa8, 0xe1, 0x22,
    0xf2, 0x42, 0xda, 0xbb, 0x31, 0x2f, 0x3f, 0x63, 0x7a, 0x26, 0x21, 0x74,
    0xd3, 0x1b, 0xf6, 0xb5, 0x85, 0xff, 0xae, 0x5b, 0x7a, 0x03, 0x5b, 0xf6,
    0xf7, 0x1c, 0x35, 0xfd, 0xad, 0x44, 0xcf, 0xd2, 0xd7, 0x4f, 0x92, 0x08,
    0xbe, 0x25, 0x8f, 0xf3, 0x24, 0x94, 0x33, 0x28, 0xf6, 0x72, 0x2d, 0x9e,
    0xe1, 0x00, 0x3e, 0x5c, 0x50, 0xb1, 0xdf, 0x82, 0xcc, 0x6d, 0x24, 0x1b,
    0x0e, 0x2a, 0xe9, 0xcd, 0x34, 0x8b, 0x1f, 0xd4, 0x7e, 0x92, 0x67, 0xaf,
    0xc1, 0xb2, 0xae, 0x91, 0xee, 0x51, 0xd6, 0xcb, 0x0e, 0x31, 0x79, 0xab,
    0x10, 0x42, 0xa9, 0x5d, 0xcf, 0x6a, 0x94, 0x83, 0xb8, 0x4b, 0x4b, 0x36,
    0xb3, 0x86, 0x1a, 0xa7, 0x25, 0x5e, 0x4c, 0x02, 0x78, 0xba, 0x36, 0x04,
    0x65, 0x0c, 0x10, 0xbe, 0x19, 0x48, 0x2f, 0x23, 0x17, 0x1b, 0x67, 0x1d,
    0xf1, 0xcf, 0x3b, 0x96, 0x0c, 0x07, 0x43, 0x01, 0xcd, 0x93, 0xc1, 0xd1,
    0x76, 0x03, 0xd1, 0x47, 0xda, 0xe2, 0xae, 0xf8, 0x37, 0xa6, 0x29, 0x64,
    0xef, 0x15, 0xe5, 0xfb, 0x4a, 0xac, 0x0b, 0x8c, 0x1c, 0xca, 0xa4, 0xbe,
    0x75, 0x4a, 0xb5, 0x72, 0x8a, 0xe9, 0x13, 0x0c, 0x4c, 0x7d, 0x02, 0x88,
    0x0a, 0xb9, 0x47, 0x2d, 0x45, 0x55, 0x62, 0x16, 0xd6, 0x99, 0x8b, 0x86,
    0x82, 0x28, 0x3d, 0x19, 0xd4, 0x2a, 0x90, 0xd5, 0xef, 0x8e, 0x5d, 0x32,
    0x76, 0x7d, 0xc2, 0x82, 0x2c, 0x6d, 0xf7, 0x85, 0x45, 0x75, 0x38, 0xab,
    0xae, 0x83, 0x06, 0x3e, 0xd9, 0xcb, 0x87, 0xc2, 0xd3, 0x70, 0xf2, 0x63,
    0xd5, 0xfa, 0xd7, 0x46, 0x6d, 0x84, 0x99, 0xeb, 0x8f, 0x46, 0x4a, 0x70,
    0x25, 0x12, 0xb0, 0xce, 0xe7, 0x71, 0xe9, 0x13, 0x0d, 0x69, 0x77, 0x35,
    0xf8, 0x97, 0xfd, 0x03, 0x6c, 0xc5, 0x04, 0x32, 0x6c, 0x3b, 0x01, 0x39,
    0x9f, 0x64, 0x35, 0x32, 0x29, 0x0f, 0x95, 0x8c, 0x0b, 0xbd, 0x90, 0x06,
    0x5d, 0xf0, 0x8b, 0xab, 0xbd, 0x30, 0xae, 0xb6, 0x3b, 0x84, 0xc4, 0x60,
    0x5d, 0x6c, 0xa3, 0x71, 0x04, 0x71, 0x27, 0xd0, 0x3a, 0x72, 0xd5, 0x98,
    0xa1, 0xed, 0xad, 0xfe, 0x70, 0x7e, 0x88, 0x47, 0x25, 0xc1, 0x68, 0x90,
    0x54, 0x90, 0x84, 0x00, 0x8d, 0x39, 0x1e, 0x09, 0x53, 0xc3, 0xf3, 0x6b,
    0xc4, 0x38, 0xcd, 0x08, 0x5e, 0xdd, 0x2d, 0x93, 0x4c, 0xe1, 0x93, 0x8c,
    0x35, 0x7a, 0x71, 0x1e, 0x0d, 0x4a, 0x34, 0x1a, 0x5b, 0x0a, 0x85, 0xed,
    0x12, 0xc1, 0xf4, 0xe5, 0x15, 0x6a, 0x26, 0x74, 0x6d, 0xdd, 0xe1, 0x6d,
    0x82, 0x6f, 0x47, 0x7c, 0x97, 0x47, 0x7e, 0x0a, 0x0f, 0xdf, 0x65, 0x53,
    0x14, 0x3e, 0x2c, 0xa3, 0xa7, 0x35, 0xe0, 0x2e, 0xcc, 0xd9, 0x4b, 0x27,
    0xd0, 0x48, 0x61, 0xd1, 0x11, 0x9d, 0xd0, 0xc3, 0x28, 0xad, 0xf3, 0xf6,
    0x8f, 0xb0, 0x94, 0xb8, 0x67, 0x71, 0x6b, 0xd7, 0xdc, 0x0d, 0xee, 0xbb,
    0x10, 0xb8, 0x24, 0x0e, 0x68, 0x03, 0x48, 0x93, 0xea, 0xd8, 0x2d, 0x54,
    0xc9, 0xda, 0x75, 0x4c, 0x46, 0xc7, 0xee, 0xe0, 0xc3, 0x7f, 0xdb, 0xee,
    0x48, 0x53, 0x60, 0x47, 0xa6, 0xfa, 0x1a, 0xe4, 0x9a, 0x01, 0x42, 0x49,
    0x1b, 0x61, 0xfd, 0x5a, 0x69, 0x3e, 0x38, 0x13, 0x60, 0xea, 0x6e, 0x59,
    0x30, 0x13, 0x23, 0x6f, 0x64, 0xba, 0x8f, 0x3b, 0x1e, 0xdd, 0x1b, 0xde,
    0xfc, 0x7f, 0xca, 0x03, 0x56, 0xcf, 0x29, 0x87, 0x72, 0xed, 0x9c, 0x17,
    0xa0, 0x98, 0x00, 0xd7, 0x58, 0x35, 0x29, 0xf6, 0xc8, 0x13, 0xec, 0x18,
    0x8b, 0xcb, 0x93, 0xd8, 0x43, 0x2d, 0x44, 0x8c, 0x6d, 0x1f, 0x6d, 0xf5,
    0xe7, 0xcd, 0x8a, 0x76, 0xa2, 0x67, 0x36, 0x5d, 0x67, 0x6a, 0x5d, 0x8d,
    0xed, 0xbf, 0x8a, 0x23, 0xf3, 0x66, 0x12, 0xa5, 0x99, 0x90, 0x28, 0xa8,
    0x95, 0xeb, 0xd7, 0xa1, 0x37, 0xdc, 0x7a, 0x00, 0x9b, 0xc6, 0x69, 0x5f,
    0xac, 0xc1, 0xe5, 0x00, 0xe3, 0x25, 0xc9, 0x76, 0x78, 0x19, 0x75, 0x0a,
    0xe8, 0xb9, 0x0e, 0x81, 0xfa, 0x41, 0x6b, 0xe7, 0x37, 0x3a, 0x7f, 0x7b,
    0x6a, 0xaf, 0x38, 0x17, 0xa3, 0x4c, 0x06, 0x41, 0x5a, 0xd4, 0x20, 0x18,
    0xc8, 0x05, 0x8e, 0x4f, 0x2c, 0xf3, 0xe4, 0xbf, 0xdf, 0x63, 0xf4, 0x79,
    0x91, 0xd4, 0xbd, 0x3f, 0x1b, 0x66, 0x44, 0x5f, 0x07, 0x8e, 0xa2, 0xdb,
    0xff, 0xac, 0x2d, 0x62, 0xa5, 0xea, 0x03, 0xd9, 0x15, 0xa0, 0xaa, 0x55,
    0x66, 0x47, 0xb6, 0xbf, 0x5f, 0xa4, 0x70, 0xec, 0x0a, 0x66, 0x2f, 0x69,
    0x07, 0xc0, 0x1b, 0xf0, 0x53, 0xcb, 0x8a, 0xf7, 0x79, 0x4d, 0xf1, 0x94,
    0x03, 0x50, 0xea, 0xc5, 0xdb, 0xe2, 0xed, 0x3b, 0x7a, 0xa8, 0x55, 0x1e,
    0xc5, 0x0f, 0xdf, 0xf8, 0x75, 0x8c, 0xe6, 0x58, 0xd1, 0x89, 0xea, 0xae,
    0x6d, 0x2b, 0x64, 0xf6, 0x17, 0x79, 0x4b, 0x19, 0x1c, 0x3f, 0xf4, 0x6b,
    0xb7, 0x1e, 0x02, 0x34, 0x02, 0x1f, 0x47, 0xb3, 0x1f, 0xa4, 0x30, 0x77,
    0x09, 0x5f, 0x96, 0xad, 0x85, 0xba, 0x3a, 0x6b, 0x73, 0x4a, 0x7c, 0x8f,
    0x36, 0xdf, 0x08, 0xac, 0xba, 0x51, 0xc9, 0x37, 0x89, 0x7f, 0x72, 0xf2,
    0x1c, 0x3b, 0xbe, 0x5b, 0x54, 0x99, 0x6f, 0xc6, 0x6c, 0x5f, 0x62, 0x68,
    0x39, 0xdc, 0x98, 0xdd, 0x1d, 0xe4, 0x19, 0x5b, 0x46, 0xce, 0xe9, 0x80,
    0x3a, 0x0f, 0xd3, 0xdf, 0xc5, 0x7e, 0x23, 0xf6, 0x92, 0xbb, 0x7b, 0x49,
    0xb5, 0xd2, 0x12, 0x33, 0x1d, 0x55, 0xb1, 0xce, 0x2d, 0x72, 0x7a, 0xb4,
    0x1a, 0x11, 0xda, 0x3a, 0x15, 0xf8, 0xe4, 0xbc, 0x11, 0xc7, 0x8b, 0x65,
    0xf1, 0xce, 0xb2, 0x96, 0xf1, 0xfe, 0xdc, 0x5f, 0x7e, 0x42, 0x45, 0x6c,
    0x91, 0x11, 0x17, 0x02, 0x52, 0x01, 0xbe, 0x03, 0x89, 0xf5, 0xab, 0xd4,
    0x0d, 0x11, 0xf8, 0x63, 0x9a, 0x39, 0xfe, 0x32, 0x36, 0x75, 0x18, 0x35,
    0xa5, 0xe5, 0xe4, 0x43, 0x17, 0xc1, 0xc2, 0xee, 0xfd, 0x4e, 0xa5, 0xbf,
    0xd1, 0x60, 0x43, 0xf4, 0x3c, 0xb4, 0x19, 0x81, 0xf6, 0xad, 0xee, 0x9d,
    0x03, 0x15, 0x9e, 0x7a, 0xd9, 0xd1, 0x3c, 0x53, 0x36, 0x95, 0x09, 0xfc,
    0x1f, 0xa2, 0x7c, 0x16, 0xef, 0x98, 0x87, 0x70, 0x3a, 0x55, 0xb5, 0x1b,
    0x22, 0xcb, 0xf4, 0x4c, 0xd0, 0x12, 0xae, 0xe0, 0xb2, 0x79, 0x8e, 0x62,
    0x84, 0x23, 0x42, 0x8e, 0xfc, 0xd5, 0xa4, 0x0c, 0xae, 0xf6, 0xbf, 0x50,
    0xd8, 0xea, 0x88, 0x5e, 0xbf, 0x73, 0xa6, 0xb9, 0xfd, 0x79, 0xb5, 0xe1,
    0x8f, 0x67, 0xd1, 0x34, 0x1a, 0xc8, 0x23, 0x7a, 0x75, 0xc3, 0xcf, 0xc9,
    0x20, 0x04, 0xa1, 0xc5, 0xa4, 0x0e, 0x36, 0x6b, 0xc4, 0x4d, 0x00, 0x17,
    0x6a, 0xf7, 0x1c, 0x15, 0xe4, 0x8c, 0x86, 0xd3, 0x7e, 0x01, 0x37, 0x23,
    0xca, 0xac, 0x72, 0x23, 0xab, 0x3b, 0xf4, 0xd5, 0x4f, 0x18, 0x28, 0x71,
    0x3b, 0x2b, 0x4a, 0x6f, 0xe4, 0x0f, 0xab, 0x74, 0x40, 0x5c, 0xb7, 0x38,
    0xb0, 0x64, 0xc0, 0x6e, 0xcc, 0x76, 0xe9, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_tls_8192 */
static const unsigned char sub2_prime_tls_8192[] = {
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xfc, 0x2a, 0x2c,
    0x51, 0x5d, 0xa5, 0x4d, 0x57, 0xee, 0x2b, 0x10, 0x13, 0x9e, 0x9e, 0x78,
    0xec, 0x5c, 0xe2, 0xc1, 0xe7, 0x16, 0x9b, 0x4a, 0xd4, 0xf0, 0x9b, 0x20,
    0x8a, 0x32, 0x19, 0xfd, 0xe6, 0x49, 0xce, 0xe7, 0x12, 0x4d, 0x9f, 0x7c,
    0xbe, 0x97, 0xf1, 0xb1, 0xb1, 0x86, 0x3a, 0xec, 0x7b, 0x40, 0xd9, 0x01,
    0x57, 0x62, 0x30, 0xbd, 0x69, 0xef, 0x8f, 0x6a, 0xea, 0xfe, 0xb2, 0xb0,
    0x92, 0x19, 0xfa, 0x8f, 0xaf, 0x83, 0x37, 0x68, 0x42, 0xb1, 0xb2, 0xaa,
    0x9e, 0xf6, 0x8d, 0x79, 0xda, 0xab, 0x89, 0xaf, 0x3f, 0xab, 0xe4, 0x9a,
    0xcc, 0x27, 0x86, 0x38, 0x70, 0x73, 0x45, 0xbb, 0xf1, 0x53, 0x44, 0xed,
    0x79, 0xf7, 0xf4, 0x39, 0x0e, 0xf8, 0xac, 0x50, 0x9b, 0x56, 0xf3, 0x9a,
    0x98, 0x56, 0x65, 0x27, 0xa4, 0x1d, 0x3c, 0xbd, 0x5e, 0x05, 0x58, 0xc1,
    0x59, 0x92, 0x7d, 0xb0, 0xe8, 0x84, 0x54, 0xa5, 0xd9, 0x64, 0x71, 0xfd,
    0xdc, 0xb5, 0x6d, 0x5b, 0xb0, 0x6b, 0xfa, 0x34, 0x0e, 0xa7, 0xa1, 0x51,
    0xef, 0x1c, 0xa6, 0xfa, 0x57, 0x2b, 0x76, 0xf3, 0xb1, 0xb9, 0x5d, 0x8c,
    0x85, 0x83, 0xd3, 0xe4, 0x77, 0x05, 0x36, 0xb8, 0x4f, 0x01, 0x7e, 0x70,
    0xe6, 0xfb, 0xf1, 0x76, 0x60, 0x1a, 0x02, 0x66, 0x94, 0x1a, 0x17, 0xb0,
    0xc8, 0xb9, 0x7f, 0x4e, 0x74, 0xc2, 0xc1, 0xff, 0xc7, 0x27, 0x89, 0x19,
    0x77, 0x79, 0x40, 0xc1, 0xe1, 0xff, 0x1d, 0x8d, 0xa6, 0x37, 0xd6, 0xb9,
    0x9d, 0xda, 0xfe, 0x5e, 0x17, 0x61, 0x10, 0x02, 0xe2, 0xc7, 0x78, 0xc1,
    0xbe, 0x8b, 0x41, 0xd9, 0x63, 0x79, 0xa5, 0x13, 0x60, 0xd9, 0x77, 0xfd,
    0x44, 0x35, 0xa1, 0x1c, 0x30, 0x8f, 0xe7, 0xee, 0x6f, 0x1a, 0xad, 0x9d,
    0xb2, 0x8c, 0x81, 0xad, 0xde, 0x1a, 0x7a, 0x6f, 0x7c, 0xce, 0x01, 0x1c,
    0x30, 0xda, 0x37, 0xe4, 0xeb, 0x73, 0x64, 0x83, 0xbd, 0x6c, 0x8e, 0x93,
    0x48, 0xfb, 0xfb, 0xf7, 0x2c, 0xc6, 0x58, 0x7d, 0x60, 0xc3, 0x6c, 0x8e,
    0x57, 0x7f, 0x09, 0x84, 0xc2, 0x89, 0xc9, 0x38, 0x5a, 0x09, 0x86, 0x49,
    0xde, 0x21, 0xbc, 0xa2, 0x7a, 0x7e, 0xa2, 0x29, 0x71, 0x6b, 0xa6, 0xe9,
    0xb2, 0x79, 0x71, 0x0f, 0x38, 0xfa, 0xa5, 0xff, 0xae, 0x57, 0x41, 0x55,
    0xce, 0x4e, 0xfb, 0x4f, 0x74, 0x36, 0x95, 0xe2, 0x91, 0x1b, 0x1d, 0x06,
    0xd5, 0xe2, 0x90, 0xcb, 0xcd, 0x86, 0xf5, 0x6d, 0x0e, 0xdf, 0xcd, 0x21,
    0x6a, 0xe2, 0x24, 0x27, 0x05, 0x5e, 0x68, 0x35, 0xfd, 0x29, 0xee, 0xf7,
    0x9e, 0x0d, 0x90, 0x77, 0x1f, 0xea, 0xce, 0xbe, 0x12, 0xf2, 0x0e, 0x95,
    0xb3, 0x4f, 0x0f, 0x78, 0xb7, 0x37, 0xa9, 0x61, 0x8b, 0x26, 0xfa, 0x7d,
    0xbc, 0x98, 0x74, 0xf2, 0x72, 0xc4, 0x2b, 0xdb, 0x56, 0x3e, 0xaf, 0xa1,
    0x6b, 0x4f, 0xb6, 0x8c, 0x3b, 0xb1, 0xe7, 0x8e, 0xaa, 0x81, 0xa0, 0x02,
    0x43, 0xfa, 0xad, 0xd2, 0xbf, 0x18, 0xe6, 0x3d, 0x38, 0x9a, 0xe4, 0x43,
    0x77, 0xda, 0x18, 0xc5, 0x76, 0xb5, 0x0f, 0x00, 0x96, 0xcf, 0x34, 0x19,
    0x54, 0x83, 0xb0, 0x05, 0x48, 0xc0, 0x98, 0x62, 0x36, 0xe3, 0xbc, 0x7c,
    0xb8, 0xd6, 0x80, 0x1c, 0x04, 0x94, 0xcc, 0xd1, 0x99, 0xe5, 0xc5, 0xbd,
    0x0d, 0x0e, 0xdc, 0x9e, 0xb8, 0xa0, 0x00, 0x1e, 0x15, 0x27, 0x67, 0x54,
    0xfc, 0xc6, 0x85, 0x66, 0x05, 0x41, 0x48, 0xe6, 0xe7, 0x64, 0xbe, 0xe7,
    0xc7, 0x64, 0xda, 0xad, 0x3f, 0xc4, 0x52, 0x35, 0xa6, 0xda, 0xd4, 0x28,
    0xfa, 0x20, 0xc1, 0x70, 0xe3, 0x45, 0x00, 0x3f, 0x2f, 0x06, 0xec, 0x81,
    0x05, 0xfe, 0xb2, 0x5b, 0x22, 0x81, 0xb6, 0x3d, 0x27, 0x33, 0xbe, 0x96,
    0x1c, 0x29, 0x95, 0x1d, 0x11, 0xdd, 0x22, 0x21, 0x65, 0x7a, 0x9f, 0x53,
    0x1d, 0xda, 0x2a, 0x19, 0x4d, 0xbb, 0x12, 0x64, 0x48, 0xbd, 0xee, 0xb2,
    0x58, 0xe0, 0x7e, 0xa6, 0x59, 0xc7, 0x46, 0x19, 0xa6, 0x38, 0x0e, 0x1d,
    0x66, 0xd6, 0x83, 0x2b, 0xfe, 0x67, 0xf6, 0x38, 0xcd, 0x8f, 0xae, 0x1f,
    0x27, 0x23, 0x02, 0x0f, 0x9c, 0x40, 0xa3, 0xfd, 0xa6, 0x7e, 0xda, 0x3b,
    0xd2, 0x92, 0x38, 0xfb, 0xd4, 0xd4, 0xb4, 0x88, 0x5c, 0x2a, 0x99, 0x17,
    0x6d, 0xb1, 0xa0, 0x6c, 0x50, 0x07, 0x78, 0x49, 0x1a, 0x82, 0x88, 0xf1,
    0x85, 0x5f, 0x60, 0xff, 0xfc, 0xf1, 0xd1, 0x37, 0x3f, 0xd9, 0x4f, 0xc6,
    0x0c, 0x18, 0x11, 0xe1, 0xac, 0x3f, 0x1c, 0x6d, 0x00, 0x3b, 0xec, 0xda,
    0x3b, 0x1f, 0x27, 0x25, 0xca, 0x59, 0x5d, 0xe0, 0xca, 0x63, 0x32, 0x8f,
    0x3b, 0xe5, 0x7c, 0xc9, 0x77, 0x55, 0x60, 0x11, 0x95, 0x14, 0x0d, 0xfb,
    0x59, 0xd3, 0x9c, 0xe0, 0x91, 0x30, 0x8b, 0x41, 0x05, 0x74, 0x6d, 0xac,
    0x23, 0xd3, 0x3e, 0x5f, 0x7c, 0xe4, 0x84, 0x8d, 0xa3, 0x16, 0xa9, 0xc6,
    0x6b, 0x95, 0x81, 0xba, 0x35, 0x73, 0xbf, 0xaf, 0x31, 0x14, 0x96, 0x18,
    0x8a, 0xb1, 0x54, 0x23, 0x28, 0x2e, 0xe4, 0x16, 0xdc, 0x2a, 0x19, 0xc5,
    0x72, 0x4f, 0xa9, 0x1a, 0xe4, 0xad, 0xc8, 0x8b, 0xc6, 0x67, 0x96, 0xea,
    0xe5, 0x67, 0x7a, 0x01, 0xf6, 0x4e, 0x8c, 0x08, 0x63, 0x13, 0x95, 0x82,
    0x2d, 0x9d, 0xb8, 0xfc, 0xee, 0x35, 0xc0, 0x6b, 0x1f, 0xee, 0xa5, 0x47,
    0x4d, 0x6d, 0x8f, 0x34, 0xb1, 0x53, 0x4a, 0x93, 0x6a, 0x18, 0xb0, 0xe0,
    0xd2, 0x0e, 0xab, 0x86, 0xbc, 0x9c, 0x6d, 0x6a, 0x52, 0x07, 0x19, 0x4e,
    0x67, 0xfa, 0x35, 0x55, 0x1b, 0x56, 0x80, 0x26, 0x7b, 0x00, 0x64, 0x1c,
    0x0f, 0x21, 0x2d, 0x18, 0xec, 0xa8, 0xd7, 0x32, 0x7e, 0xd9, 0x1f, 0xe7,
    0x64, 0xa8, 0x4e, 0xa1, 0xb4, 0x3f, 0xf5, 0xb4, 0xf6, 0xe8, 0xe6, 0x2f,
    0x05, 0xc6, 0x61, 0xde, 0xfb, 0x25, 0x88, 0x77, 0xc3, 0x5b, 0x18, 0xa1,
    0x51, 0xd5, 0xc4, 0x14, 0xaa, 0xad, 0x97, 0xba, 0x3e, 0x49, 0x93, 0x32,
    0xe5, 0x96, 0x07, 0x8e, 0x60, 0x0d, 0xeb, 0x81, 0x14, 0x9c, 0x44, 0x1c,
    0xe9, 0x57, 0x82, 0xf2, 0x2a, 0x28, 0x25, 0x63, 0xc5, 0xba, 0xc1, 0x41,
    0x14, 0x23, 0x60, 0x5d, 0x1a, 0xe1, 0xaf, 0xae, 0x2c, 0x8b, 0x06, 0x60,
    0x23, 0x7e, 0xc1, 0x28, 0xaa, 0x0f, 0xe3, 0x46, 0x4e, 0x43, 0x58, 0x11,
    0x5d, 0xb8, 0x4c, 0xc3, 0xb5, 0x23, 0x07, 0x3a, 0x28, 0xd4, 0x54, 0x98,
    0x84, 0xb8, 0x1f, 0xf7, 0x0e, 0x10, 0xbf, 0x36, 0x1c, 0x13, 0x72, 0x96,
    0x28, 0xd5, 0x34, 0x8f, 0x07, 0x21, 0x1e, 0x7e, 0x4c, 0xf4, 0xf1, 0x8b,
    0x28, 0x60, 0x90, 0xbd, 0xb1, 0x24, 0x0b, 0x66, 0xd6, 0xcd, 0x4a, 0xfc,
    0xea, 0xdc, 0x00, 0xca, 0x44, 0x6c, 0xe0, 0x50, 0x50, 0xff, 0x18, 0x3a,
    0xd2, 0xbb, 0xf1, 0x18, 0xc1, 0xfc, 0x0e, 0xa5, 0x1f, 0x97, 0xd2, 0x2b,
    0x8f, 0x7e, 0x46, 0x70, 0x5d, 0x45, 0x27, 0xf4, 0x5b, 0x42, 0xae, 0xff,
    0x39, 0x58, 0x53, 0x37, 0x6f, 0x69, 0x7d, 0xd5, 0xfd, 0xf2, 0xc5, 0x18,
    0x7d, 0x7d, 0x5f, 0x0e, 0x2e, 0xb8, 0xd4, 0x3f, 0x17, 0xba, 0x0f, 0x7c,
    0x60, 0xff, 0x43, 0x7f, 0x53, 0x5d, 0xfe, 0xf2, 0x98, 0x33, 0xbf, 0x86,
    0xcb, 0xe8, 0x8e, 0xa4, 0xfb, 0xd4, 0x22, 0x1e, 0x84, 0x11, 0x72, 0x83,
    0x54, 0xfa, 0x30, 0xa7, 0x00, 0x8f, 0x15, 0x4a, 0x41, 0xc7, 0xfc, 0x46,
    0x6b, 0x46, 0x45, 0xdb, 0xe2, 0xe3, 0x21, 0x26, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,
};

/* q=(p-1)/2 for prime prime_safe_1536 */
static const unsigned char sub2_prime_safe_1536[] = {
    0x7b, 0xb3, 0x98, 0xe4, 0x22, 0xb5, 0x6c, 0xf5, 0x29, 0x85, 0x90, 0xe3,
    0xa5, 0x7d, 0x40, 0xb3, 0x3b, 0x2e, 0x75, 0x5b, 0xfa, 0x88, 0x99, 0x36,
    0xe9, 0xa6, 0x3d, 0x56, 0x1c, 0x8b, 0x8d, 0x43, 0xdc, 0x00, 0x6b, 0x88,
    0xe2, 0xfe, 0xf0, 0xf1, 0xb2, 0xa6, 0x0f, 0xa1, 0x12, 0x20, 0x8f, 0x49,
    0x21, 0x5f, 0xdb, 0x32, 0x87, 0x39, 0x41, 0xc5, 0x5c, 0x41, 0x53, 0x27,
    0xcf, 0x65, 0x27, 0xe8, 0xd8, 0x89, 0xe1, 0x7d, 0x33, 0xd0, 0xb5, 0x03,
    0x27, 0xd7, 0xb7, 0x0b, 0x6c, 0xca, 0x6c, 0x6d, 0x71, 0xb3, 0x31, 0x00,
    0x8f, 0xc1, 0x47, 0x88, 0x70, 0x17, 0x9e, 0x51, 0xa1, 0x54, 0x5d, 0xca,
    0x19, 0x3c, 0xbc, 0xbf, 0xcb, 0xfc, 0x1d, 0x18, 0xd5, 0x0a, 0x63, 0xff,
    0x09, 0xcb, 0x3b, 0x8a, 0xdf, 0xa3, 0x90, 0x2b, 0x88, 0xf0, 0x27, 0xed,
    0x3f, 0x54, 0x8c, 0xa4, 0xd0, 0xc6, 0x94, 0xbb, 0x45, 0x69, 0xcd, 0xd8,
    0x5f, 0x28, 0x61, 0x92, 0xc1, 0x7c, 0xf1, 0x90, 0xc6, 0x7e, 0xd3, 0x28,
    0xf2, 0x9b, 0x3f, 0x41, 0x5b, 0x48, 0x22, 0xf0, 0xea, 0xb9, 0x2b, 0x5f,
    0x62, 0xb3, 0x9e, 0x89, 0x8d, 0x1c, 0xbf, 0xcc, 0x19, 0xfe, 0x5a, 0x3d,
    0xd2, 0x1c, 0x38, 0xc3, 0xcb, 0x37, 0x73, 0x3d, 0xbb, 0xd9, 0x32, 0xfe,
    0xef, 0x93, 0xc9, 0x86, 0x1e, 0x30, 0x6f, 0xf2, 0x99, 0xff, 0x6b, 0xa5,
};

/* q=(p-1)/2 for prime prime_safe_2048 */
static const unsigned char sub2_prime_safe_2048[] = {
    0x70, 0xd1, 0xb7, 0x24, 0xb4, 0x83, 0x8e, 0x2f, 0xda, 0x0a, 0x9a, 0xa3,
    0x4c, 0xa9, 0x68, 0x27, 0x7f, 0xa7, 0x26, 0x58, 0xf0, 0xac, 0xf6, 0x97,
    0x38, 0xf9, 0xc0, 0x0a, 0x2a, 0x68, 0x7e, 0x41, 0x90, 0x14, 0x8a, 0x90,
    0xd3, 0x2f, 0x88, 0x40, 0xab, 0xfa, 0x17, 0x24, 0xd9, 0x68, 0x9b, 0xf4,
    0x35, 0x5f, 0xb9, 0x7c, 0xaa, 0xa7, 0x4f, 0x57, 0x10, 0x62, 0xdb, 0x62,
    0xc8, 0xbc, 0x86, 0xd1, 0x6e, 0xda, 0x5d, 0xa8, 0x27, 0x10, 0x65, 0x45,
    0x47, 0xc1, 0x1a, 0x5c, 0xb5, 0x1f, 0x4d, 0x33, 0xe1, 0x3f, 0x41, 0xfb,
    0x60, 0x56, 0xf1, 0xe5, 0x00, 0x6b, 0x08, 0xc4, 0x4e, 0x63, 0xcf, 0xda,
    0x1e, 0xa9, 0xd2, 0xad, 0x4b, 0xa2, 0x26, 0xf3, 0xae, 0x6a, 0xbb, 0x40,
    0x7c, 0x06, 0x66, 0xd3, 0x2a, 0xf1, 0x2f, 0xe7, 0xfa, 0x23, 0x52, 0x63,
    0x87, 0xe0, 0xc0, 0x42, 0x32, 0xa3, 0x46, 0x43, 0xe9, 0x4c, 0xc1, 0x6f,
    0xc7, 0x00, 0x44, 0xf9, 0x86, 0xea, 0xe0, 0x2a, 0x4a, 0x63, 0x51, 0xc9,
    0x07, 0xc8, 0x88, 0x77, 0x51, 0xb2, 0xa2, 0x5b, 0xb6, 0xf4, 0x11, 0xfc,
    0xbf, 0xc8, 0xb1, 0x32, 0x84, 0xc7, 0x50, 0x99, 0xea, 0x6b, 0x2a, 0x85,
    0x60, 0x74, 0x33, 0x38, 0x02, 0xe8, 0x09, 0x1a, 0x60, 0xfe, 0xe7, 0x3a,
    0xd2, 0x3a, 0xf0, 0xa3, 0x50, 0x84, 0x5a, 0x29, 0x7f, 0x12, 0xd2, 0x62,
    0xa7, 0x91, 0x82, 0x3f, 0x50, 0x96, 0x79, 0xab, 0x65, 0xfd, 0x3d, 0x5e,
    0x22, 0xe6, 0x3c, 0x59, 0x94, 0x79, 0xf2, 0xea, 0x93, 0x2b, 0x13, 0xc3,
    0x35, 0x2b, 0x35, 0xc3, 0xab, 0x07, 0x62, 0x1e, 0x76, 0xff, 0xe5, 0xcb,
    0x5a, 0x09, 0x8e, 0xa6, 0x9c, 0x27, 0x34, 0x9a, 0x28, 0xbd, 0x42, 0x98,
    0xda, 0x40, 0x6d, 0x20, 0xf1, 0xee, 0x17, 0x29, 0xec, 0x38, 0x9f, 0x66,
    0x1b, 0xc5, 0x40, 0x19,
};

/* q=(p-1)/2 for prime prime_safe_3072 */
static const unsigned char sub2_prime_safe_3072[] = {
    0x43, 0xb3, 0x6f, 0xfb, 0xf6, 0x24, 0xb5, 0x4d, 0x3e, 0x4b, 0x14, 0x57,
    0x33, 0x9c, 0x55, 0xfd, 0x7f, 0x2e, 0x23, 0x3d, 0xf7, 0xf4, 0x8c, 0x53,
    0x3b, 0x59, 0x72, 0x87, 0x5f, 0x5c, 0x79, 0x40, 0x1b, 0x04, 0xc1, 0x22,
    0x3d, 0xf4, 0x74, 0x66, 0x44, 0x93, 0xb4, 0x02, 0xf0, 0x70, 0x9b, 0xeb,
    0xdf, 0xed, 0x86, 0x7b, 0x24, 0x29, 0x0b, 0x9f, 0xba, 0xe2, 0xa7, 0x5a,
    0x1e, 0xfc, 0x26, 0x75, 0x5a, 0x05, 0x83, 0x02, 0x0a, 0xc4, 0xbe, 0x5d,
    0x79, 0xfa, 0xef, 0x33, 0x37, 0x3e, 0x98, 0x62, 0x10, 0x02, 0xed, 0x19,
    0x07, 0xff, 0xbc, 0xb8, 0xa2, 0x4d, 0x88, 0x07, 0xf8, 0xdd, 0x98, 0xef,
    0x33, 0xc8, 0x75, 0x3b, 0xd6, 0xb2, 0xeb, 0x82, 0xba, 0xd5, 0xb3, 0x79,
    0x73, 0x29, 0x56, 0x79, 0x55, 0x53, 0xe9, 0x22, 0xec, 0xe3, 0x21, 0x1c,
    0x93, 0x8f, 0xa3, 0x42, 0x56, 0xbc, 0x5a, 0x7d, 0x42, 0x7c, 0x4d, 0x9f,
    0x65, 0xe0, 0xcc, 0xf2, 0x9a, 0xa1, 0x13, 0x02, 0xf5, 0x56, 0x28, 0x82,
    0x27, 0xc5, 0x4c, 0x12, 0xd3, 0xa3, 0x55, 0xbd, 0xf6, 0xdc, 0x54, 0x85,
    0x92, 0x11, 0xc1, 0x91, 0x8b, 0x43, 0xb2, 0x48, 0x86, 0x5f, 0x8f, 0xde,
    0x76, 0x25, 0x6e, 0x89, 0x15, 0x86, 0x54, 0x9c, 0xcb, 0x62, 0x61, 0xe7,
    0xd2, 0x9c, 0x20, 0x06, 0xb7, 0x68, 0x7d, 0x05, 0x06, 0x1f, 0x74, 0xba,
    0x85, 0xb8, 0x14, 0x34, 0x5e, 0x7e, 0xfb, 0x61, 0x4d, 0x2c, 0xc8, 0x90,
    0x2e, 0x38, 0x7f, 0x18, 0xd3, 0x28, 0x43, 0xcd, 0x35, 0x30, 0x90, 0x16,
    0x3b, 0xc2, 0x40, 0xd4, 0x1f, 0x64, 0xd4, 0x39, 0x58, 0x29, 0xa1, 0xc2,
    0x8e, 0x4d, 0x9d, 0x6e, 0xf7, 0x84, 0xbe, 0xe3, 0xb4, 0x63, 0x77, 0x84,
    0x67, 0x23, 0xd0, 0x6e, 0x2d, 0xed, 0x97, 0x96, 0x9a, 0x71, 0xef, 0x4a,
    0xfb, 0x35, 0xb6, 0xae, 0xc8, 0xdf, 0x22, 0xf7, 0x16, 0x82, 0x49, 0xbc,
    0x63, 0xd2, 0x24, 0xe6, 0x38, 0xd4, 0x2e, 0xec, 0x45, 0x3f, 0x4f, 0x27,
    0x88, 0x64, 0xa0, 0xe8, 0xb1, 0x60, 0xb8, 0x24, 0x5a, 0x89, 0x08, 0x91,
    0xd3, 0x72, 0x6f, 0xb2, 0x56, 0x6c, 0xf2, 0x1b, 0xe1, 0x5c, 0x91, 0xd3,
    0xa0, 0x75, 0x3f, 0xaa, 0x71, 0xf7, 0xb8, 0xc0, 0xda, 0x73, 0x82, 0x88,
    0x6b, 0x15, 0xea, 0x88, 0xc2, 0x2d, 0x34, 0xd2, 0xd6, 0x29, 0x36, 0xd4,
    0x3c, 0x93, 0xff, 0x8e, 0x01, 0x68, 0xb1, 0x1b, 0x01, 0xd1, 0x54, 0xa3,
    0x36, 0x27, 0xe5, 0x2c, 0x79, 0x59, 0x76, 0xc8, 0xda, 0x4f, 0x2d, 0xee,
    0xfc, 0xcc, 0xdb, 0x46, 0xb8, 0x1a, 0x05, 0x62, 0xa6, 0xeb, 0xe7, 0x45,
    0xf8, 0xa8, 0x12, 0xc4, 0xff, 0xf3, 0xf9, 0x0f, 0x5c, 0x90, 0xd9, 0xc5,
    0xe4, 0x21, 0x3e, 0x13, 0x77, 0xa6, 0x18, 0x46, 0xb0, 0x5b, 0x92, 0xfd,
};

#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
/* q=(p-1)/2 for prime prime_safe_4096 */
static const unsigned char sub2_prime_safe_4096[] = {
    0x45, 0xef, 0xe0, 0xd1, 0xf2, 0x5e, 0x8e, 0x58, 0xfa, 0x58, 0xa8, 0xe9,
    0xc5, 0x67, 0x1e, 0x99, 0xac, 0x40, 0x51, 0x8e, 0x3e, 0x06, 0xde, 0xc7,
    0x5e, 0xd9, 0xf3, 0xcf, 0x6a, 0x6f, 0x03, 0x7e, 0x4c, 0x57, 0x80, 0xa1,
    0xc9, 0x96, 0x7e, 0x7d, 0xc9, 0x40, 0x70, 0x37, 0x7c, 0xfb, 0x55, 0xb9,
    0xcb, 0x46, 0xbf, 0x60, 0x75, 0x93, 0x36, 0x06, 0x29, 0x83, 0x4f, 0x99,
    0x25, 0xd6, 0xa9, 0xea, 0xdf, 0xc8, 0x9a, 0x8b, 0x7e, 0xbf, 0xdd, 0x18,
    0x5b, 0x5a, 0x44, 0x08, 0x0f, 0xad, 0x60, 0x31, 0x7c, 0xbf, 0xb8, 0xcd,
    0xda, 0x88, 0x25, 0xcc, 0xe8, 0x78, 0x74, 0xe1, 0x77, 0x1a, 0x92, 0x75,
    0xe6, 0x77, 0x03, 0x5f, 0xd0, 0x02, 0xf2, 0x30, 0xd2, 0x53, 0x4c, 0x11,
    0xe8, 0x72, 0x45, 0x30, 0xe5, 0x02, 0xc5, 0x36, 0x4c, 0x7d, 0x41, 0xe1,
    0xa8, 0x3e, 0xaa, 0x9d, 0x97, 0x6a, 0xd6, 0x0a, 0x30, 0xc3, 0x68, 0xda,
    0xe7, 0xe0, 0x6e, 0x34, 0xa5, 0xb6, 0x25, 0x62, 0xeb, 0xff, 0x70, 0x74,
    0x0d, 0x32, 0x08, 0xed, 0xab, 0x78, 0x0e, 0x4a, 0xae, 0x68, 0xb5, 0x5c,
    0xfb, 0x71, 0x00, 0x7a, 0x11, 0x01, 0x81, 0x95, 0x5e, 0x4e, 0x41, 0x75,
    0xc4, 0x8d, 0x6e, 0xca, 0x32, 0x81, 0x22, 0x30, 0xbb, 0x60, 0xd7, 0x6c,
    0x65, 0x7e, 0xb3, 0x7a, 0x4b, 0x73, 0xbc, 0xff, 0x1d, 0x4c, 0x78, 0xc0,
    0x01, 0x7d, 0x21, 0x5b, 0xd7, 0x75, 0x9c, 0x94, 0x61, 0xdc, 0xe7, 0x46,
    0x38, 0xf5, 0x0a, 0x3a, 0x43, 0x36, 0x13, 0x6a, 0x8a, 0x90, 0xcb, 0x86,
    0x41, 0x46, 0xc0, 0xc2, 0x62, 0xa3, 0x88, 0x03, 0x33, 0xd4, 0x2f, 0xd8,
    0xe2, 0x99, 0x6e, 0x3f, 0xf3, 0x30, 0xf2, 0xf5, 0xcf, 0x54, 0xb0, 0xcc,
    0xa1, 0xd4, 0xc5, 0xf6, 0xd7, 0xf2, 0x10, 0xf7, 0xc7, 0x3c, 0x2d, 0x30,
    0xaa, 0xce, 0xa1, 0xed, 0xbb, 0xd5, 0x5d, 0x8c, 0xf5, 0x27, 0xa4, 0xa9,
    0xc0, 0x67, 0x3e, 0x4d, 0x75, 0x53, 0x49, 0xac, 0x6a, 0x55, 0xfa, 0x74,
    0xb0, 0x3e, 0xe5, 0x59, 0x4b, 0xd2, 0xf0, 0x49, 0x67, 0x76, 0x2b, 0xde,
    0x62, 0x82, 0xbb, 0x08, 0xbc, 0x81, 0xf0, 0xd9, 0x4c, 0xe0, 0x90, 0xea,
    0x42, 0xf3, 0xb7, 0xe4, 0xac, 0x74, 0x0e, 0x06, 0xe4, 0x48, 0x22, 0x26,
    0x2c, 0x2a, 0xcd, 0x77, 0x6f, 0x31, 0x07, 0x59, 0x71, 0xde, 0x75, 0xa8,
    0xa0, 0x02, 0xb8, 0xff, 0x5a, 0x74, 0xf3, 0x7b, 0x07, 0x6b, 0xdd, 0x8d,
    0xdc, 0x4c, 0xf4, 0x64, 0xed, 0x4f, 0xef, 0x1e, 0x09, 0xec, 0x8b, 0x22,
    0x9e, 0xd6, 0x71, 0x04, 0xe1, 0xc3, 0xdd, 0x9c, 0xc6, 0x37, 0x88, 0xb0,
    0x43, 0x8f, 0xd7, 0xd3, 0xee, 0x09, 0x47, 0xbe, 0xa6, 0x2f, 0x2b, 0x61,
    0xb1, 0x6e, 0xee, 0x81, 0xaa, 0xcf, 0x12, 0x36, 0x62, 0xb6, 0x5c, 0x07,
    0x57, 0x88, 0xea, 0x8f, 0x35, 0x1b, 0x4e, 0x65, 0x23, 0x1a, 0x09, 0x95,
    0xe8, 0xd1, 0x9a, 0x16, 0x41, 0x8d, 0x92, 0xe6, 0x0b, 0x80, 0xce, 0x34,
    0x29, 0xdb, 0xc3, 0xf6, 0x87, 0x24, 0x6b, 0xb4, 0xfc, 0xe4, 0x0e, 0xc5,
    0xb8, 0xfa, 0x37, 0xe8, 0xd8, 0xea, 0xb8, 0x50, 0x6b, 0xb8, 0x9e, 0xcf,
    0xfe, 0x7d, 0x1a, 0xb4, 0x92, 0xf9, 0x9c, 0xbc, 0xd6, 0xbd, 0x80, 0xe2,
    0xb3, 0x52, 0xf8, 0x63, 0x8e, 0x5b, 0x28, 0xf2, 0x81, 0x15, 0xe7, 0xe0,
    0x95, 0x48, 0xce, 0xd2, 0xdf, 0x9b, 0x9b, 0xee, 0x97, 0x18, 0x20, 0x6d,
    0xdf, 0xf6, 0x7f, 0x36, 0x16, 0x74, 0x90, 0x77, 0x44, 0xd6, 0x2a, 0xd7,
    0x81, 0xad, 0x5d, 0x2d, 0x29, 0x7d, 0xdf, 0xda, 0xd7, 0x1c, 0x10, 0x52,
    0xb4, 0x49, 0x2f, 0xf6, 0x0b, 0xd4, 0xc0, 0x29, 0xf9, 0x1d, 0x86, 0x04,
    0xf9, 0xf5, 0x8a, 0xb1, 0x47, 0x1c, 0xbd, 0xb5,
};

/* q=(p-1)/2 for prime prime_safe_6144 */
static const unsigned char sub2_prime_safe_6144[] = {
    0x5c, 0x87, 0xe0, 0xa0, 0xa5, 0x6f, 0x0d, 0x0e, 0x40, 0x50, 0x6b, 0x1c,
    0xc0, 0x88, 0x79, 0x84, 0xe5, 0x60, 0x30, 0x46, 0x2f, 0x46, 0x0b, 0x90,
    0xd0, 0x0c, 0x28, 0x6b, 0x30, 0x09, 0xfe, 0x1c, 0x00, 0x13, 0x6c, 0xb8,
    0xe9, 0x39, 0xfe, 0x2e, 0x86, 0x78, 0x90, 0x67, 0x3b, 0x22, 0x5d, 0xc5,
    0xae, 0x64, 0x2d, 0x2c, 0x86, 0x66, 0xa4, 0x5d, 0x5f, 0xc3, 0x39, 0x6d,
    0x7a, 0xde, 0xbe, 0x0e, 0xa0, 0xdd, 0x74, 0x4f, 0xc6, 0x61, 0x0c, 0x13,
    0xfd, 0x5e, 0x63, 0x67, 0xec, 0x23, 0xfa, 0xf4, 0xb8, 0xe6, 0x1b, 0x9a,
    0x61, 0xcd, 0xad, 0x7f, 0xe1, 0x86, 0x55, 0x8e, 0xcb, 0xc6, 0x13, 0x4a,
    0xc6, 0x78, 0x85, 0x2e, 0x91, 0x42, 0x2d, 0x3e, 0x79, 0x68, 0xc5, 0xbe,
    0x37, 0x8b, 0x84, 0x89, 0x80, 0x64, 0xef, 0xbc, 0xf0, 0xb7, 0x64, 0x7c,
    0x69, 0xe0, 0xee, 0xd9, 0x7a, 0x12, 0x15, 0x7d, 0x2e, 0x33, 0x12, 0x95,
    0x9c, 0xe8, 0x9c, 0xa4, 0x7d, 0x3b, 0x27, 0xab, 0xd1, 0x90, 0x61, 0x9c,
    0x17, 0x42, 0xb3, 0x98, 0xc9, 0x42, 0x9e, 0x38, 0x11, 0x8a, 0x76, 0x36,
    0x42, 0x94, 0x70, 0x27, 0xe6, 0x63, 0x1d, 0xe7, 0x8c, 0x98, 0x1d, 0x80,
    0xff, 0x4f, 0x0b, 0x32, 0x8e, 0x7a, 0x18, 0x86, 0x4e, 0x91, 0xa0, 0x42,
    0xb6, 0x6e, 0xf2, 0xfb, 0xc8, 0x12, 0xb4, 0xbd, 0x1e, 0x6b, 0x72, 0x21,
    0x36, 0x43, 0x82, 0x03, 0x53, 0xc1, 0x0e, 0xfe, 0x2f, 0x6c, 0x81, 0xb0,
    0x10, 0x4d, 0x2e, 0x35, 0x7f, 0x29, 0x86, 0x82, 0xc9, 0x0d, 0xd0, 0xed,
    0xfd, 0x00, 0x97, 0xc2, 0x44, 0xf0, 0x2b, 0x33, 0x3f, 0x71, 0xf3, 0x4c,
    0xa6, 0xd9, 0xe9, 0x78, 0x67, 0x79, 0xef, 0x82, 0x86, 0xab, 0xa1, 0x66,
    0xfe, 0x03, 0x1e, 0x73, 0x88, 0x9a, 0x3f, 0xa8, 0xc7, 0x5b, 0x92, 0x00,
    0xf1, 0x93, 0x23, 0xf3, 0xe8, 0xab, 0x87, 0x07, 0x78, 0x89, 0x62, 0xbc,
    0x96, 0xc3, 0x87, 0xd8, 0x8c, 0xb5, 0x6b, 0xa2, 0x19, 0xa3, 0x26, 0x5e,
    0x62, 0xe3, 0x12, 0x7c, 0x3e, 0x3d, 0x30, 0xff, 0x39, 0x4a, 0x90, 0xe6,
    0xe8, 0x9d, 0x69, 0xae, 0xbb, 0xbb, 0x5e, 0xc3, 0x6c, 0x5e, 0xc7, 0x2f,
    0x79, 0x72, 0x90, 0x00, 0xec, 0xda, 0x23, 0xfb, 0x8e, 0x28, 0xb8, 0x1c,
    0xb5, 0x63, 0xf5, 0x76, 0xc8, 0x6b, 0xe2, 0x69, 0xe6, 0xc7, 0x25, 0xec,
    0x08, 0xf8, 0x69, 0xb3, 0x1b, 0x3b, 0xf1, 0x0b, 0x09, 0xde, 0xe9, 0x2a,
    0x25, 0x0e, 0x30, 0xaa, 0x44, 0x0d, 0x34, 0xc2, 0xcf, 0xae, 0xe2, 0xdb,
    0xb1, 0x3f, 0x39, 0x05, 0x44, 0xc8, 0x12, 0x47, 0x9c, 0xd9, 0x79, 0x5b,
    0x09, 0x47, 0x28, 0x5a, 0x69, 0xf5, 0x61, 0xd6, 0x75, 0x46, 0x93, 0x8b,
    0xde, 0x83, 0xe9, 0x0a, 0xc0, 0x24, 0xf0, 0x4b, 0xa0, 0x8b, 0x6b, 0x1d,
    0x92, 0x74, 0x45, 0xfe, 0xd1, 0x8c, 0x5e, 0xa9, 0x2e, 0xf1, 0x10, 0xe7,
    0x3e, 0x37, 0x88, 0x1c, 0x38, 0x32, 0x62, 0x0a, 0xf9, 0x94, 0x63, 0x33,
    0x7e, 0x68, 0x91, 0x02, 0x40, 0x40, 0x63, 0x62, 0xba, 0xfa, 0xee, 0x58,
    0x20, 0x25, 0x89, 0x7d, 0x6d, 0xea, 0x9b, 0x66, 0x98, 0xd5, 0xeb, 0x8e,
    0x8c, 0x03, 0xce, 0x84, 0xcd, 0x8b, 0x50, 0x7f, 0x0f, 0x37, 0x9f, 0x9a,
    0x2d, 0x73, 0x38, 0x42, 0xcc, 0x18, 0x6a, 0x4a, 0x62, 0xf8, 0x1b, 0x1a,
    0xd0, 0xf6, 0xa3, 0x31, 0x9e, 0x07, 0xe7, 0xe2, 0xcf, 0x3e, 0x34, 0x12,
    0xb2, 0x49, 0x98, 0x1b, 0x1c, 0x58, 0xcc, 0xb6, 0x1b, 0xfa, 0xe7, 0xb2,
    0x25, 0xf7, 0xd3, 0x7f, 0xb5, 0x55, 0x55, 0x5b, 0x14, 0xf6, 0x9c, 0x40,
    0x0f, 0xac, 0x1a, 0xc4, 0x1f, 0x80, 0x8e, 0x64, 0x11, 0xa4, 0x1b, 0xd3,
    0xe9, 0x58, 0xd8, 0xf7, 0x22, 0x2c, 0x85, 0x7d, 0x82, 0xec, 0xf0, 0xad,
    0xa9, 0x9a, 0x4e, 0xcc, 0x98, 0x14, 0x54, 0x9d, 0xc7, 0x0d, 0xd6, 0x45,
    0x48, 0x48, 0xe4, 0xb8, 0xc5, 0x75, 0x5c, 0x88, 0xea, 0xb3, 0xc3, 0xa7,
    0xed, 0x93, 0xa7, 0xbf, 0xdc, 0x2a, 0x3f, 0xaf, 0x0c, 0x04, 0x7b, 0xf9,
    0x8e, 0x01, 0x1d, 0x02, 0x6f, 0x66, 0x08, 0x03, 0x3f, 0x0a, 0xe1, 0x92,
    0x06, 0x6f, 0x86, 0xfc, 0x43, 0x60, 0x26, 0x55, 0x87, 0xba, 0x82, 0x5f,
    0x79, 0xc8, 0x14, 0x68, 0x91, 0x0b, 0xcb, 0x66, 0x14, 0x88, 0x84, 0xd3,
    0xa9, 0xa1, 0x75, 0x48, 0xa8, 0xd7, 0xaa, 0xd0, 0x81, 0xb3, 0xbc, 0x31,
    0xd9, 0xd8, 0x07, 0xac, 0xae, 0x9b, 0xf3, 0x98, 0x45, 0xe5, 0x50, 0x22,
    0x89, 0x3d, 0x52, 0x84, 0xfd, 0xd3, 0x4c, 0xee, 0xfb, 0xf4, 0x98, 0x2d,
    0x61, 0x4e, 0x86, 0xef, 0x9c, 0xcc, 0x92, 0x86, 0xd9, 0x2b, 0xdb, 0x3c,
    0x01, 0x18, 0x7c, 0x43, 0x6f, 0x3c, 0xda, 0x5f, 0x1f, 0x29, 0xff, 0xba,
    0x07, 0xa6, 0x98, 0x16, 0xf3, 0x2b, 0xa5, 0x2b, 0xa9, 0x9d, 0x05, 0x8c,
    0xc3, 0x55, 0xc8, 0x72, 0x99, 0xc2, 0x29, 0xbd, 0x0b, 0xe2, 0xf8, 0xc6,
    0x61, 0xf2, 0x08, 0xa9, 0x95, 0xda, 0xda, 0x47, 0x73, 0x69, 0x02, 0x21,
    0xad, 0xb5, 0x18, 0x63, 0xe5, 0x57, 0xc8, 0xe0, 0x3b, 0x21, 0xc3, 0x32,
    0xf7, 0x66, 0xc1, 0x5f, 0x51, 0x6c, 0x16, 0xd6, 0xf5, 0xda, 0x8d, 0x5a,
    0xdf, 0xd0, 0xf3, 0xc9, 0xa8, 0x0a, 0x84, 0x13, 0x93, 0x9e, 0x66, 0x29,
    0xc1, 0x33, 0xea, 0x79, 0x06, 0x93, 0x30, 0x43, 0x82, 0x97, 0x55, 0x31,
    0x2a, 0xe6, 0x4d, 0x77, 0x16, 0x10, 0x11, 0x8a, 0x7d, 0x2e, 0x14, 0xa0,
    0xf0, 0xc4, 0xc1, 0x8c, 0xe0, 0x9b, 0x46, 0x52, 0x48, 0xfb, 0x20, 0x1b,
    0xb8, 0x15, 0x06, 0xc1, 0x5d, 0xab, 0x37, 0x11, 0x9a, 0x5c, 0xb7, 0x19,
};

/* q=(p-1)/2 for prime prime_safe_8192 */
static const unsigned char sub2_prime_safe_8192[] = {
    0x4d, 0xd3, 0xcd, 0xd1, 0x43, 0x2a, 0x73, 0xcc, 0x88, 0xad, 0x9a, 0xc0,
    0xea, 0xbd, 0x45, 0x37, 0x26, 0xa6, 0xb0, 0xae, 0xe9, 0xe7, 0x86, 0x32,
    0xbf, 0x6d, 0x6c, 0x67, 0x14, 0x56, 0x50, 0x1c, 0x40, 0xf7, 0x50, 0x8a,
    0x12, 0x90, 0xb3, 0xb3, 0x1d, 0x36, 0x07, 0xc0, 0x1e, 0xc4, 0xbc, 0xff,
    0x38, 0xa1, 0xab, 0xe1, 0xd4, 0xaa, 0x0f, 0x10, 0x45, 0x77, 0x07, 0xd3,
    0x45, 0xc4, 0x40, 0x9e, 0xf4, 0x2e, 0x20, 0x23, 0x82, 0xef, 0xec, 0x36,
    0xcc, 0x32, 0x8b, 0x54, 0xfc, 0xe2, 0x46, 0x01, 0x5d, 0x57, 0x35, 0x9b,
    0x3b, 0x64, 0xfd, 0x47, 0x68, 0x6b, 0xcd, 0x1e, 0x65, 0xe8, 0xa2, 0x04,
    0xeb, 0xa7, 0x94, 0x28, 0xca, 0x49, 0x2d, 0x81, 0x59, 0x5e, 0xbc, 0x69,
    0xe1, 0x3b, 0x01, 0x8a, 0x8b, 0x85, 0xaa, 0x84, 0x01, 0x21, 0x4f, 0x13,
    0x2b, 0x19, 0xb9, 0x73, 0x5e, 0x87, 0x7c, 0x9e, 0x96, 0x59, 0xc5, 0x26,
    0x33, 0x8b, 0xfe, 0xf4, 0x81, 0xd6, 0xc6, 0x1a, 0x42, 0x72, 0xc1, 0xef,
    0xce, 0x02, 0x49, 0x81, 0x93, 0x0c, 0xe0, 0xf8, 0x92, 0x34, 0x7b, 0x2a,
    0x4b, 0x67, 0x1c, 0x28, 0xde, 0xb6, 0x1e, 0xce, 0x06, 0x6c, 0x37, 0x09,
    0xa6, 0x45, 0xfb, 0x1a, 0x57, 0x6c, 0x42, 0x8e, 0x8e, 0xc7, 0x61, 0x56,
    0xd5, 0xd1, 0x62, 0xa0, 0x3b, 0x3f, 0x97, 0x97, 0x1c, 0x7a, 0x35, 0x1c,
    0x99, 0x9e, 0x8b, 0xe7, 0x0f, 0xf4, 0xe1, 0xc6, 0xcf, 0x72, 0xdf, 0x6b,
    0x56, 0xcd, 0x11, 0xec, 0x03, 0x79, 0xbe, 0x1c, 0xea, 0xd7, 0x2b, 0xdb,
    0x72, 0xe1, 0xcd, 0x45, 0x46, 0x37, 0x69, 0xe0, 0x8d, 0x32, 0x09, 0x00,
    0x0c, 0x29, 0xe5, 0x19, 0x44, 0x47, 0x60, 0x2f, 0x96, 0xd9, 0x1e, 0x8a,
    0x0d, 0xac, 0x2e, 0x10, 0x74, 0x29, 0x72, 0x94, 0x20, 0xde, 0x4f, 0x04,
    0x14, 0xd5, 0xd2, 0xa1, 0xcc, 0x87, 0x6b, 0x95, 0x5c, 0xdc, 0x32, 0x4e,
    0xc1, 0xf1, 0x8d, 0x13, 0x2c, 0xb2, 0xf9, 0x06, 0x64, 0xe2, 0xc7, 0x86,
    0xe7, 0xd0, 0x8c, 0x7e, 0x45, 0xbb, 0xf4, 0xf0, 0x8c, 0xbd, 0x81, 0xea,
    0x1b, 0xc6, 0xae, 0x9b, 0x95, 0xd6, 0xac, 0x2f, 0x39, 0xb9, 0x67, 0x42,
    0x72, 0xe4, 0xba, 0x8e, 0xf9, 0xac, 0x21, 0x3b, 0xff, 0x29, 0xd0, 0x61,
    0x33, 0x10, 0xd7, 0xf1, 0x30, 0xe9, 0x42, 0x59, 0x81, 0xa6, 0xec, 0x3e,
    0xc2, 0xf0, 0xd4, 0x50, 0x24, 0x2e, 0x8d, 0x54, 0xd6, 0x60, 0xb4, 0x92,
    0x63, 0x7d, 0x5a, 0x91, 0x1f, 0x51, 0xc6, 0x9a, 0x94, 0xe7, 0xcd, 0x72,
    0xc2, 0x1d, 0x85, 0x93, 0x9b, 0x3f, 0x4e, 0xd3, 0x58, 0x22, 0xb0, 0x21,
    0x0f, 0x25, 0x92, 0x68, 0x9b, 0x45, 0xb8, 0x68, 0xca, 0xaa, 0x0a, 0x5c,
    0xa3, 0x9e, 0xc6, 0xf2, 0x2f, 0xc0, 0x8d, 0x10, 0x8b, 0x8b, 0xdf, 0xc9,
    0x11, 0x26, 0x3b, 0x98, 0x6e, 0x4e, 0x42, 0x73, 0x34, 0x66, 0x6b, 0x08,
    0x82, 0x7f, 0xb8, 0xc3, 0x59, 0xd4, 0xcd, 0x89, 0xca, 0x9a, 0xfe, 0xb4,
    0x14, 0x4d, 0xb7, 0xae, 0x7b, 0xb3, 0x54, 0x37, 0xc4, 0x87, 0xc9, 0x6f,
    0xa9, 0x12, 0x1f, 0xed, 0x97, 0xa0, 0x09, 0x19, 0x52, 0x7f, 0x97, 0x25,
    0xdc, 0x50, 0x73, 0xe4, 0xe5, 0xcc, 0x09, 0xfc, 0xe9, 0x7d, 0x41, 0x34,
    0x59, 0x47, 0xe9, 0x8b, 0xc6, 0x49, 0xfa, 0xc0, 0x72, 0x2d, 0x19, 0x8d,
    0xb5, 0x6c, 0x5f, 0x9b, 0xd3, 0xf0, 0xb1, 0x8e, 0xb5, 0x61, 0xfd, 0x50,
    0x97, 0xe0, 0xb9, 0x2a, 0xea, 0xf1, 0x33, 0x9d, 0xb5, 0x9d, 0x54, 0x58,
    0x2a, 0x02, 0x0e, 0xdd, 0xe0, 0xf2, 0x9d, 0x29, 0x58, 0xb3, 0x85, 0x89,
    0x1f, 0x66, 0xd4, 0xcd, 0x07, 0x5d, 0xd1, 0xba, 0xb6, 0xb7, 0xbb, 0xba,
    0x32, 0x71, 0x8b, 0x46, 0x52, 0xdd, 0x76, 0x28, 0xb9, 0xe7, 0x25, 0xf3,
    0x37, 0x9e, 0x8a, 0xab, 0x21, 0xf0, 0x8b, 0xbb, 0xb3, 0x55, 0xee, 0x4e,
    0xcd, 0x88, 0x2e, 0xe2, 0x74, 0x8f, 0x55, 0x16, 0x8a, 0xdd, 0xe2, 0x04,
    0xa3, 0x18, 0x70, 0xdc, 0x49, 0x4a, 0x2f, 0xdb, 0xf3, 0xbf, 0x4b, 0xa1,
    0xe0, 0x24, 0x2d, 0xd7, 0xf5, 0x3a, 0x57, 0x46, 0x3c, 0xb5, 0xb3, 0x41,
    0xb1, 0x44, 0x0b, 0xd2, 0x2b, 0x2e, 0xac, 0x7d, 0xb6, 0x1c, 0x2b, 0xa6,
    0xf7, 0xeb, 0x9b, 0x22, 0x1c, 0xad, 0xd5, 0xca, 0x72, 0x04, 0x18, 0x69,
    0x96, 0x2c, 0xd0, 0x19, 0x71, 0x38, 0xcc, 0xf6, 0x33, 0x2f, 0x7b, 0xf1,
    0x4e, 0x0c, 0xb4, 0xb9, 0x37, 0xed, 0x9f, 0x66, 0x0c, 0xad, 0x7e, 0xd6,
    0xeb, 0x37, 0x4e, 0x83, 0xe0, 0x32, 0x80, 0xba, 0xee, 0x9b, 0x8d, 0xce,
    0x2f, 0x49, 0x99, 0x7c, 0x3f, 0x32, 0xea, 0xda, 0x8a, 0x9a, 0xd6, 0x82,
    0xda, 0xe9, 0x12, 0xe3, 0xb8, 0xad, 0x72, 0x5b, 0xac, 0x35, 0x61, 0xad,
    0x6c, 0xea, 0x77, 0x19, 0x5a, 0x85, 0xad, 0x95, 0x66, 0xc0, 0x67, 0x6a,
    0x16, 0xe4, 0x84, 0xca, 0x7a, 0xf9, 0x3e, 0x57, 0xdd, 0x2d, 0x69, 0xee,
    0x66, 0xeb, 0xfb, 0xf5, 0x21, 0x71, 0x61, 0x1a, 0x10, 0xdc, 0x8a, 0x92,
    0x74, 0x19, 0x35, 0xb7, 0xd8, 0x76, 0xbb, 0x2f, 0x22, 0xdf, 0x81, 0x51,
    0x5c, 0x1e, 0x52, 0xfa, 0xba, 0x71, 0x8c, 0x44, 0x90, 0xa7, 0x53, 0x04,
    0x51, 0xd2, 0xc9, 0xb4, 0xa4, 0x4b, 0x5e, 0xa3, 0xe9, 0xf5, 0xb3, 0x94,
    0xd4, 0x5d, 0xdf, 0x3c, 0x02, 0xfd, 0x23, 0x44, 0xa7, 0x06, 0x71, 0x36,
    0x5d, 0xf2, 0xfc, 0x5d, 0x72, 0xae, 0x94, 0xf3, 0xee, 0xb8, 0xbf, 0x4a,
    0x6b, 0xab, 0x06, 0x1e, 0x6f, 0x2f, 0xde, 0x6e, 0x07, 0xc7, 0x6b, 0x37,
    0x85, 0x03, 0xdc, 0x03, 0x92, 0x31, 0x26, 0x76, 0xa2, 0xa7, 0x86, 0xcf,
    0x97, 0x41, 0xb5, 0x75, 0xde, 0x7f, 0xd4, 0xf9, 0x39, 0xd9, 0xad, 0xd5,
    0x56, 0x76, 0xd6, 0x44, 0x51, 0x06, 0xc6, 0xc7, 0xda, 0x7b, 0xb9, 0x8f,
    0x60, 0x17, 0x69, 0xa2, 0x8a, 0xa5, 0xa5, 0x73, 0xea, 0x77, 0xd8, 0xe3,
    0x69, 0xc7, 0xfc, 0x12, 0x09, 0x19, 0x9f, 0x47, 0x4a, 0xde, 0x40, 0xda,
    0x6a, 0x68, 0x89, 0xde, 0x3f, 0x12, 0xda, 0x2d, 0xff, 0x8a, 0xdd, 0x7c,
    0x4d, 0x76, 0x3c, 0x72, 0x31, 0xe3, 0x93, 0x6a, 0xc4, 0x9e, 0xb1, 0xad,
    0xbe, 0x43, 0x31, 0x9a, 0x03, 0x14, 0x11, 0x84, 0x7f, 0xb6, 0xde, 0xf0,
    0x3a, 0xd9, 0xb8, 0x89, 0x13, 0x31, 0xe5, 0x49, 0x9b, 0x43, 0x75, 0xfb,
    0xa4, 0x68, 0xcb, 0x7a, 0x01, 0x1f, 0x2e, 0xb4, 0xba, 0xaf, 0x4a, 0xf7,
    0x19, 0x5c, 0xdd, 0x2a, 0xe2, 0xa1, 0x3a, 0x00, 0x70, 0x87, 0x8b, 0x02,
    0xb1, 0x1e, 0x2c, 0x65, 0xf0, 0x6a, 0x54, 0xf2, 0x8d, 0x1d, 0xc2, 0x3f,
    0x0c, 0xc3, 0xd6, 0xb3, 0xe6, 0xcd, 0xcb, 0xd8, 0x19, 0x6b, 0xdc, 0x0f,
    0x4b, 0x34, 0xba, 0x87, 0xb0, 0xb4, 0xd9, 0xe4, 0xe7, 0x39, 0xbe, 0x2f,
    0xea, 0x84, 0x6f, 0xea, 0x03, 0xba, 0xb0, 0x6b, 0xa8, 0x29, 0x73, 0xae,
    0x37, 0x82, 0x2c, 0xb2, 0xde, 0xb8, 0x4c, 0x8a, 0xfc, 0xde, 0x1a, 0x3c,
    0x35, 0x32, 0x56, 0x2f, 0x83, 0xe1, 0x44, 0xc4, 0x7f, 0x08, 0xbd, 0x7b,
    0x9e, 0xdf, 0x41, 0xff, 0xf5, 0x8e, 0xa9, 0x5f, 0x6a, 0x04, 0xb8, 0x87,
    0xbe, 0x4a, 0x8c, 0xf9, 0x25, 0xfa, 0xa2, 0x31, 0xf9, 0x76, 0x1f, 0xfc,
    0xf2, 0x7d, 0xdf, 0x12, 0x59, 0x0c, 0x29, 0xe7, 0x0b, 0x20, 0x0f, 0x13,
    0xb1, 0x4c, 0xc9, 0xe4, 0xa4, 0xc7, 0xcc, 0x06, 0xec, 0x39, 0xb2, 0xcc,
    0xd6, 0x7f, 0xff, 0x11, 0x35, 0x68, 0xfd, 0xd0, 0xf2, 0x73, 0xd5, 0x9e,
    0x39, 0x08, 0x56, 0x39,
};
#endif

/* q=(p-1)/2 for prime prime_weak_1024 */
static const unsigned char sub2_prime_weak_1024[] = {
    0x72, 0x41, 0x04, 0xa5, 0x35, 0xdf, 0x4d, 0xa8, 0x88, 0xd0, 0x3a, 0x12,
    0xff, 0xa8, 0x0e, 0x05, 0x6b, 0x68, 0x5e, 0x69, 0x92, 0x44, 0xba, 0xba,
    0x59, 0xeb, 0x35, 0xfa, 0x63, 0xaf, 0xb5, 0x76, 0x0f, 0x1d, 0x10, 0x01,
    0x0b, 0x3a, 0xe6, 0x22, 0x25, 0x5f, 0xad, 0xac, 0x56, 0xff, 0x58, 0x0c,
    0x35, 0x1c, 0x45, 0xe5, 0xed, 0xe8, 0xbb, 0xa1, 0x71, 0xd1, 0xc3, 0xc5,
    0x4c, 0x97, 0x08, 0xec, 0x64, 0x81, 0x42, 0x0e, 0xe9, 0x33, 0x94, 0x5e,
    0xc7, 0xfd, 0xab, 0x79, 0x31, 0xc5, 0x16, 0x3e, 0x1c, 0x77, 0xd1, 0x06,
    0x35, 0x1b, 0x68, 0x4c, 0x89, 0xa3, 0xa4, 0x20, 0x72, 0xe6, 0xed, 0x82,
    0x26, 0x51, 0x09, 0x1f, 0x8d, 0x4d, 0xcd, 0x07, 0x5c, 0x34, 0x3e, 0x80,
    0xde, 0x0b, 0x37, 0xa8, 0xb2, 0x0e, 0xd5, 0x90, 0xba, 0xa4, 0x89, 0x1b,
    0x56, 0x32, 0xc5, 0xfc, 0x43, 0xec, 0xd7, 0xe8,
};

/* q=(p-1)/2 for prime prime_weak_2048 */
static const unsigned char sub2_prime_weak_2048[] = {
    0x5a, 0x84, 0x41, 0xb5, 0x11, 0x1c, 0xef, 0x81, 0x7f, 0x39, 0xb5, 0xfd,
    0x86, 0xa7, 0x56, 0xa5, 0x87, 0xfe, 0xd9, 0x13, 0xf3, 0xe9, 0x1a, 0xea,
    0x41, 0xf9, 0x5e, 0x14, 0xff, 0xa8, 0x7b, 0xb5, 0xdb, 0xca, 0x1c, 0x7f,
    0xee, 0x3c, 0xb3, 0xcd, 0x40, 0x45, 0xe1, 0x10, 0x27, 0x29, 0x81, 0x15,
    0x03, 0xf6, 0x54, 0xde, 0x91, 0x68, 0xdd, 0x1a, 0x98, 0x88, 0x10, 0xdb,
    0x27, 0xf0, 0xca, 0x05, 0xd8, 0x59, 0x9b, 0x90, 0x06, 0xb5, 0x6a, 0x48,
    0xae, 0x42, 0xf4, 0xd7, 0x45, 0x79, 0x4a, 0x73, 0xa2, 0x7a, 0xe6, 0x02,
    0x41, 0x2b, 0xc0, 0x90, 0xc1, 0x8c, 0x24, 0x16, 0xf1, 0x8e, 0x50, 0xbf,
    0xf7, 0x08, 0x5c, 0xf4, 0x20, 0x7e, 0x6d, 0x21, 0xbe, 0x8c, 0x72, 0x34,
    0x4f, 0xf6, 0xaf, 0x61, 0x8f, 0xc0, 0x77, 0xae, 0x12, 0x2f, 0x34, 0x56,
    0x4c, 0xce, 0x3a, 0x4b, 0x2d, 0xd9, 0xf3, 0xd9, 0x32, 0xbc, 0x7d, 0x9e,
    0x08, 0x80, 0x02, 0x25, 0xcc, 0x07, 0x45, 0x3d, 0x9c, 0x04, 0x1a, 0x5c,
    0xb6, 0x84, 0x32, 0x8b, 0xc8, 0xa4, 0xb1, 0x23, 0xb2, 0x55, 0xe3, 0x68,
    0x79, 0x67, 0xc4, 0x83, 0xf5, 0xd1, 0xae, 0xf9, 0xd1, 0x7d, 0xee, 0xbd,
    0x9f, 0x3f, 0x51, 0x6b, 0x8d, 0x21, 0x56, 0xba, 0x5e, 0xdd, 0xe7, 0x90,
    0xc8, 0xe9, 0x35, 0x8e, 0xce, 0xd4, 0x02, 0xc4, 0x27, 0xd8, 0xa2, 0xd1,
    0x43, 0x48, 0x09, 0x7e, 0xe5, 0x92, 0xf0, 0x89, 0x04, 0x23, 0x8e, 0xc1,
    0x96, 0x8a, 0x21, 0x10, 0x04, 0x18, 0xaa, 0x16, 0x4d, 0xa4, 0xfb, 0x5b,
    0x16, 0x92, 0xf5, 0x14, 0x5f, 0x89, 0x95, 0xe9, 0xa2, 0xc6, 0x81, 0x4f,
    0xd2, 0xd5, 0x75, 0xe0, 0x24, 0x68, 0x83, 0x73, 0x0f, 0x50, 0x1f, 0x02,
    0x10, 0x3c, 0xbe, 0x68, 0xe8, 0x56, 0x30, 0xc4, 0xb6, 0x1d, 0xc4, 0x51,
    0xaa, 0x36, 0x40, 0x2c,
};

/* q=(p-1)/2 for prime prime_weak_3072 */
static const unsigned char sub2_prime_weak_3072[] = {
    0x4a, 0x19, 0x63, 0xa3, 0xa8, 0xd1, 0x81, 0xcd, 0xf9, 0x28, 0xae, 0x34,
    0xd7, 0x82, 0x9e, 0x3b, 0x31, 0x51, 0x76, 0x2d, 0x66, 0x6f, 0xc0, 0x79,
    0x96, 0xe7, 0x52, 0xd2, 0xcf, 0x16, 0xd5, 0xaf, 0xc8, 0xde, 0xc9, 0xb0,
    0xeb, 0xbd, 0xb8, 0xb7, 0xf9, 0xc9, 0x5f, 0xd4, 0x7e, 0x66, 0x80, 0x7a,
    0xa4, 0x84, 0x00, 0x46, 0x69, 0x7f, 0x25, 0x6c, 0x15, 0xb7, 0x21, 0x60,
    0x6c, 0x51, 0x45, 0x95, 0x8c, 0x01, 0x56, 0xf4, 0x27, 0x22, 0x04, 0x93,
    0x50, 0xd0, 0xe5, 0x4c, 0xf1, 0xec, 0xcd, 0x43, 0x9e, 0x41, 0xb5, 0x0d,
    0x3d, 0xb0, 0x5d, 0x3c, 0x06, 0x3c, 0xa8, 0x0f, 0xef, 0x20, 0x0a, 0x2c,
    0x0c, 0x54, 0x95, 0xba, 0x08, 0xda, 0x32, 0xff, 0x4e, 0x81, 0xd2, 0x77,
    0xef, 0xba, 0x47, 0x66, 0xbd, 0xea, 0x79, 0x94, 0x3a, 0xd9, 0x18, 0xf7,
    0xcc, 0xb2, 0xe5, 0xad, 0x3b, 0xe5, 0x51, 0x12, 0x94, 0x57, 0x7d, 0x4f,
    0xf5, 0xed, 0x66, 0x1a, 0x3d, 0x90, 0xeb, 0xed, 0xaa, 0x20, 0x73, 0x17,
    0xed, 0xe0, 0x67, 0x6e, 0x72, 0xe4, 0x93, 0xcb, 0xcc, 0xce, 0x01, 0x27,
    0x92, 0x44, 0x49, 0xef, 0xd4, 0xe3, 0x9f, 0x08, 0x64, 0x55, 0x35, 0x67,
    0x6d, 0x23, 0x4a, 0x46, 0x56, 0x8f, 0x78, 0xe5, 0xe9, 0xe6, 0xa1, 0xa2,
    0x5a, 0x10, 0x48, 0xcf, 0x7b, 0x68, 0x81, 0xf7, 0xe1, 0x02, 0x7b, 0x83,
    0xed, 0xd6, 0x51, 0x14, 0x46, 0x3e, 0x8e, 0xae, 0x96, 0x2d, 0x7e, 0x13,
    0x2d, 0x85, 0xac, 0x5c, 0xcd, 0x23, 0xf4, 0xd0, 0x6f, 0xd2, 0xad, 0x79,
    0xf2, 0xeb, 0x75, 0xb4, 0xda, 0xa7, 0x5e, 0x38, 0xe0, 0x6b, 0x4d, 0xdc,
    0x20, 0x1d, 0xe2, 0xb9, 0x2e, 0xa6, 0x8d, 0x8b, 0x9e, 0x9b, 0x52, 0x58,
    0x8a, 0xd3, 0xcd, 0x39, 0x75, 0xf9, 0x4f, 0x20, 0x68, 0xde, 0x1a, 0xe3,
    0xe8, 0x8d, 0x47, 0x8e, 0x15, 0xaf, 0x6c, 0x59, 0x9d, 0xa2, 0x57, 0x7a,
    0xc0, 0xe8, 0x45, 0x1b, 0xd5, 0xdd, 0x11, 0x5e, 0x16, 0xc4, 0x17, 0x92,
    0x5d, 0xd8, 0x0d, 0x54, 0xaf, 0x83, 0x88, 0x36, 0xe3, 0x5d, 0x9e, 0x51,
    0x33, 0x7c, 0xdc, 0xca, 0xeb, 0x2f, 0x46, 0x67, 0x02, 0x6e, 0x59, 0xa6,
    0x5e, 0x74, 0xe2, 0xe5, 0x8c, 0xcb, 0xf1, 0x50, 0x84, 0x9c, 0x6b, 0xc1,
    0x53, 0x5f, 0xe4, 0x8a, 0x92, 0xf8, 0x96, 0x3b, 0xfe, 0x5e, 0xfd, 0x3f,
    0xc9, 0x7f, 0x6b, 0x18, 0x81, 0x91, 0x96, 0x8b, 0x97, 0xa8, 0xcf, 0x2e,
    0x58, 0xb4, 0x60, 0x1f, 0xa1, 0x4c, 0x80, 0x2a, 0x99, 0xb4, 0x6b, 0xf7,
    0x28, 0xbe, 0x9f, 0x01, 0xa7, 0x81, 0x2f, 0x93, 0xee, 0x8b, 0x8c, 0x36,
    0x0f, 0x4e, 0xc8, 0xb2, 0xfc, 0x6b, 0xd3, 0x4f, 0xd0, 0xdd, 0x54, 0x3b,
    0x72, 0x6c, 0x7a, 0x2c, 0xc8, 0x0b, 0x33, 0xc4, 0x61, 0x54, 0xf2, 0x16,
};

/* q=(p-1)/2 for prime prime_weak_4096 */
static const unsigned char sub2_prime_weak_4096[] = {
    0x7f, 0xa8, 0x69, 0xe6, 0x44, 0x8b, 0xaf, 0x5b, 0x7c, 0x51, 0xd8, 0x71,
    0x7c, 0xcf, 0x8b, 0xd0, 0xc9, 0x2b, 0x0a, 0x89, 0x89, 0x4f, 0x8c, 0x6e,
    0x03, 0x80, 0x61, 0x24, 0xe4, 0xec, 0xea, 0x05, 0x71, 0xeb, 0xfb, 0x30,
    0x10, 0xd4, 0xbd, 0xe0, 0x07, 0x87, 0x57, 0x1f, 0x3b, 0xbb, 0xa4, 0x6c,
    0x7e, 0xa1, 0x76, 0x5a, 0xd7, 0x00, 0x55, 0xe7, 0x68, 0x88, 0xe5, 0x69,
    0x32, 0x2d, 0x51, 0xb5, 0xdd, 0x68, 0xc9, 0xf5, 0x6d, 0x69, 0x50, 0x30,
    0x1c, 0x85, 0x9a, 0x27, 0x86, 0x78, 0xd8, 0x29, 0x3a, 0xa8, 0x9e, 0x94,
    0x01, 0x5a, 0xde, 0xa1, 0x4c, 0x10, 0x53, 0xa1, 0x5c, 0x90, 0xcd, 0x57,
    0x5b, 0x20, 0xbd, 0xb8, 0x71, 0xec, 0xd7, 0xc0, 0x8d, 0x60, 0x9c, 0xce,
    0x29, 0x2b, 0x65, 0x86, 0xb5, 0x33, 0xb7, 0x9e, 0x89, 0x3b, 0x39, 0xa9,
    0xca, 0x96, 0xe0, 0x82, 0x6d, 0xc1, 0xf2, 0x68, 0x5f, 0x16, 0xd3, 0x3d,
    0x07, 0xc0, 0x0d, 0xe8, 0x0b, 0x0a, 0x1d, 0x70, 0x24, 0x7d, 0x7a, 0xa2,
    0x54, 0x70, 0x5f, 0xcc, 0x70, 0xab, 0x75, 0x3b, 0x5b, 0x71, 0x51, 0xad,
    0x8a, 0xbc, 0x88, 0x58, 0x20, 0xee, 0x14, 0x87, 0x8f, 0x1b, 0xb4, 0xe6,
    0x89, 0xdf, 0x16, 0xf0, 0x39, 0x9c, 0x34, 0x76, 0xa8, 0x35, 0x68, 0x7d,
    0xe5, 0x8b, 0x9d, 0x2c, 0xfd, 0xf6, 0x5d, 0x3a, 0xdb, 0x27, 0x17, 0xb7,
    0x4b, 0xcc, 0x07, 0x3c, 0x92, 0xee, 0xec, 0x7a, 0x9a, 0x5a, 0x50, 0x3f,
    0x5d, 0x34, 0x3e, 0x27, 0xfd, 0xf0, 0x4b, 0xa3, 0x28, 0x0f, 0x25, 0x2c,
    0xce, 0x6e, 0x1a, 0x71, 0x15, 0x5a, 0xe4, 0x2c, 0x4a, 0x24, 0x4f, 0xdc,
    0x1b, 0x65, 0xe7, 0x1b, 0x58, 0xbe, 0x72, 0xc6, 0xad, 0xa1, 0xeb, 0xc4,
    0x6f, 0xd7, 0x68, 0x64, 0xa1, 0x2f, 0x85, 0x71, 0xb1, 0x88, 0xe2, 0x86,
    0x40, 0x2a, 0xac, 0x6b, 0xf9, 0x28, 0xb7, 0x59, 0xbf, 0x4e, 0x8e, 0x61,
    0xb0, 0xac, 0xae, 0x23, 0xea, 0x4c, 0xe0, 0x33, 0xfd, 0xd9, 0x6b, 0x08,
    0xed, 0x49, 0x2d, 0xb5, 0xe9, 0x38, 0x5b, 0xb4, 0xb9, 0x73, 0x83, 0x6e,
    0xa0, 0x56, 0x40, 0xa8, 0x8e, 0xa9, 0x3d, 0x22, 0x9c, 0x44, 0x93, 0x96,
    0x62, 0x25, 0xbf, 0x2f, 0x3c, 0xf7, 0xc2, 0x35, 0x12, 0x26, 0xce, 0x4f,
    0x65, 0x3a, 0xae, 0x03, 0x36, 0xe8, 0x29, 0x74, 0xed, 0x4f, 0xa3, 0x5b,
    0x31, 0x0e, 0xd9, 0xec, 0xf9, 0x3e, 0xeb, 0x61, 0x3d, 0x24, 0xbe, 0x6e,
    0xcd, 0xd5, 0x61, 0xc2, 0x05, 0x84, 0x19, 0xdc, 0x40, 0x61, 0x89, 0x47,
    0xd6, 0xd6, 0x07, 0xbf, 0xd7, 0xac, 0xb0, 0x86, 0xcc, 0x60, 0xfc, 0xb4,
    0x61, 0x8d, 0x88, 0x04, 0x62, 0x19, 0x9e, 0x52, 0x71, 0x6a, 0xf5, 0xb8,
    0xae, 0x8c, 0xbf, 0x02, 0xe5, 0x4d, 0x7a, 0xdd, 0xb8, 0xaa, 0xc1, 0xce,
    0x12, 0xa8, 0x1a, 0xbf, 0x96, 0xf5, 0xf9, 0x06, 0xf6, 0x9e, 0x5c, 0x38,
    0xde, 0x84, 0x7a, 0xc4, 0xbf, 0x2f, 0x1c, 0x20, 0x6b, 0xf6, 0xbb, 0xc6,
    0xbd, 0x76, 0x95, 0x4f, 0xfe, 0x00, 0xfa, 0x71, 0x67, 0xed, 0x46, 0x51,
    0xab, 0xee, 0x0a, 0x6b, 0x50, 0xec, 0xcb, 0xdc, 0xf3, 0x7e, 0x24, 0x3a,
    0xa1, 0xde, 0x9d, 0xc8, 0x8b, 0x9e, 0x19, 0xe5, 0x67, 0x14, 0x84, 0x8d,
    0xf4, 0x4e, 0xdb, 0x3a, 0x02, 0xaf, 0x17, 0x52, 0x8e, 0xbf, 0x9d, 0x54,
    0x96, 0x7b, 0x26, 0xa0, 0xc8, 0x5e, 0x2b, 0x0c, 0x29, 0x01, 0x48, 0x77,
    0xb8, 0xff, 0x9f, 0x06, 0x7c, 0x00, 0x02, 0x03, 0xea, 0x90, 0x13, 0x6e,
    0xae, 0x58, 0x9b, 0x81, 0x90, 0x06, 0x5a, 0x5b, 0x1c, 0xa4, 0xa4, 0xd5,
    0x73, 0xcc, 0x00, 0xd1, 0x17, 0x05, 0x19, 0xc1, 0x4f, 0x5c, 0x92, 0x5b,
    0xc0, 0x6f, 0xe9, 0xef, 0x82, 0x72, 0x28, 0x4e,
};

#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
/* q=(p-1)/2 for prime prime_weak_6144 */
static const unsigned char sub2_prime_weak_6144[] = {
    0x51, 0x12, 0x4b, 0x5b, 0x10, 0xb4, 0x6a, 0xbf, 0x16, 0x30, 0x26, 0xe4,
    0x40, 0xac, 0xce, 0x0e, 0x38, 0x76, 0x12, 0x14, 0x5b, 0x29, 0x1b, 0x04,
    0xc3, 0xd5, 0x60, 0xad, 0xf2, 0xd3, 0x1f, 0x44, 0x2a, 0x02, 0xf1, 0x84,
    0x84, 0xe5, 0x36, 0xcd, 0xe2, 0x46, 0x93, 0x57, 0xeb, 0xf7, 0x4f, 0x86,
    0xde, 0xa2, 0x47, 0x7f, 0x66, 0xf9, 0x73, 0x6f, 0x56, 0x79, 0x01, 0x1b,
    0xee, 0x1a, 0xe1, 0x67, 0x66, 0xaf, 0xe2, 0xc3, 0x87, 0xcc, 0xd3, 0xed,
    0x87, 0x8d, 0x66, 0xbb, 0x55, 0x25, 0x52, 0x84, 0xb0, 0x30, 0x71, 0xac,
    0x72, 0x29, 0x03, 0x8d, 0xa1, 0x0b, 0x88, 0xa8, 0x15, 0xa0, 0x4a, 0xc6,
    0xa4, 0x50, 0x1a, 0x4a, 0x92, 0x9c, 0x67, 0x84, 0xca, 0x73, 0x2a, 0x83,
    0x45, 0x6f, 0x6e, 0x20, 0xa5, 0x6c, 0x8f, 0xc0, 0x41, 0x0e, 0xdc, 0x0f,
    0x42, 0x30, 0x6f, 0x76, 0xa7, 0xe0, 0x6c, 0x0e, 0xaa, 0x6d, 0x59, 0xf9,
    0x87, 0x2a, 0x1f, 0x8c, 0x44, 0x7f, 0x92, 0x98, 0xe3, 0x0b, 0x73, 0x38,
    0x7d, 0x62, 0x04, 0x7e, 0x00, 0x45, 0xfb, 0x4e, 0x94, 0xc5, 0x2c, 0xa4,
    0xf6, 0xae, 0x1a, 0x3d, 0x42, 0x3c, 0xa0, 0x60, 0xbf, 0x41, 0x0b, 0x9b,
    0x64, 0x4b, 0x5a, 0xe9, 0x7c, 0xed, 0xe0, 0x08, 0x4f, 0xfc, 0x4a, 0x9a,
    0xb7, 0xd8, 0x5c, 0xa4, 0x44, 0x6e, 0x78, 0x26, 0x98, 0x66, 0x8a, 0xfe,
    0x97, 0xdd, 0x0c, 0x66, 0x4a, 0x28, 0x1f, 0xff, 0x30, 0x1e, 0xbd, 0x23,
    0x77, 0xe2, 0x66, 0x8a, 0x70, 0x77, 0xcb, 0xc0, 0xd0, 0xca, 0xf1, 0xd2,
    0xc8, 0xcd, 0x7b, 0xcf, 0xbe, 0x7d, 0x06, 0x34, 0xdb, 0x6f, 0xed, 0xd7,
    0x98, 0xec, 0x54, 0x3b, 0xb5, 0x5d, 0x5d, 0x40, 0x7f, 0x9f, 0xaf, 0xc3,
    0x4f, 0xc0, 0x01, 0x8f, 0x68, 0x2f, 0x9b, 0xa8, 0x30, 0xfe, 0x01, 0xec,
    0x49, 0xd0, 0xbc, 0xb1, 0x7d, 0x49, 0x5c, 0x25, 0x33, 0x4c, 0xeb, 0xc2,
    0xc6, 0x87, 0x83, 0x81, 0x01, 0xc1, 0xc6, 0x10, 0x52, 0xce, 0x17, 0xfe,
    0x91, 0x2d, 0x78, 0x4a, 0x8f, 0x5f, 0x8b, 0xf8, 0x9d, 0x20, 0x3f, 0xe7,
    0x4a, 0x31, 0x2f, 0xac, 0x72, 0xf9, 0xcc, 0xc6, 0x1c, 0x47, 0x82, 0x88,
    0x34, 0x75, 0x20, 0xda, 0xe0, 0x37, 0xa7, 0xb1, 0xc3, 0x8e, 0xcc, 0x61,
    0x98, 0xb3, 0x0f, 0x4f, 0x96, 0x9e, 0x37, 0x4f, 0xd9, 0xe7, 0xc7, 0x3b,
    0xfa, 0x9e, 0x28, 0xad, 0x77, 0x41, 0x50, 0xe2, 0xa9, 0x90, 0x3a, 0xe8,
    0xd4, 0x01, 0x1b, 0xa1, 0x84, 0x0b, 0x02, 0x80, 0xf6, 0xf5, 0x78, 0xa9,
    0x2c, 0x10, 0x4a, 0x42, 0x82, 0x97, 0x24, 0x1f, 0xa3, 0xa4, 0xa7, 0x80,
    0xa2, 0x5e, 0x8f, 0x21, 0x75, 0x48, 0x48, 0x11, 0xcc, 0x82, 0xfe, 0x9b,
    0xa0, 0x86, 0x17, 0xe2, 0x10, 0x02, 0x4c, 0xf7, 0x07, 0xdd, 0xe1, 0x36,
    0x85, 0x3f, 0x92, 0x2d, 0x0b, 0xd2, 0x75, 0xce, 0x33, 0xff, 0x32, 0x06,
    0xf5, 0x5b, 0x90, 0x24, 0x20, 0x1d, 0x92, 0xf6, 0xa8, 0xae, 0x7e, 0x10,
    0x0c, 0x5b, 0x7e, 0x1f, 0x6d, 0xec, 0xd0, 0xde, 0xcf, 0x77, 0x65, 0xae,
    0x81, 0x7f, 0x3f, 0xa1, 0x4e, 0xe4, 0xe7, 0x7d, 0x70, 0xec, 0x79, 0x02,
    0xb3, 0x9a, 0xc4, 0x27, 0x6b, 0xb8, 0x4b, 0xb1, 0xda, 0x86, 0x30, 0x44,
    0xe0, 0x7f, 0x19, 0x6b, 0xd7, 0x25, 0xf8, 0x85, 0x57, 0x1e, 0x6f, 0x0c,
    0x4e, 0x0e, 0xe9, 0x6d, 0x79, 0x01, 0x46, 0xf8, 0x83, 0xeb, 0x2f, 0x5b,
    0xdd, 0x57, 0xc0, 0xcb, 0xf7, 0x70, 0x4e, 0xa8, 0xf9, 0x8e, 0xe0, 0xae,
    0xa1, 0xf1, 0x05, 0x86, 0x4e, 0x06, 0xba, 0x48, 0x90, 0x37, 0xb2, 0xf8,
    0xf9, 0x42, 0x01, 0x1c, 0x5a, 0xf2, 0x88, 0x10, 0xfe, 0x73, 0x61, 0xa5,
    0xb0, 0x24, 0xb5, 0x78, 0xea, 0xa8, 0x07, 0xb7, 0xc5, 0x8f, 0x40, 0x79,
    0xae, 0x94, 0xf7, 0x30, 0x55, 0x93, 0x52, 0xc6, 0x62, 0x26, 0x65, 0xd3,
    0x55, 0x71, 0xff, 0x68, 0xb3, 0xa4, 0x5a, 0x7d, 0x5f, 0xab, 0xff, 0x31,
    0x42, 0xd0, 0x56, 0x6e, 0x27, 0x38, 0x80, 0xe6, 0x09, 0x76, 0x40, 0x4a,
    0xaa, 0x6e, 0x0a, 0x4f, 0x10, 0x6d, 0x2d, 0x5e, 0xf7, 0x3b, 0x5f, 0x1c,
    0xe7, 0xde, 0xc5, 0x71, 0x87, 0x38, 0xc2, 0xf2, 0x1e, 0x31, 0x1d, 0xfc,
    0x37, 0x38, 0x6a, 0x6b, 0x17, 0x70, 0x2f, 0x08, 0xce, 0x99, 0xec, 0x98,
    0x7f, 0x9d, 0xe6, 0x15, 0x1c, 0xe2, 0x37, 0xfe, 0xe5, 0x44, 0x56, 0x94,
    0x51, 0x74, 0x54, 0x6b, 0xf3, 0x04, 0x06, 0xd7, 0xce, 0xec, 0x64, 0x20,
    0xb3, 0x42, 0x33, 0x43, 0x15, 0xc0, 0x9d, 0xb6, 0x63, 0x3b, 0x13, 0xb5,
    0x06, 0xcb, 0x07, 0x32, 0x9f, 0x6f, 0xfa, 0xb4, 0x02, 0x4e, 0x96, 0x93,
    0x45, 0xe5, 0x05, 0x3c, 0x95, 0x5a, 0x50, 0x59, 0x8c, 0x25, 0x75, 0x35,
    0x69, 0x0a, 0x66, 0xa3, 0xc2, 0xcf, 0xc3, 0x6b, 0xef, 0x55, 0x0f, 0x07,
    0x38, 0x89, 0xf6, 0x7f, 0x3e, 0x34, 0xdf, 0x91, 0x78, 0x30, 0xa8, 0x4b,
    0xbb, 0xe1, 0x15, 0x98, 0xc4, 0x88, 0xeb, 0x04, 0x58, 0xea, 0x67, 0x5d,
    0x50, 0x0b, 0x4e, 0x15, 0xc5, 0x9f, 0x0b, 0xec, 0x75, 0x70, 0xf8, 0x90,
    0x3f, 0x9f, 0x3b, 0x4f, 0x97, 0xa3, 0x61, 0xd7, 0xe2, 0x5d, 0x64, 0xb1,
    0xfb, 0xdd, 0xcc, 0x36, 0xb0, 0x0b, 0x02, 0x0a, 0x61, 0x76, 0x97, 0x61,
    0x80, 0x27, 0xc7, 0xce, 0xe3, 0x6c, 0xe6, 0xe0, 0xd5, 0xa7, 0x33, 0xf6,
    0xfc, 0x69, 0x31, 0x09, 0xfd, 0x08, 0x98, 0xdd, 0x84, 0x6e, 0xa7, 0x44,
    0xa5, 0x7f, 0x83, 0xc4, 0xda, 0xb6, 0x61, 0xff, 0x3b, 0x36, 0x88, 0x26,
    0x0f, 0x08, 0x2a, 0x91, 0x4a, 0xff, 0x04, 0xd2, 0xb7, 0x39, 0x86, 0x15,
};

/* q=(p-1)/2 for prime prime_weak_8192 */
static const unsigned char sub2_prime_weak_8192[] = {
    0x49, 0xef, 0xb6, 0x9b, 0xee, 0x15, 0x52, 0x55, 0xae, 0xee, 0x39, 0xa1,
    0x09, 0x0c, 0x47, 0x9c, 0xa3, 0xb9, 0xfa, 0x9f, 0x5e, 0x37, 0x06, 0x95,
    0x34, 0x2e, 0xa9, 0xa7, 0x91, 0x46, 0x54, 0x54, 0x25, 0x56, 0x35, 0x30,
    0x2a, 0x65, 0x0d, 0x3a, 0xed, 0x42, 0x81, 0x2f, 0x40, 0x5d, 0xcd, 0xad,
    0x3a, 0x4b, 0x34, 0xe1, 0x3e, 0x42, 0x0f, 0xbb, 0x06, 0xa9, 0xf2, 0x05,
    0x99, 0x79, 0xa5, 0xfb, 0x49, 0x2d, 0x96, 0x4c, 0x2e, 0xd4, 0xb0, 0x6e,
    0x0b, 0xad, 0xfd, 0xda, 0x87, 0x1c, 0x57, 0x31, 0x8b, 0x3c, 0xd2, 0x62,
    0xbb, 0x3a, 0x10, 0x4b, 0xad, 0xee, 0x54, 0xc4, 0x68, 0x8a, 0x23, 0x1f,
    0x0e, 0xf3, 0x65, 0x5a, 0x9c, 0x2b, 0xfe, 0xf5, 0xb3, 0x15, 0x7d, 0x46,
    0x18, 0x03, 0xf5, 0x5a, 0x5e, 0x3c, 0x99, 0x8a, 0x6f, 0xc7, 0x8e, 0xb0,
    0x23, 0xe3, 0x91, 0xec, 0xbf, 0xf1, 0x8e, 0x4a, 0x54, 0xdd, 0x96, 0x8d,
    0x9b, 0xb2, 0x10, 0x67, 0xb4, 0x29, 0x1c, 0xec, 0xb7, 0x91, 0xa8, 0x59,
    0x33, 0xe4, 0x23, 0xd5, 0x1c, 0xcb, 0x69, 0x7e, 0xcd, 0xce, 0x43, 0x38,
    0xec, 0x3e, 0x33, 0xda, 0xbd, 0x4e, 0xa7, 0xfc, 0x47, 0x9a, 0x32, 0x65,
    0xed, 0xc2, 0x88, 0xcb, 0xc3, 0x7b, 0xd0, 0x8c, 0x95, 0x08, 0x3d, 0x79,
    0x0a, 0x8d, 0x86, 0x37, 0x32, 0x78, 0x8c, 0x29, 0xfc, 0xcd, 0x6e, 0xbe,
    0x06, 0xbe, 0x1e, 0x9c, 0xce, 0x51, 0xe2, 0xfc, 0x34, 0x37, 0xda, 0x1a,
    0xfc, 0x0e, 0xdc, 0x64, 0x55, 0xf5, 0x2c, 0x79, 0xdd, 0xbc, 0x79, 0xf1,
    0x53, 0x0b, 0x59, 0xa5, 0x05, 0x2b, 0x2d, 0xa2, 0x56, 0x65, 0xb3, 0x2e,
    0xd1, 0xb1, 0x38, 0xc8, 0x82, 0xea, 0x4b, 0xb9, 0x19, 0xbb, 0xa1, 0x98,
    0x9a, 0xce, 0x21, 0xdc, 0x6a, 0xc2, 0xed, 0xc7, 0x14, 0x65, 0x94, 0xcc,
    0x5b, 0xff, 0x35, 0x7b, 0x04, 0x44, 0xc1, 0x7e, 0x73, 0x2e, 0xb1, 0x34,
    0x2a, 0xd6, 0x1d, 0xce, 0xc1, 0x66, 0x83, 0x08, 0x29, 0xc9, 0x8e, 0xb3,
    0x35, 0x67, 0x31, 0x96, 0x24, 0x9b, 0x79, 0x86, 0x8e, 0x1f, 0x92, 0x68,
    0x3f, 0xd9, 0x50, 0x67, 0xbb, 0x15, 0x0b, 0x51, 0x37, 0xb5, 0xfa, 0x7f,
    0x5a, 0xe5, 0x4c, 0xa2, 0x3e, 0x7e, 0x1d, 0xe0, 0xf2, 0x04, 0xfa, 0xbd,
    0xb6, 0xb6, 0x50, 0x8a, 0x88, 0x00, 0x26, 0x3a, 0xa6, 0x95, 0x40, 0x4a,
    0xc8, 0x4d, 0x0a, 0xaf, 0x3b, 0x94, 0x47, 0x41, 0xa0, 0x42, 0x8f, 0x96,
    0xb8, 0x0b, 0xd0, 0x58, 0x3e, 0xf2, 0xfd, 0x40, 0xa8, 0xdf, 0x5a, 0x0b,
    0x7b, 0x2a, 0x4f, 0x87, 0x51, 0xf1, 0x0f, 0x2f, 0x4d, 0x8e, 0x6d, 0x07,
    0x4f, 0xc9, 0xae, 0x7a, 0x21, 0xde, 0xce, 0x0f, 0x0b, 0x33, 0xda, 0xa1,
    0x4a, 0x38, 0x7c, 0x3c, 0x86, 0x16, 0xa4, 0x60, 0x92, 0x62, 0xe3, 0x54,
    0xb2, 0x06, 0x22, 0x76, 0x4c, 0xd7, 0x5a, 0xf3, 0xe0, 0x92, 0x45, 0x36,
    0x68, 0xd1, 0x5f, 0xa6, 0x35, 0x85, 0xf4, 0xf8, 0x4c, 0x1e, 0xe3, 0xce,
    0x70, 0xc6, 0x8d, 0x6f, 0x62, 0x22, 0x21, 0xe3, 0x5f, 0x9c, 0x31, 0x12,
    0xc8, 0xa1, 0x42, 0x00, 0x94, 0x65, 0xc0, 0x5e, 0x1c, 0xa6, 0x61, 0x9f,
    0xfb, 0x6f, 0xf0, 0xf3, 0x64, 0xbb, 0x9a, 0xab, 0x97, 0xc4, 0xce, 0xfd,
    0x57, 0x9b, 0xeb, 0x19, 0xb8, 0x9a, 0x7f, 0xa9, 0x14, 0x59, 0x9e, 0x4b,
    0x34, 0x08, 0x09, 0x64, 0xdf, 0x0c, 0x01, 0xe6, 0xf7, 0x93, 0x85, 0x68,
    0xe4, 0x87, 0x24, 0x80, 0x91, 0x39, 0xed, 0xaf, 0x88, 0xba, 0xb6, 0xf5,
    0x0b, 0x6d, 0x13, 0x3f, 0x9f, 0x3e, 0x65, 0xb1, 0x67, 0xe6, 0x46, 0xeb,
    0x75, 0x67, 0x13, 0x22, 0x52, 0x3a, 0x2a, 0x27, 0x15, 0x8a, 0xdd, 0x4e,
    0xd0, 0x9c, 0xf4, 0x7e, 0xf0, 0x14, 0xf8, 0x6b, 0xd5, 0x18, 0x35, 0xeb,
    0x8a, 0x1e, 0x50, 0x02, 0x5e, 0x76, 0xc1, 0x65, 0xe4, 0xed, 0xa7, 0x90,
    0x02, 0xb7, 0x22, 0xbc, 0xee, 0xad, 0x9e, 0xaf, 0x77, 0x78, 0xe1, 0xd5,
    0x59, 0xe9, 0x9d, 0x23, 0xd6, 0x71, 0x89, 0x50, 0xea, 0xfa, 0x12, 0x72,
    0xb6, 0x72, 0x4f, 0xda, 0x65, 0x4b, 0x24, 0xa8, 0x9b, 0x1d, 0xd2, 0x51,
    0x6b, 0x17, 0x21, 0x11, 0x99, 0x46, 0x64, 0x41, 0xf5, 0x0a, 0x68, 0x84,
    0x04, 0xc7, 0xed, 0xa6, 0x61, 0x00, 0x22, 0x03, 0x40, 0xea, 0x08, 0xae,
    0x95, 0x8f, 0x1b, 0xc0, 0x55, 0x5c, 0xc4, 0x7d, 0x55, 0xe9, 0x3b, 0x17,
    0x01, 0xdc, 0x1d, 0x85, 0xfe, 0x00, 0xcb, 0x71, 0xb1, 0x00, 0x38, 0x89,
    0xf4, 0x7d, 0xbc, 0x67, 0x1c, 0x83, 0x50, 0xa2, 0x6e, 0xb0, 0xb5, 0x2b,
    0x59, 0x66, 0xe5, 0xf6, 0x33, 0x92, 0x14, 0x3e, 0x9c, 0xc0, 0x1b, 0xe5,
    0xca, 0xa4, 0xcb, 0x74, 0x9f, 0xdb, 0xc4, 0xf5, 0x88, 0xbe, 0x1a, 0x24,
    0x9b, 0x16, 0x76, 0x41, 0x5b, 0x1e, 0x54, 0xcd, 0x69, 0xdc, 0x55, 0xdc,
    0x94, 0x17, 0xcb, 0xb8, 0x82, 0x54, 0x43, 0x15, 0xa1, 0xdb, 0x13, 0xa8,
    0xc5, 0x70, 0x51, 0xcc, 0x73, 0x99, 0x99, 0x7f, 0x0c, 0x5c, 0x9c, 0x4a,
    0xbc, 0x0b, 0xdf, 0x21, 0xd0, 0x04, 0x45, 0x82, 0xc6, 0xab, 0x6b, 0xa7,
    0x30, 0x80, 0x80, 0x02, 0x89, 0x36, 0x89, 0xca, 0xf5, 0x67, 0x6e, 0x5f,
    0xe2, 0x3a, 0x10, 0x44, 0x94, 0x02, 0xe9, 0x4b, 0xe1, 0x9a, 0x92, 0x36,
    0xa1, 0xee, 0xf1, 0x4f, 0x8a, 0xc0, 0x77, 0x6e, 0xe6, 0xc5, 0x44, 0x62,
    0xc9, 0x6d, 0x0e, 0xec, 0xe8, 0x5c, 0x7e, 0x8c, 0x66, 0x2c, 0x0d, 0xe5,
    0x1d, 0xe6, 0x4f, 0x66, 0xa9, 0xb0, 0xb4, 0x7a, 0xdd, 0x96, 0x81, 0x2a,
    0x95, 0xc9, 0xcf, 0x8c, 0x0b, 0x90, 0x58, 0xaa, 0x70, 0x7f, 0x1f, 0x35,
    0x08, 0x3f, 0xf7, 0x30, 0x3e, 0x65, 0x8a, 0x41, 0x34, 0x76, 0x84, 0x03,
    0xf3, 0x9a, 0x56, 0x93, 0xb7, 0xed, 0x2b, 0xf1, 0x53, 0xa5, 0xbf, 0x3d,
    0x17, 0x4a, 0xc4, 0x2c, 0x1e, 0xf3, 0xee, 0x51, 0xf9, 0x74, 0xfa, 0xca,
    0xfe, 0x8e, 0x2f, 0xcf, 0x2e, 0x06, 0x74, 0x1b, 0x6a, 0x84, 0x9a, 0xb3,
    0x13, 0xdc, 0x89, 0xc5, 0x07, 0x7d, 0x75, 0xd3, 0x2d, 0xeb, 0x03, 0xa6,
    0xe7, 0x86, 0xc8, 0x38, 0xd0, 0xf2, 0xac, 0x0f, 0x13, 0xb4, 0xb2, 0x0c,
    0x11, 0x03, 0xc5, 0x15, 0x74, 0x84, 0x00, 0x01, 0x45, 0x2c, 0x1c, 0x40,
    0x82, 0xec, 0x73, 0xae, 0x9e, 0xf4, 0x15, 0x8b, 0xfd, 0x14, 0xae, 0x75,
    0xc9, 0x86, 0x07, 0x94, 0xb4, 0x10, 0xc9, 0xb1, 0x79, 0x70, 0xa2, 0x1c,
    0x34, 0x90, 0xab, 0xc3, 0x38, 0xb5, 0x9e, 0x89, 0x27, 0x14, 0x6d, 0x85,
    0xea, 0x16, 0x62, 0xf4, 0x2f, 0xcd, 0xe9, 0x13, 0x04, 0x22, 0xd2, 0x59,
    0x58, 0xaf, 0x68, 0x8c, 0x1f, 0x31, 0x46, 0xbb, 0xd0, 0x31, 0x03, 0xba,
    0x86, 0x34, 0x3f, 0xd5, 0xe9, 0x16, 0x76, 0x47, 0x54, 0xb7, 0x1b, 0x9e,
    0xed, 0x99, 0xbd, 0x25, 0x5d, 0x43, 0x12, 0xa8, 0x35, 0x1b, 0x8d, 0xcd,
    0xc8, 0x8d, 0x2f, 0xc9, 0x90, 0xf5, 0x48, 0xee, 0x32, 0x5b, 0x03, 0xa2,
    0x1a, 0x3c, 0xb5, 0x35, 0x21, 0x27, 0x79, 0xf1, 0x51, 0x35, 0xff, 0xe6,
    0xeb, 0xe2, 0xb4, 0xdc, 0xc0, 0xbe, 0x9a, 0x5a, 0x2d, 0xdb, 0x41, 0xe1,
    0xb5, 0xcd, 0x70, 0x97, 0x2f, 0x1a, 0x00, 0x90, 0xf5, 0x9b, 0xe6, 0x62,
    0xaf, 0xbf, 0xd0, 0x6f, 0x07, 0xbc, 0xdb, 0xe1, 0x9d, 0xc2, 0x3e, 0xf4,
    0x4b, 0x7e, 0x99, 0x23, 0xbc, 0x1f, 0x11, 0x64, 0x4c, 0x67, 0x3d, 0x77,
    0x8e, 0xd3, 0x04, 0x9d, 0x7f, 0xfb, 0xb4, 0x6c, 0xdc, 0x74, 0xbf, 0x45,
    0x76, 0x11, 0x80, 0xcb,
};
#endif

/* Public keys in known small subgroups - fails in all modes */
static const unsigned char pub_key_zero[] = {0};
static const unsigned char pub_key_one[] = {1};

static const unsigned char pub_key_minus_1_ike_1536[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2,
    0x21, 0x68, 0xC2, 0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6,
    0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
    0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9,
    0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE, 0x9F, 0x24, 0x11,
    0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B, 0x3D,
    0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF, 0x05, 0x98, 0xDA, 0x48, 0x36,
    0x1C, 0x55, 0xD3, 0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF, 0x5F,
    0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD, 0x96, 0x1C, 0x62, 0xF3, 0x56,
    0x20, 0x85, 0x52, 0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6D,
    0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98, 0x04, 0xF1, 0x74, 0x6C, 0x08,
    0xCA, 0x23, 0x73, 0x27, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE};

static const unsigned char pub_key_minus_1_safe_2048[] = {
    0xe1, 0xa3, 0x6e, 0x49, 0x69, 0x07, 0x1c, 0x5f, 0xb4, 0x15, 0x35, 0x46,
    0x99, 0x52, 0xd0, 0x4e, 0xff, 0x4e, 0x4c, 0xb1, 0xe1, 0x59, 0xed, 0x2e,
    0x71, 0xf3, 0x80, 0x14, 0x54, 0xd0, 0xfc, 0x83, 0x20, 0x29, 0x15, 0x21,
    0xa6, 0x5f, 0x10, 0x81, 0x57, 0xf4, 0x2e, 0x49, 0xb2, 0xd1, 0x37, 0xe8,
    0x6a, 0xbf, 0x72, 0xf9, 0x55, 0x4e, 0x9e, 0xae, 0x20, 0xc5, 0xb6, 0xc5,
    0x91, 0x79, 0x0d, 0xa2, 0xdd, 0xb4, 0xbb, 0x50, 0x4e, 0x20, 0xca, 0x8a,
    0x8f, 0x82, 0x34, 0xb9, 0x6a, 0x3e, 0x9a, 0x67, 0xc2, 0x7e, 0x83, 0xf6,
    0xc0, 0xad, 0xe3, 0xca, 0x00, 0xd6, 0x11, 0x88, 0x9c, 0xc7, 0x9f, 0xb4,
    0x3d, 0x53, 0xa5, 0x5a, 0x97, 0x44, 0x4d, 0xe7, 0x5c, 0xd5, 0x76, 0x80,
    0xf8, 0x0c, 0xcd, 0xa6, 0x55, 0xe2, 0x5f, 0xcf, 0xf4, 0x46, 0xa4, 0xc7,
    0x0f, 0xc1, 0x80, 0x84, 0x65, 0x46, 0x8c, 0x87, 0xd2, 0x99, 0x82, 0xdf,
    0x8e, 0x00, 0x89, 0xf3, 0x0d, 0xd5, 0xc0, 0x54, 0x94, 0xc6, 0xa3, 0x92,
    0x0f, 0x91, 0x10, 0xee, 0xa3, 0x65, 0x44, 0xb7, 0x6d, 0xe8, 0x23, 0xf9,
    0x7f, 0x91, 0x62, 0x65, 0x09, 0x8e, 0xa1, 0x33, 0xd4, 0xd6, 0x55, 0x0a,
    0xc0, 0xe8, 0x66, 0x70, 0x05, 0xd0, 0x12, 0x34, 0xc1, 0xfd, 0xce, 0x75,
    0xa4, 0x75, 0xe1, 0x46, 0xa1, 0x08, 0xb4, 0x52, 0xfe, 0x25, 0xa4, 0xc5,
    0x4f, 0x23, 0x04, 0x7e, 0xa1, 0x2c, 0xf3, 0x56, 0xcb, 0xfa, 0x7a, 0xbc,
    0x45, 0xcc, 0x78, 0xb3, 0x28, 0xf3, 0xe5, 0xd5, 0x26, 0x56, 0x27, 0x86,
    0x6a, 0x56, 0x6b, 0x87, 0x56, 0x0e, 0xc4, 0x3c, 0xed, 0xff, 0xcb, 0x96,
    0xb4, 0x13, 0x1d, 0x4d, 0x38, 0x4e, 0x69, 0x34, 0x51, 0x7a, 0x85, 0x31,
    0xb4, 0x80, 0xda, 0x41, 0xe3, 0xdc, 0x2e, 0x53, 0xd8, 0x71, 0x3e, 0xcc,
    0x37, 0x8a, 0x80, 0x32};

static const unsigned char pub_key_minus_1_weak_3072[] = {
    0x94, 0x32, 0xc7, 0x47, 0x51, 0xa3, 0x03, 0x9b, 0xf2, 0x51, 0x5c, 0x69,
    0xaf, 0x05, 0x3c, 0x76, 0x62, 0xa2, 0xec, 0x5a, 0xcc, 0xdf, 0x80, 0xf3,
    0x2d, 0xce, 0xa5, 0xa5, 0x9e, 0x2d, 0xab, 0x5f, 0x91, 0xbd, 0x93, 0x61,
    0xd7, 0x7b, 0x71, 0x6f, 0xf3, 0x92, 0xbf, 0xa8, 0xfc, 0xcd, 0x00, 0xf5,
    0x49, 0x08, 0x00, 0x8c, 0xd2, 0xfe, 0x4a, 0xd8, 0x2b, 0x6e, 0x42, 0xc0,
    0xd8, 0xa2, 0x8b, 0x2b, 0x18, 0x02, 0xad, 0xe8, 0x4e, 0x44, 0x09, 0x26,
    0xa1, 0xa1, 0xca, 0x99, 0xe3, 0xd9, 0x9a, 0x87, 0x3c, 0x83, 0x6a, 0x1a,
    0x7b, 0x60, 0xba, 0x78, 0x0c, 0x79, 0x50, 0x1f, 0xde, 0x40, 0x14, 0x58,
    0x18, 0xa9, 0x2b, 0x74, 0x11, 0xb4, 0x65, 0xfe, 0x9d, 0x03, 0xa4, 0xef,
    0xdf, 0x74, 0x8e, 0xcd, 0x7b, 0xd4, 0xf3, 0x28, 0x75, 0xb2, 0x31, 0xef,
    0x99, 0x65, 0xcb, 0x5a, 0x77, 0xca, 0xa2, 0x25, 0x28, 0xae, 0xfa, 0x9f,
    0xeb, 0xda, 0xcc, 0x34, 0x7b, 0x21, 0xd7, 0xdb, 0x54, 0x40, 0xe6, 0x2f,
    0xdb, 0xc0, 0xce, 0xdc, 0xe5, 0xc9, 0x27, 0x97, 0x99, 0x9c, 0x02, 0x4f,
    0x24, 0x88, 0x93, 0xdf, 0xa9, 0xc7, 0x3e, 0x10, 0xc8, 0xaa, 0x6a, 0xce,
    0xda, 0x46, 0x94, 0x8c, 0xad, 0x1e, 0xf1, 0xcb, 0xd3, 0xcd, 0x43, 0x44,
    0xb4, 0x20, 0x91, 0x9e, 0xf6, 0xd1, 0x03, 0xef, 0xc2, 0x04, 0xf7, 0x07,
    0xdb, 0xac, 0xa2, 0x28, 0x8c, 0x7d, 0x1d, 0x5d, 0x2c, 0x5a, 0xfc, 0x26,
    0x5b, 0x0b, 0x58, 0xb9, 0x9a, 0x47, 0xe9, 0xa0, 0xdf, 0xa5, 0x5a, 0xf3,
    0xe5, 0xd6, 0xeb, 0x69, 0xb5, 0x4e, 0xbc, 0x71, 0xc0, 0xd6, 0x9b, 0xb8,
    0x40, 0x3b, 0xc5, 0x72, 0x5d, 0x4d, 0x1b, 0x17, 0x3d, 0x36, 0xa4, 0xb1,
    0x15, 0xa7, 0x9a, 0x72, 0xeb, 0xf2, 0x9e, 0x40, 0xd1, 0xbc, 0x35, 0xc7,
    0xd1, 0x1a, 0x8f, 0x1c, 0x2b, 0x5e, 0xd8, 0xb3, 0x3b, 0x44, 0xae, 0xf5,
    0x81, 0xd0, 0x8a, 0x37, 0xab, 0xba, 0x22, 0xbc, 0x2d, 0x88, 0x2f, 0x24,
    0xbb, 0xb0, 0x1a, 0xa9, 0x5f, 0x07, 0x10, 0x6d, 0xc6, 0xbb, 0x3c, 0xa2,
    0x66, 0xf9, 0xb9, 0x95, 0xd6, 0x5e, 0x8c, 0xce, 0x04, 0xdc, 0xb3, 0x4c,
    0xbc, 0xe9, 0xc5, 0xcb, 0x19, 0x97, 0xe2, 0xa1, 0x09, 0x38, 0xd7, 0x82,
    0xa6, 0xbf, 0xc9, 0x15, 0x25, 0xf1, 0x2c, 0x77, 0xfc, 0xbd, 0xfa, 0x7f,
    0x92, 0xfe, 0xd6, 0x31, 0x03, 0x23, 0x2d, 0x17, 0x2f, 0x51, 0x9e, 0x5c,
    0xb1, 0x68, 0xc0, 0x3f, 0x42, 0x99, 0x00, 0x55, 0x33, 0x68, 0xd7, 0xee,
    0x51, 0x7d, 0x3e, 0x03, 0x4f, 0x02, 0x5f, 0x27, 0xdd, 0x17, 0x18, 0x6c,
    0x1e, 0x9d, 0x91, 0x65, 0xf8, 0xd7, 0xa6, 0x9f, 0xa1, 0xba, 0xa8, 0x76,
    0xe4, 0xd8, 0xf4, 0x59, 0x90, 0x16, 0x67, 0x88, 0xc2, 0xa9, 0xe4, 0x2c};

static const unsigned char pub_key_minus_1_weak_4096[] = {
    0xff, 0x50, 0xd3, 0xcc, 0x89, 0x17, 0x5e, 0xb6, 0xf8, 0xa3, 0xb0, 0xe2,
    0xf9, 0x9f, 0x17, 0xa1, 0x92, 0x56, 0x15, 0x13, 0x12, 0x9f, 0x18, 0xdc,
    0x07, 0x00, 0xc2, 0x49, 0xc9, 0xd9, 0xd4, 0x0a, 0xe3, 0xd7, 0xf6, 0x60,
    0x21, 0xa9, 0x7b, 0xc0, 0x0f, 0x0e, 0xae, 0x3e, 0x77, 0x77, 0x48, 0xd8,
    0xfd, 0x42, 0xec, 0xb5, 0xae, 0x00, 0xab, 0xce, 0xd1, 0x11, 0xca, 0xd2,
    0x64, 0x5a, 0xa3, 0x6b, 0xba, 0xd1, 0x93, 0xea, 0xda, 0xd2, 0xa0, 0x60,
    0x39, 0x0b, 0x34, 0x4f, 0x0c, 0xf1, 0xb0, 0x52, 0x75, 0x51, 0x3d, 0x28,
    0x02, 0xb5, 0xbd, 0x42, 0x98, 0x20, 0xa7, 0x42, 0xb9, 0x21, 0x9a, 0xae,
    0xb6, 0x41, 0x7b, 0x70, 0xe3, 0xd9, 0xaf, 0x81, 0x1a, 0xc1, 0x39, 0x9c,
    0x52, 0x56, 0xcb, 0x0d, 0x6a, 0x67, 0x6f, 0x3d, 0x12, 0x76, 0x73, 0x53,
    0x95, 0x2d, 0xc1, 0x04, 0xdb, 0x83, 0xe4, 0xd0, 0xbe, 0x2d, 0xa6, 0x7a,
    0x0f, 0x80, 0x1b, 0xd0, 0x16, 0x14, 0x3a, 0xe0, 0x48, 0xfa, 0xf5, 0x44,
    0xa8, 0xe0, 0xbf, 0x98, 0xe1, 0x56, 0xea, 0x76, 0xb6, 0xe2, 0xa3, 0x5b,
    0x15, 0x79, 0x10, 0xb0, 0x41, 0xdc, 0x29, 0x0f, 0x1e, 0x37, 0x69, 0xcd,
    0x13, 0xbe, 0x2d, 0xe0, 0x73, 0x38, 0x68, 0xed, 0x50, 0x6a, 0xd0, 0xfb,
    0xcb, 0x17, 0x3a, 0x59, 0xfb, 0xec, 0xba, 0x75, 0xb6, 0x4e, 0x2f, 0x6e,
    0x97, 0x98, 0x0e, 0x79, 0x25, 0xdd, 0xd8, 0xf5, 0x34, 0xb4, 0xa0, 0x7e,
    0xba, 0x68, 0x7c, 0x4f, 0xfb, 0xe0, 0x97, 0x46, 0x50, 0x1e, 0x4a, 0x59,
    0x9c, 0xdc, 0x34, 0xe2, 0x2a, 0xb5, 0xc8, 0x58, 0x94, 0x48, 0x9f, 0xb8,
    0x36, 0xcb, 0xce, 0x36, 0xb1, 0x7c, 0xe5, 0x8d, 0x5b, 0x43, 0xd7, 0x88,
    0xdf, 0xae, 0xd0, 0xc9, 0x42, 0x5f, 0x0a, 0xe3, 0x63, 0x11, 0xc5, 0x0c,
    0x80, 0x55, 0x58, 0xd7, 0xf2, 0x51, 0x6e, 0xb3, 0x7e, 0x9d, 0x1c, 0xc3,
    0x61, 0x59, 0x5c, 0x47, 0xd4, 0x99, 0xc0, 0x67, 0xfb, 0xb2, 0xd6, 0x11,
    0xda, 0x92, 0x5b, 0x6b, 0xd2, 0x70, 0xb7, 0x69, 0x72, 0xe7, 0x06, 0xdd,
    0x40, 0xac, 0x81, 0x51, 0x1d, 0x52, 0x7a, 0x45, 0x38, 0x89, 0x27, 0x2c,
    0xc4, 0x4b, 0x7e, 0x5e, 0x79, 0xef, 0x84, 0x6a, 0x24, 0x4d, 0x9c, 0x9e,
    0xca, 0x75, 0x5c, 0x06, 0x6d, 0xd0, 0x52, 0xe9, 0xda, 0x9f, 0x46, 0xb6,
    0x62, 0x1d, 0xb3, 0xd9, 0xf2, 0x7d, 0xd6, 0xc2, 0x7a, 0x49, 0x7c, 0xdd,
    0x9b, 0xaa, 0xc3, 0x84, 0x0b, 0x08, 0x33, 0xb8, 0x80, 0xc3, 0x12, 0x8f,
    0xad, 0xac, 0x0f, 0x7f, 0xaf, 0x59, 0x61, 0x0d, 0x98, 0xc1, 0xf9, 0x68,
    0xc3, 0x1b, 0x10, 0x08, 0xc4, 0x33, 0x3c, 0xa4, 0xe2, 0xd5, 0xeb, 0x71,
    0x5d, 0x19, 0x7e, 0x05, 0xca, 0x9a, 0xf5, 0xbb, 0x71, 0x55, 0x83, 0x9c,
    0x25, 0x50, 0x35, 0x7f, 0x2d, 0xeb, 0xf2, 0x0d, 0xed, 0x3c, 0xb8, 0x71,
    0xbd, 0x08, 0xf5, 0x89, 0x7e, 0x5e, 0x38, 0x40, 0xd7, 0xed, 0x77, 0x8d,
    0x7a, 0xed, 0x2a, 0x9f, 0xfc, 0x01, 0xf4, 0xe2, 0xcf, 0xda, 0x8c, 0xa3,
    0x57, 0xdc, 0x14, 0xd6, 0xa1, 0xd9, 0x97, 0xb9, 0xe6, 0xfc, 0x48, 0x75,
    0x43, 0xbd, 0x3b, 0x91, 0x17, 0x3c, 0x33, 0xca, 0xce, 0x29, 0x09, 0x1b,
    0xe8, 0x9d, 0xb6, 0x74, 0x05, 0x5e, 0x2e, 0xa5, 0x1d, 0x7f, 0x3a, 0xa9,
    0x2c, 0xf6, 0x4d, 0x41, 0x90, 0xbc, 0x56, 0x18, 0x52, 0x02, 0x90, 0xef,
    0x71, 0xff, 0x3e, 0x0c, 0xf8, 0x00, 0x04, 0x07, 0xd5, 0x20, 0x26, 0xdd,
    0x5c, 0xb1, 0x37, 0x03, 0x20, 0x0c, 0xb4, 0xb6, 0x39, 0x49, 0x49, 0xaa,
    0xe7, 0x98, 0x01, 0xa2, 0x2e, 0x0a, 0x33, 0x82, 0x9e, 0xb9, 0x24, 0xb7,
    0x80, 0xdf, 0xd3, 0xdf, 0x04, 0xe4, 0x50, 0x9d};

static const unsigned char pub_key_minus_1_tls_6144[] = {
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAD, 0xF8, 0x54, 0x58,
    0xA2, 0xBB, 0x4A, 0x9A, 0xAF, 0xDC, 0x56, 0x20, 0x27, 0x3D, 0x3C, 0xF1,
    0xD8, 0xB9, 0xC5, 0x83, 0xCE, 0x2D, 0x36, 0x95, 0xA9, 0xE1, 0x36, 0x41,
    0x14, 0x64, 0x33, 0xFB, 0xCC, 0x93, 0x9D, 0xCE, 0x24, 0x9B, 0x3E, 0xF9,
    0x7D, 0x2F, 0xE3, 0x63, 0x63, 0x0C, 0x75, 0xD8, 0xF6, 0x81, 0xB2, 0x02,
    0xAE, 0xC4, 0x61, 0x7A, 0xD3, 0xDF, 0x1E, 0xD5, 0xD5, 0xFD, 0x65, 0x61,
    0x24, 0x33, 0xF5, 0x1F, 0x5F, 0x06, 0x6E, 0xD0, 0x85, 0x63, 0x65, 0x55,
    0x3D, 0xED, 0x1A, 0xF3, 0xB5, 0x57, 0x13, 0x5E, 0x7F, 0x57, 0xC9, 0x35,
    0x98, 0x4F, 0x0C, 0x70, 0xE0, 0xE6, 0x8B, 0x77, 0xE2, 0xA6, 0x89, 0xDA,
    0xF3, 0xEF, 0xE8, 0x72, 0x1D, 0xF1, 0x58, 0xA1, 0x36, 0xAD, 0xE7, 0x35,
    0x30, 0xAC, 0xCA, 0x4F, 0x48, 0x3A, 0x79, 0x7A, 0xBC, 0x0A, 0xB1, 0x82,
    0xB3, 0x24, 0xFB, 0x61, 0xD1, 0x08, 0xA9, 0x4B, 0xB2, 0xC8, 0xE3, 0xFB,
    0xB9, 0x6A, 0xDA, 0xB7, 0x60, 0xD7, 0xF4, 0x68, 0x1D, 0x4F, 0x42, 0xA3,
    0xDE, 0x39, 0x4D, 0xF4, 0xAE, 0x56, 0xED, 0xE7, 0x63, 0x72, 0xBB, 0x19,
    0x0B, 0x07, 0xA7, 0xC8, 0xEE, 0x0A, 0x6D, 0x70, 0x9E, 0x02, 0xFC, 0xE1,
    0xCD, 0xF7, 0xE2, 0xEC, 0xC0, 0x34, 0x04, 0xCD, 0x28, 0x34, 0x2F, 0x61,
    0x91, 0x72, 0xFE, 0x9C, 0xE9, 0x85, 0x83, 0xFF, 0x8E, 0x4F, 0x12, 0x32,
    0xEE, 0xF2, 0x81, 0x83, 0xC3, 0xFE, 0x3B, 0x1B, 0x4C, 0x6F, 0xAD, 0x73,
    0x3B, 0xB5, 0xFC, 0xBC, 0x2E, 0xC2, 0x20, 0x05, 0xC5, 0x8E, 0xF1, 0x83,
    0x7D, 0x16, 0x83, 0xB2, 0xC6, 0xF3, 0x4A, 0x26, 0xC1, 0xB2, 0xEF, 0xFA,
    0x88, 0x6B, 0x42, 0x38, 0x61, 0x1F, 0xCF, 0xDC, 0xDE, 0x35, 0x5B, 0x3B,
    0x65, 0x19, 0x03, 0x5B, 0xBC, 0x34, 0xF4, 0xDE, 0xF9, 0x9C, 0x02, 0x38,
    0x61, 0xB4, 0x6F, 0xC9, 0xD6, 0xE6, 0xC9, 0x07, 0x7A, 0xD9, 0x1D, 0x26,
    0x91, 0xF7, 0xF7, 0xEE, 0x59, 0x8C, 0xB0, 0xFA, 0xC1, 0x86, 0xD9, 0x1C,
    0xAE, 0xFE, 0x13, 0x09, 0x85, 0x13, 0x92, 0x70, 0xB4, 0x13, 0x0C, 0x93,
    0xBC, 0x43, 0x79, 0x44, 0xF4, 0xFD, 0x44, 0x52, 0xE2, 0xD7, 0x4D, 0xD3,
    0x64, 0xF2, 0xE2, 0x1E, 0x71, 0xF5, 0x4B, 0xFF, 0x5C, 0xAE, 0x82, 0xAB,
    0x9C, 0x9D, 0xF6, 0x9E, 0xE8, 0x6D, 0x2B, 0xC5, 0x22, 0x36, 0x3A, 0x0D,
    0xAB, 0xC5, 0x21, 0x97, 0x9B, 0x0D, 0xEA, 0xDA, 0x1D, 0xBF, 0x9A, 0x42,
    0xD5, 0xC4, 0x48, 0x4E, 0x0A, 0xBC, 0xD0, 0x6B, 0xFA, 0x53, 0xDD, 0xEF,
    0x3C, 0x1B, 0x20, 0xEE, 0x3F, 0xD5, 0x9D, 0x7C, 0x25, 0xE4, 0x1D, 0x2B,
    0x66, 0x9E, 0x1E, 0xF1, 0x6E, 0x6F, 0x52, 0xC3, 0x16, 0x4D, 0xF4, 0xFB,
    0x79, 0x30, 0xE9, 0xE4, 0xE5, 0x88, 0x57, 0xB6, 0xAC, 0x7D, 0x5F, 0x42,
    0xD6, 0x9F, 0x6D, 0x18, 0x77, 0x63, 0xCF, 0x1D, 0x55, 0x03, 0x40, 0x04,
    0x87, 0xF5, 0x5B, 0xA5, 0x7E, 0x31, 0xCC, 0x7A, 0x71, 0x35, 0xC8, 0x86,
    0xEF, 0xB4, 0x31, 0x8A, 0xED, 0x6A, 0x1E, 0x01, 0x2D, 0x9E, 0x68, 0x32,
    0xA9, 0x07, 0x60, 0x0A, 0x91, 0x81, 0x30, 0xC4, 0x6D, 0xC7, 0x78, 0xF9,
    0x71, 0xAD, 0x00, 0x38, 0x09, 0x29, 0x99, 0xA3, 0x33, 0xCB, 0x8B, 0x7A,
    0x1A, 0x1D, 0xB9, 0x3D, 0x71, 0x40, 0x00, 0x3C, 0x2A, 0x4E, 0xCE, 0xA9,
    0xF9, 0x8D, 0x0A, 0xCC, 0x0A, 0x82, 0x91, 0xCD, 0xCE, 0xC9, 0x7D, 0xCF,
    0x8E, 0xC9, 0xB5, 0x5A, 0x7F, 0x88, 0xA4, 0x6B, 0x4D, 0xB5, 0xA8, 0x51,
    0xF4, 0x41, 0x82, 0xE1, 0xC6, 0x8A, 0x00, 0x7E, 0x5E, 0x0D, 0xD9, 0x02,
    0x0B, 0xFD, 0x64, 0xB6, 0x45, 0x03, 0x6C, 0x7A, 0x4E, 0x67, 0x7D, 0x2C,
    0x38, 0x53, 0x2A, 0x3A, 0x23, 0xBA, 0x44, 0x42, 0xCA, 0xF5, 0x3E, 0xA6,
    0x3B, 0xB4, 0x54, 0x32, 0x9B, 0x76, 0x24, 0xC8, 0x91, 0x7B, 0xDD, 0x64,
    0xB1, 0xC0, 0xFD, 0x4C, 0xB3, 0x8E, 0x8C, 0x33, 0x4C, 0x70, 0x1C, 0x3A,
    0xCD, 0xAD, 0x06, 0x57, 0xFC, 0xCF, 0xEC, 0x71, 0x9B, 0x1F, 0x5C, 0x3E,
    0x4E, 0x46, 0x04, 0x1F, 0x38, 0x81, 0x47, 0xFB, 0x4C, 0xFD, 0xB4, 0x77,
    0xA5, 0x24, 0x71, 0xF7, 0xA9, 0xA9, 0x69, 0x10, 0xB8, 0x55, 0x32, 0x2E,
    0xDB, 0x63, 0x40, 0xD8, 0xA0, 0x0E, 0xF0, 0x92, 0x35, 0x05, 0x11, 0xE3,
    0x0A, 0xBE, 0xC1, 0xFF, 0xF9, 0xE3, 0xA2, 0x6E, 0x7F, 0xB2, 0x9F, 0x8C,
    0x18, 0x30, 0x23, 0xC3, 0x58, 0x7E, 0x38, 0xDA, 0x00, 0x77, 0xD9, 0xB4,
    0x76, 0x3E, 0x4E, 0x4B, 0x94, 0xB2, 0xBB, 0xC1, 0x94, 0xC6, 0x65, 0x1E,
    0x77, 0xCA, 0xF9, 0x92, 0xEE, 0xAA, 0xC0, 0x23, 0x2A, 0x28, 0x1B, 0xF6,
    0xB3, 0xA7, 0x39, 0xC1, 0x22, 0x61, 0x16, 0x82, 0x0A, 0xE8, 0xDB, 0x58,
    0x47, 0xA6, 0x7C, 0xBE, 0xF9, 0xC9, 0x09, 0x1B, 0x46, 0x2D, 0x53, 0x8C,
    0xD7, 0x2B, 0x03, 0x74, 0x6A, 0xE7, 0x7F, 0x5E, 0x62, 0x29, 0x2C, 0x31,
    0x15, 0x62, 0xA8, 0x46, 0x50, 0x5D, 0xC8, 0x2D, 0xB8, 0x54, 0x33, 0x8A,
    0xE4, 0x9F, 0x52, 0x35, 0xC9, 0x5B, 0x91, 0x17, 0x8C, 0xCF, 0x2D, 0xD5,
    0xCA, 0xCE, 0xF4, 0x03, 0xEC, 0x9D, 0x18, 0x10, 0xC6, 0x27, 0x2B, 0x04,
    0x5B, 0x3B, 0x71, 0xF9, 0xDC, 0x6B, 0x80, 0xD6, 0x3F, 0xDD, 0x4A, 0x8E,
    0x9A, 0xDB, 0x1E, 0x69, 0x62, 0xA6, 0x95, 0x26, 0xD4, 0x31, 0x61, 0xC1,
    0xA4, 0x1D, 0x57, 0x0D, 0x79, 0x38, 0xDA, 0xD4, 0xA4, 0x0E, 0x32, 0x9C,
    0xD0, 0xE4, 0x0E, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE};

static const unsigned char pub_key_minus_1_safe_8192[] = {
    0x9b, 0xa7, 0x9b, 0xa2, 0x86, 0x54, 0xe7, 0x99, 0x11, 0x5b, 0x35, 0x81,
    0xd5, 0x7a, 0x8a, 0x6e, 0x4d, 0x4d, 0x61, 0x5d, 0xd3, 0xcf, 0x0c, 0x65,
    0x7e, 0xda, 0xd8, 0xce, 0x28, 0xac, 0xa0, 0x38, 0x81, 0xee, 0xa1, 0x14,
    0x25, 0x21, 0x67, 0x66, 0x3a, 0x6c, 0x0f, 0x80, 0x3d, 0x89, 0x79, 0xfe,
    0x71, 0x43, 0x57, 0xc3, 0xa9, 0x54, 0x1e, 0x20, 0x8a, 0xee, 0x0f, 0xa6,
    0x8b, 0x88, 0x81, 0x3d, 0xe8, 0x5c, 0x40, 0x47, 0x05, 0xdf, 0xd8, 0x6d,
    0x98, 0x65, 0x16, 0xa9, 0xf9, 0xc4, 0x8c, 0x02, 0xba, 0xae, 0x6b, 0x36,
    0x76, 0xc9, 0xfa, 0x8e, 0xd0, 0xd7, 0x9a, 0x3c, 0xcb, 0xd1, 0x44, 0x09,
    0xd7, 0x4f, 0x28, 0x51, 0x94, 0x92, 0x5b, 0x02, 0xb2, 0xbd, 0x78, 0xd3,
    0xc2, 0x76, 0x03, 0x15, 0x17, 0x0b, 0x55, 0x08, 0x02, 0x42, 0x9e, 0x26,
    0x56, 0x33, 0x72, 0xe6, 0xbd, 0x0e, 0xf9, 0x3d, 0x2c, 0xb3, 0x8a, 0x4c,
    0x67, 0x17, 0xfd, 0xe9, 0x03, 0xad, 0x8c, 0x34, 0x84, 0xe5, 0x83, 0xdf,
    0x9c, 0x04, 0x93, 0x03, 0x26, 0x19, 0xc1, 0xf1, 0x24, 0x68, 0xf6, 0x54,
    0x96, 0xce, 0x38, 0x51, 0xbd, 0x6c, 0x3d, 0x9c, 0x0c, 0xd8, 0x6e, 0x13,
    0x4c, 0x8b, 0xf6, 0x34, 0xae, 0xd8, 0x85, 0x1d, 0x1d, 0x8e, 0xc2, 0xad,
    0xab, 0xa2, 0xc5, 0x40, 0x76, 0x7f, 0x2f, 0x2e, 0x38, 0xf4, 0x6a, 0x39,
    0x33, 0x3d, 0x17, 0xce, 0x1f, 0xe9, 0xc3, 0x8d, 0x9e, 0xe5, 0xbe, 0xd6,
    0xad, 0x9a, 0x23, 0xd8, 0x06, 0xf3, 0x7c, 0x39, 0xd5, 0xae, 0x57, 0xb6,
    0xe5, 0xc3, 0x9a, 0x8a, 0x8c, 0x6e, 0xd3, 0xc1, 0x1a, 0x64, 0x12, 0x00,
    0x18, 0x53, 0xca, 0x32, 0x88, 0x8e, 0xc0, 0x5f, 0x2d, 0xb2, 0x3d, 0x14,
    0x1b, 0x58, 0x5c, 0x20, 0xe8, 0x52, 0xe5, 0x28, 0x41, 0xbc, 0x9e, 0x08,
    0x29, 0xab, 0xa5, 0x43, 0x99, 0x0e, 0xd7, 0x2a, 0xb9, 0xb8, 0x64, 0x9d,
    0x83, 0xe3, 0x1a, 0x26, 0x59, 0x65, 0xf2, 0x0c, 0xc9, 0xc5, 0x8f, 0x0d,
    0xcf, 0xa1, 0x18, 0xfc, 0x8b, 0x77, 0xe9, 0xe1, 0x19, 0x7b, 0x03, 0xd4,
    0x37, 0x8d, 0x5d, 0x37, 0x2b, 0xad, 0x58, 0x5e, 0x73, 0x72, 0xce, 0x84,
    0xe5, 0xc9, 0x75, 0x1d, 0xf3, 0x58, 0x42, 0x77, 0xfe, 0x53, 0xa0, 0xc2,
    0x66, 0x21, 0xaf, 0xe2, 0x61, 0xd2, 0x84, 0xb3, 0x03, 0x4d, 0xd8, 0x7d,
    0x85, 0xe1, 0xa8, 0xa0, 0x48, 0x5d, 0x1a, 0xa9, 0xac, 0xc1, 0x69, 0x24,
    0xc6, 0xfa, 0xb5, 0x22, 0x3e, 0xa3, 0x8d, 0x35, 0x29, 0xcf, 0x9a, 0xe5,
    0x84, 0x3b, 0x0b, 0x27, 0x36, 0x7e, 0x9d, 0xa6, 0xb0, 0x45, 0x60, 0x42,
    0x1e, 0x4b, 0x24, 0xd1, 0x36, 0x8b, 0x70, 0xd1, 0x95, 0x54, 0x14, 0xb9,
    0x47, 0x3d, 0x8d, 0xe4, 0x5f, 0x81, 0x1a, 0x21, 0x17, 0x17, 0xbf, 0x92,
    0x22, 0x4c, 0x77, 0x30, 0xdc, 0x9c, 0x84, 0xe6, 0x68, 0xcc, 0xd6, 0x11,
    0x04, 0xff, 0x71, 0x86, 0xb3, 0xa9, 0x9b, 0x13, 0x95, 0x35, 0xfd, 0x68,
    0x28, 0x9b, 0x6f, 0x5c, 0xf7, 0x66, 0xa8, 0x6f, 0x89, 0x0f, 0x92, 0xdf,
    0x52, 0x24, 0x3f, 0xdb, 0x2f, 0x40, 0x12, 0x32, 0xa4, 0xff, 0x2e, 0x4b,
    0xb8, 0xa0, 0xe7, 0xc9, 0xcb, 0x98, 0x13, 0xf9, 0xd2, 0xfa, 0x82, 0x68,
    0xb2, 0x8f, 0xd3, 0x17, 0x8c, 0x93, 0xf5, 0x80, 0xe4, 0x5a, 0x33, 0x1b,
    0x6a, 0xd8, 0xbf, 0x37, 0xa7, 0xe1, 0x63, 0x1d, 0x6a, 0xc3, 0xfa, 0xa1,
    0x2f, 0xc1, 0x72, 0x55, 0xd5, 0xe2, 0x67, 0x3b, 0x6b, 0x3a, 0xa8, 0xb0,
    0x54, 0x04, 0x1d, 0xbb, 0xc1, 0xe5, 0x3a, 0x52, 0xb1, 0x67, 0x0b, 0x12,
    0x3e, 0xcd, 0xa9, 0x9a, 0x0e, 0xbb, 0xa3, 0x75, 0x6d, 0x6f, 0x77, 0x74,
    0x64, 0xe3, 0x16, 0x8c, 0xa5, 0xba, 0xec, 0x51, 0x73, 0xce, 0x4b, 0xe6,
    0x6f, 0x3d, 0x15, 0x56, 0x43, 0xe1, 0x17, 0x77, 0x66, 0xab, 0xdc, 0x9d,
    0x9b, 0x10, 0x5d, 0xc4, 0xe9, 0x1e, 0xaa, 0x2d, 0x15, 0xbb, 0xc4, 0x09,
    0x46, 0x30, 0xe1, 0xb8, 0x92, 0x94, 0x5f, 0xb7, 0xe7, 0x7e, 0x97, 0x43,
    0xc0, 0x48, 0x5b, 0xaf, 0xea, 0x74, 0xae, 0x8c, 0x79, 0x6b, 0x66, 0x83,
    0x62, 0x88, 0x17, 0xa4, 0x56, 0x5d, 0x58, 0xfb, 0x6c, 0x38, 0x57, 0x4d,
    0xef, 0xd7, 0x36, 0x44, 0x39, 0x5b, 0xab, 0x94, 0xe4, 0x08, 0x30, 0xd3,
    0x2c, 0x59, 0xa0, 0x32, 0xe2, 0x71, 0x99, 0xec, 0x66, 0x5e, 0xf7, 0xe2,
    0x9c, 0x19, 0x69, 0x72, 0x6f, 0xdb, 0x3e, 0xcc, 0x19, 0x5a, 0xfd, 0xad,
    0xd6, 0x6e, 0x9d, 0x07, 0xc0, 0x65, 0x01, 0x75, 0xdd, 0x37, 0x1b, 0x9c,
    0x5e, 0x93, 0x32, 0xf8, 0x7e, 0x65, 0xd5, 0xb5, 0x15, 0x35, 0xad, 0x05,
    0xb5, 0xd2, 0x25, 0xc7, 0x71, 0x5a, 0xe4, 0xb7, 0x58, 0x6a, 0xc3, 0x5a,
    0xd9, 0xd4, 0xee, 0x32, 0xb5, 0x0b, 0x5b, 0x2a, 0xcd, 0x80, 0xce, 0xd4,
    0x2d, 0xc9, 0x09, 0x94, 0xf5, 0xf2, 0x7c, 0xaf, 0xba, 0x5a, 0xd3, 0xdc,
    0xcd, 0xd7, 0xf7, 0xea, 0x42, 0xe2, 0xc2, 0x34, 0x21, 0xb9, 0x15, 0x24,
    0xe8, 0x32, 0x6b, 0x6f, 0xb0, 0xed, 0x76, 0x5e, 0x45, 0xbf, 0x02, 0xa2,
    0xb8, 0x3c, 0xa5, 0xf5, 0x74, 0xe3, 0x18, 0x89, 0x21, 0x4e, 0xa6, 0x08,
    0xa3, 0xa5, 0x93, 0x69, 0x48, 0x96, 0xbd, 0x47, 0xd3, 0xeb, 0x67, 0x29,
    0xa8, 0xbb, 0xbe, 0x78, 0x05, 0xfa, 0x46, 0x89, 0x4e, 0x0c, 0xe2, 0x6c,
    0xbb, 0xe5, 0xf8, 0xba, 0xe5, 0x5d, 0x29, 0xe7, 0xdd, 0x71, 0x7e, 0x94,
    0xd7, 0x56, 0x0c, 0x3c, 0xde, 0x5f, 0xbc, 0xdc, 0x0f, 0x8e, 0xd6, 0x6f,
    0x0a, 0x07, 0xb8, 0x07, 0x24, 0x62, 0x4c, 0xed, 0x45, 0x4f, 0x0d, 0x9f,
    0x2e, 0x83, 0x6a, 0xeb, 0xbc, 0xff, 0xa9, 0xf2, 0x73, 0xb3, 0x5b, 0xaa,
    0xac, 0xed, 0xac, 0x88, 0xa2, 0x0d, 0x8d, 0x8f, 0xb4, 0xf7, 0x73, 0x1e,
    0xc0, 0x2e, 0xd3, 0x45, 0x15, 0x4b, 0x4a, 0xe7, 0xd4, 0xef, 0xb1, 0xc6,
    0xd3, 0x8f, 0xf8, 0x24, 0x12, 0x33, 0x3e, 0x8e, 0x95, 0xbc, 0x81, 0xb4,
    0xd4, 0xd1, 0x13, 0xbc, 0x7e, 0x25, 0xb4, 0x5b, 0xff, 0x15, 0xba, 0xf8,
    0x9a, 0xec, 0x78, 0xe4, 0x63, 0xc7, 0x26, 0xd5, 0x89, 0x3d, 0x63, 0x5b,
    0x7c, 0x86, 0x63, 0x34, 0x06, 0x28, 0x23, 0x08, 0xff, 0x6d, 0xbd, 0xe0,
    0x75, 0xb3, 0x71, 0x12, 0x26, 0x63, 0xca, 0x93, 0x36, 0x86, 0xeb, 0xf7,
    0x48, 0xd1, 0x96, 0xf4, 0x02, 0x3e, 0x5d, 0x69, 0x75, 0x5e, 0x95, 0xee,
    0x32, 0xb9, 0xba, 0x55, 0xc5, 0x42, 0x74, 0x00, 0xe1, 0x0f, 0x16, 0x05,
    0x62, 0x3c, 0x58, 0xcb, 0xe0, 0xd4, 0xa9, 0xe5, 0x1a, 0x3b, 0x84, 0x7e,
    0x19, 0x87, 0xad, 0x67, 0xcd, 0x9b, 0x97, 0xb0, 0x32, 0xd7, 0xb8, 0x1e,
    0x96, 0x69, 0x75, 0x0f, 0x61, 0x69, 0xb3, 0xc9, 0xce, 0x73, 0x7c, 0x5f,
    0xd5, 0x08, 0xdf, 0xd4, 0x07, 0x75, 0x60, 0xd7, 0x50, 0x52, 0xe7, 0x5c,
    0x6f, 0x04, 0x59, 0x65, 0xbd, 0x70, 0x99, 0x15, 0xf9, 0xbc, 0x34, 0x78,
    0x6a, 0x64, 0xac, 0x5f, 0x07, 0xc2, 0x89, 0x88, 0xfe, 0x11, 0x7a, 0xf7,
    0x3d, 0xbe, 0x83, 0xff, 0xeb, 0x1d, 0x52, 0xbe, 0xd4, 0x09, 0x71, 0x0f,
    0x7c, 0x95, 0x19, 0xf2, 0x4b, 0xf5, 0x44, 0x63, 0xf2, 0xec, 0x3f, 0xf9,
    0xe4, 0xfb, 0xbe, 0x24, 0xb2, 0x18, 0x53, 0xce, 0x16, 0x40, 0x1e, 0x27,
    0x62, 0x99, 0x93, 0xc9, 0x49, 0x8f, 0x98, 0x0d, 0xd8, 0x73, 0x65, 0x99,
    0xac, 0xff, 0xfe, 0x22, 0x6a, 0xd1, 0xfb, 0xa1, 0xe4, 0xe7, 0xab, 0x3c,
    0x72, 0x10, 0xac, 0x72};

/* Public keys in small subgroups of weak primes - fails in all modes*/
static const unsigned char pub_key_bad_weak_1024[] = {3};
static const unsigned char pub_key_bad_weak_2048[] = {3};
static const unsigned char pub_key_bad_weak_3072[] = {3};
static const unsigned char pub_key_bad_weak_4096[] = {3};
static const unsigned char pub_key_bad_weak_6144[] = {3};
static const unsigned char pub_key_bad_weak_8192[] = {3};

enum DhParamType {
  TLS_APPROVED,
  IKE_APPROVED,
  SAFE_PRIME,
  SAFE_PRIME_WITH_SUBPRIME,
  KNOWN_SUBPRIME,
  WRONG_SUBPRIME,
  UNKNOWN_SUBPRIME,
  BAD_PUB_KEY
};

enum DhKeyClass {
  CLASS_1536 = 0,
  CLASS_2048,
  CLASS_3072,
  CLASS_4096,
  CLASS_6144,
  CLASS_8192,
  CLASS_LAST
};
const DhKeyClass CLASS_FIRST = CLASS_1536;

const unsigned char *reference_prime[CLASS_LAST] = {
    prime_ike_1536, prime_tls_2048, prime_tls_3072,
    prime_ike_4096, prime_ike_6144, prime_tls_8192};

const size_t reference_prime_len[CLASS_LAST] = {
    sizeof(prime_ike_1536), sizeof(prime_tls_2048), sizeof(prime_tls_3072),
    sizeof(prime_ike_4096), sizeof(prime_ike_6144), sizeof(prime_tls_8192)};

struct DhTestVector {
  const char *id;
  SECItem p;
  SECItem g;
  SECItem q;
  SECItem pub_key;
  DhParamType param_type;
  DhKeyClass key_class;
};

static const unsigned char g2[] = {2};
static const unsigned char g3[] = {3};

static const DhTestVector DH_TEST_VECTORS[] = {
    /* test our approved primes, the pass in all modes and configurations */
    {"IKE 1536",
     {siBuffer, (unsigned char *)prime_ike_1536, sizeof(prime_ike_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_1536},
    {"IKE 2048",
     {siBuffer, (unsigned char *)prime_ike_2048, sizeof(prime_ike_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_2048},
    {"TLS 3048",
     {siBuffer, (unsigned char *)prime_tls_2048, sizeof(prime_tls_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_2048},
    {"IKE 3072",
     {siBuffer, (unsigned char *)prime_ike_3072, sizeof(prime_ike_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_3072},
    {"TLS 3072",
     {siBuffer, (unsigned char *)prime_tls_3072, sizeof(prime_tls_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_3072},
    {"IKE 4096",
     {siBuffer, (unsigned char *)prime_ike_4096, sizeof(prime_ike_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_4096},
    {"TLS 4096",
     {siBuffer, (unsigned char *)prime_tls_4096, sizeof(prime_tls_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_4096},
    {"IKE 6144",
     {siBuffer, (unsigned char *)prime_ike_6144, sizeof(prime_ike_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_6144},
    {"TLS 6144",
     {siBuffer, (unsigned char *)prime_tls_6144, sizeof(prime_tls_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_6144},
    {"IKE 8192",
     {siBuffer, (unsigned char *)prime_ike_8192, sizeof(prime_ike_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_8192},
    {"TLS 8192",
     {siBuffer, (unsigned char *)prime_tls_8192, sizeof(prime_tls_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_8192},
    /* approved primes with explicit subprimes.These should pass without
     * the need to verify the primes and subprimes for primality */
    {"IKE 1536 with subprime",
     {siBuffer, (unsigned char *)prime_ike_1536, sizeof(prime_ike_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_1536,
      sizeof(sub2_prime_ike_1536)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_1536},
    {"IKE 2048 with subprime",
     {siBuffer, (unsigned char *)prime_ike_2048, sizeof(prime_ike_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_2048,
      sizeof(sub2_prime_ike_2048)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_2048},
    {"TLS 2048 with subprime",
     {siBuffer, (unsigned char *)prime_tls_2048, sizeof(prime_tls_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_2048,
      sizeof(sub2_prime_tls_2048)},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_2048},
    {"IKE 3072 with subprime",
     {siBuffer, (unsigned char *)prime_ike_3072, sizeof(prime_ike_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_3072,
      sizeof(sub2_prime_ike_3072)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_3072},
    {"TLS 3072 with subprime",
     {siBuffer, (unsigned char *)prime_tls_3072, sizeof(prime_tls_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_3072,
      sizeof(sub2_prime_tls_3072)},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_3072},
    {"IKE 4096 with subprime",
     {siBuffer, (unsigned char *)prime_ike_4096, sizeof(prime_ike_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_4096,
      sizeof(sub2_prime_ike_4096)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_4096},
    {"TLS 4096 with subprime",
     {siBuffer, (unsigned char *)prime_tls_4096, sizeof(prime_tls_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_4096,
      sizeof(sub2_prime_tls_4096)},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_4096},
    {"IKE 6144 with subprime",
     {siBuffer, (unsigned char *)prime_ike_6144, sizeof(prime_ike_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_6144,
      sizeof(sub2_prime_ike_6144)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_6144},
    {"TLS 6144 with subprime",
     {siBuffer, (unsigned char *)prime_tls_6144, sizeof(prime_tls_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_6144,
      sizeof(sub2_prime_tls_6144)},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_6144},
    {"IKE 8192 with subprime",
     {siBuffer, (unsigned char *)prime_ike_8192, sizeof(prime_ike_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_ike_8192,
      sizeof(sub2_prime_ike_8192)},
     {siBuffer, NULL, 0},
     IKE_APPROVED,
     CLASS_8192},
    {"TLS 8192 with subprime",
     {siBuffer, (unsigned char *)prime_tls_8192, sizeof(prime_tls_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_8192,
      sizeof(sub2_prime_tls_8192)},
     {siBuffer, NULL, 0},
     TLS_APPROVED,
     CLASS_8192},
    /* test our non-approved safe primes. This primes should pass in
     * non-FIPS and fail in FIPS. They should pass without checks */
    {"Safe Prime 1536",
     {siBuffer, (unsigned char *)prime_safe_1536, sizeof(prime_safe_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_1536},
    {"Safe Prime 2048",
     {siBuffer, (unsigned char *)prime_safe_2048, sizeof(prime_safe_2048)},
     {siBuffer, (unsigned char *)g3, sizeof(g3)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_2048},
    {"Safe Prime 3072",
     {siBuffer, (unsigned char *)prime_safe_3072, sizeof(prime_safe_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_3072},
    {"Safe Prime 4096",
     {siBuffer, (unsigned char *)prime_safe_4096, sizeof(prime_safe_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_4096},
    {"Safe Prime 6144",
     {siBuffer, (unsigned char *)prime_safe_6144, sizeof(prime_safe_6144)},
     {siBuffer, (unsigned char *)g3, sizeof(g3)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_6144},
    {"Safe Prime 8192",
     {siBuffer, (unsigned char *)prime_safe_8192, sizeof(prime_safe_8192)},
     {siBuffer, (unsigned char *)g3, sizeof(g3)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     SAFE_PRIME,
     CLASS_8192},
    /* test our non-approved safe primes. This primes should pass in
     * non-FIPS and fail in FIPS. In non-FIPS, they need checks */
    {"Safe Prime 1536 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_1536, sizeof(prime_safe_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_1536,
      sizeof(sub2_prime_safe_1536)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_1536},
    {"Safe Prime 2048 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_2048, sizeof(prime_safe_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_2048,
      sizeof(sub2_prime_safe_2048)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_2048},
    {"Safe Prime 3072 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_3072, sizeof(prime_safe_3072)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_3072,
      sizeof(sub2_prime_safe_3072)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_3072},
#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
    {"Safe Prime 4096 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_4096, sizeof(prime_safe_4096)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_4096,
      sizeof(sub2_prime_safe_4096)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_4096},
    {"Safe Prime 6144 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_6144, sizeof(prime_safe_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_6144,
      sizeof(sub2_prime_safe_6144)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_6144},
    {"Safe Prime 8192 with Subprime",
     {siBuffer, (unsigned char *)prime_safe_8192, sizeof(prime_safe_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_8192,
      sizeof(sub2_prime_safe_8192)},
     {siBuffer, NULL, 0},
     SAFE_PRIME_WITH_SUBPRIME,
     CLASS_8192},
#endif
    /* test "weak" primes with "unknown" subprimes. We use
     * the same primes as the known subprimes, but we don't
     * include the subprime in the test. These primes should
     * pass in non-FIPS mode and fail in FIPS mode */
    {"Weak Prime 1024 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_1024, sizeof(prime_weak_1024)},
     {siBuffer, (unsigned char *)base_weak_1024, sizeof(base_weak_1024)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_1536},
    {"Weak Prime 2048 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_2048, sizeof(prime_weak_2048)},
     {siBuffer, (unsigned char *)base_weak_2048, sizeof(base_weak_2048)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_2048},
    {"Weak Prime 3072 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_3072, sizeof(prime_weak_3072)},
     {siBuffer, (unsigned char *)base_weak_3072, sizeof(base_weak_3072)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_3072},
    {"Weak Prime 4096 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_4096, sizeof(prime_weak_4096)},
     {siBuffer, (unsigned char *)base_weak_4096, sizeof(base_weak_4096)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_4096},
    {"Weak Prime 6144 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_6144, sizeof(prime_weak_6144)},
     {siBuffer, (unsigned char *)base_weak_6144, sizeof(base_weak_6144)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_6144},
    {"Weak Prime 8192 Unknown Subprime",
     {siBuffer, (unsigned char *)prime_weak_8192, sizeof(prime_weak_8192)},
     {siBuffer, (unsigned char *)base_weak_8192, sizeof(base_weak_8192)},
     {siBuffer, NULL, 0},
     {siBuffer, NULL, 0},
     UNKNOWN_SUBPRIME,
     CLASS_8192},
    /* test "weak" primes with known subprimes.  These primes should
     * pass in non-FIPS and fail in FIPS. In non-FIPS they should have full
     * checks. */
    {"Weak Prime 1024 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_1024, sizeof(prime_weak_1024)},
     {siBuffer, (unsigned char *)base_weak_1024, sizeof(base_weak_1024)},
     {siBuffer, (unsigned char *)subprime_weak_1024,
      sizeof(subprime_weak_1024)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_1536},
    {"Weak Prime 2048 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_2048, sizeof(prime_weak_2048)},
     {siBuffer, (unsigned char *)base_weak_2048, sizeof(base_weak_2048)},
     {siBuffer, (unsigned char *)subprime_weak_2048,
      sizeof(subprime_weak_2048)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_2048},
    {"Weak Prime 3072 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_3072, sizeof(prime_weak_3072)},
     {siBuffer, (unsigned char *)base_weak_3072, sizeof(base_weak_3072)},
     {siBuffer, (unsigned char *)subprime_weak_3072,
      sizeof(subprime_weak_3072)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_3072},
#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
    {"Weak Prime 4096 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_4096, sizeof(prime_weak_4096)},
     {siBuffer, (unsigned char *)base_weak_4096, sizeof(base_weak_4096)},
     {siBuffer, (unsigned char *)subprime_weak_4096,
      sizeof(subprime_weak_4096)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_4096},
    {"Weak Prime 6144 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_6144, sizeof(prime_weak_6144)},
     {siBuffer, (unsigned char *)base_weak_6144, sizeof(base_weak_6144)},
     {siBuffer, (unsigned char *)subprime_weak_6144,
      sizeof(subprime_weak_6144)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_6144},
    {"Weak Prime 8192 Known Subprime",
     {siBuffer, (unsigned char *)prime_weak_8192, sizeof(prime_weak_8192)},
     {siBuffer, (unsigned char *)base_weak_8192, sizeof(base_weak_8192)},
     {siBuffer, (unsigned char *)subprime_weak_8192,
      sizeof(subprime_weak_8192)},
     {siBuffer, NULL, 0},
     KNOWN_SUBPRIME,
     CLASS_8192},
#endif
    /* test "weak" primes as if they were safe primes.  These primes should
     * faill in all modes. */
    {"Weak Prime 1024 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_1024, sizeof(prime_weak_1024)},
     {siBuffer, (unsigned char *)base_weak_1024, sizeof(base_weak_1024)},
     {siBuffer, (unsigned char *)sub2_prime_weak_1024,
      sizeof(sub2_prime_weak_1024)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_1536},
    {"Weak Prime 2048 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_2048, sizeof(prime_weak_2048)},
     {siBuffer, (unsigned char *)base_weak_2048, sizeof(base_weak_2048)},
     {siBuffer, (unsigned char *)sub2_prime_weak_2048,
      sizeof(sub2_prime_weak_2048)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_2048},
    {"Weak Prime 3072 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_3072, sizeof(prime_weak_3072)},
     {siBuffer, (unsigned char *)base_weak_3072, sizeof(base_weak_3072)},
     {siBuffer, (unsigned char *)sub2_prime_weak_3072,
      sizeof(sub2_prime_weak_3072)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_3072},
#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
    {"Weak Prime 4096 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_4096, sizeof(prime_weak_4096)},
     {siBuffer, (unsigned char *)base_weak_4096, sizeof(base_weak_4096)},
     {siBuffer, (unsigned char *)sub2_prime_weak_4096,
      sizeof(sub2_prime_weak_4096)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_4096},
    {"Weak Prime 6144 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_6144, sizeof(prime_weak_6144)},
     {siBuffer, (unsigned char *)base_weak_6144, sizeof(base_weak_6144)},
     {siBuffer, (unsigned char *)sub2_prime_weak_6144,
      sizeof(sub2_prime_weak_6144)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_6144},
    {"Weak Prime 8192 Wrong Subprime",
     {siBuffer, (unsigned char *)prime_weak_8192, sizeof(prime_weak_8192)},
     {siBuffer, (unsigned char *)base_weak_8192, sizeof(base_weak_8192)},
     {siBuffer, (unsigned char *)sub2_prime_weak_8192,
      sizeof(sub2_prime_weak_8192)},
     {siBuffer, NULL, 0},
     WRONG_SUBPRIME,
     CLASS_8192},
#endif
    /******** Now test various invalid public keys */
    /* first known small subgroups of safe primes. These test should
     * fail in all modes with all primes */
    {"Pubkey = 0 IKE 1536",
     {siBuffer, (unsigned char *)prime_ike_1536, sizeof(prime_ike_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, (unsigned char *)pub_key_zero, sizeof(pub_key_zero)},
     BAD_PUB_KEY,
     CLASS_1536},
    {"PubKey = 1 TLS 2048",
     {siBuffer, (unsigned char *)prime_tls_2048, sizeof(prime_tls_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, (unsigned char *)pub_key_one, sizeof(pub_key_one)},
     BAD_PUB_KEY,
     CLASS_2048},
    {"Pubkey == -1 IKE 1536",
     {siBuffer, (unsigned char *)prime_ike_1536, sizeof(prime_ike_1536)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, (unsigned char *)pub_key_minus_1_ike_1536,
      sizeof(pub_key_minus_1_ike_1536)},
     BAD_PUB_KEY,
     CLASS_1536},
    {"Pubkey = -1 SAFE 2048 WITH SUBPRIME",
     {siBuffer, (unsigned char *)prime_safe_2048, sizeof(prime_safe_2048)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_safe_2048,
      sizeof(sub2_prime_safe_2048)},
     {siBuffer, (unsigned char *)pub_key_minus_1_safe_2048,
      sizeof(pub_key_minus_1_safe_2048)},
     BAD_PUB_KEY,
     CLASS_2048},
    {"Pubkey = -1 WEAK 3072 KNOWN SUBPRIME",
     {siBuffer, (unsigned char *)prime_weak_3072, sizeof(prime_weak_3072)},
     {siBuffer, (unsigned char *)base_weak_3072, sizeof(base_weak_3072)},
     {siBuffer, (unsigned char *)subprime_weak_3072,
      sizeof(subprime_weak_3072)},
     {siBuffer, (unsigned char *)pub_key_minus_1_weak_3072,
      sizeof(pub_key_minus_1_weak_3072)},
     BAD_PUB_KEY,
     CLASS_3072},
    {"Pubkey = -1 WEAK 4096 UNKNOWN SUBPRIME",
     {siBuffer, (unsigned char *)prime_weak_4096, sizeof(prime_weak_4096)},
     {siBuffer, (unsigned char *)base_weak_4096, sizeof(base_weak_4096)},
     {siBuffer, NULL, 0},
     {siBuffer, (unsigned char *)pub_key_minus_1_weak_4096,
      sizeof(pub_key_minus_1_weak_4096)},
     BAD_PUB_KEY,
     CLASS_4096},
    {"Pubkey = -1 TLS 6144 WITH SUBPRIME",
     {siBuffer, (unsigned char *)prime_tls_6144, sizeof(prime_tls_6144)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, (unsigned char *)sub2_prime_tls_6144,
      sizeof(sub2_prime_tls_6144)},
     {siBuffer, (unsigned char *)pub_key_minus_1_tls_6144,
      sizeof(pub_key_minus_1_tls_6144)},
     BAD_PUB_KEY,
     CLASS_6144},
    {"Pubkey = -1 SAFE 8192",
     {siBuffer, (unsigned char *)prime_safe_8192, sizeof(prime_safe_8192)},
     {siBuffer, (unsigned char *)g2, sizeof(g2)},
     {siBuffer, NULL, 0},
     {siBuffer, (unsigned char *)pub_key_minus_1_safe_8192,
      sizeof(pub_key_minus_1_safe_8192)},
     BAD_PUB_KEY,
     CLASS_8192},
    /* y is a known small subgroups of weak primes (which known subprimes).
     * These test should fail in all modes with all primes */
    {"Pubkey small subgroup Weak 1024 prime",
     {siBuffer, (unsigned char *)prime_weak_1024, sizeof(prime_weak_1024)},
     {siBuffer, (unsigned char *)base_weak_1024, sizeof(base_weak_1024)},
     {siBuffer, (unsigned char *)subprime_weak_1024,
      sizeof(subprime_weak_1024)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_1024,
      sizeof(pub_key_bad_weak_1024)},
     BAD_PUB_KEY,
     CLASS_1536},
    {"Pubkey small subgroup Weak 2048 prime",
     {siBuffer, (unsigned char *)prime_weak_2048, sizeof(prime_weak_2048)},
     {siBuffer, (unsigned char *)base_weak_2048, sizeof(base_weak_2048)},
     {siBuffer, (unsigned char *)subprime_weak_2048,
      sizeof(subprime_weak_2048)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_2048,
      sizeof(pub_key_bad_weak_2048)},
     BAD_PUB_KEY,
     CLASS_2048},
    {"Pubkey small subgroup Weak 3072 prime",
     {siBuffer, (unsigned char *)prime_weak_3072, sizeof(prime_weak_3072)},
     {siBuffer, (unsigned char *)base_weak_3072, sizeof(base_weak_3072)},
     {siBuffer, (unsigned char *)subprime_weak_3072,
      sizeof(subprime_weak_3072)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_3072,
      sizeof(pub_key_bad_weak_3072)},
     BAD_PUB_KEY,
     CLASS_3072},
#ifdef NSS_SOFTOKEN_DH_INCLUDE_SLOW
    {"Pubkey small subgroup Weak 4096 prime",
     {siBuffer, (unsigned char *)prime_weak_4096, sizeof(prime_weak_4096)},
     {siBuffer, (unsigned char *)base_weak_4096, sizeof(base_weak_4096)},
     {siBuffer, (unsigned char *)subprime_weak_4096,
      sizeof(subprime_weak_4096)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_4096,
      sizeof(pub_key_bad_weak_4096)},
     BAD_PUB_KEY,
     CLASS_4096},
    {"Pubkey small subgroup Weak 6144 prime",
     {siBuffer, (unsigned char *)prime_weak_6144, sizeof(prime_weak_6144)},
     {siBuffer, (unsigned char *)base_weak_6144, sizeof(base_weak_6144)},
     {siBuffer, (unsigned char *)subprime_weak_6144,
      sizeof(subprime_weak_6144)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_6144,
      sizeof(pub_key_bad_weak_6144)},
     BAD_PUB_KEY,
     CLASS_6144},
    {"Pubkey small subgroup Weak 8192 prime",
     {siBuffer, (unsigned char *)prime_weak_8192, sizeof(prime_weak_8192)},
     {siBuffer, (unsigned char *)base_weak_8192, sizeof(base_weak_8192)},
     {siBuffer, (unsigned char *)subprime_weak_8192,
      sizeof(subprime_weak_8192)},
     {siBuffer, (unsigned char *)pub_key_bad_weak_8192,
      sizeof(pub_key_bad_weak_8192)},
     BAD_PUB_KEY,
     CLASS_8192}
#endif
};
};
