/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.Helper;
import org.jhotdraw.framework.DrawingView;

public class SplitPaneDesktop
extends JSplitPane
implements Desktop {
    private DesktopEventService myDesktopEventService;

    public SplitPaneDesktop() {
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setOneTouchExpandable(true);
        this.addPropertyChangeListener(this.createPropertyChangeListener());
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (SplitPaneDesktop.this.getRightComponent() != null) {
                    SplitPaneDesktop.this.getRightComponent().repaint();
                }
                if (SplitPaneDesktop.this.getLeftComponent() != null) {
                    SplitPaneDesktop.this.getLeftComponent().repaint();
                }
            }
        };
    }

    protected Component createContents(DrawingView drawingView, int n) {
        this.setRightComponent(this.createRightComponent(drawingView));
        this.setLeftComponent(this.createLeftComponent(drawingView));
        switch (n) {
            case 0: {
                return this.getLeftComponent();
            }
            case 1: {
                return this.getRightComponent();
            }
        }
        return null;
    }

    protected Component createRightComponent(DrawingView drawingView) {
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)drawingView));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setAlignmentX(0.0f);
        return jScrollPane;
    }

    protected Component createLeftComponent(DrawingView drawingView) {
        return new JScrollPane(new JList());
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView drawingView, int n) {
        this.createContents(drawingView, 0);
        this.setDividerLocation(this.getInitDividerLocation());
    }

    protected int getInitDividerLocation() {
        return 150;
    }

    public void removeFromDesktop(DrawingView drawingView, int n) {
        Component[] componentArray = this.getContainer().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (drawingView != Helper.getDrawingView(componentArray[i])) continue;
            this.getContainer().remove(componentArray[i]);
            break;
        }
    }

    public void removeAllFromDesktop(int n) {
        this.getContainer().removeAll();
    }

    public DrawingView[] getAllFromDesktop(int n) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().addDesktopListener(desktopListener);
    }

    public void removeDesktopListener(DesktopListener desktopListener) {
        this.getDesktopEventService().removeDesktopListener(desktopListener);
    }

    private Container getContainer() {
        return this;
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService desktopEventService) {
        this.myDesktopEventService = desktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    public void updateTitle(String string) {
        this.setName(string);
    }
}

